/*
 * Decompiled with CFR 0.152.
 */
package com.wdtinc.mapbox_vector_tile.adapt.jts;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import com.wdtinc.mapbox_vector_tile.adapt.jts.IGeometryFilter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.IUserDataConverter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.RoundingFilter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.TileGeomResult;
import com.wdtinc.mapbox_vector_tile.builder.MvtLayerParams;
import com.wdtinc.mapbox_vector_tile.builder.MvtLayerProps;
import com.wdtinc.mapbox_vector_tile.encoding.GeomCmd;
import com.wdtinc.mapbox_vector_tile.encoding.GeomCmdHdr;
import com.wdtinc.mapbox_vector_tile.encoding.MvtUtil;
import com.wdtinc.mapbox_vector_tile.encoding.ZigZag;
import com.wdtinc.mapbox_vector_tile.util.Vec2d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import net.osmand.binary.VectorTile;

public final class JtsAdapter {
    public static TileGeomResult createTileGeom(Geometry g, Envelope tileEnvelope, GeometryFactory geomFactory, MvtLayerParams mvtLayerParams, IGeometryFilter filter) {
        return JtsAdapter.createTileGeom(JtsAdapter.flatFeatureList(g), tileEnvelope, geomFactory, mvtLayerParams, filter);
    }

    public static TileGeomResult createTileGeom(List<Geometry> g, Envelope tileEnvelope, GeometryFactory geomFactory, MvtLayerParams mvtLayerParams, IGeometryFilter filter) {
        Geometry tileEnvelopeGeom = geomFactory.toGeometry(tileEnvelope);
        AffineTransformation t = new AffineTransformation();
        double xDiff = tileEnvelope.getWidth();
        double yDiff = tileEnvelope.getHeight();
        double xOffset = -tileEnvelope.getMinX();
        double yOffset = -tileEnvelope.getMinY();
        t.translate(xOffset, yOffset);
        t.scale(1.0 / (xDiff / (double)mvtLayerParams.extent), -1.0 / (yDiff / (double)mvtLayerParams.extent));
        t.translate(0.0, (double)mvtLayerParams.extent);
        List<Geometry> intersectedGeoms = JtsAdapter.flatIntersection(tileEnvelopeGeom, g);
        ArrayList<Geometry> transformedGeoms = new ArrayList<Geometry>(intersectedGeoms.size());
        for (Geometry nextInterGeom : intersectedGeoms) {
            Object nextUserData = nextInterGeom.getUserData();
            Geometry nextTransformGeom = t.transform(nextInterGeom);
            nextTransformGeom.apply((CoordinateSequenceFilter)RoundingFilter.INSTANCE);
            nextTransformGeom = TopologyPreservingSimplifier.simplify((Geometry)nextTransformGeom, (double)0.1);
            nextTransformGeom.setUserData(nextUserData);
            if (!filter.accept(nextTransformGeom)) continue;
            transformedGeoms.add(nextTransformGeom);
        }
        return new TileGeomResult(intersectedGeoms, transformedGeoms);
    }

    private static List<Geometry> flatIntersection(Geometry envelope, Geometry data) {
        return JtsAdapter.flatIntersection(envelope, JtsAdapter.flatFeatureList(data));
    }

    private static List<Geometry> flatIntersection(Geometry envelope, List<Geometry> dataGeoms) {
        ArrayList<Geometry> intersectedGeoms = new ArrayList<Geometry>(dataGeoms.size());
        for (Geometry nextGeom : dataGeoms) {
            try {
                Geometry nextIntersected;
                if (!envelope.getEnvelopeInternal().intersects(nextGeom.getEnvelopeInternal()) || (nextIntersected = envelope.intersection(nextGeom)).isEmpty()) continue;
                nextIntersected.setUserData(nextGeom.getUserData());
                intersectedGeoms.add(nextIntersected);
            }
            catch (TopologyException topologyException) {}
        }
        return intersectedGeoms;
    }

    public static VectorTile.Tile.GeomType toGeomType(Geometry geometry) {
        VectorTile.Tile.GeomType result = VectorTile.Tile.GeomType.UNKNOWN;
        if (geometry instanceof Point || geometry instanceof MultiPoint) {
            result = VectorTile.Tile.GeomType.POINT;
        } else if (geometry instanceof LineString || geometry instanceof MultiLineString) {
            result = VectorTile.Tile.GeomType.LINESTRING;
        } else if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
            result = VectorTile.Tile.GeomType.POLYGON;
        }
        return result;
    }

    public static List<Geometry> flatFeatureList(Geometry geom) {
        ArrayList<Geometry> singleGeoms = new ArrayList<Geometry>();
        Stack<Geometry> geomStack = new Stack<Geometry>();
        geomStack.push(geom);
        while (!geomStack.isEmpty()) {
            Geometry nextGeom = (Geometry)geomStack.pop();
            if (nextGeom instanceof Point || nextGeom instanceof MultiPoint || nextGeom instanceof LineString || nextGeom instanceof MultiLineString || nextGeom instanceof Polygon || nextGeom instanceof MultiPolygon) {
                singleGeoms.add(nextGeom);
                continue;
            }
            if (!(nextGeom instanceof GeometryCollection)) continue;
            int nextGeomCount = nextGeom.getNumGeometries();
            for (int i = 0; i < nextGeomCount; ++i) {
                geomStack.push(nextGeom.getGeometryN(i));
            }
        }
        return singleGeoms;
    }

    public static List<VectorTile.Tile.Feature> toFeatures(Geometry geometry, MvtLayerProps layerProps, IUserDataConverter userDataConverter) {
        return JtsAdapter.toFeatures(JtsAdapter.flatFeatureList(geometry), layerProps, userDataConverter);
    }

    public static List<VectorTile.Tile.Feature> toFeatures(Collection<Geometry> flatGeoms, MvtLayerProps layerProps, IUserDataConverter userDataConverter) {
        if (flatGeoms.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VectorTile.Tile.Feature> features = new ArrayList<VectorTile.Tile.Feature>();
        Vec2d cursor = new Vec2d();
        for (Geometry nextGeom : flatGeoms) {
            cursor.set(0.0, 0.0);
            VectorTile.Tile.Feature nextFeature = JtsAdapter.toFeature(nextGeom, cursor, layerProps, userDataConverter);
            if (nextFeature == null) continue;
            features.add(nextFeature);
        }
        return features;
    }

    private static VectorTile.Tile.Feature toFeature(Geometry geom, Vec2d cursor, MvtLayerProps layerProps, IUserDataConverter userDataConverter) {
        VectorTile.Tile.GeomType mvtGeomType = JtsAdapter.toGeomType(geom);
        if (mvtGeomType == VectorTile.Tile.GeomType.UNKNOWN) {
            return null;
        }
        VectorTile.Tile.Feature.Builder featureBuilder = VectorTile.Tile.Feature.newBuilder();
        boolean mvtClosePath = MvtUtil.shouldClosePath(mvtGeomType);
        ArrayList<Integer> mvtGeom = new ArrayList<Integer>();
        featureBuilder.setType(mvtGeomType);
        if (geom instanceof Point || geom instanceof MultiPoint) {
            mvtGeom.addAll(JtsAdapter.ptsToGeomCmds(geom, cursor));
        } else if (geom instanceof LineString || geom instanceof MultiLineString) {
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                mvtGeom.addAll(JtsAdapter.linesToGeomCmds(geom.getGeometryN(i), mvtClosePath, cursor, 1));
            }
        } else if (geom instanceof MultiPolygon || geom instanceof Polygon) {
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                Polygon nextPoly = (Polygon)geom.getGeometryN(i);
                boolean valid = true;
                LineString exteriorRing = nextPoly.getExteriorRing();
                double exteriorArea = CGAlgorithms.signedArea((Coordinate[])exteriorRing.getCoordinates());
                if ((int)Math.round(exteriorArea) == 0) continue;
                if (exteriorArea < 0.0) {
                    CoordinateArrays.reverse((Coordinate[])exteriorRing.getCoordinates());
                }
                ArrayList<Integer> nextPolyGeom = new ArrayList<Integer>(JtsAdapter.linesToGeomCmds((Geometry)exteriorRing, mvtClosePath, cursor, 2));
                for (int ringIndex = 0; ringIndex < nextPoly.getNumInteriorRing(); ++ringIndex) {
                    LineString nextInteriorRing = nextPoly.getInteriorRingN(ringIndex);
                    double interiorArea = CGAlgorithms.signedArea((Coordinate[])nextInteriorRing.getCoordinates());
                    if ((int)Math.round(interiorArea) == 0) continue;
                    if (interiorArea > 0.0) {
                        CoordinateArrays.reverse((Coordinate[])nextInteriorRing.getCoordinates());
                    }
                    if (Math.abs(exteriorArea) <= Math.abs(interiorArea)) {
                        valid = false;
                        break;
                    }
                    nextPolyGeom.addAll(JtsAdapter.linesToGeomCmds((Geometry)nextInteriorRing, mvtClosePath, cursor, 2));
                }
                if (!valid) continue;
                mvtGeom.addAll(nextPolyGeom);
            }
        }
        if (mvtGeom.size() < 1) {
            return null;
        }
        featureBuilder.addAllGeometry(mvtGeom);
        userDataConverter.addTags(geom.getUserData(), layerProps, featureBuilder);
        return featureBuilder.build();
    }

    private static List<Integer> ptsToGeomCmds(Geometry geom, Vec2d cursor) {
        Coordinate[] geomCoords = geom.getCoordinates();
        if (geomCoords.length <= 0) {
            Collections.emptyList();
        }
        ArrayList<Integer> geomCmds = new ArrayList<Integer>(JtsAdapter.geomCmdBuffLenPts(geomCoords.length));
        Vec2d mvtPos = new Vec2d();
        int moveCmdLen = 0;
        geomCmds.add(0);
        for (int i = 0; i < geomCoords.length; ++i) {
            Coordinate nextCoord = geomCoords[i];
            mvtPos.set(nextCoord.x, nextCoord.y);
            if (i != 0 && JtsAdapter.equalAsInts(cursor, mvtPos)) continue;
            ++moveCmdLen;
            JtsAdapter.moveCursor(cursor, geomCmds, mvtPos);
        }
        if (moveCmdLen <= GeomCmdHdr.CMD_HDR_LEN_MAX) {
            geomCmds.set(0, GeomCmdHdr.cmdHdr(GeomCmd.MoveTo, moveCmdLen));
            return geomCmds;
        }
        return Collections.emptyList();
    }

    private static List<Integer> linesToGeomCmds(Geometry geom, boolean closeEnabled, Vec2d cursor, int minLineToLen) {
        int repeatEndCoordCount;
        Coordinate[] geomCoords = geom.getCoordinates();
        int minExpGeomCoords = geomCoords.length - (repeatEndCoordCount = JtsAdapter.countCoordRepeatReverse(geomCoords));
        if (minExpGeomCoords < 2) {
            Collections.emptyList();
        }
        ArrayList<Integer> geomCmds = new ArrayList<Integer>(JtsAdapter.geomCmdBuffLenLines(minExpGeomCoords, closeEnabled));
        Vec2d mvtPos = new Vec2d();
        Coordinate nextCoord = geomCoords[0];
        mvtPos.set(nextCoord.x, nextCoord.y);
        geomCmds.add(GeomCmdHdr.cmdHdr(GeomCmd.MoveTo, 1));
        JtsAdapter.moveCursor(cursor, geomCmds, mvtPos);
        int lineToCmdHdrIndex = geomCmds.size();
        geomCmds.add(0);
        int lineToLength = 0;
        for (int i = 1; i < minExpGeomCoords; ++i) {
            nextCoord = geomCoords[i];
            mvtPos.set(nextCoord.x, nextCoord.y);
            if (JtsAdapter.equalAsInts(cursor, mvtPos)) continue;
            ++lineToLength;
            JtsAdapter.moveCursor(cursor, geomCmds, mvtPos);
        }
        if (lineToLength >= minLineToLen && lineToLength <= GeomCmdHdr.CMD_HDR_LEN_MAX) {
            geomCmds.set(lineToCmdHdrIndex, GeomCmdHdr.cmdHdr(GeomCmd.LineTo, lineToLength));
            if (closeEnabled) {
                geomCmds.add(GeomCmdHdr.closePathCmdHdr());
            }
            return geomCmds;
        }
        return Collections.emptyList();
    }

    private static int countCoordRepeatReverse(Coordinate[] coords) {
        Coordinate nextCoord;
        int repeatCoords = 0;
        Coordinate firstCoord = coords[0];
        for (int i = coords.length - 1; i > 0 && JtsAdapter.equalAsInts2d(firstCoord, nextCoord = coords[i]); --i) {
            ++repeatCoords;
        }
        return repeatCoords;
    }

    private static void moveCursor(Vec2d cursor, List<Integer> geomCmds, Vec2d mvtPos) {
        geomCmds.add(ZigZag.encode((int)mvtPos.x - (int)cursor.x));
        geomCmds.add(ZigZag.encode((int)mvtPos.y - (int)cursor.y));
        cursor.set(mvtPos);
    }

    private static boolean equalAsInts2d(Coordinate a, Coordinate b) {
        return (int)a.getOrdinate(0) == (int)b.getOrdinate(0) && (int)a.getOrdinate(1) == (int)b.getOrdinate(1);
    }

    private static boolean equalAsInts(Vec2d a, Vec2d b) {
        return (int)a.x == (int)b.x && (int)a.y == (int)b.y;
    }

    private static int geomCmdBuffLenPts(int coordCount) {
        return 1 + coordCount * 2;
    }

    private static int geomCmdBuffLenLines(int coordCount, boolean closeEnabled) {
        return 2 + (closeEnabled ? 1 : 0) + coordCount * 2;
    }
}

