/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.viterbi;

import com.atilika.kuromoji.dict.Dictionary;

public class ViterbiNode {
    private final int wordId;
    private final String surface;
    private final int leftId;
    private final int rightId;
    private final int wordCost;
    private int pathCost;
    private ViterbiNode leftNode;
    private final Type type;
    private final int startIndex;

    public ViterbiNode(int wordId, String surface, int leftId, int rightId, int wordCost, int startIndex, Type type) {
        this.wordId = wordId;
        this.surface = surface;
        this.leftId = leftId;
        this.rightId = rightId;
        this.wordCost = wordCost;
        this.startIndex = startIndex;
        this.type = type;
    }

    public ViterbiNode(int wordId, String word, Dictionary dictionary, int startIndex, Type type) {
        this(wordId, word, dictionary.getLeftId(wordId), dictionary.getRightId(wordId), dictionary.getWordCost(wordId), startIndex, type);
    }

    public int getWordId() {
        return this.wordId;
    }

    public String getSurface() {
        return this.surface;
    }

    public int getLeftId() {
        return this.leftId;
    }

    public int getRightId() {
        return this.rightId;
    }

    public int getWordCost() {
        return this.wordCost;
    }

    public int getPathCost() {
        return this.pathCost;
    }

    public void setPathCost(int pathCost) {
        this.pathCost = pathCost;
    }

    public void setLeftNode(ViterbiNode node) {
        this.leftNode = node;
    }

    public ViterbiNode getLeftNode() {
        return this.leftNode;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        KNOWN,
        UNKNOWN,
        USER,
        INSERTED;

    }
}

