/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;

public class InteriorPointLine {
    private Coordinate centroid;
    private double minDistance = Double.MAX_VALUE;
    private Coordinate interiorPoint = null;

    public InteriorPointLine(Geometry g) {
        this.centroid = g.getCentroid().getCoordinate();
        this.addInterior(g);
        if (this.interiorPoint == null) {
            this.addEndpoints(g);
        }
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }

    private void addInterior(Geometry geom) {
        if (geom instanceof LineString) {
            this.addInterior(geom.getCoordinates());
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            int i = 0;
            while (i < gc.getNumGeometries()) {
                this.addInterior(gc.getGeometryN(i));
                ++i;
            }
        }
    }

    private void addInterior(Coordinate[] pts) {
        int i = 1;
        while (i < pts.length - 1) {
            this.add(pts[i]);
            ++i;
        }
    }

    private void addEndpoints(Geometry geom) {
        if (geom instanceof LineString) {
            this.addEndpoints(geom.getCoordinates());
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            int i = 0;
            while (i < gc.getNumGeometries()) {
                this.addEndpoints(gc.getGeometryN(i));
                ++i;
            }
        }
    }

    private void addEndpoints(Coordinate[] pts) {
        this.add(pts[0]);
        this.add(pts[pts.length - 1]);
    }

    private void add(Coordinate point) {
        double dist = point.distance(this.centroid);
        if (dist < this.minDistance) {
            this.interiorPoint = new Coordinate(point);
            this.minDistance = dist;
        }
    }
}

