/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml.link;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.renderer.xhtml.link.XHTMLLinkTypeRenderer;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;
import org.xwiki.rendering.renderer.reference.link.URILabelGenerator;

public abstract class AbstractXHTMLLinkTypeRenderer
implements XHTMLLinkTypeRenderer {
    protected static final String CLASS = "class";
    protected static final String SPAN = "span";
    @Inject
    protected ComponentManager componentManager;
    private XHTMLWikiPrinter xhtmlPrinter;
    private boolean hasLabel;

    protected boolean hasLabel() {
        return this.hasLabel;
    }

    @Override
    public void setHasLabel(boolean hasLabel) {
        this.hasLabel = hasLabel;
    }

    @Override
    public void setXHTMLWikiPrinter(XHTMLWikiPrinter printer) {
        this.xhtmlPrinter = printer;
    }

    @Override
    public XHTMLWikiPrinter getXHTMLWikiPrinter() {
        return this.xhtmlPrinter;
    }

    protected abstract void beginLinkExtraAttributes(ResourceReference var1, Map<String, String> var2, Map<String, String> var3);

    protected String computeLabel(ResourceReference reference) {
        String label;
        try {
            URILabelGenerator uriLabelGenerator = (URILabelGenerator)this.componentManager.getInstance(URILabelGenerator.class, reference.getType().getScheme());
            label = uriLabelGenerator.generateLabel(reference);
        }
        catch (ComponentLookupException e) {
            label = reference.getReference();
        }
        return label;
    }

    public void beginLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        LinkedHashMap<String, String> spanAttributes = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> anchorAttributes = new LinkedHashMap<String, String>();
        anchorAttributes.putAll(parameters);
        if (this.isExternalLink(reference)) {
            spanAttributes.put(CLASS, "wikiexternallink");
        } else {
            spanAttributes.put(CLASS, "wikiinternallink");
        }
        if (isFreeStandingURI) {
            anchorAttributes.put(CLASS, this.addAttributeValue((String)anchorAttributes.get(CLASS), "wikimodel-freestanding"));
        }
        this.beginLinkExtraAttributes(reference, spanAttributes, anchorAttributes);
        this.getXHTMLWikiPrinter().printXMLStartElement(SPAN, spanAttributes);
        this.getXHTMLWikiPrinter().printXMLStartElement("a", anchorAttributes);
    }

    public void endLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        if (!this.hasLabel()) {
            this.getXHTMLWikiPrinter().printXMLStartElement(SPAN, (String[][])new String[][]{{CLASS, "wikigeneratedlinkcontent"}});
            this.getXHTMLWikiPrinter().printXML(this.computeLabel(reference));
            this.getXHTMLWikiPrinter().printXMLEndElement(SPAN);
        }
        this.getXHTMLWikiPrinter().printXMLEndElement("a");
        this.getXHTMLWikiPrinter().printXMLEndElement(SPAN);
    }

    private String addAttributeValue(String currentValue, String valueToAdd) {
        String newValue = currentValue == null || currentValue.length() == 0 ? "" : currentValue + " ";
        return newValue + valueToAdd;
    }

    protected boolean isExternalLink(ResourceReference reference) {
        return true;
    }
}

