/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.AreaI;
import net.osmand.core.jni.ColorARGB;
import net.osmand.core.jni.ColorRGB;
import net.osmand.core.jni.LatLon;
import net.osmand.core.jni.NullableLatLon;
import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.PointD;
import net.osmand.core.jni.PointF;
import net.osmand.core.jni.PointI;
import net.osmand.core.jni.QVectorPointI;
import net.osmand.core.jni.SWIGTYPE_p_OsmAnd__PointT_long_long_t;
import net.osmand.core.jni.SWIGTYPE_p_QDir;
import net.osmand.core.jni.SWIGTYPE_p_QFileInfoList;
import net.osmand.core.jni.SWIGTYPE_p_QListT_OsmAnd__Utilities__ItemPointOnPath_t;
import net.osmand.core.jni.SWIGTYPE_p_QSetT_OsmAnd__ZoomLevel_t;
import net.osmand.core.jni.SWIGTYPE_p_QString;
import net.osmand.core.jni.SWIGTYPE_p_QStringList;
import net.osmand.core.jni.SWIGTYPE_p_QVectorT_OsmAnd__PointT_long_long_t_t;
import net.osmand.core.jni.SWIGTYPE_p_bool;
import net.osmand.core.jni.SWIGTYPE_p_double;
import net.osmand.core.jni.SWIGTYPE_p_float;
import net.osmand.core.jni.SWIGTYPE_p_glm__dmat3;
import net.osmand.core.jni.SWIGTYPE_p_glm__dvec3;
import net.osmand.core.jni.SWIGTYPE_p_glm__vec3;
import net.osmand.core.jni.SWIGTYPE_p_int;
import net.osmand.core.jni.SWIGTYPE_p_std__pairT_int_int_t;
import net.osmand.core.jni.SWIGTYPE_p_std__time_t;
import net.osmand.core.jni.SWIGTYPE_p_std__tm;
import net.osmand.core.jni.SWIGTYPE_p_unsigned_short;
import net.osmand.core.jni.TileId;
import net.osmand.core.jni.TileIdVector;
import net.osmand.core.jni.ZoomLevel;

public class Utilities {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Utilities(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Utilities utilities) {
        return utilities == null ? 0L : utilities.swigCPtr;
    }

    protected static long swigRelease(Utilities utilities) {
        long l = 0L;
        if (utilities != null) {
            if (!utilities.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = utilities.swigCPtr;
            utilities.swigCMemOwn = false;
            utilities.delete();
        }
        return l;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                throw new UnsupportedOperationException("C++ destructor does not have public access");
            }
            this.swigCPtr = 0L;
        }
    }

    public static SWIGTYPE_p_std__tm localtime(SWIGTYPE_p_std__time_t sWIGTYPE_p_std__time_t) {
        return new SWIGTYPE_p_std__tm(OsmAndCoreJNI.Utilities_localtime(SWIGTYPE_p_std__time_t.getCPtr(sWIGTYPE_p_std__time_t)), true);
    }

    public static long roundMillisecondsToHours(long l) {
        return OsmAndCoreJNI.Utilities_roundMillisecondsToHours(l);
    }

    public static String getDateTimeString(long l) {
        return OsmAndCoreJNI.Utilities_getDateTimeString(l);
    }

    public static String getMGRSLetter(int n) {
        return OsmAndCoreJNI.Utilities_getMGRSLetter(n);
    }

    public static String getMGRSSquareColumn(PointI pointI, PointD pointD) {
        return OsmAndCoreJNI.Utilities_getMGRSSquareColumn(PointI.getCPtr(pointI), pointI, PointD.getCPtr(pointD), pointD);
    }

    public static String getMGRSSquareRow(PointI pointI, PointD pointD) {
        return OsmAndCoreJNI.Utilities_getMGRSSquareRow(PointI.getCPtr(pointI), pointI, PointD.getCPtr(pointD), pointD);
    }

    public static void removeTrailingZeros(SWIGTYPE_p_QString sWIGTYPE_p_QString) {
        OsmAndCoreJNI.Utilities_removeTrailingZeros(SWIGTYPE_p_QString.getCPtr(sWIGTYPE_p_QString));
    }

    public static String getDegreeMinuteSecondString(double d) {
        return OsmAndCoreJNI.Utilities_getDegreeMinuteSecondString(d);
    }

    public static String getDegreeMinuteString(double d) {
        return OsmAndCoreJNI.Utilities_getDegreeMinuteString(d);
    }

    public static double toRadians(double d) {
        return OsmAndCoreJNI.Utilities_toRadians(d);
    }

    public static int get31TileNumberX(double d) {
        return OsmAndCoreJNI.Utilities_get31TileNumberX(d);
    }

    public static int get31TileNumberY(double d) {
        return OsmAndCoreJNI.Utilities_get31TileNumberY(d);
    }

    public static PointI convertLatLonTo31(LatLon latLon) {
        return new PointI(OsmAndCoreJNI.Utilities_convertLatLonTo31(LatLon.getCPtr(latLon), latLon), true);
    }

    public static double get31LongitudeX(double d) {
        return OsmAndCoreJNI.Utilities_get31LongitudeX(d);
    }

    public static double get31LatitudeY(double d) {
        return OsmAndCoreJNI.Utilities_get31LatitudeY(d);
    }

    public static LatLon convert31ToLatLon(PointI pointI) {
        return new LatLon(OsmAndCoreJNI.Utilities_convert31ToLatLon(PointI.getCPtr(pointI), pointI), true);
    }

    public static double getTileNumberX(float f, double d) {
        return OsmAndCoreJNI.Utilities_getTileNumberX(f, d);
    }

    public static double getTileNumberY(float f, double d) {
        return OsmAndCoreJNI.Utilities_getTileNumberY(f, d);
    }

    public static float convert31toFloat(int n, ZoomLevel zoomLevel) {
        return OsmAndCoreJNI.Utilities_convert31toFloat__SWIG_0(n, zoomLevel.swigValue());
    }

    public static PointF convert31toFloat(PointI pointI, ZoomLevel zoomLevel) {
        return new PointF(OsmAndCoreJNI.Utilities_convert31toFloat__SWIG_1(PointI.getCPtr(pointI), pointI, zoomLevel.swigValue()), true);
    }

    public static PointD convert31toDouble(SWIGTYPE_p_OsmAnd__PointT_long_long_t sWIGTYPE_p_OsmAnd__PointT_long_long_t, ZoomLevel zoomLevel) {
        return new PointD(OsmAndCoreJNI.Utilities_convert31toDouble(SWIGTYPE_p_OsmAnd__PointT_long_long_t.getCPtr(sWIGTYPE_p_OsmAnd__PointT_long_long_t), zoomLevel.swigValue()), true);
    }

    public static PointI convertFloatTo31(PointF pointF, PointI pointI, ZoomLevel zoomLevel) {
        return new PointI(OsmAndCoreJNI.Utilities_convertFloatTo31(PointF.getCPtr(pointF), pointF, PointI.getCPtr(pointI), pointI, zoomLevel.swigValue()), true);
    }

    public static double normalizeLatitude(double d) {
        return OsmAndCoreJNI.Utilities_normalizeLatitude(d);
    }

    public static double normalizeLongitude(double d) {
        return OsmAndCoreJNI.Utilities_normalizeLongitude(d);
    }

    public static int metersTo31(double d) {
        return OsmAndCoreJNI.Utilities_metersTo31__SWIG_0(d);
    }

    public static PointI metersTo31(PointD pointD) {
        return new PointI(OsmAndCoreJNI.Utilities_metersTo31__SWIG_1(PointD.getCPtr(pointD), pointD), true);
    }

    public static double metersFrom31(double d) {
        return OsmAndCoreJNI.Utilities_metersFrom31__SWIG_0(d);
    }

    public static PointD metersFrom31(PointD pointD) {
        return new PointD(OsmAndCoreJNI.Utilities_metersFrom31__SWIG_1(PointD.getCPtr(pointD), pointD), true);
    }

    public static double getPowZoom(float f) {
        return OsmAndCoreJNI.Utilities_getPowZoom(f);
    }

    public static double getSignedAngle(PointD pointD, PointD pointD2) {
        return OsmAndCoreJNI.Utilities_getSignedAngle(PointD.getCPtr(pointD), pointD, PointD.getCPtr(pointD2), pointD2);
    }

    public static double dotProduct(PointD pointD, PointD pointD2) {
        return OsmAndCoreJNI.Utilities_dotProduct(PointD.getCPtr(pointD), pointD, PointD.getCPtr(pointD2), pointD2);
    }

    public static PointD getScaleDivisor31ToPixel(PointI pointI, ZoomLevel zoomLevel) {
        return new PointD(OsmAndCoreJNI.Utilities_getScaleDivisor31ToPixel(PointI.getCPtr(pointI), pointI, zoomLevel.swigValue()), true);
    }

    public static double getTileDistanceWidth(float f) {
        return OsmAndCoreJNI.Utilities_getTileDistanceWidth(f);
    }

    public static double getLongitudeFromTile(float f, double d) {
        return OsmAndCoreJNI.Utilities_getLongitudeFromTile(f, d);
    }

    public static double getLatitudeFromTile(float f, double d) {
        return OsmAndCoreJNI.Utilities_getLatitudeFromTile(f, d);
    }

    public static PointD getAnglesFrom31(PointI pointI) {
        return new PointD(OsmAndCoreJNI.Utilities_getAnglesFrom31(PointI.getCPtr(pointI), pointI), true);
    }

    public static PointI get31FromAngles(PointD pointD) {
        return new PointI(OsmAndCoreJNI.Utilities_get31FromAngles(PointD.getCPtr(pointD), pointD), true);
    }

    public static PointD getZoneUTM(PointD pointD, SWIGTYPE_p_double sWIGTYPE_p_double) {
        return new PointD(OsmAndCoreJNI.Utilities_getZoneUTM(PointD.getCPtr(pointD), pointD, SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double)), true);
    }

    public static int getCodedZoneUTM(PointI pointI, boolean bl) {
        return OsmAndCoreJNI.Utilities_getCodedZoneUTM__SWIG_0(PointI.getCPtr(pointI), pointI, bl);
    }

    public static int getCodedZoneUTM(PointI pointI) {
        return OsmAndCoreJNI.Utilities_getCodedZoneUTM__SWIG_1(PointI.getCPtr(pointI), pointI);
    }

    public static PointD getCoordinatesUTM(PointD pointD, double d) {
        return new PointD(OsmAndCoreJNI.Utilities_getCoordinatesUTM(PointD.getCPtr(pointD), pointD, d), true);
    }

    public static ZoomLevel clipZoomLevel(ZoomLevel zoomLevel) {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.Utilities_clipZoomLevel(zoomLevel.swigValue()));
    }

    public static float zoomFractionToVisual(float f) {
        return OsmAndCoreJNI.Utilities_zoomFractionToVisual(f);
    }

    public static float visualZoomToFraction(float f) {
        return OsmAndCoreJNI.Utilities_visualZoomToFraction(f);
    }

    public static double x31toMeters(int n) {
        return OsmAndCoreJNI.Utilities_x31toMeters(n);
    }

    public static double y31toMeters(int n) {
        return OsmAndCoreJNI.Utilities_y31toMeters(n);
    }

    public static long metersToX31(double d) {
        return OsmAndCoreJNI.Utilities_metersToX31(d);
    }

    public static long metersToY31(double d) {
        return OsmAndCoreJNI.Utilities_metersToY31(d);
    }

    public static double x31ToMeters(int n, int n2, int n3) {
        return OsmAndCoreJNI.Utilities_x31ToMeters(n, n2, n3);
    }

    public static double y31ToMeters(int n, int n2, int n3) {
        return OsmAndCoreJNI.Utilities_y31ToMeters(n, n2, n3);
    }

    public static double squareDistance31(int n, int n2, int n3, int n4) {
        return OsmAndCoreJNI.Utilities_squareDistance31__SWIG_0(n, n2, n3, n4);
    }

    public static double distance31(int n, int n2, int n3, int n4) {
        return OsmAndCoreJNI.Utilities_distance31__SWIG_0(n, n2, n3, n4);
    }

    public static double squareDistance31(PointI pointI, PointI pointI2) {
        return OsmAndCoreJNI.Utilities_squareDistance31__SWIG_1(PointI.getCPtr(pointI), pointI, PointI.getCPtr(pointI2), pointI2);
    }

    public static double distance31(PointI pointI, PointI pointI2) {
        return OsmAndCoreJNI.Utilities_distance31__SWIG_1(PointI.getCPtr(pointI), pointI, PointI.getCPtr(pointI2), pointI2);
    }

    public static double distance(double d, double d2, double d3, double d4) {
        return OsmAndCoreJNI.Utilities_distance__SWIG_0(d, d2, d3, d4);
    }

    public static double distance(LatLon latLon, LatLon latLon2) {
        return OsmAndCoreJNI.Utilities_distance__SWIG_1(LatLon.getCPtr(latLon), latLon, LatLon.getCPtr(latLon2), latLon2);
    }

    public static double distance(NullableLatLon nullableLatLon, NullableLatLon nullableLatLon2) {
        return OsmAndCoreJNI.Utilities_distance__SWIG_2(NullableLatLon.getCPtr(nullableLatLon), nullableLatLon, NullableLatLon.getCPtr(nullableLatLon2), nullableLatLon2);
    }

    public static double projection31(int n, int n2, int n3, int n4, int n5, int n6) {
        return OsmAndCoreJNI.Utilities_projection31__SWIG_0(n, n2, n3, n4, n5, n6);
    }

    public static double projection31(PointI pointI, PointI pointI2, PointI pointI3) {
        return OsmAndCoreJNI.Utilities_projection31__SWIG_1(PointI.getCPtr(pointI), pointI, PointI.getCPtr(pointI2), pointI2, PointI.getCPtr(pointI3), pointI3);
    }

    public static double projectionCoeff31(PointI pointI, PointI pointI2, PointI pointI3) {
        return OsmAndCoreJNI.Utilities_projectionCoeff31(PointI.getCPtr(pointI), pointI, PointI.getCPtr(pointI2), pointI2, PointI.getCPtr(pointI3), pointI3);
    }

    public static double measuredDist31(int n, int n2, int n3, int n4) {
        return OsmAndCoreJNI.Utilities_measuredDist31(n, n2, n3, n4);
    }

    public static double normalizedAngleRadians(double d) {
        return OsmAndCoreJNI.Utilities_normalizedAngleRadians(d);
    }

    public static double normalizedAngleDegrees(double d) {
        return OsmAndCoreJNI.Utilities_normalizedAngleDegrees(d);
    }

    public static double computeSignedArea(QVectorPointI qVectorPointI) {
        return OsmAndCoreJNI.Utilities_computeSignedArea(QVectorPointI.getCPtr(qVectorPointI), qVectorPointI);
    }

    public static double polygonArea(QVectorPointI qVectorPointI) {
        return OsmAndCoreJNI.Utilities_polygonArea(QVectorPointI.getCPtr(qVectorPointI), qVectorPointI);
    }

    public static boolean rayIntersectX(PointD pointD, PointD pointD2, double d, SWIGTYPE_p_double sWIGTYPE_p_double) {
        return OsmAndCoreJNI.Utilities_rayIntersectX__SWIG_0(PointD.getCPtr(pointD), pointD, PointD.getCPtr(pointD2), pointD2, d, SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double));
    }

    public static boolean rayIntersect(PointD pointD, PointD pointD2, PointD pointD3) {
        return OsmAndCoreJNI.Utilities_rayIntersect__SWIG_0(PointD.getCPtr(pointD), pointD, PointD.getCPtr(pointD2), pointD2, PointD.getCPtr(pointD3), pointD3);
    }

    public static boolean rayIntersectX(PointF pointF, PointF pointF2, float f, SWIGTYPE_p_float sWIGTYPE_p_float) {
        return OsmAndCoreJNI.Utilities_rayIntersectX__SWIG_1(PointF.getCPtr(pointF), pointF, PointF.getCPtr(pointF2), pointF2, f, SWIGTYPE_p_float.getCPtr(sWIGTYPE_p_float));
    }

    public static boolean rayIntersect(PointF pointF, PointF pointF2, PointF pointF3) {
        return OsmAndCoreJNI.Utilities_rayIntersect__SWIG_1(PointF.getCPtr(pointF), pointF, PointF.getCPtr(pointF2), pointF2, PointF.getCPtr(pointF3), pointF3);
    }

    public static boolean rayIntersectX(PointI pointI, PointI pointI2, int n, SWIGTYPE_p_int sWIGTYPE_p_int) {
        return OsmAndCoreJNI.Utilities_rayIntersectX__SWIG_2(PointI.getCPtr(pointI), pointI, PointI.getCPtr(pointI2), pointI2, n, SWIGTYPE_p_int.getCPtr(sWIGTYPE_p_int));
    }

    public static boolean rayIntersect(PointI pointI, PointI pointI2, PointI pointI3) {
        return OsmAndCoreJNI.Utilities_rayIntersect__SWIG_2(PointI.getCPtr(pointI), pointI, PointI.getCPtr(pointI2), pointI2, PointI.getCPtr(pointI3), pointI3);
    }

    public static double squaredDistanceBetweenPointAndLine(PointI pointI, PointI pointI2, PointI pointI3, SWIGTYPE_p_bool sWIGTYPE_p_bool) {
        return OsmAndCoreJNI.Utilities_squaredDistanceBetweenPointAndLine__SWIG_0(PointI.getCPtr(pointI), pointI, PointI.getCPtr(pointI2), pointI2, PointI.getCPtr(pointI3), pointI3, SWIGTYPE_p_bool.getCPtr(sWIGTYPE_p_bool));
    }

    public static double squaredDistanceBetweenPointAndLine(PointI pointI, PointI pointI2, PointI pointI3) {
        return OsmAndCoreJNI.Utilities_squaredDistanceBetweenPointAndLine__SWIG_1(PointI.getCPtr(pointI), pointI, PointI.getCPtr(pointI2), pointI2, PointI.getCPtr(pointI3), pointI3);
    }

    public static double distanceBetweenPointAndLine(PointI pointI, PointI pointI2, PointI pointI3, SWIGTYPE_p_bool sWIGTYPE_p_bool) {
        return OsmAndCoreJNI.Utilities_distanceBetweenPointAndLine__SWIG_0(PointI.getCPtr(pointI), pointI, PointI.getCPtr(pointI2), pointI2, PointI.getCPtr(pointI3), pointI3, SWIGTYPE_p_bool.getCPtr(sWIGTYPE_p_bool));
    }

    public static double distanceBetweenPointAndLine(PointI pointI, PointI pointI2, PointI pointI3) {
        return OsmAndCoreJNI.Utilities_distanceBetweenPointAndLine__SWIG_1(PointI.getCPtr(pointI), pointI, PointI.getCPtr(pointI2), pointI2, PointI.getCPtr(pointI3), pointI3);
    }

    public static double minimalSquaredDistanceToLineSegmentFromPoint(QVectorPointI qVectorPointI, PointI pointI, SWIGTYPE_p_int sWIGTYPE_p_int, SWIGTYPE_p_int sWIGTYPE_p_int2) {
        return OsmAndCoreJNI.Utilities_minimalSquaredDistanceToLineSegmentFromPoint__SWIG_0(QVectorPointI.getCPtr(qVectorPointI), qVectorPointI, PointI.getCPtr(pointI), pointI, SWIGTYPE_p_int.getCPtr(sWIGTYPE_p_int), SWIGTYPE_p_int.getCPtr(sWIGTYPE_p_int2));
    }

    public static double minimalSquaredDistanceToLineSegmentFromPoint(QVectorPointI qVectorPointI, PointI pointI, SWIGTYPE_p_int sWIGTYPE_p_int) {
        return OsmAndCoreJNI.Utilities_minimalSquaredDistanceToLineSegmentFromPoint__SWIG_1(QVectorPointI.getCPtr(qVectorPointI), qVectorPointI, PointI.getCPtr(pointI), pointI, SWIGTYPE_p_int.getCPtr(sWIGTYPE_p_int));
    }

    public static double minimalSquaredDistanceToLineSegmentFromPoint(QVectorPointI qVectorPointI, PointI pointI) {
        return OsmAndCoreJNI.Utilities_minimalSquaredDistanceToLineSegmentFromPoint__SWIG_2(QVectorPointI.getCPtr(qVectorPointI), qVectorPointI, PointI.getCPtr(pointI), pointI);
    }

    public static double minimalDistanceToLineSegmentFromPoint(QVectorPointI qVectorPointI, PointI pointI, SWIGTYPE_p_int sWIGTYPE_p_int, SWIGTYPE_p_int sWIGTYPE_p_int2) {
        return OsmAndCoreJNI.Utilities_minimalDistanceToLineSegmentFromPoint__SWIG_0(QVectorPointI.getCPtr(qVectorPointI), qVectorPointI, PointI.getCPtr(pointI), pointI, SWIGTYPE_p_int.getCPtr(sWIGTYPE_p_int), SWIGTYPE_p_int.getCPtr(sWIGTYPE_p_int2));
    }

    public static double minimalDistanceToLineSegmentFromPoint(QVectorPointI qVectorPointI, PointI pointI, SWIGTYPE_p_int sWIGTYPE_p_int) {
        return OsmAndCoreJNI.Utilities_minimalDistanceToLineSegmentFromPoint__SWIG_1(QVectorPointI.getCPtr(qVectorPointI), qVectorPointI, PointI.getCPtr(pointI), pointI, SWIGTYPE_p_int.getCPtr(sWIGTYPE_p_int));
    }

    public static double minimalDistanceToLineSegmentFromPoint(QVectorPointI qVectorPointI, PointI pointI) {
        return OsmAndCoreJNI.Utilities_minimalDistanceToLineSegmentFromPoint__SWIG_2(QVectorPointI.getCPtr(qVectorPointI), qVectorPointI, PointI.getCPtr(pointI), pointI);
    }

    public static double degreesDiff(double d, double d2) {
        return OsmAndCoreJNI.Utilities_degreesDiff(d, d2);
    }

    public static AreaI tileBoundingBox31(TileId tileId, ZoomLevel zoomLevel) {
        return new AreaI(OsmAndCoreJNI.Utilities_tileBoundingBox31(TileId.getCPtr(tileId), tileId, zoomLevel.swigValue()), true);
    }

    public static AreaI roundBoundingBox31(AreaI areaI, ZoomLevel zoomLevel) {
        return new AreaI(OsmAndCoreJNI.Utilities_roundBoundingBox31(AreaI.getCPtr(areaI), areaI, zoomLevel.swigValue()), true);
    }

    public static long interleaveBy1(int n) {
        return OsmAndCoreJNI.Utilities_interleaveBy1(n);
    }

    public static long encodeMortonCode(int n, int n2) {
        return OsmAndCoreJNI.Utilities_encodeMortonCode(n, n2);
    }

    public static int deinterleaveBy1(long l) {
        return OsmAndCoreJNI.Utilities_deinterleaveBy1(l);
    }

    public static void decodeMortonCode(long l, SWIGTYPE_p_unsigned_short sWIGTYPE_p_unsigned_short, SWIGTYPE_p_unsigned_short sWIGTYPE_p_unsigned_short2) {
        OsmAndCoreJNI.Utilities_decodeMortonCode(l, SWIGTYPE_p_unsigned_short.getCPtr(sWIGTYPE_p_unsigned_short), SWIGTYPE_p_unsigned_short.getCPtr(sWIGTYPE_p_unsigned_short2));
    }

    public static QVectorPointI simplifyPathOutsideBBox(QVectorPointI qVectorPointI, AreaI areaI) {
        return new QVectorPointI(OsmAndCoreJNI.Utilities_simplifyPathOutsideBBox(QVectorPointI.getCPtr(qVectorPointI), qVectorPointI, AreaI.getCPtr(areaI), areaI), true);
    }

    public static AreaI getEnlargedPrimitivesArea(AreaI areaI) {
        return new AreaI(OsmAndCoreJNI.Utilities_getEnlargedPrimitivesArea(AreaI.getCPtr(areaI), areaI), true);
    }

    public static AreaI getEnlargedVisibleArea(AreaI areaI) {
        return new AreaI(OsmAndCoreJNI.Utilities_getEnlargedVisibleArea(AreaI.getCPtr(areaI), areaI), true);
    }

    public static TileIdVector getAllMetaTileIds(TileId tileId) {
        return new TileIdVector(OsmAndCoreJNI.Utilities_getAllMetaTileIds(TileId.getCPtr(tileId), tileId), true);
    }

    public static TileIdVector getMetaTileIds(TileId tileId) {
        return new TileIdVector(OsmAndCoreJNI.Utilities_getMetaTileIds(TileId.getCPtr(tileId), tileId), true);
    }

    public static TileIdVector getTileIdsUnderscaledByZoomShift(TileId tileId, long l) {
        return new TileIdVector(OsmAndCoreJNI.Utilities_getTileIdsUnderscaledByZoomShift(TileId.getCPtr(tileId), tileId, l), true);
    }

    public static TileId getTileIdOverscaledByZoomShift(TileId tileId, long l, PointF pointF, PointF pointF2) {
        return new TileId(OsmAndCoreJNI.Utilities_getTileIdOverscaledByZoomShift__SWIG_0(TileId.getCPtr(tileId), tileId, l, PointF.getCPtr(pointF), pointF, PointF.getCPtr(pointF2), pointF2), true);
    }

    public static TileId getTileIdOverscaledByZoomShift(TileId tileId, long l, PointF pointF) {
        return new TileId(OsmAndCoreJNI.Utilities_getTileIdOverscaledByZoomShift__SWIG_1(TileId.getCPtr(tileId), tileId, l, PointF.getCPtr(pointF), pointF), true);
    }

    public static TileId getTileIdOverscaledByZoomShift(TileId tileId, long l) {
        return new TileId(OsmAndCoreJNI.Utilities_getTileIdOverscaledByZoomShift__SWIG_2(TileId.getCPtr(tileId), tileId, l), true);
    }

    public static AreaI areaRightShift(AreaI areaI, long l) {
        return new AreaI(OsmAndCoreJNI.Utilities_areaRightShift(AreaI.getCPtr(areaI), areaI, l), true);
    }

    public static AreaI areaLeftShift(AreaI areaI, long l) {
        return new AreaI(OsmAndCoreJNI.Utilities_areaLeftShift(AreaI.getCPtr(areaI), areaI, l), true);
    }

    public static long getNextPowerOfTwo(long l) {
        return OsmAndCoreJNI.Utilities_getNextPowerOfTwo(l);
    }

    public static long getPreviousPowerOfTwo(long l) {
        return OsmAndCoreJNI.Utilities_getPreviousPowerOfTwo(l);
    }

    public static int commonDivisor(int n, int n2) {
        return OsmAndCoreJNI.Utilities_commonDivisor(n, n2);
    }

    public static double getMetersPerTileUnit(float f, double d, double d2) {
        return OsmAndCoreJNI.Utilities_getMetersPerTileUnit(f, d, d2);
    }

    public static PointD getTileEllipsoidNumberAndOffsetY(int n, double d, int n2) {
        return new PointD(OsmAndCoreJNI.Utilities_getTileEllipsoidNumberAndOffsetY(n, d, n2), true);
    }

    public static TileId getTileId(PointI pointI, ZoomLevel zoomLevel, PointF pointF, PointI pointI2) {
        return new TileId(OsmAndCoreJNI.Utilities_getTileId__SWIG_0(PointI.getCPtr(pointI), pointI, zoomLevel.swigValue(), PointF.getCPtr(pointF), pointF, PointI.getCPtr(pointI2), pointI2), true);
    }

    public static TileId getTileId(PointI pointI, ZoomLevel zoomLevel, PointF pointF) {
        return new TileId(OsmAndCoreJNI.Utilities_getTileId__SWIG_1(PointI.getCPtr(pointI), pointI, zoomLevel.swigValue(), PointF.getCPtr(pointF), pointF), true);
    }

    public static TileId getTileId(PointI pointI, ZoomLevel zoomLevel) {
        return new TileId(OsmAndCoreJNI.Utilities_getTileId__SWIG_2(PointI.getCPtr(pointI), pointI, zoomLevel.swigValue()), true);
    }

    public static TileId normalizeTileId(TileId tileId, ZoomLevel zoomLevel) {
        return new TileId(OsmAndCoreJNI.Utilities_normalizeTileId(TileId.getCPtr(tileId), tileId, zoomLevel.swigValue()), true);
    }

    public static PointI normalizeCoordinates(PointI pointI, ZoomLevel zoomLevel) {
        return new PointI(OsmAndCoreJNI.Utilities_normalizeCoordinates(PointI.getCPtr(pointI), pointI, zoomLevel.swigValue()), true);
    }

    public static PointI wrapCoordinates(SWIGTYPE_p_OsmAnd__PointT_long_long_t sWIGTYPE_p_OsmAnd__PointT_long_long_t) {
        return new PointI(OsmAndCoreJNI.Utilities_wrapCoordinates(SWIGTYPE_p_OsmAnd__PointT_long_long_t.getCPtr(sWIGTYPE_p_OsmAnd__PointT_long_long_t)), true);
    }

    public static PointI shortestVector31(PointI pointI) {
        return new PointI(OsmAndCoreJNI.Utilities_shortestVector31__SWIG_0(PointI.getCPtr(pointI), pointI), true);
    }

    public static PointI shortestVector(PointI pointI, ZoomLevel zoomLevel) {
        return new PointI(OsmAndCoreJNI.Utilities_shortestVector(PointI.getCPtr(pointI), pointI, zoomLevel.swigValue()), true);
    }

    public static PointI shortestVector31(PointI pointI, PointI pointI2) {
        return new PointI(OsmAndCoreJNI.Utilities_shortestVector31__SWIG_1(PointI.getCPtr(pointI), pointI, PointI.getCPtr(pointI2), pointI2), true);
    }

    public static PointI shortestLongitudeVector(PointI pointI) {
        return new PointI(OsmAndCoreJNI.Utilities_shortestLongitudeVector(PointI.getCPtr(pointI), pointI), true);
    }

    public static SWIGTYPE_p_glm__dvec3 getGlobeRadialVector(PointD pointD) {
        return new SWIGTYPE_p_glm__dvec3(OsmAndCoreJNI.Utilities_getGlobeRadialVector__SWIG_0(PointD.getCPtr(pointD), pointD), true);
    }

    public static SWIGTYPE_p_glm__dvec3 getGlobeRadialVector(PointI pointI, PointD pointD) {
        return new SWIGTYPE_p_glm__dvec3(OsmAndCoreJNI.Utilities_getGlobeRadialVector__SWIG_1(PointI.getCPtr(pointI), pointI, PointD.getCPtr(pointD), pointD), true);
    }

    public static SWIGTYPE_p_glm__dvec3 getGlobeRadialVector(PointI pointI) {
        return new SWIGTYPE_p_glm__dvec3(OsmAndCoreJNI.Utilities_getGlobeRadialVector__SWIG_2(PointI.getCPtr(pointI), pointI), true);
    }

    public static SWIGTYPE_p_glm__vec3 planeWorldCoordinates(PointI pointI, PointI pointI2, ZoomLevel zoomLevel, float f, double d) {
        return new SWIGTYPE_p_glm__vec3(OsmAndCoreJNI.Utilities_planeWorldCoordinates(PointI.getCPtr(pointI), pointI, PointI.getCPtr(pointI2), pointI2, zoomLevel.swigValue(), f, d), true);
    }

    public static SWIGTYPE_p_glm__vec3 sphericalWorldCoordinates(PointI pointI, SWIGTYPE_p_glm__dmat3 sWIGTYPE_p_glm__dmat3, double d, double d2, PointD pointD) {
        return new SWIGTYPE_p_glm__vec3(OsmAndCoreJNI.Utilities_sphericalWorldCoordinates__SWIG_0(PointI.getCPtr(pointI), pointI, SWIGTYPE_p_glm__dmat3.getCPtr(sWIGTYPE_p_glm__dmat3), d, d2, PointD.getCPtr(pointD), pointD), true);
    }

    public static SWIGTYPE_p_glm__vec3 sphericalWorldCoordinates(PointI pointI, SWIGTYPE_p_glm__dmat3 sWIGTYPE_p_glm__dmat3, double d, double d2) {
        return new SWIGTYPE_p_glm__vec3(OsmAndCoreJNI.Utilities_sphericalWorldCoordinates__SWIG_1(PointI.getCPtr(pointI), pointI, SWIGTYPE_p_glm__dmat3.getCPtr(sWIGTYPE_p_glm__dmat3), d, d2), true);
    }

    public static double snapToGridDecimal(double d) {
        return OsmAndCoreJNI.Utilities_snapToGridDecimal(d);
    }

    public static double snapToGridSexagesimal(double d) {
        return OsmAndCoreJNI.Utilities_snapToGridSexagesimal(d);
    }

    public static double snapToGridDMS(double d) {
        return OsmAndCoreJNI.Utilities_snapToGridDMS(d);
    }

    public static double snapToGridDM(double d) {
        return OsmAndCoreJNI.Utilities_snapToGridDM(d);
    }

    public static int extractFirstInteger(String string) {
        return OsmAndCoreJNI.Utilities_extractFirstInteger(string);
    }

    public static int extractIntegerNumber(String string) {
        return OsmAndCoreJNI.Utilities_extractIntegerNumber(string);
    }

    public static boolean extractFirstNumberPosition(String string, SWIGTYPE_p_int sWIGTYPE_p_int, SWIGTYPE_p_int sWIGTYPE_p_int2, boolean bl, boolean bl2) {
        return OsmAndCoreJNI.Utilities_extractFirstNumberPosition(string, SWIGTYPE_p_int.getCPtr(sWIGTYPE_p_int), SWIGTYPE_p_int.getCPtr(sWIGTYPE_p_int2), bl, bl2);
    }

    public static double parseSpeed(String string, double d, SWIGTYPE_p_bool sWIGTYPE_p_bool) {
        return OsmAndCoreJNI.Utilities_parseSpeed__SWIG_0(string, d, SWIGTYPE_p_bool.getCPtr(sWIGTYPE_p_bool));
    }

    public static double parseSpeed(String string, double d) {
        return OsmAndCoreJNI.Utilities_parseSpeed__SWIG_1(string, d);
    }

    public static double parseLength(String string, double d, SWIGTYPE_p_bool sWIGTYPE_p_bool) {
        return OsmAndCoreJNI.Utilities_parseLength__SWIG_0(string, d, SWIGTYPE_p_bool.getCPtr(sWIGTYPE_p_bool));
    }

    public static double parseLength(String string, double d) {
        return OsmAndCoreJNI.Utilities_parseLength__SWIG_1(string, d);
    }

    public static double parseWeight(String string, double d, SWIGTYPE_p_bool sWIGTYPE_p_bool) {
        return OsmAndCoreJNI.Utilities_parseWeight__SWIG_0(string, d, SWIGTYPE_p_bool.getCPtr(sWIGTYPE_p_bool));
    }

    public static double parseWeight(String string, double d) {
        return OsmAndCoreJNI.Utilities_parseWeight__SWIG_1(string, d);
    }

    public static ColorARGB parseColor(String string, ColorARGB colorARGB, SWIGTYPE_p_bool sWIGTYPE_p_bool) {
        return new ColorARGB(OsmAndCoreJNI.Utilities_parseColor__SWIG_0(string, ColorARGB.getCPtr(colorARGB), colorARGB, SWIGTYPE_p_bool.getCPtr(sWIGTYPE_p_bool)), true);
    }

    public static ColorARGB parseColor(String string, ColorARGB colorARGB) {
        return new ColorARGB(OsmAndCoreJNI.Utilities_parseColor__SWIG_1(string, ColorARGB.getCPtr(colorARGB), colorARGB), true);
    }

    public static boolean isColorBright(ColorARGB colorARGB) {
        return OsmAndCoreJNI.Utilities_isColorBright__SWIG_0(ColorARGB.getCPtr(colorARGB), colorARGB);
    }

    public static boolean isColorBright(ColorRGB colorRGB) {
        return OsmAndCoreJNI.Utilities_isColorBright__SWIG_1(ColorRGB.getCPtr(colorRGB), colorRGB);
    }

    public static int parseArbitraryInt(String string, int n, SWIGTYPE_p_bool sWIGTYPE_p_bool) {
        return OsmAndCoreJNI.Utilities_parseArbitraryInt__SWIG_0(string, n, SWIGTYPE_p_bool.getCPtr(sWIGTYPE_p_bool));
    }

    public static int parseArbitraryInt(String string, int n) {
        return OsmAndCoreJNI.Utilities_parseArbitraryInt__SWIG_1(string, n);
    }

    public static int parseArbitraryLong(String string, int n, SWIGTYPE_p_bool sWIGTYPE_p_bool) {
        return OsmAndCoreJNI.Utilities_parseArbitraryLong__SWIG_0(string, n, SWIGTYPE_p_bool.getCPtr(sWIGTYPE_p_bool));
    }

    public static int parseArbitraryLong(String string, int n) {
        return OsmAndCoreJNI.Utilities_parseArbitraryLong__SWIG_1(string, n);
    }

    public static long parseArbitraryUInt(String string, long l, SWIGTYPE_p_bool sWIGTYPE_p_bool) {
        return OsmAndCoreJNI.Utilities_parseArbitraryUInt__SWIG_0(string, l, SWIGTYPE_p_bool.getCPtr(sWIGTYPE_p_bool));
    }

    public static long parseArbitraryUInt(String string, long l) {
        return OsmAndCoreJNI.Utilities_parseArbitraryUInt__SWIG_1(string, l);
    }

    public static long parseArbitraryULong(String string, long l, SWIGTYPE_p_bool sWIGTYPE_p_bool) {
        return OsmAndCoreJNI.Utilities_parseArbitraryULong__SWIG_0(string, l, SWIGTYPE_p_bool.getCPtr(sWIGTYPE_p_bool));
    }

    public static long parseArbitraryULong(String string, long l) {
        return OsmAndCoreJNI.Utilities_parseArbitraryULong__SWIG_1(string, l);
    }

    public static float parseArbitraryFloat(String string, float f, SWIGTYPE_p_bool sWIGTYPE_p_bool) {
        return OsmAndCoreJNI.Utilities_parseArbitraryFloat__SWIG_0(string, f, SWIGTYPE_p_bool.getCPtr(sWIGTYPE_p_bool));
    }

    public static float parseArbitraryFloat(String string, float f) {
        return OsmAndCoreJNI.Utilities_parseArbitraryFloat__SWIG_1(string, f);
    }

    public static boolean parseArbitraryBool(String string, boolean bl, SWIGTYPE_p_bool sWIGTYPE_p_bool) {
        return OsmAndCoreJNI.Utilities_parseArbitraryBool__SWIG_0(string, bl, SWIGTYPE_p_bool.getCPtr(sWIGTYPE_p_bool));
    }

    public static boolean parseArbitraryBool(String string, boolean bl) {
        return OsmAndCoreJNI.Utilities_parseArbitraryBool__SWIG_1(string, bl);
    }

    public static int javaDoubleCompare(double d, double d2) {
        return OsmAndCoreJNI.Utilities_javaDoubleCompare(d, d2);
    }

    public static void findFiles(SWIGTYPE_p_QDir sWIGTYPE_p_QDir, SWIGTYPE_p_QStringList sWIGTYPE_p_QStringList, SWIGTYPE_p_QFileInfoList sWIGTYPE_p_QFileInfoList, boolean bl) {
        OsmAndCoreJNI.Utilities_findFiles__SWIG_0(SWIGTYPE_p_QDir.getCPtr(sWIGTYPE_p_QDir), SWIGTYPE_p_QStringList.getCPtr(sWIGTYPE_p_QStringList), SWIGTYPE_p_QFileInfoList.getCPtr(sWIGTYPE_p_QFileInfoList), bl);
    }

    public static void findFiles(SWIGTYPE_p_QDir sWIGTYPE_p_QDir, SWIGTYPE_p_QStringList sWIGTYPE_p_QStringList, SWIGTYPE_p_QFileInfoList sWIGTYPE_p_QFileInfoList) {
        OsmAndCoreJNI.Utilities_findFiles__SWIG_1(SWIGTYPE_p_QDir.getCPtr(sWIGTYPE_p_QDir), SWIGTYPE_p_QStringList.getCPtr(sWIGTYPE_p_QStringList), SWIGTYPE_p_QFileInfoList.getCPtr(sWIGTYPE_p_QFileInfoList));
    }

    public static void findDirectories(SWIGTYPE_p_QDir sWIGTYPE_p_QDir, SWIGTYPE_p_QStringList sWIGTYPE_p_QStringList, SWIGTYPE_p_QFileInfoList sWIGTYPE_p_QFileInfoList, boolean bl) {
        OsmAndCoreJNI.Utilities_findDirectories__SWIG_0(SWIGTYPE_p_QDir.getCPtr(sWIGTYPE_p_QDir), SWIGTYPE_p_QStringList.getCPtr(sWIGTYPE_p_QStringList), SWIGTYPE_p_QFileInfoList.getCPtr(sWIGTYPE_p_QFileInfoList), bl);
    }

    public static void findDirectories(SWIGTYPE_p_QDir sWIGTYPE_p_QDir, SWIGTYPE_p_QStringList sWIGTYPE_p_QStringList, SWIGTYPE_p_QFileInfoList sWIGTYPE_p_QFileInfoList) {
        OsmAndCoreJNI.Utilities_findDirectories__SWIG_1(SWIGTYPE_p_QDir.getCPtr(sWIGTYPE_p_QDir), SWIGTYPE_p_QStringList.getCPtr(sWIGTYPE_p_QStringList), SWIGTYPE_p_QFileInfoList.getCPtr(sWIGTYPE_p_QFileInfoList));
    }

    public static SWIGTYPE_p_QSetT_OsmAnd__ZoomLevel_t enumerateZoomLevels(ZoomLevel zoomLevel, ZoomLevel zoomLevel2) {
        return new SWIGTYPE_p_QSetT_OsmAnd__ZoomLevel_t(OsmAndCoreJNI.Utilities_enumerateZoomLevels(zoomLevel.swigValue(), zoomLevel2.swigValue()), true);
    }

    public static String stringifyZoomLevels(SWIGTYPE_p_QSetT_OsmAnd__ZoomLevel_t sWIGTYPE_p_QSetT_OsmAnd__ZoomLevel_t) {
        return OsmAndCoreJNI.Utilities_stringifyZoomLevels(SWIGTYPE_p_QSetT_OsmAnd__ZoomLevel_t.getCPtr(sWIGTYPE_p_QSetT_OsmAnd__ZoomLevel_t));
    }

    public static String getQuadKey(long l, long l2, long l3) {
        return OsmAndCoreJNI.Utilities_getQuadKey(l, l2, l3);
    }

    public static SWIGTYPE_p_QListT_OsmAnd__Utilities__ItemPointOnPath_t calculateItemPointsOnPath(float f, float f2, float f3, float f4) {
        return new SWIGTYPE_p_QListT_OsmAnd__Utilities__ItemPointOnPath_t(OsmAndCoreJNI.Utilities_calculateItemPointsOnPath__SWIG_0(f, f2, f3, f4), true);
    }

    public static SWIGTYPE_p_QListT_OsmAnd__Utilities__ItemPointOnPath_t calculateItemPointsOnPath(float f, float f2, float f3) {
        return new SWIGTYPE_p_QListT_OsmAnd__Utilities__ItemPointOnPath_t(OsmAndCoreJNI.Utilities_calculateItemPointsOnPath__SWIG_1(f, f2, f3), true);
    }

    public static SWIGTYPE_p_QListT_OsmAnd__Utilities__ItemPointOnPath_t calculateItemPointsOnPath(float f, float f2) {
        return new SWIGTYPE_p_QListT_OsmAnd__Utilities__ItemPointOnPath_t(OsmAndCoreJNI.Utilities_calculateItemPointsOnPath__SWIG_2(f, f2), true);
    }

    public static String resolveColorFromPalette(String string, boolean bl) {
        return OsmAndCoreJNI.Utilities_resolveColorFromPalette(string, bl);
    }

    public static LatLon rhumbDestinationPoint(LatLon latLon, double d, double d2) {
        return new LatLon(OsmAndCoreJNI.Utilities_rhumbDestinationPoint__SWIG_0(LatLon.getCPtr(latLon), latLon, d, d2), true);
    }

    public static LatLon rhumbDestinationPoint(double d, double d2, double d3, double d4) {
        return new LatLon(OsmAndCoreJNI.Utilities_rhumbDestinationPoint__SWIG_1(d, d2, d3, d4), true);
    }

    public static SWIGTYPE_p_std__pairT_int_int_t calculateFinalXYFromBaseAndPrecisionXY(int n, int n2, int n3, int n4, int n5, boolean bl) {
        return new SWIGTYPE_p_std__pairT_int_int_t(OsmAndCoreJNI.Utilities_calculateFinalXYFromBaseAndPrecisionXY(n, n2, n3, n4, n5, bl), true);
    }

    public static boolean isPointInsidePolygon(PointI pointI, QVectorPointI qVectorPointI) {
        return OsmAndCoreJNI.Utilities_isPointInsidePolygon(PointI.getCPtr(pointI), pointI, QVectorPointI.getCPtr(qVectorPointI), qVectorPointI);
    }

    public static void resizeVector(PointF pointF, PointF pointF2, float f) {
        OsmAndCoreJNI.Utilities_resizeVector(PointF.getCPtr(pointF), pointF, PointF.getCPtr(pointF2), pointF2, f);
    }

    public static PointF computeNormalToLine(PointF pointF, PointF pointF2, boolean bl) {
        return new PointF(OsmAndCoreJNI.Utilities_computeNormalToLine(PointF.getCPtr(pointF), pointF, PointF.getCPtr(pointF2), pointF2, bl), true);
    }

    public static SWIGTYPE_p_glm__vec3 calculatePlaneN(SWIGTYPE_p_glm__vec3 sWIGTYPE_p_glm__vec3, SWIGTYPE_p_glm__vec3 sWIGTYPE_p_glm__vec32, SWIGTYPE_p_glm__vec3 sWIGTYPE_p_glm__vec33) {
        return new SWIGTYPE_p_glm__vec3(OsmAndCoreJNI.Utilities_calculatePlaneN(SWIGTYPE_p_glm__vec3.getCPtr(sWIGTYPE_p_glm__vec3), SWIGTYPE_p_glm__vec3.getCPtr(sWIGTYPE_p_glm__vec32), SWIGTYPE_p_glm__vec3.getCPtr(sWIGTYPE_p_glm__vec33)), true);
    }

    public static boolean calculateIntersection(SWIGTYPE_p_OsmAnd__PointT_long_long_t sWIGTYPE_p_OsmAnd__PointT_long_long_t, SWIGTYPE_p_OsmAnd__PointT_long_long_t sWIGTYPE_p_OsmAnd__PointT_long_long_t2, AreaI areaI, SWIGTYPE_p_OsmAnd__PointT_long_long_t sWIGTYPE_p_OsmAnd__PointT_long_long_t3) {
        return OsmAndCoreJNI.Utilities_calculateIntersection__SWIG_0(SWIGTYPE_p_OsmAnd__PointT_long_long_t.getCPtr(sWIGTYPE_p_OsmAnd__PointT_long_long_t), SWIGTYPE_p_OsmAnd__PointT_long_long_t.getCPtr(sWIGTYPE_p_OsmAnd__PointT_long_long_t2), AreaI.getCPtr(areaI), areaI, SWIGTYPE_p_OsmAnd__PointT_long_long_t.getCPtr(sWIGTYPE_p_OsmAnd__PointT_long_long_t3));
    }

    public static boolean calculateIntersection(PointI pointI, PointI pointI2, AreaI areaI, PointI pointI3) {
        return OsmAndCoreJNI.Utilities_calculateIntersection__SWIG_1(PointI.getCPtr(pointI), pointI, PointI.getCPtr(pointI2), pointI2, AreaI.getCPtr(areaI), areaI, PointI.getCPtr(pointI3), pointI3);
    }

    public static double calculateShortestPath(SWIGTYPE_p_OsmAnd__PointT_long_long_t sWIGTYPE_p_OsmAnd__PointT_long_long_t, PointI pointI, PointI pointI2, SWIGTYPE_p_OsmAnd__PointT_long_long_t sWIGTYPE_p_OsmAnd__PointT_long_long_t2, SWIGTYPE_p_OsmAnd__PointT_long_long_t sWIGTYPE_p_OsmAnd__PointT_long_long_t3, SWIGTYPE_p_QVectorT_OsmAnd__PointT_long_long_t_t sWIGTYPE_p_QVectorT_OsmAnd__PointT_long_long_t_t) {
        return OsmAndCoreJNI.Utilities_calculateShortestPath__SWIG_0(SWIGTYPE_p_OsmAnd__PointT_long_long_t.getCPtr(sWIGTYPE_p_OsmAnd__PointT_long_long_t), PointI.getCPtr(pointI), pointI, PointI.getCPtr(pointI2), pointI2, SWIGTYPE_p_OsmAnd__PointT_long_long_t.getCPtr(sWIGTYPE_p_OsmAnd__PointT_long_long_t2), SWIGTYPE_p_OsmAnd__PointT_long_long_t.getCPtr(sWIGTYPE_p_OsmAnd__PointT_long_long_t3), SWIGTYPE_p_QVectorT_OsmAnd__PointT_long_long_t_t.getCPtr(sWIGTYPE_p_QVectorT_OsmAnd__PointT_long_long_t_t));
    }

    public static double calculateShortestPath(SWIGTYPE_p_OsmAnd__PointT_long_long_t sWIGTYPE_p_OsmAnd__PointT_long_long_t, PointI pointI, PointI pointI2, SWIGTYPE_p_OsmAnd__PointT_long_long_t sWIGTYPE_p_OsmAnd__PointT_long_long_t2, SWIGTYPE_p_OsmAnd__PointT_long_long_t sWIGTYPE_p_OsmAnd__PointT_long_long_t3) {
        return OsmAndCoreJNI.Utilities_calculateShortestPath__SWIG_1(SWIGTYPE_p_OsmAnd__PointT_long_long_t.getCPtr(sWIGTYPE_p_OsmAnd__PointT_long_long_t), PointI.getCPtr(pointI), pointI, PointI.getCPtr(pointI2), pointI2, SWIGTYPE_p_OsmAnd__PointT_long_long_t.getCPtr(sWIGTYPE_p_OsmAnd__PointT_long_long_t2), SWIGTYPE_p_OsmAnd__PointT_long_long_t.getCPtr(sWIGTYPE_p_OsmAnd__PointT_long_long_t3));
    }

    public static void logDebugTileBBox(TileId tileId, ZoomLevel zoomLevel, String string, String string2) {
        OsmAndCoreJNI.Utilities_logDebugTileBBox__SWIG_0(TileId.getCPtr(tileId), tileId, zoomLevel.swigValue(), string, string2);
    }

    public static void logDebugTileBBox(TileId tileId, ZoomLevel zoomLevel, String string) {
        OsmAndCoreJNI.Utilities_logDebugTileBBox__SWIG_1(TileId.getCPtr(tileId), tileId, zoomLevel.swigValue(), string);
    }

    public static void logDebugTileBBox(TileId tileId, ZoomLevel zoomLevel) {
        OsmAndCoreJNI.Utilities_logDebugTileBBox__SWIG_2(TileId.getCPtr(tileId), tileId, zoomLevel.swigValue());
    }

    public static void logDebugBBox(AreaI areaI, ZoomLevel zoomLevel, String string, String string2) {
        OsmAndCoreJNI.Utilities_logDebugBBox__SWIG_0(AreaI.getCPtr(areaI), areaI, zoomLevel.swigValue(), string, string2);
    }

    public static void logDebugBBox(AreaI areaI, ZoomLevel zoomLevel, String string) {
        OsmAndCoreJNI.Utilities_logDebugBBox__SWIG_1(AreaI.getCPtr(areaI), areaI, zoomLevel.swigValue(), string);
    }

    public static void logDebugBBox(AreaI areaI, ZoomLevel zoomLevel) {
        OsmAndCoreJNI.Utilities_logDebugBBox__SWIG_2(AreaI.getCPtr(areaI), areaI, zoomLevel.swigValue());
    }

    public static void logDebugBBox(AreaI areaI) {
        OsmAndCoreJNI.Utilities_logDebugBBox__SWIG_3(AreaI.getCPtr(areaI), areaI);
    }

    public static void logDebugPath(QVectorPointI qVectorPointI, ZoomLevel zoomLevel, String string, String string2) {
        OsmAndCoreJNI.Utilities_logDebugPath__SWIG_0(QVectorPointI.getCPtr(qVectorPointI), qVectorPointI, zoomLevel.swigValue(), string, string2);
    }

    public static void logDebugPath(QVectorPointI qVectorPointI, ZoomLevel zoomLevel, String string) {
        OsmAndCoreJNI.Utilities_logDebugPath__SWIG_1(QVectorPointI.getCPtr(qVectorPointI), qVectorPointI, zoomLevel.swigValue(), string);
    }

    public static void logDebugPath(QVectorPointI qVectorPointI, ZoomLevel zoomLevel) {
        OsmAndCoreJNI.Utilities_logDebugPath__SWIG_2(QVectorPointI.getCPtr(qVectorPointI), qVectorPointI, zoomLevel.swigValue());
    }

    public static void logDebugPath(QVectorPointI qVectorPointI) {
        OsmAndCoreJNI.Utilities_logDebugPath__SWIG_3(QVectorPointI.getCPtr(qVectorPointI), qVectorPointI);
    }

    public static void logDebugPoint(PointI pointI, ZoomLevel zoomLevel, String string, String string2) {
        OsmAndCoreJNI.Utilities_logDebugPoint__SWIG_0(PointI.getCPtr(pointI), pointI, zoomLevel.swigValue(), string, string2);
    }

    public static void logDebugPoint(PointI pointI, ZoomLevel zoomLevel, String string) {
        OsmAndCoreJNI.Utilities_logDebugPoint__SWIG_1(PointI.getCPtr(pointI), pointI, zoomLevel.swigValue(), string);
    }

    public static void logDebugPoint(PointI pointI, ZoomLevel zoomLevel) {
        OsmAndCoreJNI.Utilities_logDebugPoint__SWIG_2(PointI.getCPtr(pointI), pointI, zoomLevel.swigValue());
    }

    public static void logDebugPoint(PointI pointI) {
        OsmAndCoreJNI.Utilities_logDebugPoint__SWIG_3(PointI.getCPtr(pointI), pointI);
    }

    public static boolean contains(QVectorPointI qVectorPointI, PointI pointI) {
        return OsmAndCoreJNI.Utilities_contains(QVectorPointI.getCPtr(qVectorPointI), qVectorPointI, PointI.getCPtr(pointI), pointI);
    }

    public static String splitAndClearRepeats(String string, String string2) {
        return OsmAndCoreJNI.Utilities_splitAndClearRepeats(string, string2);
    }

    public static enum CHCode {
        Left(OsmAndCoreJNI.Utilities_CHCode_Left_get()),
        Right,
        Bottom,
        Top;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static CHCode swigToEnum(int n) {
            CHCode[] cHCodeArray = (CHCode[])CHCode.class.getEnumConstants();
            if (n < cHCodeArray.length && n >= 0 && cHCodeArray[n].swigValue == n) {
                return cHCodeArray[n];
            }
            for (CHCode cHCode : cHCodeArray) {
                if (cHCode.swigValue != n) continue;
                return cHCode;
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(CHCode.class) + " with value " + n);
        }

        private CHCode() {
            this.swigValue = SwigNext.next++;
        }

        private CHCode(int n2) {
            this.swigValue = n2;
            SwigNext.next = n2 + 1;
        }

        private CHCode(CHCode cHCode) {
            this.swigValue = cHCode.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static class ItemPointOnPath {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        protected ItemPointOnPath(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(ItemPointOnPath itemPointOnPath) {
            return itemPointOnPath == null ? 0L : itemPointOnPath.swigCPtr;
        }

        protected static long swigRelease(ItemPointOnPath itemPointOnPath) {
            long l = 0L;
            if (itemPointOnPath != null) {
                if (!itemPointOnPath.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                l = itemPointOnPath.swigCPtr;
                itemPointOnPath.swigCMemOwn = false;
                itemPointOnPath.delete();
            }
            return l;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    OsmAndCoreJNI.delete_Utilities_ItemPointOnPath(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public void setPriority(int n) {
            OsmAndCoreJNI.Utilities_ItemPointOnPath_priority_set(this.swigCPtr, this, n);
        }

        public int getPriority() {
            return OsmAndCoreJNI.Utilities_ItemPointOnPath_priority_get(this.swigCPtr, this);
        }

        public void setItemCenterOffset(float f) {
            OsmAndCoreJNI.Utilities_ItemPointOnPath_itemCenterOffset_set(this.swigCPtr, this, f);
        }

        public float getItemCenterOffset() {
            return OsmAndCoreJNI.Utilities_ItemPointOnPath_itemCenterOffset_get(this.swigCPtr, this);
        }

        public void setItemCenterN(float f) {
            OsmAndCoreJNI.Utilities_ItemPointOnPath_itemCenterN_set(this.swigCPtr, this, f);
        }

        public float getItemCenterN() {
            return OsmAndCoreJNI.Utilities_ItemPointOnPath_itemCenterN_get(this.swigCPtr, this);
        }

        public ItemPointOnPath() {
            this(OsmAndCoreJNI.new_Utilities_ItemPointOnPath(), true);
        }

        public static class PriorityComparator {
            private transient long swigCPtr;
            protected transient boolean swigCMemOwn;

            protected PriorityComparator(long l, boolean bl) {
                this.swigCMemOwn = bl;
                this.swigCPtr = l;
            }

            protected static long getCPtr(PriorityComparator priorityComparator) {
                return priorityComparator == null ? 0L : priorityComparator.swigCPtr;
            }

            protected static long swigRelease(PriorityComparator priorityComparator) {
                long l = 0L;
                if (priorityComparator != null) {
                    if (!priorityComparator.swigCMemOwn) {
                        throw new RuntimeException("Cannot release ownership as memory is not owned");
                    }
                    l = priorityComparator.swigCPtr;
                    priorityComparator.swigCMemOwn = false;
                    priorityComparator.delete();
                }
                return l;
            }

            protected void finalize() {
                this.delete();
            }

            public synchronized void delete() {
                if (this.swigCPtr != 0L) {
                    if (this.swigCMemOwn) {
                        this.swigCMemOwn = false;
                        OsmAndCoreJNI.delete_Utilities_ItemPointOnPath_PriorityComparator(this.swigCPtr);
                    }
                    this.swigCPtr = 0L;
                }
            }

            public boolean method(ItemPointOnPath itemPointOnPath, ItemPointOnPath itemPointOnPath2) {
                return OsmAndCoreJNI.Utilities_ItemPointOnPath_PriorityComparator_method(this.swigCPtr, this, ItemPointOnPath.getCPtr(itemPointOnPath), itemPointOnPath, ItemPointOnPath.getCPtr(itemPointOnPath2), itemPointOnPath2);
            }

            public PriorityComparator() {
                this(OsmAndCoreJNI.new_Utilities_ItemPointOnPath_PriorityComparator(), true);
            }
        }
    }
}

