/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.dict;

import com.atilika.kuromoji.dict.CharacterDefinitions;
import com.atilika.kuromoji.dict.Dictionary;
import com.atilika.kuromoji.io.IntegerArrayIO;
import com.atilika.kuromoji.io.StringArrayIO;
import com.atilika.kuromoji.util.ResourceResolver;
import com.atilika.kuromoji.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;

public class UnknownDictionary
implements Dictionary {
    public static final String UNKNOWN_DICTIONARY_FILENAME = "unknownDictionary.bin";
    private static final String DEFAULT_FEATURE = "*";
    private static final String FEATURE_SEPARATOR = ",";
    private final int[][] entries;
    private final int[][] costs;
    private final String[][] features;
    private final int totalFeatures;
    private final CharacterDefinitions characterDefinition;

    public UnknownDictionary(CharacterDefinitions characterDefinition, int[][] entries, int[][] costs, String[][] features, int totalFeatures) {
        this.characterDefinition = characterDefinition;
        this.entries = entries;
        this.costs = costs;
        this.features = features;
        this.totalFeatures = totalFeatures;
    }

    public UnknownDictionary(CharacterDefinitions characterDefinition, int[][] entries, int[][] costs, String[][] features) {
        this(characterDefinition, entries, costs, features, features.length);
    }

    public int[] lookupWordIds(int categoryId) {
        return this.entries[categoryId];
    }

    @Override
    public int getLeftId(int wordId) {
        return this.costs[wordId][0];
    }

    @Override
    public int getRightId(int wordId) {
        return this.costs[wordId][1];
    }

    @Override
    public int getWordCost(int wordId) {
        return this.costs[wordId][2];
    }

    @Override
    public String getAllFeatures(int wordId) {
        return StringUtils.join(this.getAllFeaturesArray(wordId), FEATURE_SEPARATOR);
    }

    @Override
    public String[] getAllFeaturesArray(int wordId) {
        int i;
        if (this.totalFeatures == this.features.length) {
            return this.features[wordId];
        }
        String[] allFeatures = new String[this.totalFeatures];
        String[] basicFeatures = this.features[wordId];
        for (i = 0; i < basicFeatures.length; ++i) {
            allFeatures[i] = basicFeatures[i];
        }
        for (i = basicFeatures.length; i < this.totalFeatures; ++i) {
            allFeatures[i] = DEFAULT_FEATURE;
        }
        return allFeatures;
    }

    @Override
    public String getFeature(int wordId, int ... fields) {
        String[] allFeatures = this.getAllFeaturesArray(wordId);
        String[] features = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            int featureNumber = fields[i];
            features[i] = allFeatures[featureNumber];
        }
        return StringUtils.join(features, FEATURE_SEPARATOR);
    }

    public CharacterDefinitions getCharacterDefinition() {
        return this.characterDefinition;
    }

    public static UnknownDictionary newInstance(ResourceResolver resolver, CharacterDefinitions characterDefinitions, int totalFeatures) throws IOException {
        InputStream unkDefInput = resolver.resolve(UNKNOWN_DICTIONARY_FILENAME);
        int[][] costs = IntegerArrayIO.readArray2D(unkDefInput);
        int[][] references = IntegerArrayIO.readArray2D(unkDefInput);
        String[][] features = StringArrayIO.readArray2D(unkDefInput);
        UnknownDictionary unknownDictionary = new UnknownDictionary(characterDefinitions, references, costs, features, totalFeatures);
        return unknownDictionary;
    }
}

