/*
 * Decompiled with CFR 0.152.
 */
package io.github.cosinekitty.astronomy;

import io.github.cosinekitty.astronomy.Time;
import io.github.cosinekitty.astronomy.Vector;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 02\u00020\u0001:\u00010B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0011\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000J\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0000J\u0016\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0000J\u0006\u0010#\u001a\u00020\u001fJ\u0006\u0010$\u001a\u00020\u001fJ\u000e\u0010%\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0000J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J'\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010*\u001a\u00020+2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020/H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u00061"}, d2={"Lio/github/cosinekitty/astronomy/TerseVector;", "", "x", "", "y", "z", "<init>", "(DDD)V", "getX", "()D", "setX", "(D)V", "getY", "setY", "getZ", "setZ", "toAstroVector", "Lio/github/cosinekitty/astronomy/Vector;", "time", "Lio/github/cosinekitty/astronomy/Time;", "plus", "other", "minus", "unaryMinus", "times", "div", "denom", "mean", "quadrature", "magnitude", "decrement", "", "increment", "mix", "ramp", "setToZero", "negate", "copyFrom", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "", "toString", "", "Companion", "OsmAnd-shared"})
public final class TerseVector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double x;
    private double y;
    private double z;

    public TerseVector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getZ() {
        return this.z;
    }

    public final void setZ(double d) {
        this.z = d;
    }

    @NotNull
    public final Vector toAstroVector(@NotNull Time time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return new Vector(this.x, this.y, this.z, time);
    }

    @NotNull
    public final TerseVector plus(@NotNull TerseVector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new TerseVector(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    @NotNull
    public final TerseVector minus(@NotNull TerseVector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new TerseVector(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    @NotNull
    public final TerseVector unaryMinus() {
        return new TerseVector(-this.x, -this.y, -this.z);
    }

    @NotNull
    public final TerseVector times(double other) {
        return new TerseVector(this.x * other, this.y * other, this.z * other);
    }

    @NotNull
    public final TerseVector div(double denom) {
        return new TerseVector(this.x / denom, this.y / denom, this.z / denom);
    }

    @NotNull
    public final TerseVector mean(@NotNull TerseVector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new TerseVector((this.x + other.x) / 2.0, (this.y + other.y) / 2.0, (this.z + other.z) / 2.0);
    }

    public final double quadrature() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double magnitude() {
        return Math.sqrt(this.quadrature());
    }

    public final void decrement(@NotNull TerseVector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
    }

    public final void increment(@NotNull TerseVector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
    }

    public final void mix(double ramp, @NotNull TerseVector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.x = (1.0 - ramp) * this.x + ramp * other.x;
        this.y = (1.0 - ramp) * this.y + ramp * other.y;
        this.z = (1.0 - ramp) * this.z + ramp * other.z;
    }

    public final void setToZero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public final void copyFrom(@NotNull TerseVector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    @NotNull
    public final TerseVector copy(double x, double y, double z) {
        return new TerseVector(x, y, z);
    }

    public static /* synthetic */ TerseVector copy$default(TerseVector terseVector, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = terseVector.x;
        }
        if ((n & 2) != 0) {
            d2 = terseVector.y;
        }
        if ((n & 4) != 0) {
            d3 = terseVector.z;
        }
        return terseVector.copy(d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "TerseVector(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = result * 31 + Double.hashCode(this.y);
        result = result * 31 + Double.hashCode(this.z);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TerseVector)) {
            return false;
        }
        TerseVector terseVector = (TerseVector)other;
        if (Double.compare(this.x, terseVector.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, terseVector.y) != 0) {
            return false;
        }
        return Double.compare(this.z, terseVector.z) == 0;
    }

    @JvmStatic
    @NotNull
    public static final TerseVector zero() {
        return Companion.zero();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lio/github/cosinekitty/astronomy/TerseVector$Companion;", "", "<init>", "()V", "zero", "Lio/github/cosinekitty/astronomy/TerseVector;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TerseVector zero() {
            return new TerseVector(0.0, 0.0, 0.0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

