/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import java.io.Serializable;
import net.osmand.Location;
import net.osmand.util.MapUtils;

public class LatLon
implements Serializable {
    private static final long serialVersionUID = 1811582709897737392L;
    private final double latitude;
    private final double longitude;

    public LatLon(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public Location toLocation() {
        Location location = new Location("");
        location.setLatitude(this.latitude);
        location.setLongitude(this.longitude);
        return location;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        int temp = (int)Math.floor(this.latitude * 10000.0);
        result = 31 * result + temp;
        temp = (int)Math.floor(this.longitude * 10000.0);
        result = 31 * result + temp;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LatLon other = (LatLon)obj;
        return MapUtils.areLatLonEqual(this, other);
    }

    public String toString() {
        return "Lat " + (float)this.latitude + " Lon " + (float)this.longitude;
    }
}

