/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router.tester;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.osmand.data.LatLon;
import net.osmand.router.tester.RandomRouteResult;

class RandomRouteEntry {
    LatLon start;
    LatLon finish;
    List<LatLon> via = new ArrayList<LatLon>();
    String profile = "car";
    List<String> params = new ArrayList<String>();
    List<RandomRouteResult> results = new ArrayList<RandomRouteResult>();

    RandomRouteEntry() {
    }

    Map<String, String> mapParams() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.params.forEach(p -> {
            String[] kv = p.split("[:=]");
            if (kv.length > 1) {
                map.put(kv[0], kv[1]);
            } else {
                map.put(kv[0], "true");
            }
        });
        return map;
    }

    public String toString() {
        return this.toURL("osmand");
    }

    String toURL(String type) {
        return this.toURL(type, "test.osmand.net", false);
    }

    String toURL(String type, String domain, boolean car2phase) {
        String START = String.format("%f,%f", this.start.getLatitude(), this.start.getLongitude());
        String FINISH = String.format("%f,%f", this.finish.getLatitude(), this.finish.getLongitude());
        String TYPE = type == null ? "osmand" : type;
        String PROFILE = this.profile;
        String GO = String.format("10/%f/%f", (this.start.getLatitude() + this.finish.getLatitude()) / 2.0, (this.start.getLongitude() + this.finish.getLongitude()) / 2.0);
        String hasVia = !this.via.isEmpty() ? "&via=" : "";
        ArrayList viaList = new ArrayList();
        this.via.forEach(ll -> viaList.add(String.format("%f,%f", ll.getLatitude(), ll.getLongitude())));
        String VIA = String.join((CharSequence)";", viaList);
        ArrayList<String> typeParams = new ArrayList<String>(this.params);
        if ("brp-java".equals(TYPE)) {
            typeParams.add("hhoff:true");
        }
        if ("brp-cpp".equals(TYPE)) {
            typeParams.add("hhoff:true,nativerouting:true");
        }
        if ("hh-java".equals(TYPE)) {
            typeParams.add("hhonly:true");
        }
        if ("hh-cpp".equals(TYPE)) {
            typeParams.add("hhonly:true,nativerouting:true");
        }
        if (TYPE.startsWith("brp") && "car".equals(PROFILE)) {
            typeParams.add("calcmode:" + (car2phase ? "COMPLEX" : "NORMAL"));
        }
        String hasParams = !typeParams.isEmpty() ? "&params=" : "";
        String PARAMS = String.join((CharSequence)",", typeParams);
        String protoDomain = domain.contains("://") ? domain : (domain.contains("localhost") ? "http://" : "https://") + domain;
        return String.format("%s/map/navigate/?start=%s&finish=%s%s%s&profile=%s%s%s#%s", protoDomain, START, FINISH, hasVia, VIA, PROFILE, hasParams, PARAMS, GO);
    }
}

