/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.extensions.DoubleExtensionsKt;
import net.osmand.shared.gpx.SplitSegment;
import net.osmand.shared.gpx.primitives.TrkSegment;
import net.osmand.shared.gpx.primitives.WptPt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u000b2\u00020\u0001:\u0003\t\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H&\u00a8\u0006\f"}, d2={"Lnet/osmand/shared/gpx/SplitMetric;", "", "<init>", "()V", "metric", "", "p1", "Lnet/osmand/shared/gpx/primitives/WptPt;", "p2", "DistanceSplitMetric", "TimeSplitMetric", "Companion", "OsmAnd-shared"})
public abstract class SplitMetric {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public abstract double metric(@NotNull WptPt var1, @NotNull WptPt var2);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lnet/osmand/shared/gpx/SplitMetric$Companion;", "", "<init>", "()V", "splitSegment", "", "metric", "Lnet/osmand/shared/gpx/SplitMetric;", "secondaryMetric", "metricLimit", "", "splitSegments", "", "Lnet/osmand/shared/gpx/SplitSegment;", "segment", "Lnet/osmand/shared/gpx/primitives/TrkSegment;", "joinSegments", "", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public final void splitSegment(@NotNull SplitMetric metric, @NotNull SplitMetric secondaryMetric, double metricLimit, @NotNull List<SplitSegment> splitSegments, @NotNull TrkSegment segment, boolean joinSegments) {
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            Intrinsics.checkNotNullParameter((Object)secondaryMetric, (String)"secondaryMetric");
            Intrinsics.checkNotNullParameter(splitSegments, (String)"splitSegments");
            Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
            double currentMetricEnd = metricLimit;
            double secondaryMetricEnd = 0.0;
            SplitSegment sp = new SplitSegment(segment, 0, 0.0);
            double total = 0.0;
            WptPt prev = null;
            int n = ((Collection)segment.getPoints()).size();
            for (int k = 0; k < n; ++k) {
                WptPt point = segment.getPoints().get(k);
                if (k > 0) {
                    double currentSegment = 0.0;
                    if (!segment.getGeneralSegment() || joinSegments || !point.getFirstPoint()) {
                        if (prev != null) {
                            WptPt it;
                            boolean bl = false;
                            currentSegment = metric.metric(it, point);
                            secondaryMetricEnd += secondaryMetric.metric(it, point);
                        }
                    }
                    while (total + currentSegment > currentMetricEnd) {
                        double p = currentMetricEnd - total;
                        double cf = p / currentSegment;
                        sp.setLastPoint(k - 1, cf);
                        sp.setMetricEnd(currentMetricEnd);
                        sp.setSecondaryMetricEnd(secondaryMetricEnd);
                        splitSegments.add(sp);
                        sp = new SplitSegment(segment, k - 1, cf);
                        currentMetricEnd += metricLimit;
                    }
                    total += currentSegment;
                }
                prev = point;
            }
            if (!((Collection)segment.getPoints()).isEmpty() && (sp.getEndPointInd() != segment.getPoints().size() - 1 || !(sp.getStartCoeff() == 1.0))) {
                sp.setMetricEnd(total);
                sp.setSecondaryMetricEnd(secondaryMetricEnd);
                sp.setLastPoint(segment.getPoints().size() - 2, 1.0);
                splitSegments.add(sp);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/osmand/shared/gpx/SplitMetric$DistanceSplitMetric;", "Lnet/osmand/shared/gpx/SplitMetric;", "<init>", "()V", "calculations", "", "metric", "", "p1", "Lnet/osmand/shared/gpx/primitives/WptPt;", "p2", "OsmAnd-shared"})
    public static final class DistanceSplitMetric
    extends SplitMetric {
        @NotNull
        private final float[] calculations = new float[1];

        @Override
        public double metric(@NotNull WptPt p1, @NotNull WptPt p2) {
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            double R = 6371000.0;
            double lat1 = DoubleExtensionsKt.toRadians(p1.getLat());
            double lat2 = DoubleExtensionsKt.toRadians(p2.getLat());
            double dLat = DoubleExtensionsKt.toRadians(p2.getLat() - p1.getLat());
            double dLon = DoubleExtensionsKt.toRadians(p2.getLon() - p1.getLon());
            double a = Math.sin(dLat / (double)2) * Math.sin(dLat / (double)2) + Math.cos(lat1) * Math.cos(lat2) * Math.sin(dLon / (double)2) * Math.sin(dLon / (double)2);
            double c = (double)2 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
            return R * c;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lnet/osmand/shared/gpx/SplitMetric$TimeSplitMetric;", "Lnet/osmand/shared/gpx/SplitMetric;", "<init>", "()V", "metric", "", "p1", "Lnet/osmand/shared/gpx/primitives/WptPt;", "p2", "OsmAnd-shared"})
    public static final class TimeSplitMetric
    extends SplitMetric {
        @Override
        public double metric(@NotNull WptPt p1, @NotNull WptPt p2) {
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            return p1.getTime() != 0L && p2.getTime() != 0L ? (double)Math.abs((p2.getTime() - p1.getTime()) / 1000L) : 0.0;
        }
    }
}

