/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.util;

import co.touchlab.stately.collections.ConcurrentMutableMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.osmand.shared.data.KLatLon;
import net.osmand.shared.data.KQuadRect;
import net.osmand.shared.extensions.DoubleExtensionsKt;
import net.osmand.shared.util.KGeoParsedPoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0013\n\u0002\b%\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005J6\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 J&\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tJ\u0016\u0010!\u001a\u00020\t2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'J\u001e\u0010!\u001a\u00020\t2\u0006\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tJ6\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\tJ\u0016\u00103\u001a\u00020'2\u0006\u00104\u001a\u00020'2\u0006\u00105\u001a\u00020'J&\u00103\u001a\u0002062\u0006\u00107\u001a\u00020\t2\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\tJ.\u0010;\u001a\u00020'2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u00020\tJ6\u0010A\u001a\u00020\t2\u0006\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\t2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\tJ6\u0010D\u001a\u00020'2\u0006\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\t2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\tJ6\u0010E\u001a\u00020\t2\u0006\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\t2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\tJ\u000e\u0010F\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tJ\u000e\u0010G\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tJ\u000e\u0010H\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\tJ\u000e\u0010I\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\tJ\u000e\u0010J\u001a\u00020\t2\u0006\u0010K\u001a\u00020\u0005J\u000e\u0010L\u001a\u00020\t2\u0006\u0010M\u001a\u00020\u0005J\u0016\u0010N\u001a\u00020\t2\u0006\u0010O\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tJ\u0016\u0010P\u001a\u00020\t2\u0006\u0010O\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tJ\u0016\u0010Q\u001a\u00020\t2\u0006\u0010O\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tJ\u001e\u0010R\u001a\u0002062\u0006\u0010O\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\t2\u0006\u0010S\u001a\u00020\u0005J\u0016\u0010T\u001a\u00020\t2\u0006\u0010O\u001a\u00020\t2\u0006\u0010U\u001a\u00020\tJ\u000e\u0010V\u001a\u00020\t2\u0006\u0010O\u001a\u00020\tJ\u0016\u0010V\u001a\u00020\t2\u0006\u0010B\u001a\u00020\t2\u0006\u0010O\u001a\u00020\tJ\u0016\u0010W\u001a\u00020\t2\u0006\u0010B\u001a\u00020\t2\u0006\u0010O\u001a\u00020\tJ\u0016\u0010X\u001a\u00020\t2\u0006\u0010O\u001a\u00020\t2\u0006\u0010Y\u001a\u00020\tJ\u000e\u0010Z\u001a\u00020\t2\u0006\u0010O\u001a\u00020\tJ.\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\\2\u0006\u0010^\u001a\u00020\\2\u0006\u0010_\u001a\u00020\\2\u0006\u0010`\u001a\u00020\\2\u0006\u0010S\u001a\u00020\\J.\u0010a\u001a\u00020\\2\u0006\u0010]\u001a\u00020\\2\u0006\u0010^\u001a\u00020\\2\u0006\u0010_\u001a\u00020\\2\u0006\u0010`\u001a\u00020\\2\u0006\u0010S\u001a\u00020\\J\u0016\u0010b\u001a\u00020\t2\u0006\u0010O\u001a\u00020\t2\u0006\u0010c\u001a\u00020\tJ&\u0010d\u001a\u00020\u00052\u0006\u0010O\u001a\u00020\t2\u0006\u0010e\u001a\u00020\t2\u0006\u0010f\u001a\u00020\t2\u0006\u0010S\u001a\u00020\tJ&\u0010g\u001a\u00020\u00052\u0006\u0010O\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010S\u001a\u00020\tJ\u001e\u0010h\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00122\u0006\u0010O\u001a\u00020\u0005J\u001e\u0010i\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010O\u001a\u00020\u0005J\u001e\u0010j\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010O\u001a\u00020\u0005J\u0016\u0010k\u001a\u00020l2\u0006\u0010Y\u001a\u00020l2\u0006\u0010c\u001a\u00020lJ\u0016\u0010m\u001a\u00020\\2\u0006\u0010n\u001a\u00020\\2\u0006\u0010o\u001a\u00020\\J\u000e\u0010p\u001a\u00020\\2\u0006\u0010n\u001a\u00020\\J\u000e\u0010q\u001a\u00020\\2\u0006\u0010r\u001a\u00020\\J\u000e\u0010s\u001a\u00020\t2\u0006\u0010t\u001a\u00020\tJ\u0016\u0010u\u001a\u00020\t2\u0006\u0010v\u001a\u00020\t2\u0006\u0010w\u001a\u00020\tJ&\u0010x\u001a\u00020\t2\u0006\u0010y\u001a\u00020\u00052\u0006\u0010z\u001a\u00020\u00052\u0006\u0010{\u001a\u00020\u00052\u0006\u0010|\u001a\u00020\u0005J&\u0010}\u001a\u00020\t2\u0006\u0010y\u001a\u00020\u00052\u0006\u0010z\u001a\u00020\u00052\u0006\u0010{\u001a\u00020\u00052\u0006\u0010|\u001a\u00020\u0005J'\u0010\u0081\u0001\u001a\u00020\t2\u0006\u0010y\u001a\u00020\u00052\u0006\u0010z\u001a\u00020\u00052\u0006\u0010{\u001a\u00020\u00052\u0006\u0010|\u001a\u00020\u0005J\u0012\u0010\u0085\u0001\u001a\u00020\t2\u0007\u0010\u0086\u0001\u001a\u00020\u0005H\u0002J;\u0010\u0087\u0001\u001a\u00020 2\u0006\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\t2\u0007\u0010\u0088\u0001\u001a\u00020\t2\u0007\u0010\u0089\u0001\u001a\u00020\t2\u0007\u0010\u008a\u0001\u001a\u00020\t2\u0007\u0010\u008b\u0001\u001a\u00020\tJ\u0010\u0010\u008c\u0001\u001a\u00020l2\u0007\u0010\u008d\u0001\u001a\u00020lJ\u0010\u0010\u008e\u0001\u001a\u00020l2\u0007\u0010\u008d\u0001\u001a\u00020lJ!\u0010\u008f\u0001\u001a\u00030\u0090\u00012\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0007\u0010\u0091\u0001\u001a\u00020\u0005J/\u0010\u0092\u0001\u001a\u00020\\2\u0006\u0010y\u001a\u00020\\2\u0006\u0010z\u001a\u00020\\2\u0006\u0010{\u001a\u00020\\2\u0006\u0010|\u001a\u00020\\2\u0006\u0010Y\u001a\u00020\\J\"\u0010\u0093\u0001\u001a\u00030\u0094\u00012\b\u0010\u0095\u0001\u001a\u00030\u0090\u00012\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tJ\u001b\u0010\u0096\u0001\u001a\u00020 2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010'J!\u0010\u0096\u0001\u001a\u00020 2\b\u0010)\u001a\u0004\u0018\u00010'2\u0006\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\tJ'\u0010\u0096\u0001\u001a\u00020 2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tJ$\u0010\u0096\u0001\u001a\u00020 2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010'2\u0007\u0010\u0097\u0001\u001a\u00020\tJ0\u0010\u0096\u0001\u001a\u00020 2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\u0007\u0010\u0097\u0001\u001a\u00020\tJ\"\u0010\u0098\u0001\u001a\u00020'2\u0007\u0010\u0099\u0001\u001a\u00020'2\u0007\u0010\u009a\u0001\u001a\u00020\t2\u0007\u0010\u009b\u0001\u001a\u00020\tJ)\u0010\u0098\u0001\u001a\u00020'2\u0006\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\t2\u0007\u0010\u009a\u0001\u001a\u00020\t2\u0007\u0010\u009b\u0001\u001a\u00020\tJ+\u0010\u009c\u0001\u001a\u00020\t2\u0007\u0010\u009d\u0001\u001a\u00020\u00052\u0007\u0010\u009e\u0001\u001a\u00020\u00052\u0007\u0010\u009f\u0001\u001a\u00020\u00052\u0007\u0010\u00a0\u0001\u001a\u00020\u0005J+\u0010\u009c\u0001\u001a\u00020\t2\u0007\u0010\u009d\u0001\u001a\u00020\\2\u0007\u0010\u009e\u0001\u001a\u00020\\2\u0007\u0010\u009f\u0001\u001a\u00020\\2\u0007\u0010\u00a0\u0001\u001a\u00020\\J5\u0010\u00a1\u0001\u001a\u00020\u00122\u0007\u0010\u00a2\u0001\u001a\u00020\u00052\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u00012\u0007\u0010\u00a5\u0001\u001a\u00020\u00052\u0007\u0010\u00a6\u0001\u001a\u00020\u00052\u0007\u0010\u00a7\u0001\u001a\u00020\u0005J6\u0010\u00a8\u0001\u001a\u00020\u00052\b\u0010\u00a9\u0001\u001a\u00030\u00a4\u00012\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u00012\u0007\u0010\u00a5\u0001\u001a\u00020\u00052\u0007\u0010\u00a6\u0001\u001a\u00020\u00052\u0007\u0010\u00a7\u0001\u001a\u00020\u0005J'\u0010\u00aa\u0001\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tJ\u0011\u0010\u00ab\u0001\u001a\u00030\u00ac\u00012\u0007\u0010\u00ad\u0001\u001a\u00020\u0012J\u0011\u0010\u00ae\u0001\u001a\u00030\u0090\u00012\u0007\u0010\u00af\u0001\u001a\u00020\u0012J0\u0010\u00b0\u0001\u001a\u00020'2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\u0007\u0010\u00b1\u0001\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010~\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u007f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0080\u0001\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0082\u0001\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0083\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u0084\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00b2\u0001"}, d2={"Lnet/osmand/shared/util/KMapUtils;", "", "<init>", "()V", "ROUNDING_ERROR", "", "EARTH_RADIUS_B", "EARTH_RADIUS_A", "MIN_LATITUDE", "", "MAX_LATITUDE", "LATITUDE_TURN", "MIN_LONGITUDE", "MAX_LONGITUDE", "LONGITUDE_TURN", "DEFAULT_LATLON_PRECISION", "HIGH_LATLON_PRECISION", "BASE_SHORT_OSM_URL", "", "intToBase64", "", "calculateFromBaseZoomPrecisionXY", "baseZoom", "finalZoom", "xFinal", "yFinal", "calculateFinalXYFromBaseAndPrecisionXY", "", "precisionXY", "xBase", "yBase", "ignoreNotEnoughPrecision", "", "getDistance", "lat1", "lon1", "lat2", "lon2", "l1", "Lnet/osmand/shared/data/KLatLon;", "l2", "l", "latitude", "longitude", "scalarMultiplication", "xA", "yA", "xB", "yB", "xC", "yC", "calculateMidPoint", "s1", "s2", "", "firstLat", "firstLon", "secondLat", "secondLon", "calculateIntermediatePoint", "fromLat", "fromLon", "toLat", "toLon", "coeff", "getOrthogonalDistance", "lat", "lon", "getProjection", "getProjectionCoeff", "checkLongitude", "checkLatitude", "get31TileNumberX", "get31TileNumberY", "get31LongitudeX", "tileX", "get31LatitudeY", "tileY", "getTileNumberX", "zoom", "getTileNumberY", "getTileEllipsoidNumberY", "getTileEllipsoidNumberAndOffsetY", "tileSize", "getLatitudeFromEllipsoidTileY", "tileNumberY", "getTileDistanceWidth", "getTileDistanceHeight", "getLongitudeFromTile", "x", "getPowZoom", "calcDiffPixelX", "", "rotateSin", "rotateCos", "dTileX", "dTileY", "calcDiffPixelY", "getLatitudeFromTile", "y", "getPixelShiftX", "long1", "long2", "getPixelShiftY", "buildGeoUrl", "buildShortOsmUrl", "createShortLinkString", "interleaveBits", "", "unifyRotationDiff", "rotate", "targetRotate", "unifyRotationTo360", "normalizeDegrees360", "degrees", "alignAngleDifference", "diff", "degreesDiff", "a1", "a2", "squareRootDist31", "x1", "y1", "x2", "y2", "measuredDist31", "EQUATOR", "EARTH_CIRCUMFERENCE", "HALF_EARTH_CIRCUMFERENCE", "squareDist31TileMetric", "PRECISION_ZOOM", "DIST_CACHE", "Lco/touchlab/stately/collections/ConcurrentMutableMap;", "getTileWidth", "y31", "rightSide", "aLat", "aLon", "bLat", "bLon", "deinterleaveY", "coord", "deinterleaveX", "calculateLatLonBbox", "Lnet/osmand/shared/data/KQuadRect;", "radiusMeters", "getInterpolatedY", "insetLatLonRect", "", "r", "areLatLonEqual", "precision", "rhumbDestinationPoint", "latLon", "distance", "bearing", "getSqrtDistance", "startX", "startY", "endX", "endY", "convertDistToChar", "dist", "firstLetter", "", "firstDist", "mult1", "mult2", "convertCharToDist", "ch", "getEllipsoidDistance", "decodeShortLinkString", "Lnet/osmand/shared/util/KGeoParsedPoint;", "s", "decodeShortLinkToQuadRect", "shortLink", "interpolateLatLon", "fraction", "OsmAnd-shared"})
public final class KMapUtils {
    @NotNull
    public static final KMapUtils INSTANCE = new KMapUtils();
    public static final int ROUNDING_ERROR = 3;
    private static final int EARTH_RADIUS_B = 6356752;
    private static final int EARTH_RADIUS_A = 6378137;
    public static final double MIN_LATITUDE = -85.0511;
    public static final double MAX_LATITUDE = 85.0511;
    public static final double LATITUDE_TURN = 180.0;
    public static final double MIN_LONGITUDE = -180.0;
    public static final double MAX_LONGITUDE = 180.0;
    public static final double LONGITUDE_TURN = 360.0;
    public static final double DEFAULT_LATLON_PRECISION = 1.0E-5;
    public static final double HIGH_LATLON_PRECISION = 1.0E-7;
    @NotNull
    private static final String BASE_SHORT_OSM_URL = "https://openstreetmap.org/go/";
    @NotNull
    private static final char[] intToBase64;
    public static final int EQUATOR = 0x40000000;
    public static final double EARTH_CIRCUMFERENCE = 4.007501668557849E7;
    public static final double HALF_EARTH_CIRCUMFERENCE = 2.0037508342789244E7;
    private static final int PRECISION_ZOOM = 14;
    @NotNull
    private static final ConcurrentMutableMap<Integer, Double> DIST_CACHE;

    private KMapUtils() {
    }

    public final int calculateFromBaseZoomPrecisionXY(int baseZoom, int finalZoom, int xFinal, int yFinal) {
        int px = xFinal;
        int py = yFinal;
        int precisionNumber = 1;
        int zoom = finalZoom - 1;
        if (baseZoom <= zoom) {
            while (true) {
                int x = px / 2;
                int y = py / 2;
                int deltax = px - x * 2;
                int deltay = py - y * 2;
                precisionNumber = (precisionNumber << 2) + (deltax << 1) + deltay;
                px = x;
                py = y;
                if (zoom == baseZoom) break;
                --zoom;
            }
        }
        return precisionNumber;
    }

    @NotNull
    public final int[] calculateFinalXYFromBaseAndPrecisionXY(int baseZoom, int finalZoom, int precisionXY, int xBase, int yBase, boolean ignoreNotEnoughPrecision) {
        int tPrecisionXY;
        int finalX = xBase;
        int finalY = yBase;
        int precisionCalc = tPrecisionXY = precisionXY;
        for (int zoom = baseZoom; zoom < finalZoom; ++zoom) {
            if (precisionCalc <= 1 && precisionCalc > 0 && !ignoreNotEnoughPrecision) {
                throw new IllegalArgumentException("Not enough bits to retrieve zoom approximation");
            }
            finalY = finalY * 2 + (tPrecisionXY & 1);
            finalX = finalX * 2 + ((tPrecisionXY & 2) >> 1);
            tPrecisionXY >>= 2;
        }
        int[] nArray = new int[]{finalX, finalY};
        return nArray;
    }

    public final double getDistance(double lat1, double lon1, double lat2, double lon2) {
        double R = 6372.8;
        double dLat = DoubleExtensionsKt.toRadians(lat2 - lat1);
        double dLon = DoubleExtensionsKt.toRadians(lon2 - lon1);
        double sinHalfLat = Math.sin(dLat / (double)2);
        double sinHalfLon = Math.sin(dLon / (double)2);
        double a = sinHalfLat * sinHalfLat + Math.cos(DoubleExtensionsKt.toRadians(lat1)) * Math.cos(DoubleExtensionsKt.toRadians(lat2)) * sinHalfLon * sinHalfLon;
        return (double)2 * R * (double)1000 * Math.asin(Math.sqrt(a));
    }

    public final double getDistance(@NotNull KLatLon l1, @NotNull KLatLon l2) {
        Intrinsics.checkNotNullParameter((Object)l1, (String)"l1");
        Intrinsics.checkNotNullParameter((Object)l2, (String)"l2");
        return this.getDistance(l1.getLatitude(), l1.getLongitude(), l2.getLatitude(), l2.getLongitude());
    }

    public final double getDistance(@NotNull KLatLon l, double latitude, double longitude) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        return this.getDistance(l.getLatitude(), l.getLongitude(), latitude, longitude);
    }

    public final double scalarMultiplication(double xA, double yA, double xB, double yB, double xC, double yC) {
        return (xB - xA) * (xC - xA) + (yB - yA) * (yC - yA);
    }

    @NotNull
    public final KLatLon calculateMidPoint(@NotNull KLatLon s1, @NotNull KLatLon s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        double[] latLon = this.calculateMidPoint(s1.getLatitude(), s1.getLongitude(), s2.getLatitude(), s2.getLongitude());
        return new KLatLon(latLon[0], latLon[1]);
    }

    @NotNull
    public final double[] calculateMidPoint(double firstLat, double firstLon, double secondLat, double secondLon) {
        double lat1 = firstLat / (double)180 * Math.PI;
        double lon1 = firstLon / (double)180 * Math.PI;
        double lat2 = secondLat / (double)180 * Math.PI;
        double lon2 = secondLon / (double)180 * Math.PI;
        double Bx = Math.cos(lat2) * Math.cos(lon2 - lon1);
        double By = Math.cos(lat2) * Math.sin(lon2 - lon1);
        double latMid = Math.atan2(Math.sin(lat1) + Math.sin(lat2), Math.sqrt((Math.cos(lat1) + Bx) * (Math.cos(lat1) + Bx) + By * By));
        double lonMid = lon1 + Math.atan2(By, Math.cos(lat1) + Bx);
        double[] dArray = new double[]{this.checkLatitude(latMid * (double)180 / Math.PI), this.checkLongitude(lonMid * (double)180 / Math.PI)};
        return dArray;
    }

    @NotNull
    public final KLatLon calculateIntermediatePoint(double fromLat, double fromLon, double toLat, double toLon, double coeff) {
        double lat1 = DoubleExtensionsKt.toRadians(fromLat);
        double lon1 = DoubleExtensionsKt.toRadians(fromLon);
        double lat2 = DoubleExtensionsKt.toRadians(toLat);
        double lon2 = DoubleExtensionsKt.toRadians(toLon);
        double lat1Cos = Math.cos(lat1);
        double lat2Cos = Math.cos(lat2);
        double d = (double)2 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / (double)2), 2.0) + lat1Cos * lat2Cos * Math.pow(Math.sin((lon1 - lon2) / (double)2), 2.0)));
        double A = Math.sin((1.0 - coeff) * d) / Math.sin(d);
        double B = Math.sin(coeff * d) / Math.sin(d);
        double x = A * lat1Cos * Math.cos(lon1) + B * lat2Cos * Math.cos(lon2);
        double y = A * lat1Cos * Math.sin(lon1) + B * lat2Cos * Math.sin(lon2);
        double z = A * Math.sin(lat1) + B * Math.sin(lat2);
        double lat = Math.atan2(z, Math.sqrt(x * x + y * y));
        double lon = Math.atan2(y, x);
        return new KLatLon(this.checkLatitude(lat * (double)180 / Math.PI), this.checkLongitude(lon * (double)180 / Math.PI));
    }

    public final double getOrthogonalDistance(double lat, double lon, double fromLat, double fromLon, double toLat, double toLon) {
        return this.getDistance(this.getProjection(lat, lon, fromLat, fromLon, toLat, toLon), lat, lon);
    }

    @NotNull
    public final KLatLon getProjection(double lat, double lon, double fromLat, double fromLon, double toLat, double toLon) {
        double mDist = Math.pow(fromLat - toLat, 2.0) + Math.pow(fromLon - toLon, 2.0);
        double projection = this.scalarMultiplication(fromLat, fromLon, toLat, toLon, lat, lon);
        double prlat = 0.0;
        double prlon = 0.0;
        if (projection < 0.0) {
            prlat = fromLat;
            prlon = fromLon;
        } else if (projection >= mDist) {
            prlat = toLat;
            prlon = toLon;
        } else {
            prlat = fromLat + (toLat - fromLat) * (projection / mDist);
            prlon = fromLon + (toLon - fromLon) * (projection / mDist);
        }
        return new KLatLon(prlat, prlon);
    }

    public final double getProjectionCoeff(double lat, double lon, double fromLat, double fromLon, double toLat, double toLon) {
        double mDist = Math.pow(fromLat - toLat, 2.0) + Math.pow(fromLon - toLon, 2.0);
        double projection = this.scalarMultiplication(fromLat, fromLon, toLat, toLon, lat, lon);
        return projection < 0.0 ? 0.0 : (projection >= mDist ? 1.0 : projection / mDist);
    }

    public final double checkLongitude(double longitude) {
        double adjustedLongitude;
        boolean bl = -180.0 <= longitude ? longitude <= 180.0 : false;
        if (bl) {
            return longitude;
        }
        for (adjustedLongitude = longitude; adjustedLongitude <= -180.0 || adjustedLongitude > 180.0; adjustedLongitude += adjustedLongitude < 0.0 ? 360.0 : -360.0) {
        }
        return adjustedLongitude;
    }

    public final double checkLatitude(double latitude) {
        double adjustedLatitude;
        boolean bl = -85.0511 <= latitude ? latitude <= 85.0511 : false;
        if (bl) {
            return latitude;
        }
        for (adjustedLatitude = latitude; adjustedLatitude < -90.0 || adjustedLatitude > 90.0; adjustedLatitude += adjustedLatitude < 0.0 ? 180.0 : -180.0) {
        }
        return RangesKt.coerceIn((double)adjustedLatitude, (double)-85.0511, (double)85.0511);
    }

    public final int get31TileNumberX(double longitude) {
        double checkedLongitude = this.checkLongitude(longitude);
        long l = 0x80000000L;
        return (int)((checkedLongitude + 180.0) / 360.0 * (double)l);
    }

    public final int get31TileNumberY(double latitude) {
        double checkedLatitude = this.checkLatitude(latitude);
        double eval = Math.log(Math.tan(DoubleExtensionsKt.toRadians(checkedLatitude)) + 1.0 / Math.cos(DoubleExtensionsKt.toRadians(checkedLatitude)));
        long l = 0x80000000L;
        return (int)((1.0 - eval / Math.PI) / (double)2 * (double)l);
    }

    public final double get31LongitudeX(int tileX) {
        return this.getLongitudeFromTile(21.0, (double)tileX / 1024.0);
    }

    public final double get31LatitudeY(int tileY) {
        return this.getLatitudeFromTile(21.0, (double)tileY / 1024.0);
    }

    public final double getTileNumberX(double zoom, double longitude) {
        double powZoom;
        double checkedLongitude = this.checkLongitude(longitude);
        double dz = (checkedLongitude + 180.0) / 360.0 * (powZoom = this.getPowZoom(zoom));
        return dz >= powZoom ? powZoom - 0.01 : dz;
    }

    public final double getTileNumberY(double zoom, double latitude) {
        double checkedLatitude = this.checkLatitude(latitude);
        double eval = Math.log(Math.tan(DoubleExtensionsKt.toRadians(checkedLatitude)) + 1.0 / Math.cos(DoubleExtensionsKt.toRadians(checkedLatitude)));
        if (Double.isInfinite(eval) || Double.isNaN(eval)) {
            checkedLatitude = checkedLatitude < 0.0 ? -89.9 : 89.9;
            eval = Math.log(Math.tan(DoubleExtensionsKt.toRadians(checkedLatitude)) + 1.0 / Math.cos(DoubleExtensionsKt.toRadians(checkedLatitude)));
        }
        return (1.0 - eval / Math.PI) / (double)2 * this.getPowZoom(zoom);
    }

    public final double getTileEllipsoidNumberY(double zoom, double latitude) {
        double E2 = latitude * Math.PI / (double)180;
        double sradiusa = 6378137.0;
        double sradiusb = 6356752.0;
        double J2 = Math.sqrt(sradiusa * sradiusa - sradiusb * sradiusb) / sradiusa;
        double M2 = Math.log((1.0 + Math.sin(E2)) / (1.0 - Math.sin(E2))) / (double)2 - J2 * Math.log((1.0 + J2 * Math.sin(E2)) / (1.0 - J2 * Math.sin(E2))) / (double)2;
        double B2 = this.getPowZoom(zoom);
        return B2 / (double)2 - M2 * B2 / (double)2 / Math.PI;
    }

    @NotNull
    public final double[] getTileEllipsoidNumberAndOffsetY(int zoom, double latitude, int tileSize) {
        double E2 = latitude * Math.PI / (double)180;
        double sradiusa = 6378137.0;
        double sradiusb = 6356752.0;
        double J2 = Math.sqrt(sradiusa * sradiusa - sradiusb * sradiusb) / sradiusa;
        double M2 = Math.log((1.0 + Math.sin(E2)) / (1.0 - Math.sin(E2))) / (double)2 - J2 * Math.log((1.0 + J2 * Math.sin(E2)) / (1.0 - J2 * Math.sin(E2))) / (double)2;
        double B2 = this.getPowZoom(zoom);
        double tileY = B2 / (double)2 - M2 * B2 / (double)2 / Math.PI;
        double tilesCount = 1 << zoom;
        double yTileNumber = Math.floor(tilesCount * (0.5 - M2 / (double)2 / Math.PI));
        double offsetY = Math.floor((tilesCount * (0.5 - M2 / (double)2 / Math.PI) - yTileNumber) * (double)tileSize);
        double[] dArray = new double[]{tileY, offsetY};
        return dArray;
    }

    public final double getLatitudeFromEllipsoidTileY(double zoom, double tileNumberY) {
        double MerkElipsK = 1.0E-7;
        double sradiusa = 6378137.0;
        double sradiusb = 6356752.0;
        double FExct = Math.sqrt(sradiusa * sradiusa - sradiusb * sradiusb) / sradiusa;
        double TilesAtZoom = this.getPowZoom(zoom);
        double result = (tileNumberY - TilesAtZoom / (double)2) / -(TilesAtZoom / (Math.PI * 2));
        result = ((double)2 * Math.atan(Math.exp(result)) - 1.5707963267948966) * (double)180 / Math.PI;
        double Zu = result / 57.29577951308232;
        double yy = tileNumberY - TilesAtZoom / (double)2;
        double Zum1 = Zu;
        Zu = Math.asin(1.0 - (1.0 + Math.sin(Zum1)) * Math.pow(1.0 - FExct * Math.sin(Zum1), FExct) / (Math.exp((double)2 * yy / -(TilesAtZoom / (Math.PI * 2))) * Math.pow(1.0 + FExct * Math.sin(Zum1), FExct)));
        while (Math.abs(Zum1 - Zu) >= MerkElipsK) {
            Zum1 = Zu;
            Zu = Math.asin(1.0 - (1.0 + Math.sin(Zum1)) * Math.pow(1.0 - FExct * Math.sin(Zum1), FExct) / (Math.exp((double)2 * yy / -(TilesAtZoom / (Math.PI * 2))) * Math.pow(1.0 + FExct * Math.sin(Zum1), FExct)));
        }
        return Zu * (double)180 / Math.PI;
    }

    public final double getTileDistanceWidth(double zoom) {
        return this.getTileDistanceWidth(30.0, zoom);
    }

    public final double getTileDistanceWidth(double lat, double zoom) {
        KLatLon ll = new KLatLon(lat, this.getLongitudeFromTile(zoom, 0.0));
        KLatLon ll2 = new KLatLon(lat, this.getLongitudeFromTile(zoom, 1.0));
        return this.getDistance(ll, ll2);
    }

    public final double getTileDistanceHeight(double lat, double zoom) {
        double y = this.getTileNumberY(zoom, lat);
        KLatLon ll = new KLatLon(this.getLatitudeFromTile(zoom, Math.floor(y)), 0.0);
        KLatLon ll2 = new KLatLon(this.getLatitudeFromTile(zoom, Math.floor(y) + 1.0), 0.0);
        return this.getDistance(ll, ll2);
    }

    public final double getLongitudeFromTile(double zoom, double x) {
        return x / this.getPowZoom(zoom) * 360.0 - 180.0;
    }

    public final double getPowZoom(double zoom) {
        return zoom >= 0.0 && zoom - Math.floor(zoom) < (double)0.001f ? (double)(1 << (int)zoom) : Math.pow(2.0, zoom);
    }

    public final float calcDiffPixelX(float rotateSin, float rotateCos, float dTileX, float dTileY, float tileSize) {
        return (rotateCos * dTileX - rotateSin * dTileY) * tileSize;
    }

    public final float calcDiffPixelY(float rotateSin, float rotateCos, float dTileX, float dTileY, float tileSize) {
        return (rotateSin * dTileX + rotateCos * dTileY) * tileSize;
    }

    public final double getLatitudeFromTile(double zoom, double y) {
        int sign = y < 0.0 ? -1 : 1;
        return Math.atan((double)sign * Math.sinh(Math.PI * (1.0 - (double)2 * y / this.getPowZoom(zoom)))) * (double)180 / Math.PI;
    }

    public final int getPixelShiftX(double zoom, double long1, double long2, double tileSize) {
        return (int)((this.getTileNumberX(zoom, long1) - this.getTileNumberX(zoom, long2)) * tileSize);
    }

    public final int getPixelShiftY(double zoom, double lat1, double lat2, double tileSize) {
        return (int)((this.getTileNumberY(zoom, lat1) - this.getTileNumberY(zoom, lat2)) * tileSize);
    }

    @NotNull
    public final String buildGeoUrl(@NotNull String latitude, @NotNull String longitude, int zoom) {
        Intrinsics.checkNotNullParameter((Object)latitude, (String)"latitude");
        Intrinsics.checkNotNullParameter((Object)longitude, (String)"longitude");
        return "geo:" + latitude + "," + longitude + "?z=" + zoom;
    }

    @NotNull
    public final String buildShortOsmUrl(double latitude, double longitude, int zoom) {
        return BASE_SHORT_OSM_URL + this.createShortLinkString(latitude, longitude, zoom) + "?m";
    }

    @NotNull
    public final String createShortLinkString(double latitude, double longitude, int zoom) {
        long lat = (long)((latitude + (double)90) / (double)180 * (double)0x100000000L);
        long lon = (long)((longitude + (double)180) / (double)360 * (double)0x100000000L);
        long code = this.interleaveBits(lon, lat);
        Object str = "";
        int n = (int)Math.ceil((double)(zoom + 8) / 3.0);
        for (int i = 0; i < n; ++i) {
            str = (String)str + intToBase64[(int)(code >> 58 - 6 * i & 0x3FL)];
        }
        n = (zoom + 8) % 3;
        for (int j = 0; j < n; ++j) {
            str = (String)str + "-";
        }
        return str;
    }

    public final long interleaveBits(long x, long y) {
        long c = 0L;
        for (int b = 31; -1 < b; --b) {
            c = c << 1 | x >> b & 1L;
            c = c << 1 | y >> b & 1L;
        }
        return c;
    }

    public final float unifyRotationDiff(float rotate, float targetRotate) {
        float d;
        for (d = targetRotate - rotate; d >= 180.0f; d -= (float)360) {
        }
        while (d < -180.0f) {
            d += (float)360;
        }
        return d;
    }

    public final float unifyRotationTo360(float rotate) {
        float rotateVar;
        for (rotateVar = rotate; rotateVar < -180.0f; rotateVar += (float)360) {
        }
        while (rotateVar > 180.0f) {
            rotateVar -= (float)360;
        }
        return rotateVar;
    }

    public final float normalizeDegrees360(float degrees) {
        float degreesVar;
        for (degreesVar = degrees; degreesVar < 0.0f; degreesVar += 360.0f) {
        }
        while (degreesVar >= 360.0f) {
            degreesVar -= 360.0f;
        }
        return degreesVar;
    }

    public final double alignAngleDifference(double diff) {
        double diffVar;
        for (diffVar = diff; diffVar > Math.PI; diffVar -= Math.PI * 2) {
        }
        while (diffVar <= -Math.PI) {
            diffVar += Math.PI * 2;
        }
        return diffVar;
    }

    public final double degreesDiff(double a1, double a2) {
        double diff;
        for (diff = a1 - a2; diff > 180.0; diff -= (double)360) {
        }
        while (diff <= -180.0) {
            diff += (double)360;
        }
        return diff;
    }

    public final double squareRootDist31(int x1, int y1, int x2, int y2) {
        return Math.sqrt(this.squareDist31TileMetric(x1, y1, x2, y2));
    }

    public final double measuredDist31(int x1, int y1, int x2, int y2) {
        return this.getDistance(this.get31LatitudeY(y1), this.get31LongitudeX(x1), this.get31LatitudeY(y2), this.get31LongitudeX(x2));
    }

    public final double squareDist31TileMetric(int x1, int y1, int x2, int y2) {
        double dy;
        boolean top2;
        boolean top1 = y1 > 0x40000000;
        boolean bl = top2 = y2 > 0x40000000;
        if (top1 != top2 && y1 != 0x40000000 && y2 != 0x40000000) {
            double d2;
            int mx = x1 / 2 + x2 / 2;
            double d1 = Math.sqrt(this.squareDist31TileMetric(mx, 0x40000000, x2, y2));
            if (d1 + (d2 = Math.sqrt(this.squareDist31TileMetric(mx, 0x40000000, x1, y1))) > 2.0037508342789244E7) {
                return Math.pow(4.007501668557849E7 - (d1 + d2), 2);
            }
            return Math.pow(d1 + d2, 2);
        }
        int ymidx = y1 / 2 + y2 / 2;
        double tw = this.getTileWidth(ymidx);
        double dx = (double)(x2 - x1) * tw;
        double xyDist = dx * dx + (dy = (double)(y1 - y2) * tw) * dy;
        if (xyDist > Math.pow(2.0037508342789244E7, 2)) {
            return Math.pow(4.007501668557849E7 - Math.sqrt(xyDist), 2);
        }
        return xyDist;
    }

    private final double getTileWidth(int y31) {
        Double d;
        Integer n;
        double y = (double)y31 / 131072.0;
        int tileY = (int)y;
        double ry = y - (double)tileY;
        Double d2 = null;
        Double dp = null;
        d2 = (Double)DIST_CACHE.get((Object)tileY);
        if (d2 == null) {
            double td = this.getTileDistanceWidth(this.get31LatitudeY(tileY << 17), 14.0) / (double)131072;
            d2 = td;
            n = tileY;
            d = td;
            ((Map)DIST_CACHE).put(n, d);
        }
        if ((dp = (Double)DIST_CACHE.get((Object)(++tileY))) == null) {
            double tdp = this.getTileDistanceWidth(this.get31LatitudeY(tileY << 17), 14.0) / (double)131072;
            dp = tdp;
            n = tileY;
            d = tdp;
            ((Map)DIST_CACHE).put(n, d);
        }
        return ry * dp + (1.0 - ry) * d2;
    }

    public final boolean rightSide(double lat, double lon, double aLat, double aLon, double bLat, double bLon) {
        double ax = aLon - lon;
        double by = bLat - lat;
        double bx = bLon - lon;
        double ay = aLat - lat;
        double sa = ax * by - bx * ay;
        return sa < 0.0;
    }

    public final long deinterleaveY(long coord) {
        long x = 0L;
        for (int b = 31; -1 < b; --b) {
            x = x << 1 | (1L & coord) >> b * 2;
        }
        return x;
    }

    public final long deinterleaveX(long coord) {
        long x = 0L;
        for (int b = 31; -1 < b; --b) {
            x = x << 1 | (1L & coord) >> b * 2 + 1;
        }
        return x;
    }

    @NotNull
    public final KQuadRect calculateLatLonBbox(double latitude, double longitude, int radiusMeters) {
        double zoom = 16.0;
        double coeff = (double)radiusMeters / this.getTileDistanceWidth(latitude, zoom);
        double tx = this.getTileNumberX(zoom, longitude);
        double ty = this.getTileNumberY(zoom, latitude);
        double topLeftX = Math.max(0.0, tx - coeff);
        double topLeftY = Math.max(0.0, ty - coeff);
        int max = (1 << (int)zoom) - 1;
        double bottomRightX = Math.min((double)max, tx + coeff);
        double bottomRightY = Math.min((double)max, ty + coeff);
        double pw = this.getPowZoom((double)31 - zoom);
        KQuadRect rect = new KQuadRect(topLeftX * pw, topLeftY * pw, bottomRightX * pw, bottomRightY * pw);
        rect.setLeft(this.get31LongitudeX((int)rect.getLeft()));
        rect.setTop(this.get31LatitudeY((int)rect.getTop()));
        rect.setRight(this.get31LongitudeX((int)rect.getRight()));
        rect.setBottom(this.get31LatitudeY((int)rect.getBottom()));
        return rect;
    }

    public final float getInterpolatedY(float x1, float y1, float x2, float y2, float x) {
        float f;
        float a = y1 - y2;
        float b = x2 - x1;
        float d = -a * b;
        if (!(d == 0.0f)) {
            float c1 = y2 * x1 - x2 * y1;
            float c2 = x * (y2 - y1);
            f = a * (c1 - c2) / d;
        } else {
            f = y1;
        }
        return f;
    }

    public final void insetLatLonRect(@NotNull KQuadRect r, double latitude, double longitude) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        if (r.getLeft() == 0.0 && r.getRight() == 0.0) {
            r.setLeft(longitude);
            r.setRight(longitude);
            r.setTop(latitude);
            r.setBottom(latitude);
        } else {
            r.setLeft(Math.min(r.getLeft(), longitude));
            r.setRight(Math.max(r.getRight(), longitude));
            r.setTop(Math.max(r.getTop(), latitude));
            r.setBottom(Math.min(r.getBottom(), latitude));
        }
    }

    public final boolean areLatLonEqual(@Nullable KLatLon l1, @Nullable KLatLon l2) {
        return l1 == null && l2 == null || l2 != null && this.areLatLonEqual(l1, l2.getLatitude(), l2.getLongitude());
    }

    public final boolean areLatLonEqual(@Nullable KLatLon l, double lat, double lon) {
        return l != null && this.areLatLonEqual(l.getLatitude(), l.getLongitude(), lat, lon);
    }

    public final boolean areLatLonEqual(double lat1, double lon1, double lat2, double lon2) {
        return this.areLatLonEqual(lat1, lon1, lat2, lon2, 1.0E-5);
    }

    public final boolean areLatLonEqual(@Nullable KLatLon l1, @Nullable KLatLon l2, double precision) {
        return l1 == null && l2 == null || l1 != null && l2 != null && this.areLatLonEqual(l1.getLatitude(), l1.getLongitude(), l2.getLatitude(), l2.getLongitude(), precision);
    }

    public final boolean areLatLonEqual(double lat1, double lon1, double lat2, double lon2, double precision) {
        return Math.abs(lat1 - lat2) < precision && Math.abs(lon1 - lon2) < precision;
    }

    @NotNull
    public final KLatLon rhumbDestinationPoint(@NotNull KLatLon latLon, double distance, double bearing) {
        Intrinsics.checkNotNullParameter((Object)latLon, (String)"latLon");
        return this.rhumbDestinationPoint(latLon.getLatitude(), latLon.getLongitude(), distance, bearing);
    }

    @NotNull
    public final KLatLon rhumbDestinationPoint(double lat, double lon, double distance, double bearing) {
        double radius = 6378137.0;
        double d = distance / radius;
        double phi1 = DoubleExtensionsKt.toRadians(lat);
        double lambda1 = DoubleExtensionsKt.toRadians(lon);
        double theta = DoubleExtensionsKt.toRadians(bearing);
        double deltaPhi = d * Math.cos(theta);
        double phi2 = phi1 + deltaPhi;
        double deltaPsi = Math.log(Math.tan(phi2 / (double)2 + 0.7853981633974483) / Math.tan(phi1 / (double)2 + 0.7853981633974483));
        double q = Math.abs(deltaPsi) > 1.0E-11 ? deltaPhi / deltaPsi : Math.cos(phi1);
        double deltaLambda = d * Math.sin(theta) / q;
        double lambda2 = lambda1 + deltaLambda;
        return new KLatLon(DoubleExtensionsKt.toDegrees(phi2), DoubleExtensionsKt.toDegrees(lambda2));
    }

    public final double getSqrtDistance(int startX, int startY, int endX, int endY) {
        return Math.sqrt((endX - startX) * (endX - startX) + (endY - startY) * (endY - startY));
    }

    public final double getSqrtDistance(float startX, float startY, float endX, float endY) {
        return Math.sqrt((double)((endX - startX) * (endX - startX)) + (double)(endY - startY) * (double)(endY - startY));
    }

    @NotNull
    public final String convertDistToChar(int dist, char firstLetter, int firstDist, int mult1, int mult2) {
        int iteration = 0;
        int currentDist = firstDist;
        while (dist - currentDist > 0) {
            currentDist *= ++iteration % 2 == 1 ? mult1 : mult2;
        }
        return String.valueOf((char)(firstLetter + iteration));
    }

    public final int convertCharToDist(char ch, char firstLetter, int firstDist, int mult1, int mult2) {
        int dist = firstDist;
        int n = ch - firstLetter + 1;
        for (int iteration = 1; iteration < n; ++iteration) {
            dist *= iteration % 2 == 1 ? mult1 : mult2;
        }
        return dist;
    }

    public final double getEllipsoidDistance(double lat1, double lon1, double lat2, double lon2) {
        double lat12 = lat1;
        double lon12 = lon1;
        double lat22 = lat2;
        double lon22 = lon2;
        int MAXITERS = 20;
        lat12 *= Math.PI / 180;
        lat22 *= Math.PI / 180;
        double a = 6378137.0;
        double b = 6356752.3142;
        double f = (a - b) / a;
        double aSqMinusBSqOverBSq = (a * a - b * b) / (b * b);
        double L = (lon22 *= Math.PI / 180) - (lon12 *= Math.PI / 180);
        double A = 0.0;
        double U1 = Math.atan((1.0 - f) * Math.tan(lat12));
        double U2 = Math.atan((1.0 - f) * Math.tan(lat22));
        double cosU1 = Math.cos(U1);
        double cosU2 = Math.cos(U2);
        double sinU1 = Math.sin(U1);
        double sinU2 = Math.sin(U2);
        double cosU1cosU2 = cosU1 * cosU2;
        double sinU1sinU2 = sinU1 * sinU2;
        double sigma = 0.0;
        double deltaSigma = 0.0;
        double cosSqAlpha = 0.0;
        double cos2SM = 0.0;
        double cosSigma = 0.0;
        double sinSigma = 0.0;
        double cosLambda = 0.0;
        double sinLambda = 0.0;
        double lambda = L;
        for (int iter = 0; iter < MAXITERS; ++iter) {
            double lambdaOrig = lambda;
            cosLambda = Math.cos(lambda);
            sinLambda = Math.sin(lambda);
            double t1 = cosU2 * sinLambda;
            double t2 = cosU1 * sinU2 - sinU1 * cosU2 * cosLambda;
            double sinSqSigma = t1 * t1 + t2 * t2;
            sinSigma = Math.sqrt(sinSqSigma);
            cosSigma = sinU1sinU2 + cosU1cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            double sinAlpha = sinSigma == 0.0 ? 0.0 : cosU1cosU2 * sinLambda / sinSigma;
            cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            cos2SM = cosSqAlpha == 0.0 ? 0.0 : cosSigma - 2.0 * sinU1sinU2 / cosSqAlpha;
            double uSquared = cosSqAlpha * aSqMinusBSqOverBSq;
            A = 1.0 + uSquared / 16384.0 * (4096.0 + uSquared * ((double)-768 + uSquared * (320.0 - 175.0 * uSquared)));
            double B = uSquared / 1024.0 * (256.0 + uSquared * (-128.0 + uSquared * (74.0 - 47.0 * uSquared)));
            double C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha));
            double cos2SMSq = cos2SM * cos2SM;
            deltaSigma = B * sinSigma * (cos2SM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SMSq) - B / 6.0 * cos2SM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SMSq)));
            lambda = L + (1.0 - C) * f * sinAlpha * (sigma + C * sinSigma * (cos2SM + C * cosSigma * (-1.0 + 2.0 * cos2SM * cos2SM)));
            double delta = (lambda - lambdaOrig) / lambda;
            if (Math.abs(delta) < 1.0E-12) break;
        }
        return b * A * (sigma - deltaSigma);
    }

    @NotNull
    public final KGeoParsedPoint decodeShortLinkString(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String s2 = s;
        CharSequence charSequence = s2;
        Regex regex = new Regex("@");
        String string = "~";
        s2 = regex.replace(charSequence, string);
        int i = 0;
        long x = 0L;
        long y = 0L;
        int z = -8;
        for (i = 0; i < s2.length(); ++i) {
            int j;
            int digit = -1;
            char c = s2.charAt(i);
            int n = intToBase64.length;
            for (j = 0; j < n; ++j) {
                if (c != intToBase64[j]) continue;
                digit = j;
                break;
            }
            if (digit < 0 || digit < 0) break;
            x <<= 3;
            y <<= 3;
            for (j = 2; -1 < j; --j) {
                x |= (long)((digit & 1 << j + j + 1) == 0 ? 0 : 1 << j);
                y |= (long)((digit & 1 << j + j) == 0 ? 0 : 1 << j);
            }
            z += 3;
        }
        double lon = (double)x * Math.pow(2.0, 2 - 3 * i) * 90.0 - (double)180;
        double lat = (double)y * Math.pow(2.0, 2 - 3 * i) * 45.0 - (double)90;
        if (i < s2.length() && s2.charAt(i) == '-') {
            z -= 2;
            if (i + 1 < s2.length() && s2.charAt(i + 1) == '-') {
                ++z;
            }
        }
        return new KGeoParsedPoint(lat, lon, z);
    }

    @NotNull
    public final KQuadRect decodeShortLinkToQuadRect(@NotNull String shortLink) {
        Intrinsics.checkNotNullParameter((Object)shortLink, (String)"shortLink");
        KGeoParsedPoint point = this.decodeShortLinkString(shortLink);
        double bottom = point.getLatitude();
        double left = point.getLongitude();
        int precision = 0;
        String base64chars = StringsKt.concatToString((char[])intToBase64);
        int n = shortLink.length();
        for (int i = 0; i < n; ++i) {
            if (StringsKt.indexOf$default((CharSequence)base64chars, (char)shortLink.charAt(i), (int)0, (boolean)false, (int)6, null) <= 0) continue;
            ++precision;
        }
        double factor = Math.pow(2.0, 2 - 3 * precision);
        double deltaLon = factor * (double)90;
        double deltaLat = factor * (double)45;
        double top = bottom + deltaLat;
        double right = left + deltaLon;
        return new KQuadRect(left, top, right, bottom);
    }

    @NotNull
    public final KLatLon interpolateLatLon(double lat1, double lon1, double lat2, double lon2, double fraction) {
        return new KLatLon(lat1 + (lat2 - lat1) * fraction, lon1 + (lon2 - lon1) * fraction);
    }

    static {
        char[] cArray = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '~'};
        intToBase64 = cArray;
        DIST_CACHE = new ConcurrentMutableMap();
    }
}

