/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki.wikidata;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import net.osmand.PlatformUtil;
import net.osmand.impl.FileProgressImplementation;
import net.osmand.map.OsmandRegions;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.wiki.OsmCoordinatesByTag;
import net.osmand.wiki.wikidata.ArticleMapper;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class WikiDataHandler
extends DefaultHandler {
    private static final Log log = PlatformUtil.getLog(WikiDataHandler.class);
    private final SAXParser saxParser;
    private boolean page = false;
    private StringBuilder ctext = null;
    private final StringBuilder title = new StringBuilder();
    private final StringBuilder text = new StringBuilder();
    private final StringBuilder format = new StringBuilder();
    private FileProgressImplementation progress;
    private Connection conn;
    private PreparedStatement coordsPrep;
    private PreparedStatement mappingPrep;
    private PreparedStatement wikiRegionPrep;
    private PreparedStatement wikidataPropPrep;
    private int[] mappingBatch = new int[]{0};
    private int[] coordsBatch = new int[]{0};
    private int[] regionBatch = new int[]{0};
    private int[] wikidataPropBatch = new int[]{0};
    public static final int BATCH_SIZE = 5000;
    private static final int ARTICLE_BATCH_SIZE = 10000;
    private static final int ERROR_BATCH_SIZE = 200;
    private int count = 0;
    private int errorCount = 0;
    private Gson gson;
    private OsmandRegions regions;
    private List<String> keyNames = new ArrayList<String>();
    OsmCoordinatesByTag osmWikiCoordinates;
    private long lastProcessedId;

    public WikiDataHandler(SAXParser saxParser, FileProgressImplementation progress, File wikidataSqlite, OsmCoordinatesByTag osmWikiCoordinates, OsmandRegions regions, long lastProcessedId) throws SQLException {
        this.saxParser = saxParser;
        this.osmWikiCoordinates = osmWikiCoordinates;
        this.regions = regions;
        this.progress = progress;
        this.lastProcessedId = lastProcessedId;
        DBDialect dialect = DBDialect.SQLITE;
        this.conn = dialect.getDatabaseConnection(wikidataSqlite.getAbsolutePath(), log);
        this.conn.createStatement().execute("CREATE TABLE IF NOT EXISTS wiki_coords(id bigint, originalId text, lat double, lon double, wlat double, wlon double,   osmtype int, osmid bigint, poitype text, poisubtype text, labelsJson text)");
        this.conn.createStatement().execute("CREATE TABLE IF NOT EXISTS wiki_mapping(id bigint, lang text, title text)");
        this.conn.createStatement().execute("CREATE TABLE IF NOT EXISTS wiki_region(id bigint, regionName text)");
        this.conn.createStatement().execute("CREATE TABLE IF NOT EXISTS wikidata_properties(id bigint, type text, value text)");
        this.coordsPrep = this.conn.prepareStatement("INSERT INTO wiki_coords(id, originalId, lat, lon, wlat, wlon, osmtype, osmid, poitype, poisubtype, labelsJson)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.mappingPrep = this.conn.prepareStatement("INSERT INTO wiki_mapping(id, lang, title) VALUES (?, ?, ?)");
        this.wikiRegionPrep = this.conn.prepareStatement("INSERT OR IGNORE INTO wiki_region(id, regionName) VALUES(?, ? )");
        this.wikidataPropPrep = this.conn.prepareStatement("INSERT INTO wikidata_properties(id, type, value) VALUES(?, ?, ?)");
        this.gson = new GsonBuilder().registerTypeAdapter(ArticleMapper.Article.class, (Object)new ArticleMapper()).create();
    }

    public void addBatch(PreparedStatement prep, int[] bt) throws SQLException {
        prep.addBatch();
        bt[0] = bt[0] + 1;
        int batch = bt[0];
        if (batch > 5000) {
            prep.executeBatch();
            bt[0] = 0;
        }
    }

    public void finish() throws SQLException {
        log.info((Object)("Total accepted: " + this.count));
        this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS map_lang_title_idx ON wiki_mapping(lang, title)");
        this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS id_mapping_index on wiki_mapping(id)");
        this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS id_coords_idx on wiki_coords(id)");
        this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS id_coords_originalId on wiki_coords(originalId)");
        this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS id_region_idx on wiki_region(id)");
        this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS reg_region_idx on wiki_region(regionName)");
        this.conn.createStatement().execute("CREATE UNIQUE INDEX IF NOT EXISTS unique_region_idx on wiki_region(id, regionName)");
        this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS wikidata_properties_idx on wikidata_properties(id)");
        this.coordsPrep.executeBatch();
        this.mappingPrep.executeBatch();
        if (!this.conn.getAutoCommit()) {
            this.conn.commit();
        }
        this.mappingPrep.close();
        this.coordsPrep.close();
        this.conn.close();
    }

    public void setLastProcessedId(Long lastProcessedId) {
        this.lastProcessedId = lastProcessedId;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        String name;
        String string = name = this.saxParser.isNamespaceAware() ? localName : qName;
        if (!this.page) {
            this.page = name.equals("page");
        } else if (name.equals("title")) {
            this.title.setLength(0);
            this.ctext = this.title;
        } else if (name.equals("text")) {
            this.text.setLength(0);
            this.ctext = this.text;
        } else if (name.equals("format")) {
            this.format.setLength(0);
            this.ctext = this.format;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.page && this.ctext != null) {
            this.ctext.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String name;
        String string = name = this.saxParser.isNamespaceAware() ? localName : qName;
        if (this.page) {
            switch (name) {
                case "page": {
                    this.page = false;
                    this.progress.update();
                    break;
                }
                case "title": 
                case "format": {
                    this.ctext = null;
                    break;
                }
                case "text": {
                    if (!this.format.toString().equals("application/json")) {
                        return;
                    }
                    try {
                        String t = this.title.toString();
                        if (t.startsWith("Lexeme:")) {
                            return;
                        }
                        long id = Long.parseLong(this.title.substring(1));
                        if (id < this.lastProcessedId) {
                            return;
                        }
                        this.processJsonPage(id, this.ctext.toString());
                        break;
                    }
                    catch (Exception e) {
                        ++this.errorCount;
                        if (this.errorCount == 200) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                        if (this.errorCount % 200 != 0) break;
                        log.error((Object)String.format("Error pages %s (total %d)", this.title, this.errorCount));
                    }
                }
            }
        }
    }

    public void processJsonPage(long id, String json) throws SQLException, IOException {
        ArticleMapper.Article article = (ArticleMapper.Article)this.gson.fromJson(json, ArticleMapper.Article.class);
        OsmCoordinatesByTag.OsmLatLonId osmCoordinates = null;
        double wlat = article.getLat();
        double wlon = article.getLon();
        if ((osmCoordinates = this.getOsmCoordinates(id, article, osmCoordinates)) != null) {
            article.setLat(osmCoordinates.lat);
            article.setLon(osmCoordinates.lon);
        }
        if (article.getLat() != 0.0 || article.getLon() != 0.0) {
            Map names;
            if (++this.count % 10000 == 0) {
                log.info((Object)String.format("Article accepted %s (%d)", this.title, this.count));
            }
            Map<String, String> labels = article.getLabels();
            LinkedHashMap<String, String> merged = null;
            if (osmCoordinates != null && osmCoordinates.amenity != null && (names = osmCoordinates.amenity.getNamesMap(true)) != null) {
                merged = new LinkedHashMap(names);
            }
            if (labels != null) {
                if (merged == null) {
                    merged = new LinkedHashMap<String, String>();
                }
                merged.putAll(labels);
            }
            String labelsJson = merged != null ? this.gson.toJson(merged) : null;
            int ind = 0;
            this.coordsPrep.setLong(++ind, id);
            this.coordsPrep.setString(++ind, this.title.toString());
            this.coordsPrep.setDouble(++ind, article.getLat());
            this.coordsPrep.setDouble(++ind, article.getLon());
            this.coordsPrep.setDouble(++ind, wlat);
            this.coordsPrep.setDouble(++ind, wlon);
            this.coordsPrep.setInt(++ind, osmCoordinates != null ? osmCoordinates.type + 1 : 0);
            this.coordsPrep.setLong(++ind, osmCoordinates != null ? osmCoordinates.id : 0L);
            this.coordsPrep.setString(++ind, osmCoordinates != null && osmCoordinates.amenity != null ? osmCoordinates.amenity.getType().getKeyName() : null);
            this.coordsPrep.setString(++ind, osmCoordinates != null && osmCoordinates.amenity != null ? osmCoordinates.amenity.getSubType() : null);
            this.coordsPrep.setString(++ind, labelsJson);
            this.addBatch(this.coordsPrep, this.coordsBatch);
            List rgs = this.regions.getRegionsToDownload(article.getLat(), article.getLon(), this.keyNames);
            for (String reg : rgs) {
                this.wikiRegionPrep.setLong(1, id);
                this.wikiRegionPrep.setString(2, reg);
                this.addBatch(this.wikiRegionPrep, this.regionBatch);
            }
            for (ArticleMapper.SiteLink siteLink : article.getSiteLinks()) {
                this.mappingPrep.setLong(1, id);
                this.mappingPrep.setString(2, siteLink.lang());
                this.mappingPrep.setString(3, siteLink.title());
                this.addBatch(this.mappingPrep, this.mappingBatch);
            }
            if (article.getImage() != null) {
                String image = StringEscapeUtils.unescapeJava((String)article.getImage());
                this.wikidataPropPrep.setLong(1, id);
                this.wikidataPropPrep.setString(2, article.getImageProp());
                this.wikidataPropPrep.setString(3, image);
                this.addBatch(this.wikidataPropPrep, this.wikidataPropBatch);
            }
            if (article.getCommonCat() != null) {
                String commonCat = StringEscapeUtils.unescapeJava((String)article.getCommonCat());
                this.wikidataPropPrep.setLong(1, id);
                this.wikidataPropPrep.setString(2, "P373");
                this.wikidataPropPrep.setString(3, commonCat);
                this.addBatch(this.wikidataPropPrep, this.wikidataPropBatch);
            }
        }
    }

    private OsmCoordinatesByTag.OsmLatLonId getOsmCoordinates(long wid, ArticleMapper.Article article, OsmCoordinatesByTag.OsmLatLonId osmCoordinates) {
        for (ArticleMapper.SiteLink siteLink : article.getSiteLinks()) {
            String articleTitle = siteLink.title();
            String articleLang = siteLink.lang();
            osmCoordinates = this.osmWikiCoordinates.getCoordinates("wikipedia:" + articleLang, articleTitle);
            if (osmCoordinates == null) {
                osmCoordinates = this.osmWikiCoordinates.getCoordinates("wikipedia", articleLang + ":" + articleTitle);
            }
            if (osmCoordinates == null) {
                osmCoordinates = this.osmWikiCoordinates.getCoordinates("wikipedia", articleTitle);
            }
            if (osmCoordinates == null) continue;
            return osmCoordinates;
        }
        return this.osmWikiCoordinates.getCoordinates("wikidata", "Q" + wid);
    }
}

