/*
 * Decompiled with CFR 0.152.
 */
package net.osmand;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.osmand.AllocationUtil;
import net.osmand.NativeLibrary;
import net.osmand.RenderableObject;
import net.osmand.RenderingContext;
import net.osmand.binary.CachedOsmandIndexes;
import net.osmand.binary.OsmandIndex;
import net.osmand.data.QuadPointDouble;
import net.osmand.data.QuadRect;
import net.osmand.data.RotatedTileBox;
import net.osmand.render.RenderingClass;
import net.osmand.render.RenderingRuleProperty;
import net.osmand.render.RenderingRuleSearchRequest;
import net.osmand.render.RenderingRulesStorage;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import net.osmand.util.MapsCollection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlPullParserException;
import resources._R;

public class NativeJavaRendering
extends NativeLibrary {
    private static final String INDEXES_CACHE = "indexes.cache";
    public static Boolean loaded = null;
    private final Map<String, Object> tilePathLocks = new ConcurrentHashMap<String, Object>();
    private static NativeJavaRendering defaultLoadedLibrary;
    private static final Log log;
    private RenderingRulesStorage storage;
    private Map<String, String> renderingProps;
    private Map<String, MapDiff> diffs = new LinkedHashMap<String, MapDiff>();

    private static void loadRenderingAttributes(InputStream is, final Map<String, String> renderingConstants) throws SAXException, IOException {
        try {
            final SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(is, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    String tagName;
                    String string = tagName = saxParser.isNamespaceAware() ? localName : qName;
                    if ("renderingConstant".equals(tagName) && !renderingConstants.containsKey(attributes.getValue("name"))) {
                        renderingConstants.put(attributes.getValue("name"), attributes.getValue("value"));
                    }
                }
            });
        }
        catch (ParserConfigurationException e1) {
            throw new IllegalStateException(e1);
        }
        finally {
            is.close();
        }
    }

    public void closeAllFiles() {
        for (String s : this.diffs.keySet()) {
            MapDiff md = this.diffs.get(s);
            if (md.baseFile != null) {
                NativeJavaRendering.closeBinaryMapFile((String)md.baseFile.getAbsolutePath());
            }
            if (md.diffs == null) continue;
            for (File l : md.diffs.values()) {
                NativeJavaRendering.closeBinaryMapFile((String)l.getAbsolutePath());
            }
        }
        this.diffs.clear();
    }

    public void loadRuleStorage(String path, String renderingProperties) throws IOException, XmlPullParserException, SAXException {
        this.storage = NativeJavaRendering.parseStorage(path);
        this.setRenderingProps(renderingProperties);
        NativeJavaRendering.clearRenderingRulesStorage();
        NativeJavaRendering.initRenderingRulesStorage((RenderingRulesStorage)this.storage);
    }

    public static RenderingRulesStorage parseStorage(String path) throws SAXException, IOException, XmlPullParserException {
        RenderingRulesStorage storage;
        final LinkedHashMap<String, String> renderingConstants = new LinkedHashMap<String, String>();
        RenderingRulesStorage.RenderingRulesStorageResolver resolver = new RenderingRulesStorage.RenderingRulesStorageResolver(){

            public RenderingRulesStorage resolve(String name, RenderingRulesStorage.RenderingRulesStorageResolver ref) throws XmlPullParserException, IOException {
                RenderingRulesStorage depends = new RenderingRulesStorage(name, (Map)renderingConstants);
                depends.parseRulesFromXmlInputStream(RenderingRulesStorage.class.getResourceAsStream(name + ".render.xml"), ref, false);
                return depends;
            }
        };
        if (path == null || path.equals("default.render.xml")) {
            NativeJavaRendering.loadRenderingAttributes(RenderingRulesStorage.class.getResourceAsStream("default.render.xml"), renderingConstants);
            storage = new RenderingRulesStorage("default", renderingConstants);
            storage.parseRulesFromXmlInputStream(RenderingRulesStorage.class.getResourceAsStream("default.render.xml"), resolver, false);
        } else {
            InputStream is = null;
            InputStream is2 = null;
            File stylesDir = null;
            if (new File(path).exists()) {
                is = new FileInputStream(new File(path));
                is2 = new FileInputStream(new File(path));
                stylesDir = new File(path).getParentFile();
            } else {
                is = RenderingRulesStorage.class.getResourceAsStream(path);
                is2 = RenderingRulesStorage.class.getResourceAsStream(path);
            }
            if (is == null) {
                throw new IllegalArgumentException("Can't find rendering style '" + path + "'");
            }
            NativeJavaRendering.loadRenderingAttributes(is, renderingConstants);
            String name = path;
            if (name.endsWith(".render.xml")) {
                name = name.substring(0, name.length() - ".render.xml".length());
            }
            if (name.lastIndexOf(47) != -1) {
                name = name.substring(name.lastIndexOf(47) + 1);
            }
            storage = new RenderingRulesStorage(name, renderingConstants);
            storage.parseRulesFromXmlInputStream(is2, resolver, false);
            is.close();
            is2.close();
            if (stylesDir != null) {
                for (File file : stylesDir.listFiles()) {
                    if (!file.isFile() || !file.getName().endsWith("addon.render.xml")) continue;
                    FileInputStream is3 = new FileInputStream(file);
                    storage.parseRulesFromXmlInputStream((InputStream)is3, resolver, true);
                    ((InputStream)is3).close();
                }
            }
        }
        return storage;
    }

    public NativeJavaRendering() {
        try {
            this.loadRuleStorage(null, "");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
    }

    public void setRenderingProps(String renderingProperties) {
        String[] props;
        this.renderingProps = new HashMap<String, String>();
        for (String s : props = renderingProperties.split(",")) {
            int i = s.indexOf(61);
            if (i <= 0) continue;
            String key = s.substring(0, i).trim();
            String value = s.substring(i + 1).trim();
            if (value.contains(";")) {
                value = value.substring(0, value.indexOf(59));
            }
            this.renderingProps.put(key, value);
        }
    }

    public RenderingRulesStorage getRenderingRuleStorage() {
        return this.storage;
    }

    public NativeLibrary.RenderingGenerationResult render(RenderingImageContext renderingImageContext) throws IOException {
        Object res;
        long time = -System.currentTimeMillis();
        RenderingContext renderingContext = new RenderingContext(){

            protected byte[] getIconRawData(String data) {
                return _R.getIconData(data);
            }
        };
        renderingContext.preferredLocale = this.renderingProps.get("lang") != null ? this.renderingProps.get("lang") : "";
        renderingContext.nightMode = "true".equals(this.renderingProps.get("nightMode"));
        RenderingRuleSearchRequest request = new RenderingRuleSearchRequest(this.storage);
        request.setBooleanFilter(request.ALL.R_NIGHT_MODE, renderingContext.nightMode);
        for (RenderingRuleProperty customProp : this.storage.PROPS.getCustomRules()) {
            res = this.renderingProps.get(customProp.getAttrName());
            if (customProp.getAttrName().equals("engine_v1")) {
                request.setBooleanFilter(customProp, true);
                continue;
            }
            if (!Algorithms.isEmpty((CharSequence)res)) {
                if (customProp.isString()) {
                    request.setStringFilter(customProp, (String)res);
                    continue;
                }
                if (customProp.isBoolean()) {
                    request.setBooleanFilter(customProp, "true".equalsIgnoreCase((String)res));
                    continue;
                }
                try {
                    request.setIntFilter(customProp, Integer.parseInt((String)res));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                continue;
            }
            if (customProp.isString()) {
                request.setStringFilter(customProp, "");
                continue;
            }
            if (customProp.isBoolean()) {
                request.setBooleanFilter(customProp, false);
                continue;
            }
            request.setIntFilter(customProp, -1);
        }
        request.setIntFilter(request.ALL.R_MINZOOM, renderingImageContext.zoom);
        HashMap<String, Boolean> parentsStates = new HashMap<String, Boolean>();
        Map renderingClasses = this.storage.getRenderingClasses();
        for (Map.Entry entry : renderingClasses.entrySet()) {
            String name = (String)entry.getKey();
            RenderingClass renderingClass = (RenderingClass)entry.getValue();
            boolean enabled = renderingClass.isEnabledByDefault();
            String parentName = renderingClass.getParentName();
            if (parentName != null && parentsStates.containsKey(parentName) && !((Boolean)parentsStates.get(parentName)).booleanValue()) {
                enabled = false;
            }
            request.setClassProperty(name, String.valueOf(enabled));
            parentsStates.put(name, enabled);
        }
        request.saveState();
        res = this.searchObjectsForRendering(renderingImageContext.sleft, renderingImageContext.sright, renderingImageContext.stop, renderingImageContext.sbottom, renderingImageContext.zoom, request, true, renderingContext, "Nothing found");
        float f = 1.0f;
        if (this.renderingProps.get("density") != null) {
            f *= Float.parseFloat(this.renderingProps.get("density"));
        }
        renderingContext.leftX = renderingImageContext.leftX * (double)f;
        renderingContext.topY = renderingImageContext.topY * (double)f;
        renderingContext.width = (int)((float)renderingImageContext.width * f);
        renderingContext.height = (int)((float)renderingImageContext.height * f);
        renderingContext.renderingContextHandle = ((NativeLibrary.NativeSearchResult)res).nativeHandler;
        renderingContext.setDensityValue(f);
        renderingContext.textScale = 1.0f / f;
        if (this.renderingProps.get("textScale") != null) {
            renderingContext.textScale *= Float.parseFloat(this.renderingProps.get("textScale"));
        }
        renderingContext.screenDensityRatio = 1.0f / Math.max(1.0f, 1.0f);
        double tileDivisor = MapUtils.getPowZoom((double)(31 - renderingImageContext.zoom)) / (double)f;
        request.clearState();
        if (request.searchRenderingAttribute("defaultColor")) {
            renderingContext.defaultColor = request.getIntPropertyValue(request.ALL.R_ATTR_COLOR_VALUE);
        }
        request.clearState();
        request.setIntFilter(request.ALL.R_MINZOOM, renderingImageContext.zoom);
        if (request.searchRenderingAttribute("shadowRendering")) {
            renderingContext.shadowRenderingMode = request.getIntPropertyValue(request.ALL.R_ATTR_INT_VALUE);
            renderingContext.shadowRenderingColor = request.getIntPropertyValue(request.ALL.R_SHADOW_COLOR);
        }
        renderingContext.zoom = renderingImageContext.zoom;
        renderingContext.tileDivisor = tileDivisor;
        renderingContext.saveTextTile = renderingImageContext.saveTextTile;
        long search = time + System.currentTimeMillis();
        NativeLibrary.RenderingGenerationResult generationResult = NativeLibrary.generateRenderingIndirect((RenderingContext)renderingContext, (long)((NativeLibrary.NativeSearchResult)res).nativeHandler, (boolean)false, (RenderingRuleSearchRequest)request, (boolean)true);
        List renderableObjects = (List)new Gson().fromJson(renderingContext.textTile, new TypeToken<List<RenderableObject>>(){}.getType());
        if (renderingContext.saveTextTile) {
            generationResult.setInfo(RenderableObject.createGeoJson(renderableObjects));
        }
        long rendering = time + System.currentTimeMillis() - search;
        renderingImageContext.searchTime = search;
        renderingImageContext.renderingTime = rendering;
        renderingImageContext.context = renderingContext;
        res.deleteNativeResult();
        return generationResult;
    }

    public RenderingImageResult renderImage(RenderingImageContext renderingImageContext) throws IOException {
        final NativeLibrary.RenderingGenerationResult generationResult = this.render(renderingImageContext);
        InputStream inputStream = new InputStream(){
            int nextInd = 0;

            @Override
            public int read() {
                byte b;
                if (this.nextInd >= generationResult.bitmapBuffer.capacity()) {
                    return -1;
                }
                if ((b = generationResult.bitmapBuffer.get(this.nextInd++)) < 0) {
                    return b + 256;
                }
                return b;
            }
        };
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("png");
        ImageReader reader = readers.next();
        reader.setInput(new MemoryCacheImageInputStream(inputStream), true);
        BufferedImage img = reader.read(0);
        AllocationUtil.freeDirectBuffer(generationResult.bitmapBuffer);
        return new RenderingImageResult(img, generationResult);
    }

    public void initFilesInDir(File filesDir) throws IOException {
        ArrayList<File> obfFiles = new ArrayList<File>();
        Map<String, OsmandIndex.FileIndex> mp = this.initIndexesCache(filesDir, obfFiles, false);
        this.initFilesInDir(obfFiles, mp);
    }

    private void initFilesInDir(List<File> obfFiles, Map<String, OsmandIndex.FileIndex> boundaries) {
        for (File f : obfFiles) {
            int l = f.getName().length() - 4;
            if (f.getName().charAt(l - 3) == '_' && f.getName().charAt(l - 6) == '_' && f.getName().charAt(l - 9) == '_') {
                MapDiff md;
                String baseName = f.getName().substring(0, l - 9);
                if (!this.diffs.containsKey(baseName)) {
                    md = new MapDiff();
                    md.baseName = baseName;
                    this.diffs.put(baseName, md);
                }
                md = this.diffs.get(baseName);
                md.diffs.put(f.getName().substring(l - 8, l), f);
            } else if (!f.getName().contains("basemap") && boundaries != null) {
                OsmandIndex.FileIndex mapIndex = boundaries.get(f.getAbsolutePath());
                if (f.getName().endsWith("_2.obf")) {
                    this.updateBoundaries(f, mapIndex, f.getName().substring(0, f.getName().length() - 6));
                } else {
                    this.updateBoundaries(f, mapIndex, f.getName().substring(0, f.getName().length() - 4));
                }
            }
            this.initMapFile(f.getAbsolutePath(), true);
        }
    }

    private void updateBoundaries(File f, OsmandIndex.FileIndex mapIndex, String nm) {
        if (mapIndex == null || mapIndex.getMapIndexCount() == 0 || mapIndex.getMapIndex(0).getLevelsCount() == 0) {
            return;
        }
        if (!this.diffs.containsKey(nm)) {
            MapDiff mm = new MapDiff();
            mm.baseName = nm;
            this.diffs.put(nm, mm);
        }
        OsmandIndex.MapLevel rt = mapIndex.getMapIndex(0).getLevels(0);
        MapDiff dd = this.diffs.get(nm);
        dd.baseFile = f;
        dd.timestamp = mapIndex.getDateModified();
        dd.bounds = new QuadRect(MapUtils.get31LongitudeX((int)rt.getLeft()), MapUtils.get31LatitudeY((int)rt.getTop()), MapUtils.get31LongitudeX((int)rt.getRight()), MapUtils.get31LatitudeY((int)rt.getBottom()));
        for (String dd.selected : dd.diffs.keySet()) {
        }
    }

    public void enableBaseFile(MapDiff m, boolean enable) {
        if (enable) {
            if (!m.enableBaseMap) {
                NativeJavaRendering.initBinaryMapFile((String)m.baseFile.getAbsolutePath(), (boolean)true, (boolean)false);
                m.enableBaseMap = true;
            }
        } else if (m.enableBaseMap) {
            NativeJavaRendering.closeBinaryMapFile((String)m.baseFile.getAbsolutePath());
            m.enableBaseMap = false;
        }
    }

    public void enableMapFile(MapDiff md, String df) {
        NativeJavaRendering.closeBinaryMapFile((String)md.baseFile.getAbsolutePath());
        Set<String> ks = md.diffs.keySet();
        LinkedList<String> reverse = new LinkedList<String>();
        for (String s : ks) {
            String fp = md.diffs.get(s).getAbsolutePath();
            if (!md.disabled.contains(fp)) {
                NativeJavaRendering.closeBinaryMapFile((String)fp);
                md.disabled.add(fp);
            }
            reverse.addFirst(s);
        }
        boolean enable = false;
        for (String s : reverse) {
            String fp = md.diffs.get(s).getAbsolutePath();
            boolean bl = enable = enable || s.equals(df);
            if (!enable) {
                if (md.disabled.contains(fp)) continue;
                NativeJavaRendering.closeBinaryMapFile((String)fp);
                md.disabled.add(fp);
                continue;
            }
            if (!md.disabled.contains(fp)) continue;
            NativeJavaRendering.initBinaryMapFile((String)fp, (boolean)true, (boolean)false);
            md.disabled.remove(fp);
        }
        md.selected = df;
        if (md.enableBaseMap) {
            NativeJavaRendering.initBinaryMapFile((String)md.baseFile.getAbsolutePath(), (boolean)true, (boolean)false);
        }
    }

    public MapDiff getMapDiffs(double lat, double lon) {
        for (MapDiff md : this.diffs.values()) {
            if (md.bounds == null || !(md.bounds.top > lat) || !(md.bounds.bottom < lat) || !(md.bounds.left < lon) || !(md.bounds.right > lon)) continue;
            return md;
        }
        return null;
    }

    public Map<String, OsmandIndex.FileIndex> initIndexesCache(File dir, List<File> filesToUse, boolean filterDuplicates) throws IOException {
        TreeMap<String, OsmandIndex.FileIndex> map = new TreeMap<String, OsmandIndex.FileIndex>();
        File cacheFile = new File(dir, INDEXES_CACHE);
        CachedOsmandIndexes cache = new CachedOsmandIndexes();
        if (cacheFile.exists()) {
            cache.readFromFile(cacheFile);
        }
        if (dir.exists() && dir.listFiles() != null) {
            MapsCollection mapsCollection = new MapsCollection(filterDuplicates);
            for (File obf : Algorithms.getSortedFilesVersions((File)dir)) {
                if (obf.isDirectory() || !obf.getName().endsWith(".obf")) continue;
                mapsCollection.add(obf);
            }
            List<File> filteredMaps = mapsCollection.getFilesToUse();
            for (File file : filteredMaps) {
                OsmandIndex.FileIndex fileIndex = cache.getFileIndex(file, true);
                if (fileIndex == null) continue;
                map.put(file.getAbsolutePath(), fileIndex);
            }
            if (filesToUse != null) {
                filesToUse.addAll(filteredMaps);
            }
        }
        cache.writeToFile(cacheFile);
        return map;
    }

    public static NativeJavaRendering getDefault(String filename, String obfFolder, String fontsFolder) throws IOException {
        String path;
        boolean loaded;
        File f;
        if (defaultLoadedLibrary != null) {
            return defaultLoadedLibrary;
        }
        File file = f = filename == null ? null : new File(filename);
        if (filename == null || filename.length() == 0 || !f.exists()) {
            filename = null;
        }
        if (loaded = NativeLibrary.loadOldLib((String)(path = filename == null ? null : f.getParentFile().getAbsolutePath()))) {
            defaultLoadedLibrary = new NativeJavaRendering();
            long now = System.currentTimeMillis();
            if (obfFolder != null) {
                File filesFolder = new File(obfFolder);
                ArrayList<File> obfFiles = new ArrayList<File>();
                Map<String, OsmandIndex.FileIndex> map = defaultLoadedLibrary.initIndexesCache(filesFolder, obfFiles, true);
                defaultLoadedLibrary.initFilesInDir(obfFiles, map);
            }
            log.info((Object)String.format("Init native library with maps: %d ms", System.currentTimeMillis() - now));
            if (fontsFolder != null) {
                defaultLoadedLibrary.loadFontData(new File(fontsFolder));
            }
        }
        return defaultLoadedLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getGeotiffImage(String tilePath, String outColorFilename, String midColorFilename, int type, int size, int zoom, int x, int y) throws IOException {
        ByteBuffer geotiffBuffer;
        Object lock;
        Object object = lock = this.tilePathLocks.computeIfAbsent(tilePath, k -> new Object());
        synchronized (object) {
            geotiffBuffer = NativeLibrary.getGeotiffTile((String)tilePath, (String)outColorFilename, (String)midColorFilename, (int)type, (int)size, (int)zoom, (int)x, (int)y);
        }
        try (InputStream inputStream = new InputStream(){
            int nextInd = 0;

            @Override
            public int read() {
                if (this.nextInd >= geotiffBuffer.capacity()) {
                    return -1;
                }
                byte b = geotiffBuffer.get(this.nextInd++);
                return b & 0xFF;
            }
        };){
            Object object2;
            try (MemoryCacheImageInputStream memoryCacheStream = new MemoryCacheImageInputStream(inputStream);){
                Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("png");
                if (!readers.hasNext()) {
                    throw new IOException("No PNG ImageReader found");
                }
                ImageReader reader = readers.next();
                reader.setInput(memoryCacheStream, true);
                BufferedImage img = reader.read(0);
                object2 = lock;
                synchronized (object2) {
                    AllocationUtil.freeDirectBuffer(geotiffBuffer);
                }
                object2 = img;
            }
            return object2;
        }
    }

    static {
        log = LogFactory.getLog(NativeJavaRendering.class);
    }

    public static class MapDiff {
        public String baseName;
        public File baseFile;
        public QuadRect bounds;
        public Map<String, File> diffs = new TreeMap<String, File>();
        public Set<String> disabled = new TreeSet<String>();
        public boolean enableBaseMap = true;
        public String selected;
        public long timestamp;
    }

    public static class RenderingImageContext {
        public final int zoom;
        public final int sleft;
        public final int sright;
        public final int stop;
        public final int sbottom;
        private double leftX;
        private double topY;
        public final int width;
        public final int height;
        public long searchTime;
        public long renderingTime;
        public boolean saveTextTile = false;
        public RenderingContext context;

        public RenderingImageContext(int sleft, int sright, int stop, int sbottom, int zoom) {
            this.sleft = sleft;
            this.sright = sright;
            this.stop = stop;
            this.sbottom = sbottom;
            this.zoom = zoom;
            this.leftX = (double)sleft / MapUtils.getPowZoom((double)(31 - zoom));
            this.topY = (double)stop / MapUtils.getPowZoom((double)(31 - zoom));
            this.width = (int)Math.round((double)(sright - sleft) / MapUtils.getPowZoom((double)(31 - zoom - 8)));
            this.height = (int)Math.round((double)(sbottom - stop) / MapUtils.getPowZoom((double)(31 - zoom - 8)));
        }

        public RenderingImageContext(double lat, double lon, int width, int height, int zoom, double mapDensity) {
            this.width = width;
            this.height = height;
            this.zoom = zoom;
            RotatedTileBox.RotatedTileBoxBuilder bld = new RotatedTileBox.RotatedTileBoxBuilder();
            RotatedTileBox tb = bld.setPixelDimensions(width, height).setZoom(zoom).setLocation(lat, lon).build();
            tb.setMapDensity(mapDensity);
            QuadPointDouble lt = tb.getLeftTopTile((double)tb.getZoom());
            this.leftX = lt.x;
            this.topY = lt.y;
            QuadRect ll = tb.getLatLonBounds();
            this.sleft = MapUtils.get31TileNumberX((double)ll.left);
            this.sright = MapUtils.get31TileNumberX((double)ll.right);
            this.sbottom = MapUtils.get31TileNumberY((double)ll.bottom);
            this.stop = MapUtils.get31TileNumberY((double)ll.top);
        }
    }

    public static class RenderingImageResult {
        private final BufferedImage img;
        private final NativeLibrary.RenderingGenerationResult generationResult;

        RenderingImageResult(BufferedImage img, NativeLibrary.RenderingGenerationResult result) {
            this.img = img;
            this.generationResult = result;
        }

        public BufferedImage getImage() {
            return this.img;
        }

        public NativeLibrary.RenderingGenerationResult getGenerationResult() {
            return this.generationResult;
        }
    }
}

