/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.osmand.router.GeneralRouter;
import net.osmand.router.RoutingConfiguration;

public class TransportRoutingConfiguration {
    public int ZOOM_TO_LOAD_TILES = 15;
    public int walkRadius = 1500;
    public int walkChangeRadius = 300;
    public int maxNumberOfChanges = 3;
    public int finishTimeSeconds = 1200;
    public double increaseForAlternativesRoutes = 2.0;
    public double increaseForAltRoutesWalking = 3.0;
    public int combineAltRoutesDiffStops = 120;
    public int combineAltRoutesSumDiffStops = 300;
    public int maxRouteTime = 36000;
    public int maxRouteDistance = 0;
    public int maxRouteIncreaseSpeed = 30;
    public GeneralRouter router;
    public float walkSpeed = 1.0f;
    public float defaultTravelSpeed = 16.666666f;
    private int defaultStopTime = 0;
    private Map<String, Integer> stopTimes = new HashMap<String, Integer>();
    private int defaultBoardingTime = 0;
    private Map<String, Integer> boardingTimes = new HashMap<String, Integer>();
    private int defaultChangeTime = 0;
    private Map<String, Integer> changingTimes = new HashMap<String, Integer>();
    public boolean useSchedule;
    public int scheduleTimeOfDay = 4320;
    public int scheduleMaxTime = 300;
    public int scheduleDayNumber;
    private Map<String, Integer> rawTypes = new HashMap<String, Integer>();
    private Map<String, Float> speed = new TreeMap<String, Float>();

    public int getStopTime(String routeType) {
        GeneralRouter.RouteAttributeContext obstacles;
        int time;
        if (this.stopTimes.containsKey(routeType)) {
            time = this.stopTimes.get(routeType);
        } else {
            obstacles = this.router.getObjContext(GeneralRouter.RouteDataObjectAttribute.ROUTING_OBSTACLES);
            time = obstacles.evaluateInt(this.getRawBitset("stop", routeType), 0);
            this.stopTimes.put(routeType, time);
        }
        if (time > 0) {
            return time;
        }
        if (this.defaultStopTime == 0) {
            obstacles = this.router.getObjContext(GeneralRouter.RouteDataObjectAttribute.ROUTING_OBSTACLES);
            this.defaultStopTime = obstacles.evaluateInt(this.getRawBitset("stop", ""), 30);
        }
        return this.defaultStopTime;
    }

    public int getBoardingTime(String routeType) {
        GeneralRouter.RouteAttributeContext obstacles;
        int time;
        if (this.boardingTimes.containsKey(routeType)) {
            time = this.boardingTimes.get(routeType);
        } else {
            obstacles = this.router.getObjContext(GeneralRouter.RouteDataObjectAttribute.ROUTING_OBSTACLES);
            time = obstacles.evaluateInt(this.getRawBitset("boarding", routeType), 0);
            this.boardingTimes.put(routeType, time);
        }
        if (time > 0) {
            return time;
        }
        if (this.defaultBoardingTime == 0) {
            obstacles = this.router.getObjContext(GeneralRouter.RouteDataObjectAttribute.ROUTING_OBSTACLES);
            this.defaultBoardingTime = obstacles.evaluateInt(this.getRawBitset("boarding", ""), 150);
        }
        return this.defaultBoardingTime;
    }

    public int getChangeTime(String fromRouteType, String toRouteType) {
        GeneralRouter.RouteAttributeContext obstacles;
        int time;
        String key = fromRouteType + "_" + toRouteType;
        if (this.changingTimes.containsKey(key)) {
            time = this.changingTimes.get(key);
        } else {
            obstacles = this.router.getObjContext(GeneralRouter.RouteDataObjectAttribute.ROUTING_OBSTACLES);
            time = obstacles.evaluateInt(this.getRawBitset("change", key), 0);
            this.changingTimes.put(key, time);
        }
        if (time > 0) {
            return time;
        }
        if (this.defaultChangeTime == 0) {
            obstacles = this.router.getObjContext(GeneralRouter.RouteDataObjectAttribute.ROUTING_OBSTACLES);
            this.defaultChangeTime = obstacles.evaluateInt(this.getRawBitset("change", ""), 240);
        }
        return this.defaultChangeTime;
    }

    public float getSpeedByRouteType(String routeType) {
        Float sl = this.speed.get(routeType);
        if (sl == null) {
            GeneralRouter.RouteAttributeContext spds = this.router.getObjContext(GeneralRouter.RouteDataObjectAttribute.ROAD_SPEED);
            sl = Float.valueOf(spds.evaluateFloat(this.getRawBitset("route", routeType), this.defaultTravelSpeed));
            this.speed.put(routeType, sl);
        }
        return sl.floatValue();
    }

    private int getRawType(String tg, String vl) {
        String key = tg + "$" + vl;
        if (!this.rawTypes.containsKey(key)) {
            int at = this.router.registerTagValueAttribute(tg, vl);
            this.rawTypes.put(key, at);
        }
        return this.rawTypes.get(key);
    }

    private BitSet getRawBitset(String tg, String vl) {
        BitSet bs = new BitSet();
        bs.set(this.getRawType(tg, vl));
        return bs;
    }

    public TransportRoutingConfiguration(GeneralRouter prouter, Map<String, String> params) {
        if (prouter != null) {
            this.router = prouter.build((Map)params);
            this.walkRadius = this.router.getIntAttribute("walkRadius", this.walkRadius);
            this.walkChangeRadius = this.router.getIntAttribute("walkChangeRadius", this.walkChangeRadius);
            this.ZOOM_TO_LOAD_TILES = this.router.getIntAttribute("zoomToLoadTiles", this.ZOOM_TO_LOAD_TILES);
            this.maxNumberOfChanges = this.router.getIntAttribute("maxNumberOfChanges", this.maxNumberOfChanges);
            this.maxRouteTime = this.router.getIntAttribute("maxRouteTime", this.maxRouteTime);
            this.maxRouteIncreaseSpeed = this.router.getIntAttribute("maxRouteIncreaseSpeed", this.maxRouteIncreaseSpeed);
            this.maxRouteDistance = this.router.getIntAttribute("maxRouteDistance", this.maxRouteDistance);
            this.increaseForAlternativesRoutes = this.router.getFloatAttribute("increaseForAlternativesRoutes", (float)this.increaseForAlternativesRoutes);
            this.increaseForAltRoutesWalking = this.router.getFloatAttribute("increaseForAltRoutesWalking", (float)this.increaseForAltRoutesWalking);
            this.combineAltRoutesDiffStops = this.router.getIntAttribute("combineAltRoutesDiffStops", this.combineAltRoutesDiffStops);
            this.combineAltRoutesSumDiffStops = this.router.getIntAttribute("combineAltRoutesSumDiffStops", this.combineAltRoutesSumDiffStops);
            String mn = params.get("max_num_changes");
            this.maxNumberOfChanges = (int)RoutingConfiguration.parseSilentFloat(mn, this.maxNumberOfChanges);
            this.walkSpeed = this.router.getFloatAttribute("minDefaultSpeed", this.walkSpeed * 3.6f) / 3.6f;
            this.defaultTravelSpeed = this.router.getFloatAttribute("maxDefaultSpeed", this.defaultTravelSpeed * 3.6f) / 3.6f;
            GeneralRouter.RouteAttributeContext spds = this.router.getObjContext(GeneralRouter.RouteDataObjectAttribute.ROAD_SPEED);
            this.walkSpeed = spds.evaluateFloat(this.getRawBitset("route", "walk"), this.walkSpeed);
        }
    }
}

