/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template;

import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.template.AbstractTemplateFunction;
import info.bliki.wiki.template.ITemplateFunction;
import info.bliki.wiki.template.dates.StringToTime;
import info.bliki.wiki.template.dates.StringToTimeException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Time
extends AbstractTemplateFunction {
    public static final ITemplateFunction CONST = new Time();
    protected static Map<String, String> FORMAT_WIKI_TO_JAVA = new HashMap<String, String>();
    protected final SimpleDateFormat RFC822DATEFORMAT = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' '+0000", Locale.US);

    /*
     * Unable to fully structure code
     */
    @Override
    public String parseFunction(List<String> list, IWikiModel model, char[] src, int beginIndex, int endIndex, boolean isSubst) {
        if (list.size() <= 0) {
            return null;
        }
        if (list.size() > 1) {
            dateTimeParameter = isSubst != false ? list.get(1) : Time.parseTrim(list.get(1), model);
            try {
                date = new StringToTime((Object)dateTimeParameter);
            }
            catch (StringToTimeException e) {
                return "<span class=\"error\">Error: invalid time</span>";
            }
        } else {
            date = model.getCurrentTimeStamp();
        }
        condition = isSubst != false ? list.get(0) : Time.parseTrim(list.get(0), model);
        result = new StringBuilder(condition.length() * 2);
        inDoubleQuotes = false;
        cal = new GregorianCalendar(model.getLocale());
        cal.setTime(date);
        block12: for (curPos = 0; curPos < condition.length(); ++curPos) {
            curCh = condition.charAt(curPos);
            if (curPos != 0 && inDoubleQuotes && condition.charAt(curPos - 1) != '\\') ** GOTO lbl-1000
            formatCh = String.valueOf(curCh);
            if (Time.FORMAT_WIKI_TO_JAVA.containsKey(formatCh)) {
                sdf = new SimpleDateFormat(Time.FORMAT_WIKI_TO_JAVA.get(formatCh), model.getLocale());
                result.append(sdf.format(date));
                continue;
            }
            switch (curCh) {
                case 'L': {
                    if (cal.isLeapYear(cal.get(1))) {
                        result.append(1);
                        continue block12;
                    }
                    result.append(0);
                    continue block12;
                }
                case 'z': {
                    result.append(cal.get(6) - 1);
                    continue block12;
                }
                case 'N': {
                    dayOfWeek_N = cal.get(7) - 2 + 1;
                    if (dayOfWeek_N <= 0) {
                        result.append(dayOfWeek_N + 7);
                        continue block12;
                    }
                    result.append(dayOfWeek_N);
                    continue block12;
                }
                case 'w': {
                    dayOfWeek_w = cal.get(7) - 1;
                    if (dayOfWeek_w < 0) {
                        result.append(dayOfWeek_w + 7);
                        continue block12;
                    }
                    result.append(dayOfWeek_w);
                    continue block12;
                }
                case 'a': {
                    result.append(new SimpleDateFormat("a", model.getLocale()).format(date).toLowerCase());
                    continue block12;
                }
                case 'U': {
                    result.append(date.getTime() / 1000L);
                    continue block12;
                }
                case 't': {
                    result.append(cal.getActualMaximum(5));
                    continue block12;
                }
                case 'r': {
                    result.append(this.RFC822DATEFORMAT.format(date));
                    continue block12;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (curCh == '\"') {
                        inDoubleQuotes = inDoubleQuotes == false;
                    }
                    result.append(curCh);
                }
            }
        }
        return result.toString();
    }

    static {
        FORMAT_WIKI_TO_JAVA.put("Y", "yyyy");
        FORMAT_WIKI_TO_JAVA.put("y", "yy");
        FORMAT_WIKI_TO_JAVA.put("o", "yyyy");
        FORMAT_WIKI_TO_JAVA.put("n", "M");
        FORMAT_WIKI_TO_JAVA.put("m", "MM");
        FORMAT_WIKI_TO_JAVA.put("M", "MMM");
        FORMAT_WIKI_TO_JAVA.put("F", "MMMM");
        FORMAT_WIKI_TO_JAVA.put("y", "yy");
        FORMAT_WIKI_TO_JAVA.put("j", "d");
        FORMAT_WIKI_TO_JAVA.put("d", "dd");
        FORMAT_WIKI_TO_JAVA.put("D", "EEE");
        FORMAT_WIKI_TO_JAVA.put("l", "EEEE");
        FORMAT_WIKI_TO_JAVA.put("A", "a");
        FORMAT_WIKI_TO_JAVA.put("g", "h");
        FORMAT_WIKI_TO_JAVA.put("h", "hh");
        FORMAT_WIKI_TO_JAVA.put("G", "H");
        FORMAT_WIKI_TO_JAVA.put("H", "HH");
        FORMAT_WIKI_TO_JAVA.put("i", "mm");
        FORMAT_WIKI_TO_JAVA.put("s", "ss");
        FORMAT_WIKI_TO_JAVA.put("c", "yyyy-MM-dd'T'HH:mm:ss+00:00");
    }
}

