/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.model;

import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.filter.WikipediaScanner;
import java.util.List;

public class ImageFormat {
    private String fFilename;
    private String fType;
    private String fLocation = "none";
    private String fWidthStr = null;
    private int fWidth = -1;
    private String fHeightStr = null;
    private int fHeight = -1;
    private String fCaption;
    private String fAlt;
    private String fNamespace;
    private String fLink;

    public static ImageFormat getImageFormat(String rawImageLink, String imageNamespace) {
        ImageFormat img = new ImageFormat();
        List<String> list = WikipediaScanner.splitByPipe(rawImageLink, null);
        if (list.size() > 0) {
            String token = list.get(0).trim();
            img.setFilename("");
            if (token.length() > imageNamespace.length() && token.charAt(imageNamespace.length()) == ':' && imageNamespace.equalsIgnoreCase(token.substring(0, imageNamespace.length()))) {
                img.setFilename(token.substring(imageNamespace.length() + 1));
                img.setNamespace(imageNamespace);
            }
            for (int j = 1; j < list.size(); ++j) {
                String caption = list.get(j).trim();
                if (caption.length() <= 0) continue;
                token = caption.toLowerCase();
                int defIndex = token.indexOf("=");
                if (defIndex > 0) {
                    String attrValue;
                    if ((token = token.substring(0, defIndex).trim()).equals("link")) {
                        attrValue = caption.substring(defIndex + 1).trim();
                        img.setLink(attrValue);
                        continue;
                    }
                    if (token.equals("alt")) {
                        attrValue = caption.substring(defIndex + 1).trim();
                        img.setAlt(Encoder.encodeHtml(attrValue));
                        continue;
                    }
                } else {
                    if (token.equals("frame") || token.equals("thumb") || token.equals("thumbnail") || token.equals("border")) {
                        img.setType(token);
                        continue;
                    }
                    if (token.equals("right") || token.equals("left") || token.equals("center") || token.equals("none")) {
                        img.setLocation(token);
                        continue;
                    }
                    if (token.endsWith("px")) {
                        img.setSize(token);
                        continue;
                    }
                }
                img.setCaption(caption);
            }
        }
        return img;
    }

    public String getAlt() {
        return this.fAlt;
    }

    public String getCaption() {
        return this.fCaption;
    }

    public String getFilename() {
        return this.fFilename;
    }

    public String getLocation() {
        return this.fLocation;
    }

    public String getNamespace() {
        return this.fNamespace;
    }

    public String getLink() {
        return this.fLink;
    }

    public int getWidth() {
        return this.fWidth;
    }

    public String getWidthStr() {
        return this.fWidthStr;
    }

    public int getHeight() {
        return this.fHeight;
    }

    public String getHeightStr() {
        return this.fHeightStr;
    }

    public String getType() {
        return this.fType;
    }

    public void setAlt(String alt) {
        this.fAlt = alt;
    }

    public void setCaption(String caption) {
        this.fCaption = caption;
    }

    public void setFilename(String filename) {
        this.fFilename = filename;
    }

    public void setLocation(String location) {
        this.fLocation = location.toLowerCase();
    }

    public void setNamespace(String namespace) {
        this.fNamespace = namespace;
    }

    public void setLink(String link) {
        this.fLink = link;
    }

    public void setSize(String size) {
        String sizeStr = size.toLowerCase();
        if (sizeStr.endsWith("px")) {
            int indexOfX = sizeStr.indexOf("x");
            if (indexOfX >= 0 && indexOfX < sizeStr.length() - 1) {
                this.fWidthStr = sizeStr.substring(0, indexOfX) + "px";
                this.fHeightStr = sizeStr.substring(indexOfX + 1);
                try {
                    this.fHeight = Integer.parseInt(this.fHeightStr.substring(0, this.fHeightStr.length() - 2));
                    if (this.fHeight < 0) {
                        this.fHeight = -1;
                        this.fHeightStr = null;
                    }
                }
                catch (NumberFormatException e) {
                    this.fHeight = -1;
                    this.fHeightStr = null;
                }
            } else {
                this.fWidthStr = sizeStr;
                this.fHeightStr = null;
                this.fHeight = -1;
            }
            try {
                this.fWidth = Integer.parseInt(this.fWidthStr.substring(0, this.fWidthStr.length() - 2));
                if (this.fWidth < 0) {
                    this.fWidth = -1;
                    this.fWidthStr = null;
                }
            }
            catch (NumberFormatException e) {
                this.fWidth = -1;
                this.fWidthStr = null;
            }
        }
    }

    public void setType(String type) {
        this.fType = type.toLowerCase();
    }

    public void setWidth(int width) {
        this.fWidth = width;
    }
}

