/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import java.util.HashMap;
import java.util.Map;

public class Abbreviations {
    private static final Map<String, String> abbreviations = new HashMap<String, String>();

    private Abbreviations() {
    }

    public static String replace(String word) {
        String value = abbreviations.get(word.toLowerCase());
        return value != null ? value : word;
    }

    public static Map<String, String> getAbbreviations() {
        return abbreviations;
    }

    public static String replaceAll(String phrase) {
        String[] words = phrase.split(" ");
        StringBuilder r = new StringBuilder();
        boolean changed = false;
        for (String w : words) {
            String abbrRes;
            if (r.length() > 0) {
                r.append(" ");
            }
            if ((abbrRes = abbreviations.get(w.toLowerCase())) == null) {
                r.append(w);
                continue;
            }
            changed = true;
            r.append(abbrRes);
        }
        return changed ? r.toString() : phrase;
    }

    static {
        abbreviations.put("e", "East");
        abbreviations.put("w", "West");
        abbreviations.put("s", "South");
        abbreviations.put("n", "North");
        abbreviations.put("sw", "Southwest");
        abbreviations.put("se", "Southeast");
        abbreviations.put("nw", "Northwest");
        abbreviations.put("ne", "Northeast");
        abbreviations.put("ln", "Lane");
        abbreviations.put("dr", "Drive");
        abbreviations.put("rd", "Road");
        abbreviations.put("ave", "Avenue");
        abbreviations.put("st", "Street");
        abbreviations.put("blvd", "Boulevard");
    }
}

