/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.MapObject;
import net.osmand.core.jni.OsmAndCoreJNI;

public class MapObjectList {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected MapObjectList(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(MapObjectList mapObjectList) {
        return mapObjectList == null ? 0L : mapObjectList.swigCPtr;
    }

    protected static long swigRelease(MapObjectList mapObjectList) {
        long l = 0L;
        if (mapObjectList != null) {
            if (!mapObjectList.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = mapObjectList.swigCPtr;
            mapObjectList.swigCMemOwn = false;
            mapObjectList.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_MapObjectList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public MapObjectList() {
        this(OsmAndCoreJNI.new_MapObjectList(), true);
    }

    public long size() {
        return OsmAndCoreJNI.MapObjectList_size(this.swigCPtr, this);
    }

    public void reserve(long l) {
        OsmAndCoreJNI.MapObjectList_reserve(this.swigCPtr, this, l);
    }

    public boolean isEmpty() {
        return OsmAndCoreJNI.MapObjectList_isEmpty(this.swigCPtr, this);
    }

    public void clear() {
        OsmAndCoreJNI.MapObjectList_clear(this.swigCPtr, this);
    }

    public void add(MapObject mapObject) {
        OsmAndCoreJNI.MapObjectList_add(this.swigCPtr, this, MapObject.getCPtr(mapObject), mapObject);
    }

    public MapObject get(int n) {
        long l = OsmAndCoreJNI.MapObjectList_get(this.swigCPtr, this, n);
        return l == 0L ? null : new MapObject(l, true);
    }

    public void set(int n, MapObject mapObject) {
        OsmAndCoreJNI.MapObjectList_set(this.swigCPtr, this, n, MapObject.getCPtr(mapObject), mapObject);
    }
}

