/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import java.util.ArrayList;
import java.util.List;
import jogamp.opengl.Debug;

public abstract class GLDrawableFactory {
    protected static final boolean DEBUG = Debug.debug("GLDrawable");
    private static volatile boolean isInit = false;
    private static GLDrawableFactory eglFactory;
    private static GLDrawableFactory nativeOSFactory;
    private static ArrayList<GLDrawableFactory> glDrawableFactories;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void initSingleton() {
        if (isInit) return;
        Class<GLDrawableFactory> clazz = GLDrawableFactory.class;
        synchronized (GLDrawableFactory.class) {
            if (isInit) return;
            isInit = true;
            GLDrawableFactory.initSingletonImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static final void initSingletonImpl() {
        ClassLoader classLoader;
        GLDrawableFactory gLDrawableFactory;
        block19: {
            NativeWindowFactory.initSingleton();
            NativeWindowFactory.addCustomShutdownHook(false, new Runnable(){

                @Override
                public void run() {
                    GLDrawableFactory.shutdown0();
                }
            });
            String string = NativeWindowFactory.getNativeWindowType(true);
            gLDrawableFactory = null;
            String string2 = PropertyAccess.getProperty((String)"jogl.gldrawablefactory.class.name", (boolean)true);
            classLoader = GLDrawableFactory.class.getClassLoader();
            if (null == string2) {
                if (string == NativeWindowFactory.TYPE_X11) {
                    string2 = "jogamp.opengl.x11.glx.X11GLXDrawableFactory";
                } else if (string == NativeWindowFactory.TYPE_WINDOWS) {
                    string2 = "jogamp.opengl.windows.wgl.WindowsWGLDrawableFactory";
                } else if (string == NativeWindowFactory.TYPE_MACOSX) {
                    string2 = "jogamp.opengl.macosx.cgl.MacOSXCGLDrawableFactory";
                } else if (DEBUG || GLProfile.DEBUG) {
                    System.err.println("GLDrawableFactory.static - No native Windowing Factory for: " + string + "; May use EGLDrawableFactory, if available.");
                }
            }
            if (null != string2 && !GLProfile.disableOpenGLDesktop) {
                if (DEBUG || GLProfile.DEBUG) {
                    System.err.println("GLDrawableFactory.static - Native OS Factory for: " + string + ": " + string2);
                }
                try {
                    gLDrawableFactory = (GLDrawableFactory)ReflectionUtil.createInstance((String)string2, (ClassLoader)classLoader);
                }
                catch (Exception exception) {
                    if (!DEBUG && !GLProfile.DEBUG) break block19;
                    System.err.println("Info: GLDrawableFactory.static - Native Platform: " + string + " - not available: " + string2);
                    exception.printStackTrace();
                }
            }
        }
        if (null != gLDrawableFactory && gLDrawableFactory.isComplete()) {
            nativeOSFactory = gLDrawableFactory;
        }
        gLDrawableFactory = null;
        if (!GLProfile.disableOpenGLES) {
            block20: {
                try {
                    gLDrawableFactory = (GLDrawableFactory)ReflectionUtil.createInstance((String)"jogamp.opengl.egl.EGLDrawableFactory", (ClassLoader)classLoader);
                }
                catch (Exception exception) {
                    if (!DEBUG && !GLProfile.DEBUG) break block20;
                    System.err.println("Info: GLDrawableFactory.static - EGLDrawableFactory - not available");
                    exception.printStackTrace();
                }
            }
            if (null != gLDrawableFactory && gLDrawableFactory.isComplete()) {
                eglFactory = gLDrawableFactory;
            }
        } else if (DEBUG || GLProfile.DEBUG) {
            System.err.println("Info: GLDrawableFactory.static - EGLDrawableFactory - disabled!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void shutdown() {
        if (!isInit) return;
        Class<GLDrawableFactory> clazz = GLDrawableFactory.class;
        synchronized (GLDrawableFactory.class) {
            if (!isInit) return;
            isInit = false;
            GLDrawableFactory.shutdown0();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdown0() {
        ArrayList<GLDrawableFactory> arrayList = glDrawableFactories;
        synchronized (arrayList) {
            int n = glDrawableFactories.size();
            if (DEBUG) {
                System.err.println("GLDrawableFactory.shutdownAll " + n + " instances, on thread " + GLDrawableFactory.getThreadName());
            }
            for (int i = 0; i < n; ++i) {
                GLDrawableFactory gLDrawableFactory = glDrawableFactories.get(i);
                if (DEBUG) {
                    System.err.println("GLDrawableFactory.shutdownAll[" + (i + 1) + "/" + n + "]:  " + gLDrawableFactory.getClass().getName());
                }
                try {
                    gLDrawableFactory.resetAllDisplayGammaNoSync();
                    gLDrawableFactory.shutdownImpl();
                    continue;
                }
                catch (Throwable throwable) {
                    System.err.println("GLDrawableFactory.shutdownImpl: Caught " + throwable.getClass().getName() + " during factory shutdown #" + (i + 1) + "/" + n + " " + gLDrawableFactory.getClass().getName());
                    if (!DEBUG) continue;
                    throwable.printStackTrace();
                }
            }
            glDrawableFactories.clear();
            nativeOSFactory = null;
            eglFactory = null;
        }
        GLContext.shutdown();
        if (DEBUG) {
            System.err.println("GLDrawableFactory.shutdownAll.X on thread " + GLDrawableFactory.getThreadName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GLDrawableFactory() {
        ArrayList<GLDrawableFactory> arrayList = glDrawableFactories;
        synchronized (arrayList) {
            glDrawableFactories.add(this);
        }
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    protected abstract boolean isComplete();

    protected void enterThreadCriticalZone() {
    }

    protected void leaveThreadCriticalZone() {
    }

    protected abstract void shutdownImpl();

    public abstract boolean setDisplayGamma(NativeSurface var1, float var2, float var3, float var4) throws IllegalArgumentException;

    public abstract void resetDisplayGamma(NativeSurface var1);

    public abstract void resetAllDisplayGamma();

    protected abstract void resetAllDisplayGammaNoSync();

    public abstract AbstractGraphicsDevice getDefaultDevice();

    public abstract boolean getIsDeviceCompatible(AbstractGraphicsDevice var1);

    protected final AbstractGraphicsDevice validateDevice(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = this.getDefaultDevice();
            if (null == abstractGraphicsDevice) {
                throw new InternalError("no default device available");
            }
            if (GLProfile.DEBUG) {
                System.err.println("Info: " + this.getClass().getSimpleName() + ".validateDevice: using default device : " + abstractGraphicsDevice);
            }
        }
        if (!this.getIsDeviceCompatible(abstractGraphicsDevice)) {
            if (GLProfile.DEBUG) {
                System.err.println("Info: " + this.getClass().getSimpleName() + ".validateDevice: device not compatible : " + abstractGraphicsDevice);
            }
            return null;
        }
        return abstractGraphicsDevice;
    }

    protected abstract Thread getSharedResourceThread();

    protected final boolean createSharedResource(AbstractGraphicsDevice abstractGraphicsDevice) {
        return this.createSharedResourceImpl(abstractGraphicsDevice);
    }

    protected abstract boolean createSharedResourceImpl(AbstractGraphicsDevice var1);

    public final boolean hasRendererQuirk(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile, int n) {
        GLRendererQuirks gLRendererQuirks = this.getRendererQuirks(abstractGraphicsDevice, gLProfile);
        return null != gLRendererQuirks ? gLRendererQuirks.exist(n) : false;
    }

    public abstract GLRendererQuirks getRendererQuirks(AbstractGraphicsDevice var1, GLProfile var2);

    public static GLDrawableFactory getDesktopFactory() {
        GLProfile.initSingleton();
        return nativeOSFactory;
    }

    public static GLDrawableFactory getEGLFactory() {
        GLProfile.initSingleton();
        return eglFactory;
    }

    public static GLDrawableFactory getFactory(GLProfile gLProfile) throws GLException {
        return GLDrawableFactory.getFactoryImpl(gLProfile.getImplName());
    }

    protected static GLDrawableFactory getFactoryImpl(String string) throws GLException {
        if (GLProfile.usesNativeGLES(string)) {
            if (null != eglFactory) {
                return eglFactory;
            }
        } else if (null != nativeOSFactory) {
            return nativeOSFactory;
        }
        throw new GLException("No GLDrawableFactory available for profile: " + string);
    }

    protected static GLDrawableFactory getFactoryImpl(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        if (null != nativeOSFactory && nativeOSFactory.getIsDeviceCompatible(abstractGraphicsDevice)) {
            return nativeOSFactory;
        }
        if (null != eglFactory && eglFactory.getIsDeviceCompatible(abstractGraphicsDevice)) {
            return eglFactory;
        }
        throw new GLException("No native platform GLDrawableFactory, nor EGLDrawableFactory available: " + abstractGraphicsDevice);
    }

    public final List<GLCapabilitiesImmutable> getAvailableCapabilities(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null != (abstractGraphicsDevice = this.validateDevice(abstractGraphicsDevice))) {
            return this.getAvailableCapabilitiesImpl(abstractGraphicsDevice);
        }
        return null;
    }

    protected abstract List<GLCapabilitiesImmutable> getAvailableCapabilitiesImpl(AbstractGraphicsDevice var1);

    public abstract GLDrawable createGLDrawable(NativeSurface var1) throws IllegalArgumentException, GLException;

    public abstract GLOffscreenAutoDrawable createOffscreenAutoDrawable(AbstractGraphicsDevice var1, GLCapabilitiesImmutable var2, GLCapabilitiesChooser var3, int var4, int var5) throws GLException;

    public abstract GLAutoDrawable createDummyAutoDrawable(AbstractGraphicsDevice var1, boolean var2, GLCapabilitiesImmutable var3, GLCapabilitiesChooser var4);

    public abstract GLDrawable createOffscreenDrawable(AbstractGraphicsDevice var1, GLCapabilitiesImmutable var2, GLCapabilitiesChooser var3, int var4, int var5) throws GLException;

    public abstract GLDrawable createDummyDrawable(AbstractGraphicsDevice var1, boolean var2, GLCapabilitiesImmutable var3, GLCapabilitiesChooser var4);

    public abstract ProxySurface createProxySurface(AbstractGraphicsDevice var1, int var2, long var3, GLCapabilitiesImmutable var5, GLCapabilitiesChooser var6, UpstreamSurfaceHook var7);

    public abstract boolean canCreateFBO(AbstractGraphicsDevice var1, GLProfile var2);

    public abstract boolean canCreateGLPbuffer(AbstractGraphicsDevice var1, GLProfile var2);

    public abstract GLContext createExternalGLContext() throws GLException;

    public abstract boolean canCreateExternalGLDrawable(AbstractGraphicsDevice var1);

    public abstract GLDrawable createExternalGLDrawable() throws GLException;

    static {
        glDrawableFactories = new ArrayList();
    }
}

