/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.compile;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ProgressLog {
    private static int indent = 0;
    private static boolean atEOL = false;
    private static DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    private static Map<Integer, Long> startTimes = new HashMap<Integer, Long>();

    public static void begin(String message) {
        ProgressLog.newLine();
        System.out.print(ProgressLog.leader() + message + "... ");
        System.out.flush();
        atEOL = true;
        startTimes.put(++indent, System.currentTimeMillis());
    }

    public static void end() {
        ProgressLog.newLine();
        Long start = startTimes.get(indent);
        indent = Math.max(0, indent - 1);
        System.out.println(ProgressLog.leader() + "done" + (start != null ? " [" + (System.currentTimeMillis() - start) / 1000L + "s]" : ""));
        System.out.flush();
    }

    public static void println(String message) {
        ProgressLog.newLine();
        System.out.println(ProgressLog.leader() + message);
        System.out.flush();
    }

    private static void newLine() {
        if (atEOL) {
            System.out.println();
        }
        atEOL = false;
    }

    private static String leader() {
        return "[KUROMOJI] " + dateFormat.format(new Date()) + ": " + new String(new char[indent * 4]).replace("\u0000", " ");
    }
}

