/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.FColorARGB;
import net.osmand.core.jni.GridParameters;
import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.ZoomLevel;

public class GridConfiguration {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected GridConfiguration(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(GridConfiguration gridConfiguration) {
        return gridConfiguration == null ? 0L : gridConfiguration.swigCPtr;
    }

    protected static long swigRelease(GridConfiguration gridConfiguration) {
        long l = 0L;
        if (gridConfiguration != null) {
            if (!gridConfiguration.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = gridConfiguration.swigCPtr;
            gridConfiguration.swigCMemOwn = false;
            gridConfiguration.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_GridConfiguration(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public GridConfiguration() {
        this(OsmAndCoreJNI.new_GridConfiguration(), true);
    }

    public void setPrimaryGrid(boolean bl) {
        OsmAndCoreJNI.GridConfiguration_primaryGrid_set(this.swigCPtr, this, bl);
    }

    public boolean getPrimaryGrid() {
        return OsmAndCoreJNI.GridConfiguration_primaryGrid_get(this.swigCPtr, this);
    }

    public void setSecondaryGrid(boolean bl) {
        OsmAndCoreJNI.GridConfiguration_secondaryGrid_set(this.swigCPtr, this, bl);
    }

    public boolean getSecondaryGrid() {
        return OsmAndCoreJNI.GridConfiguration_secondaryGrid_get(this.swigCPtr, this);
    }

    public void setPrimaryProjection(Projection projection) {
        OsmAndCoreJNI.GridConfiguration_primaryProjection_set(this.swigCPtr, this, projection.swigValue());
    }

    public Projection getPrimaryProjection() {
        return Projection.swigToEnum(OsmAndCoreJNI.GridConfiguration_primaryProjection_get(this.swigCPtr, this));
    }

    public void setSecondaryProjection(Projection projection) {
        OsmAndCoreJNI.GridConfiguration_secondaryProjection_set(this.swigCPtr, this, projection.swigValue());
    }

    public Projection getSecondaryProjection() {
        return Projection.swigToEnum(OsmAndCoreJNI.GridConfiguration_secondaryProjection_get(this.swigCPtr, this));
    }

    public void setPrimaryGap(float f) {
        OsmAndCoreJNI.GridConfiguration_primaryGap_set(this.swigCPtr, this, f);
    }

    public float getPrimaryGap() {
        return OsmAndCoreJNI.GridConfiguration_primaryGap_get(this.swigCPtr, this);
    }

    public void setSecondaryGap(float f) {
        OsmAndCoreJNI.GridConfiguration_secondaryGap_set(this.swigCPtr, this, f);
    }

    public float getSecondaryGap() {
        return OsmAndCoreJNI.GridConfiguration_secondaryGap_get(this.swigCPtr, this);
    }

    public void setPrimaryGranularity(float f) {
        OsmAndCoreJNI.GridConfiguration_primaryGranularity_set(this.swigCPtr, this, f);
    }

    public float getPrimaryGranularity() {
        return OsmAndCoreJNI.GridConfiguration_primaryGranularity_get(this.swigCPtr, this);
    }

    public void setSecondaryGranularity(float f) {
        OsmAndCoreJNI.GridConfiguration_secondaryGranularity_set(this.swigCPtr, this, f);
    }

    public float getSecondaryGranularity() {
        return OsmAndCoreJNI.GridConfiguration_secondaryGranularity_get(this.swigCPtr, this);
    }

    public void setPrimaryThickness(float f) {
        OsmAndCoreJNI.GridConfiguration_primaryThickness_set(this.swigCPtr, this, f);
    }

    public float getPrimaryThickness() {
        return OsmAndCoreJNI.GridConfiguration_primaryThickness_get(this.swigCPtr, this);
    }

    public void setSecondaryThickness(float f) {
        OsmAndCoreJNI.GridConfiguration_secondaryThickness_set(this.swigCPtr, this, f);
    }

    public float getSecondaryThickness() {
        return OsmAndCoreJNI.GridConfiguration_secondaryThickness_get(this.swigCPtr, this);
    }

    public void setPrimaryFormat(Format format) {
        OsmAndCoreJNI.GridConfiguration_primaryFormat_set(this.swigCPtr, this, format.swigValue());
    }

    public Format getPrimaryFormat() {
        return Format.swigToEnum(OsmAndCoreJNI.GridConfiguration_primaryFormat_get(this.swigCPtr, this));
    }

    public void setSecondaryFormat(Format format) {
        OsmAndCoreJNI.GridConfiguration_secondaryFormat_set(this.swigCPtr, this, format.swigValue());
    }

    public Format getSecondaryFormat() {
        return Format.swigToEnum(OsmAndCoreJNI.GridConfiguration_secondaryFormat_get(this.swigCPtr, this));
    }

    public void setPrimaryTopMarginFactor(float f) {
        OsmAndCoreJNI.GridConfiguration_primaryTopMarginFactor_set(this.swigCPtr, this, f);
    }

    public float getPrimaryTopMarginFactor() {
        return OsmAndCoreJNI.GridConfiguration_primaryTopMarginFactor_get(this.swigCPtr, this);
    }

    public void setSecondaryTopMarginFactor(float f) {
        OsmAndCoreJNI.GridConfiguration_secondaryTopMarginFactor_set(this.swigCPtr, this, f);
    }

    public float getSecondaryTopMarginFactor() {
        return OsmAndCoreJNI.GridConfiguration_secondaryTopMarginFactor_get(this.swigCPtr, this);
    }

    public void setPrimaryBottomMarginFactor(float f) {
        OsmAndCoreJNI.GridConfiguration_primaryBottomMarginFactor_set(this.swigCPtr, this, f);
    }

    public float getPrimaryBottomMarginFactor() {
        return OsmAndCoreJNI.GridConfiguration_primaryBottomMarginFactor_get(this.swigCPtr, this);
    }

    public void setSecondaryBottomMarginFactor(float f) {
        OsmAndCoreJNI.GridConfiguration_secondaryBottomMarginFactor_set(this.swigCPtr, this, f);
    }

    public float getSecondaryBottomMarginFactor() {
        return OsmAndCoreJNI.GridConfiguration_secondaryBottomMarginFactor_get(this.swigCPtr, this);
    }

    public void setPrimaryColor(FColorARGB fColorARGB) {
        OsmAndCoreJNI.GridConfiguration_primaryColor_set(this.swigCPtr, this, FColorARGB.getCPtr(fColorARGB), fColorARGB);
    }

    public FColorARGB getPrimaryColor() {
        long l = OsmAndCoreJNI.GridConfiguration_primaryColor_get(this.swigCPtr, this);
        return l == 0L ? null : new FColorARGB(l, false);
    }

    public void setSecondaryColor(FColorARGB fColorARGB) {
        OsmAndCoreJNI.GridConfiguration_secondaryColor_set(this.swigCPtr, this, FColorARGB.getCPtr(fColorARGB), fColorARGB);
    }

    public FColorARGB getSecondaryColor() {
        long l = OsmAndCoreJNI.GridConfiguration_secondaryColor_get(this.swigCPtr, this);
        return l == 0L ? null : new FColorARGB(l, false);
    }

    public void setPrimaryMinZoomLevel(ZoomLevel zoomLevel) {
        OsmAndCoreJNI.GridConfiguration_primaryMinZoomLevel_set(this.swigCPtr, this, zoomLevel.swigValue());
    }

    public ZoomLevel getPrimaryMinZoomLevel() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.GridConfiguration_primaryMinZoomLevel_get(this.swigCPtr, this));
    }

    public void setSecondaryMinZoomLevel(ZoomLevel zoomLevel) {
        OsmAndCoreJNI.GridConfiguration_secondaryMinZoomLevel_set(this.swigCPtr, this, zoomLevel.swigValue());
    }

    public ZoomLevel getSecondaryMinZoomLevel() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.GridConfiguration_secondaryMinZoomLevel_get(this.swigCPtr, this));
    }

    public void setPrimaryMaxZoomLevel(ZoomLevel zoomLevel) {
        OsmAndCoreJNI.GridConfiguration_primaryMaxZoomLevel_set(this.swigCPtr, this, zoomLevel.swigValue());
    }

    public ZoomLevel getPrimaryMaxZoomLevel() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.GridConfiguration_primaryMaxZoomLevel_get(this.swigCPtr, this));
    }

    public void setSecondaryMaxZoomLevel(ZoomLevel zoomLevel) {
        OsmAndCoreJNI.GridConfiguration_secondaryMaxZoomLevel_set(this.swigCPtr, this, zoomLevel.swigValue());
    }

    public ZoomLevel getSecondaryMaxZoomLevel() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.GridConfiguration_secondaryMaxZoomLevel_get(this.swigCPtr, this));
    }

    public void setGridParameters(GridParameters gridParameters) {
        OsmAndCoreJNI.GridConfiguration_gridParameters_set(this.swigCPtr, this, GridParameters.getCPtr(gridParameters), gridParameters);
    }

    public GridParameters getGridParameters() {
        long l = OsmAndCoreJNI.GridConfiguration_gridParameters_get(this.swigCPtr, this);
        return l == 0L ? null : new GridParameters(l, false);
    }

    public GridConfiguration setProjectionParameters() {
        return new GridConfiguration(OsmAndCoreJNI.GridConfiguration_setProjectionParameters(this.swigCPtr, this), false);
    }

    public boolean isValid() {
        return OsmAndCoreJNI.GridConfiguration_isValid(this.swigCPtr, this);
    }

    public boolean equals(GridConfiguration gridConfiguration) {
        return OsmAndCoreJNI.GridConfiguration_equals(this.swigCPtr, this, GridConfiguration.getCPtr(gridConfiguration), gridConfiguration);
    }

    public boolean notEquals(GridConfiguration gridConfiguration) {
        return OsmAndCoreJNI.GridConfiguration_notEquals(this.swigCPtr, this, GridConfiguration.getCPtr(gridConfiguration), gridConfiguration);
    }

    public static enum Projection {
        WGS84(OsmAndCoreJNI.GridConfiguration_Projection_WGS84_get()),
        UTM(OsmAndCoreJNI.GridConfiguration_Projection_UTM_get()),
        MGRS(OsmAndCoreJNI.GridConfiguration_Projection_MGRS_get()),
        Mercator(OsmAndCoreJNI.GridConfiguration_Projection_Mercator_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Projection swigToEnum(int n) {
            Projection[] projectionArray = (Projection[])Projection.class.getEnumConstants();
            if (n < projectionArray.length && n >= 0 && projectionArray[n].swigValue == n) {
                return projectionArray[n];
            }
            for (Projection projection : projectionArray) {
                if (projection.swigValue != n) continue;
                return projection;
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(Projection.class) + " with value " + n);
        }

        private Projection() {
            this.swigValue = SwigNext.next++;
        }

        private Projection(int n2) {
            this.swigValue = n2;
            SwigNext.next = n2 + 1;
        }

        private Projection(Projection projection) {
            this.swigValue = projection.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum Format {
        Decimal(OsmAndCoreJNI.GridConfiguration_Format_Decimal_get()),
        DMS(OsmAndCoreJNI.GridConfiguration_Format_DMS_get()),
        DM(OsmAndCoreJNI.GridConfiguration_Format_DM_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Format swigToEnum(int n) {
            Format[] formatArray = (Format[])Format.class.getEnumConstants();
            if (n < formatArray.length && n >= 0 && formatArray[n].swigValue == n) {
                return formatArray[n];
            }
            for (Format format : formatArray) {
                if (format.swigValue != n) continue;
                return format;
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(Format.class) + " with value " + n);
        }

        private Format() {
            this.swigValue = SwigNext.next++;
        }

        private Format(int n2) {
            this.swigValue = n2;
            SwigNext.next = n2 + 1;
        }

        private Format(Format format) {
            this.swigValue = format.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

