/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bJN\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b0\n2\u0006\u0010\u0006\u001a\u00020\u00052\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\rJ6\u0010\u000f\u001a\u00020\u00052\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\r2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002\u00a8\u0006\u0014"}, d2={"Lnet/osmand/shared/util/DbUtils;", "", "<init>", "()V", "createDbInsertQuery", "", "tableName", "rowKeys", "", "createDbUpdateQuery", "Lkotlin/Pair;", "", "columnsToUpdate", "", "columnsToSearch", "getRowsQuery", "map", "values", "", "separator", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nDbUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbUtils.kt\nnet/osmand/shared/util/DbUtils\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,54:1\n37#2,2:55\n*S KotlinDebug\n*F\n+ 1 DbUtils.kt\nnet/osmand/shared/util/DbUtils\n*L\n33#1:55,2\n*E\n"})
public final class DbUtils {
    @NotNull
    public static final DbUtils INSTANCE = new DbUtils();

    private DbUtils() {
    }

    @NotNull
    public final String createDbInsertQuery(@NotNull String tableName, @NotNull Set<String> rowKeys) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter(rowKeys, (String)"rowKeys");
        StringBuilder keys = new StringBuilder();
        StringBuilder values = new StringBuilder();
        String split = ", ";
        Iterator<String> iterator = rowKeys.iterator();
        while (iterator.hasNext()) {
            keys.append(iterator.next());
            values.append("?");
            if (!iterator.hasNext()) continue;
            keys.append(split);
            values.append(split);
        }
        return "INSERT INTO " + tableName + " (" + keys + ") VALUES (" + values + ")";
    }

    @NotNull
    public final Pair<String, Object[]> createDbUpdateQuery(@NotNull String tableName, @NotNull Map<String, ? extends Object> columnsToUpdate, @NotNull Map<String, ? extends Object> columnsToSearch) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter(columnsToUpdate, (String)"columnsToUpdate");
        Intrinsics.checkNotNullParameter(columnsToSearch, (String)"columnsToSearch");
        List values = new ArrayList();
        String updateQuery = this.getRowsQuery(columnsToUpdate, values, ", ");
        String whereQuery = this.getRowsQuery(columnsToSearch, values, " AND ");
        String query = "UPDATE " + tableName + " SET " + updateQuery + " WHERE " + whereQuery;
        Collection $this$toTypedArray$iv = values;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new Pair((Object)query, (Object)thisCollection$iv.toArray(new Object[0]));
    }

    private final String getRowsQuery(Map<String, ? extends Object> map, List<Object> values, String separator) {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, ? extends Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Object> entry = iterator.next();
            builder.append(entry.getKey());
            builder.append(" = ?");
            if (iterator.hasNext()) {
                builder.append(separator);
            }
            values.add(entry.getValue());
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

