/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.bcm.vc.iv;

import com.jogamp.common.util.IntBitfield;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.nativewindow.util.Insets;
import com.jogamp.nativewindow.util.Point;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.ScreenImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.bcm.vc.iv.DisplayDriver;
import jogamp.newt.driver.bcm.vc.iv.ScreenDriver;
import jogamp.newt.driver.linux.LinuxEventDeviceTracker;
import jogamp.newt.driver.linux.LinuxMouseTracker;
import jogamp.opengl.egl.EGLDisplayUtil;

public class WindowDriver
extends WindowImpl {
    private static final String WINDOW_CLASS_NAME = "NewtWindow";
    private final LinuxMouseTracker linuxMouseTracker = LinuxMouseTracker.getSingleton();
    private final LinuxEventDeviceTracker linuxEventDeviceTracker = LinuxEventDeviceTracker.getSingleton();
    private int layer = -1;
    private long nativeWindowHandle = 0L;
    private long windowHandleClose = 0L;
    private static int nextLayer;
    private static int layerCount;
    private static final int MAX_LAYERS = 32;
    private static final IntBitfield usedLayers;
    private static final Object layerSync;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createNativeImpl() {
        if (0L != this.getParentWindowHandle()) {
            throw new RuntimeException("Window parenting not supported (yet)");
        }
        Object object = layerSync;
        synchronized (object) {
            if (layerCount >= 32) {
                throw new RuntimeException("Max windows reached: " + layerCount + " ( " + 32 + " )");
            }
            for (int i = 0; 0 > this.layer && i < 32; ++i) {
                if (!usedLayers.get(nextLayer)) {
                    this.layer = nextLayer;
                    usedLayers.put(this.layer, true);
                    ++layerCount;
                }
                if (32 != ++nextLayer) continue;
                nextLayer = 0;
            }
        }
        if (0 > this.layer) {
            throw new InternalError("Could not find a free layer: count " + layerCount + ", max " + 32);
        }
        object = (ScreenDriver)this.getScreen();
        DisplayDriver displayDriver = (DisplayDriver)((ScreenImpl)object).getDisplay();
        AbstractGraphicsScreen abstractGraphicsScreen = ((ScreenImpl)object).getGraphicsScreen();
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsScreen.getDevice();
        EGLGraphicsDevice eGLGraphicsDevice2 = EGLDisplayUtil.eglCreateEGLGraphicsDevice(eGLGraphicsDevice.getNativeDisplayID(), eGLGraphicsDevice.getConnection(), eGLGraphicsDevice.getUnitID());
        eGLGraphicsDevice2.open();
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(eGLGraphicsDevice2, abstractGraphicsScreen.getIndex());
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = GraphicsConfigurationFactory.getFactory(this.getScreen().getDisplay().getGraphicsDevice(), this.capsRequested).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, defaultGraphicsScreen, 0);
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        Capabilities capabilities = (Capabilities)abstractGraphicsConfiguration.getChosenCapabilities();
        if (this.capsRequested.isBackgroundOpaque() != capabilities.isBackgroundOpaque()) {
            capabilities.setBackgroundOpaque(this.capsRequested.isBackgroundOpaque());
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        this.nativeWindowHandle = this.CreateWindow0(displayDriver.getBCMHandle(), this.layer, this.getX(), this.getY(), this.getWidth(), this.getHeight(), capabilities.isBackgroundOpaque(), capabilities.getAlphaBits());
        if (this.nativeWindowHandle == 0L) {
            throw new NativeWindowException("Error creating egl window: " + abstractGraphicsConfiguration);
        }
        this.setWindowHandle(this.nativeWindowHandle);
        if (0L == this.getWindowHandle()) {
            throw new NativeWindowException("Error native Window Handle is null");
        }
        this.windowHandleClose = this.nativeWindowHandle;
        this.addWindowListener(this.linuxEventDeviceTracker);
        this.addWindowListener(this.linuxMouseTracker);
        this.focusChanged(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNativeImpl() {
        DisplayDriver displayDriver = (DisplayDriver)this.getScreen().getDisplay();
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)this.getGraphicsConfiguration().getScreen().getDevice();
        this.removeWindowListener(this.linuxMouseTracker);
        this.removeWindowListener(this.linuxEventDeviceTracker);
        if (0L != this.windowHandleClose) {
            this.CloseWindow0(displayDriver.getBCMHandle(), this.windowHandleClose);
        }
        eGLGraphicsDevice.close();
        Object object = layerSync;
        synchronized (object) {
            usedLayers.put(this.layer, false);
            --layerCount;
            this.layer = -1;
        }
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
        this.focusChanged(false, true);
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        this.reconfigure0(this.nativeWindowHandle, n, n2, n3, n4, n5);
        return true;
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        return new Point(n, n2);
    }

    @Override
    protected void updateInsetsImpl(Insets insets) {
    }

    @Override
    protected final void doMouseEvent(boolean bl, boolean bl2, short s, int n, int n2, int n3, short s2, float[] fArray, float f) {
        if (205 == s) {
            DisplayDriver displayDriver = (DisplayDriver)this.getScreen().getDisplay();
            displayDriver.moveActivePointerIcon(n2, n3);
        }
        super.doMouseEvent(bl, bl2, s, n, n2, n3, s2, fArray, f);
    }

    @Override
    protected void setPointerIconImpl(PointerIconImpl pointerIconImpl) {
        DisplayDriver displayDriver = (DisplayDriver)this.getScreen().getDisplay();
        displayDriver.setPointerIconActive(null != pointerIconImpl ? pointerIconImpl.validatedHandle() : 0L, this.linuxMouseTracker.getLastX(), this.linuxMouseTracker.getLastY());
    }

    @Override
    protected boolean setPointerVisibleImpl(boolean bl) {
        DisplayDriver displayDriver = (DisplayDriver)this.getScreen().getDisplay();
        displayDriver.setActivePointerIconVisible(bl, this.linuxMouseTracker.getLastX(), this.linuxMouseTracker.getLastY());
        return true;
    }

    protected static native boolean initIDs();

    private native long CreateWindow0(long var1, int var3, int var4, int var5, int var6, int var7, boolean var8, int var9);

    private native void CloseWindow0(long var1, long var3);

    private native void reconfigure0(long var1, int var3, int var4, int var5, int var6, int var7);

    static {
        DisplayDriver.initSingleton();
        nextLayer = 0;
        layerCount = 0;
        usedLayers = new IntBitfield(32);
        layerSync = new Object();
    }
}

