/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.htmlcleaner;

import info.bliki.htmlcleaner.BaseToken;
import info.bliki.htmlcleaner.Utils;
import info.bliki.htmlcleaner.XmlSerializer;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.PlainTextConvertable;
import info.bliki.wiki.model.IWikiModel;
import java.io.IOException;

public class ContentToken
implements BaseToken,
PlainTextConvertable {
    private final String content;

    public ContentToken(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public String toString() {
        return this.content.trim();
    }

    @Override
    public void serialize(XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.getWriter().write(this.getContent());
    }

    @Override
    public void renderPlainText(ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        if (this.content.length() > 0) {
            Utils.escapeXmlToBuffer(this.content, buf, false, true, true, true);
        }
    }
}

