/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.internal.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xwiki.logging.internal.helpers.MessageParser;

public final class ExtendedMessageFormatter {
    private ExtendedMessageFormatter() {
    }

    public static List<String> parseMessage(String messagePattern, Object[] arguments) {
        if (messagePattern == null) {
            return null;
        }
        if (arguments == null || arguments.length == 0) {
            return Arrays.asList(messagePattern);
        }
        ArrayList<String> messageList = new ArrayList<String>(arguments.length + 1);
        MessageParser parser = new MessageParser(messagePattern, false);
        StringBuilder lastElement = new StringBuilder();
        MessageParser.MessageElement element = parser.next();
        MessageParser.MessageElement previous = null;
        while (element != null) {
            if (arguments.length < messageList.size()) {
                lastElement.append(element.getString());
            } else if (element instanceof MessageParser.MessageString) {
                messageList.add(element.getString());
            } else if (!(previous instanceof MessageParser.MessageString)) {
                messageList.add("");
            }
            previous = element;
            element = parser.next();
        }
        if (lastElement.length() > 0 || parser.getCurrentMessageElement() instanceof MessageParser.MessageIndex) {
            messageList.add(lastElement.toString());
        }
        return messageList;
    }
}

