/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.SWIGTYPE_p_Animator__AnimatedValue;
import net.osmand.core.jni.SWIGTYPE_p_Animator__Key;
import net.osmand.core.jni.SWIGTYPE_p_Animator__TimingFunction;

public class GenericAnimation {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected GenericAnimation(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(GenericAnimation genericAnimation) {
        return genericAnimation == null ? 0L : genericAnimation.swigCPtr;
    }

    protected static long swigRelease(GenericAnimation genericAnimation) {
        long l = 0L;
        if (genericAnimation != null) {
            if (!genericAnimation.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = genericAnimation.swigCPtr;
            genericAnimation.swigCMemOwn = false;
            genericAnimation.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_GenericAnimation(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public boolean process(float f) {
        return OsmAndCoreJNI.GenericAnimation_process(this.swigCPtr, this, f);
    }

    public SWIGTYPE_p_Animator__Key getKey() {
        return new SWIGTYPE_p_Animator__Key(OsmAndCoreJNI.GenericAnimation_getKey(this.swigCPtr, this), true);
    }

    public SWIGTYPE_p_Animator__AnimatedValue getAnimatedValue() {
        return new SWIGTYPE_p_Animator__AnimatedValue(OsmAndCoreJNI.GenericAnimation_getAnimatedValue(this.swigCPtr, this), true);
    }

    public float getTimePassed() {
        return OsmAndCoreJNI.GenericAnimation_getTimePassed(this.swigCPtr, this);
    }

    public float getDelay() {
        return OsmAndCoreJNI.GenericAnimation_getDelay(this.swigCPtr, this);
    }

    public float getDuration() {
        return OsmAndCoreJNI.GenericAnimation_getDuration(this.swigCPtr, this);
    }

    public SWIGTYPE_p_Animator__TimingFunction getTimingFunction() {
        return new SWIGTYPE_p_Animator__TimingFunction(OsmAndCoreJNI.GenericAnimation_getTimingFunction(this.swigCPtr, this), true);
    }

    public void pause() {
        OsmAndCoreJNI.GenericAnimation_pause(this.swigCPtr, this);
    }

    public void resume() {
        OsmAndCoreJNI.GenericAnimation_resume(this.swigCPtr, this);
    }

    public boolean isPaused() {
        return OsmAndCoreJNI.GenericAnimation_isPaused(this.swigCPtr, this);
    }

    public boolean isPlaying() {
        return OsmAndCoreJNI.GenericAnimation_isPlaying(this.swigCPtr, this);
    }
}

