/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osmand.binary.RouteDataObject;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.RelationTagsPropagation;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapRoutingTypes {
    protected static final Log log = LogFactory.getLog(MapRoutingTypes.class);
    private static final char TAG_DELIMETER = '/';
    private Set<String> TAGS_TO_SAVE = new HashSet<String>();
    private Set<String> TAGS_TO_ACCEPT = new HashSet<String>();
    private Map<String, String> TAGS_TO_REPLACE = new HashMap<String, String>();
    private Map<String, String> TAGS_TYPE = new HashMap<String, String>();
    private Set<String> TAGS_TEXT = new HashSet<String>();
    private Set<String> BASE_TAGS_TEXT = new HashSet<String>();
    private Set<String> BASE_TAGS_TO_SAVE = new HashSet<String>();
    private Map<String, String> BASE_TAGS_TO_REPLACE = new HashMap<String, String>();
    private Map<String, MapRouteType> types = new LinkedHashMap<String, MapRouteType>();
    private List<MapRouteType> listTypes = new ArrayList<MapRouteType>();
    private MapRouteType refRuleType;
    private MapRouteType nameRuleType;
    private MapRenderingTypesEncoder encoder;

    public MapRoutingTypes(MapRenderingTypesEncoder baseTypes) {
        this.encoder = baseTypes;
        for (MapRenderingTypesEncoder.MapRouteTag tg : baseTypes.getRouteTags()) {
            Object t = tg.tag;
            if (tg.value != null) {
                t = (String)t + "/" + tg.value;
            }
            if (!Algorithms.isEmpty((CharSequence)tg.type)) {
                this.TAGS_TYPE.put((String)t, tg.type);
            }
            if (tg.register) {
                this.TAGS_TO_ACCEPT.add((String)t);
                continue;
            }
            if (tg.replace) {
                Object t2 = tg.tag2;
                if (tg.value2 != null) {
                    t2 = (String)t2 + "/" + tg.value2;
                }
                if (tg.base) {
                    this.BASE_TAGS_TO_REPLACE.put((String)t, (String)t2);
                }
                this.TAGS_TO_REPLACE.put((String)t, (String)t2);
                continue;
            }
            if (tg.text) {
                if (tg.base) {
                    this.BASE_TAGS_TEXT.add((String)t);
                }
                this.TAGS_TEXT.add((String)t);
                continue;
            }
            if (!tg.amend) continue;
            if (tg.base) {
                this.BASE_TAGS_TO_SAVE.add((String)t);
            }
            this.TAGS_TO_SAVE.add((String)t);
        }
    }

    public static String constructRuleKey(String tag, String val) {
        if (val == null || val.length() == 0) {
            return tag;
        }
        return tag + "/" + val;
    }

    protected static String getTagKey(String tagValue) {
        int i = tagValue.indexOf(47);
        if (i >= 0) {
            return tagValue.substring(0, i);
        }
        return tagValue;
    }

    protected static String getValueKey(String tagValue) {
        int i = tagValue.indexOf(47);
        if (i >= 0) {
            return tagValue.substring(i + 1);
        }
        return null;
    }

    public MapRouteType getRefRuleType() {
        return this.refRuleType;
    }

    public MapRouteType getNameRuleType() {
        return this.nameRuleType;
    }

    private boolean validateType(String tag, String value) {
        String tp = this.TAGS_TYPE.get(tag);
        if (tp != null) {
            try {
                if (tp.equals("length")) {
                    return RouteDataObject.parseLength((String)value, (float)-1.0f) != -1.0f;
                }
                if (tp.equals("weight")) {
                    return RouteDataObject.parseWeightInTon((String)value, (float)-1.0f) != -1.0f;
                }
                if (tp.equals("speed")) {
                    return RouteDataObject.parseSpeed((String)value, (float)-1.0f) != -1.0f;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private boolean contains(Set<String> s, String tag, String value) {
        return s.contains(tag) || s.contains(tag + "/" + value);
    }

    private String getMap(Map<String, String> s, String tag, String value) {
        String r = s.get(tag);
        if (r != null) {
            return r;
        }
        r = s.get(tag + "/" + value);
        return r;
    }

    private boolean startsWith(Set<String> setOfTags, String tag, String value) {
        if (setOfTags.contains(tag) || setOfTags.contains(tag + "/" + value)) {
            return true;
        }
        int ind = -1;
        while ((ind = tag.indexOf(58, ind + 1)) != -1) {
            if (!setOfTags.contains(tag.substring(0, ind))) continue;
            return true;
        }
        return false;
    }

    private boolean testNonParseableRules(String tag, String value) {
        if (tag.equals("maxspeed") && value != null) {
            try {
                RouteDataObject.parseSpeed((String)value, (float)0.0f);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (tag.equals("lanes") && value != null) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean encodeEntity(Map<String, String> tags, TIntArrayList outTypes, Map<MapRouteType, String> names) {
        String value;
        String tag;
        boolean init = false;
        for (Map.Entry<String, String> es : tags.entrySet()) {
            tag = es.getKey();
            if (!this.testNonParseableRules(tag, value = es.getValue()) || !this.contains(this.TAGS_TO_ACCEPT, tag, value)) continue;
            init = true;
            break;
        }
        if (!init) {
            return false;
        }
        outTypes.clear();
        names.clear();
        for (Map.Entry<String, String> es : tags.entrySet()) {
            tag = es.getKey();
            if (!this.testNonParseableRules(tag, value = this.converBooleanValue(es.getValue()))) continue;
            String tvl = this.getMap(this.TAGS_TO_REPLACE, tag, value);
            if (tvl != null) {
                int i = tvl.indexOf(47);
                tag = tvl.substring(0, i);
                value = tvl.substring(i + 1);
            }
            if (this.TAGS_TEXT.contains(tag) || this.startsWith(this.TAGS_TEXT, tag, value)) {
                if (!this.validateType(tag, value)) continue;
                names.put(this.registerRule(tag, null), value);
                continue;
            }
            if (!this.contains(this.TAGS_TO_ACCEPT, tag, value) && !this.startsWith(this.TAGS_TO_SAVE, tag, value) && this.getMap(this.TAGS_TO_REPLACE, tag, value) == null || !this.validateType(tag, value)) continue;
            outTypes.add(this.registerRule((String)tag, (String)value).id);
        }
        return true;
    }

    public boolean encodeBaseEntity(Map<String, String> tags, TIntArrayList outTypes, Map<MapRouteType, String> names) {
        String value;
        String tag;
        boolean init = false;
        for (Map.Entry<String, String> es : tags.entrySet()) {
            tag = es.getKey();
            if (!this.contains(this.TAGS_TO_ACCEPT, tag, value = es.getValue()) || !value.startsWith("trunk") && !value.startsWith("motorway") && !value.startsWith("primary") && !value.startsWith("secondary") && !value.startsWith("tertiary") && !value.startsWith("ferry")) continue;
            init = true;
            break;
        }
        if (!init) {
            return false;
        }
        outTypes.clear();
        names.clear();
        for (Map.Entry<String, String> es : tags.entrySet()) {
            tag = es.getKey();
            if (!this.testNonParseableRules(tag, value = this.converBooleanValue(es.getValue()))) continue;
            String tvl = this.getMap(this.BASE_TAGS_TO_REPLACE, tag, value);
            if (tvl != null) {
                int i = tvl.indexOf(47);
                tag = tvl.substring(0, i);
                value = tvl.substring(i + 1);
            }
            if (this.BASE_TAGS_TEXT.contains(tag) && this.validateType(tag, value)) {
                names.put(this.registerRule(tag, null), value);
            }
            if (!this.contains(this.TAGS_TO_ACCEPT, tag, value) && !this.startsWith(this.BASE_TAGS_TO_SAVE, tag, value) || !this.validateType(tag, value)) continue;
            outTypes.add(this.registerRule((String)tag, (String)value).id);
        }
        return true;
    }

    private String converBooleanValue(String value) {
        if (value.equals("true")) {
            return "yes";
        }
        if (value.equals("false")) {
            return "no";
        }
        return value;
    }

    public void encodePointTypes(Way e, TLongObjectHashMap<TIntArrayList> pointTypes, TLongObjectHashMap<TIntObjectHashMap<String>> pointNames, RelationTagsPropagation tagsTransformer, MapRenderingTypesEncoder renderingTypes, boolean base) {
        pointTypes.clear();
        for (Node nd : e.getNodes()) {
            String value;
            String tag;
            if (nd == null) continue;
            boolean accept = false;
            Map<String, String> ntags = tagsTransformer.addPropogatedTags(renderingTypes, MapRenderingTypesEncoder.EntityConvertApplyType.ROUTING, (Entity)nd, nd.getTags());
            ntags = this.encoder.transformTags(ntags, Entity.EntityType.NODE, MapRenderingTypesEncoder.EntityConvertApplyType.ROUTING);
            Iterator<Map.Entry<String, String>> iterator = ntags.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> es;
                String tvl = this.getMap(base ? this.BASE_TAGS_TO_REPLACE : this.TAGS_TO_REPLACE, tag = (es = iterator.next()).getKey(), value = this.converBooleanValue(es.getValue()));
                if (tvl != null) {
                    int i = tvl.indexOf(47);
                    tag = tvl.substring(0, i);
                    value = tvl.substring(i + 1);
                }
                if (!this.contains(this.TAGS_TO_ACCEPT, tag, value) && !this.startsWith(base ? this.BASE_TAGS_TO_SAVE : this.TAGS_TO_SAVE, tag, value)) continue;
                if (!pointTypes.containsKey(nd.getId())) {
                    pointTypes.put(nd.getId(), (Object)new TIntArrayList());
                }
                ((TIntArrayList)pointTypes.get(nd.getId())).add(this.registerRule((String)tag, (String)value).id);
                accept = true;
            }
            if (!accept) continue;
            for (Map.Entry<String, String> es : ntags.entrySet()) {
                tag = es.getKey();
                value = this.converBooleanValue(es.getValue());
                if (!this.TAGS_TEXT.contains(tag) && !this.startsWith(this.TAGS_TEXT, tag, value)) continue;
                if (!pointNames.containsKey(nd.getId())) {
                    pointNames.put(nd.getId(), (Object)new TIntObjectHashMap());
                }
                ((TIntObjectHashMap)pointNames.get(nd.getId())).put(this.registerRule((String)tag, null).id, (Object)value);
            }
        }
    }

    public MapRouteType getTypeByInternalId(int id) {
        return this.listTypes.get(id - 1);
    }

    private MapRouteType registerRule(String tag, String val) {
        String id = MapRoutingTypes.constructRuleKey(tag, val);
        if (!this.types.containsKey(id)) {
            MapRouteType rt = new MapRouteType();
            rt.id = this.types.size() + 1;
            rt.tag = tag;
            rt.value = val;
            this.types.put(id, rt);
            this.listTypes.add(rt);
            if (tag.equals("ref")) {
                this.refRuleType = rt;
            }
            if (tag.equals("name")) {
                this.nameRuleType = rt;
            }
        }
        MapRouteType type = this.types.get(id);
        ++type.freq;
        return type;
    }

    public List<MapRouteType> getEncodingRuleTypes() {
        return this.listTypes;
    }

    public static class MapRouteType {
        int freq = 0;
        int id;
        int targetId;
        String tag;
        String value;

        public MapRouteType() {
        }

        public MapRouteType(int id, String tag, String value) {
            this.id = id;
            this.targetId = id;
            this.tag = tag;
            this.value = value;
        }

        public int getInternalId() {
            return this.id;
        }

        public int getFreq() {
            return this.freq;
        }

        public int getTargetId() {
            return this.targetId;
        }

        public String getTag() {
            return this.tag;
        }

        public String getValue() {
            return this.value;
        }

        public void setTargetId(int targetId) {
            this.targetId = targetId;
        }

        public String toString() {
            if (this.value == null) {
                return "'" + this.tag + "'";
            }
            return this.tag + "='" + this.value + "'";
        }
    }

    public static class MapPointName {
        public int nameTypeInternalId;
        public int nameTypeTargetId;
        public int pointIndex;
        public String name;

        public MapPointName(int nameType, int pointIndex, String name) {
            this.nameTypeInternalId = nameType;
            this.nameTypeTargetId = nameType;
            this.pointIndex = pointIndex;
            this.name = name;
        }
    }
}

