/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.search.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.Amenity;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.Street;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.PoiFilter;
import net.osmand.osm.PoiType;
import net.osmand.search.core.ObjectType;
import net.osmand.search.core.SearchPhrase;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;

public class SearchResult {
    public static final String DELIMITER = " ";
    private static final String HYPHEN = "-";
    static final int NEAREST_METERS_LIMIT = 30000;
    public static final double MAX_TYPES_BASE_10 = 10.0;
    public static final double MAX_PHRASE_WEIGHT_TOTAL = 100.0;
    public SearchPhrase requiredSearchPhrase;
    public SearchResult parentSearchResult;
    String wordsSpan;
    boolean firstUnknownWordMatches;
    Collection<String> otherWordsMatch = null;
    public Object object;
    public ObjectType objectType;
    public BinaryMapIndexReader file;
    public double priority;
    public double priorityDistance;
    public LatLon location;
    public int preferredZoom = 15;
    public String localeName;
    public String alternateName;
    public String cityName;
    public Collection<String> otherNames;
    public String localeRelatedObjectName;
    public Object relatedObject;
    public double distRelatedObjectName;
    private double unknownPhraseMatchWeight = 0.0;
    private SearchResultResource searchResultResource;

    public SearchResult() {
        this.requiredSearchPhrase = SearchPhrase.emptyPhrase();
    }

    public SearchResult(SearchPhrase sp) {
        this.requiredSearchPhrase = sp;
    }

    public double getUnknownPhraseMatchWeight() {
        if (this.unknownPhraseMatchWeight != 0.0) {
            return this.unknownPhraseMatchWeight;
        }
        this.unknownPhraseMatchWeight = this.getSumPhraseMatchWeight(null);
        return this.unknownPhraseMatchWeight;
    }

    private double getSumPhraseMatchWeight(SearchResult exactResult) {
        double res = ObjectType.getTypeWeight(this.objectType);
        if (this.requiredSearchPhrase.getUnselectedPoiType() == null && this.objectType != ObjectType.POI_TYPE) {
            Object s;
            Object object;
            CheckWordsMatchCount completeMatchRes = new CheckWordsMatchCount();
            boolean matched = this.allWordsMatched(this.localeName, exactResult, completeMatchRes);
            if (!matched && this.alternateName != null && !Algorithms.objectEquals(this.cityName, this.alternateName)) {
                matched = this.allWordsMatched(this.alternateName, exactResult, completeMatchRes);
            }
            if (!matched && this.otherNames != null) {
                for (String otherName : this.otherNames) {
                    if (!this.allWordsMatched(otherName, exactResult, completeMatchRes)) continue;
                    matched = true;
                    break;
                }
            }
            City selectedCity = null;
            if (exactResult != null && (object = exactResult.object) instanceof Street) {
                Street s2 = (Street)object;
                selectedCity = s2.getCity();
            } else if (exactResult != null && exactResult.parentSearchResult != null && (object = exactResult.parentSearchResult.object) instanceof Street) {
                s = (Street)object;
                selectedCity = ((Street)s).getCity();
            }
            if (matched && selectedCity != null && (s = this.object) instanceof City) {
                City c = (City)s;
                if (!Algorithms.objectEquals(selectedCity.getName(), c.getName())) {
                    matched = false;
                    int[] bbox31 = selectedCity.getBbox31();
                    LatLon latlon = selectedCity.getLocation();
                    if (bbox31 != null) {
                        double lon = MapUtils.get31LongitudeX(bbox31[0] / 2 + bbox31[2] / 2);
                        double lat = MapUtils.get31LatitudeY(bbox31[1] / 2 + bbox31[3] / 2);
                        latlon = new LatLon(lat, lon);
                    }
                    res += 100.0 / Math.max(100.0, MapUtils.getDistance(this.location, latlon));
                }
            }
            if (matched) {
                res = this.getPhraseWeightForCompleteMatch(completeMatchRes);
            }
        }
        if (this.parentSearchResult != null) {
            res += this.parentSearchResult.getSumPhraseMatchWeight(exactResult == null ? this : exactResult) / 100.0;
        }
        return res;
    }

    private double getPhraseWeightForCompleteMatch(CheckWordsMatchCount completeMatchRes) {
        double res = (double)ObjectType.getTypeWeight(this.objectType) * 10.0;
        if (completeMatchRes.allWordsEqual) {
            boolean closeDistance;
            boolean bl = closeDistance = this.requiredSearchPhrase.getLastTokenLocation() != null && this.location != null && MapUtils.getDistance(this.requiredSearchPhrase.getLastTokenLocation(), this.location) <= 30000.0;
            if (this.objectType != ObjectType.POI || closeDistance) {
                res = (double)ObjectType.getTypeWeight(this.objectType) * 10.0 + 50.0;
            }
        }
        return res;
    }

    public int getDepth() {
        if (this.parentSearchResult != null) {
            return 1 + this.parentSearchResult.getDepth();
        }
        return 1;
    }

    public int getFoundWordCount() {
        int inc = this.getSelfWordCount();
        if (this.parentSearchResult != null) {
            inc += this.parentSearchResult.getFoundWordCount();
        }
        return inc;
    }

    public boolean hasObjectTypePresent(ObjectType type) {
        if (this.objectType == type) {
            return true;
        }
        if (this.parentSearchResult != null) {
            return this.parentSearchResult.hasObjectTypePresent(type);
        }
        return false;
    }

    private boolean allWordsMatched(String name, SearchResult exactResult, CheckWordsMatchCount cnt) {
        int i;
        List<String> searchPhraseNames = this.getSearchPhraseNames();
        if (name.indexOf(40) != -1) {
            name = SearchPhrase.stripBraces(name);
        }
        List<String> localResultNames = !this.requiredSearchPhrase.getFullSearchPhrase().contains(HYPHEN) ? SearchPhrase.splitWords(name, new ArrayList<String>(), "\\s|,|-") : SearchPhrase.splitWords(name, new ArrayList<String>(), "\\s|,");
        if (searchPhraseNames.isEmpty()) {
            return false;
        }
        while (exactResult != null && exactResult != this) {
            List<String> lst = exactResult.getSearchPhraseNames();
            for (String l : lst) {
                i = searchPhraseNames.indexOf(l);
                if (i == -1) continue;
                searchPhraseNames.remove(i);
            }
            exactResult = exactResult.parentSearchResult;
        }
        int idxMatchedWord = -1;
        for (String searchPhraseName : searchPhraseNames) {
            boolean wordMatched = false;
            for (i = idxMatchedWord + 1; i < localResultNames.size(); ++i) {
                int r = this.requiredSearchPhrase.getCollator().compare(searchPhraseName, localResultNames.get(i));
                if (r != 0) continue;
                wordMatched = true;
                idxMatchedWord = i;
                break;
            }
            if (wordMatched) continue;
            return false;
        }
        if (searchPhraseNames.size() == localResultNames.size()) {
            cnt.allWordsEqual = true;
        }
        cnt.allWordsInPhraseAreInResult = true;
        return true;
    }

    private List<String> getSearchPhraseNames() {
        ArrayList<String> searchPhraseNames = new ArrayList<String>();
        String fw = this.requiredSearchPhrase.getFirstUnknownSearchWord();
        List<String> ow = this.requiredSearchPhrase.getUnknownSearchWords();
        if (fw != null && fw.length() > 0) {
            searchPhraseNames.add(fw);
        }
        if (ow != null) {
            searchPhraseNames.addAll(ow);
        }
        if (this.parentSearchResult != null && this.requiredSearchPhrase == this.parentSearchResult.requiredSearchPhrase && this.parentSearchResult.getOtherWordsMatch() != null) {
            for (String s : this.parentSearchResult.getOtherWordsMatch()) {
                int i = searchPhraseNames.indexOf(s);
                if (i == -1) continue;
                searchPhraseNames.remove(i);
            }
        }
        return searchPhraseNames;
    }

    private int getSelfWordCount() {
        int inc = 0;
        if (this.firstUnknownWordMatches) {
            inc = 1;
        }
        if (this.otherWordsMatch != null) {
            inc += this.otherWordsMatch.size();
        }
        return inc;
    }

    public double getSearchDistance(LatLon location) {
        double distance = 0.0;
        if (location != null && this.location != null) {
            distance = MapUtils.getDistance(location, this.location);
        }
        return this.priority - 1.0 / (1.0 + this.priorityDistance * distance);
    }

    public double getSearchDistance(LatLon location, double pd) {
        double distance = 0.0;
        if (location != null && this.location != null) {
            distance = MapUtils.getDistance(location, this.location);
        }
        return this.priority - 1.0 / (1.0 + pd * distance);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (!Algorithms.isEmpty(this.localeName)) {
            b.append(this.localeName);
        }
        if (!Algorithms.isEmpty(this.localeRelatedObjectName)) {
            Street street;
            City city;
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(this.localeRelatedObjectName);
            if (this.relatedObject instanceof Street && (city = (street = (Street)this.relatedObject).getCity()) != null) {
                b.append(", ").append(city.getName(this.requiredSearchPhrase.getSettings().getLang(), this.requiredSearchPhrase.getSettings().isTransliterate()));
            }
        } else if (this.object instanceof AbstractPoiType) {
            AbstractPoiType poiType;
            if (b.length() > 0) {
                b.append(DELIMITER);
            }
            if ((poiType = (AbstractPoiType)this.object) instanceof PoiCategory) {
                b.append("(Category)");
            } else if (poiType instanceof PoiFilter) {
                b.append("(Filter)");
            } else if (poiType instanceof PoiType) {
                PoiType p = (PoiType)poiType;
                AbstractPoiType parentType = p.getParentType();
                if (parentType != null) {
                    String translation = parentType.getTranslation();
                    b.append("(").append(translation);
                    if (parentType instanceof PoiCategory) {
                        b.append(" / Category)");
                    } else if (parentType instanceof PoiFilter) {
                        b.append(" / Filter)");
                    } else if (parentType instanceof PoiType) {
                        PoiType pp = (PoiType)poiType;
                        PoiFilter filter = pp.getFilter();
                        PoiCategory category = pp.getCategory();
                        if (filter != null && !filter.getTranslation().equals(translation)) {
                            b.append(" / ").append(filter.getTranslation()).append(")");
                        } else if (category != null && !category.getTranslation().equals(translation)) {
                            b.append(" / ").append(category.getTranslation()).append(")");
                        } else {
                            b.append(")");
                        }
                    }
                } else if (p.getFilter() != null) {
                    b.append("(").append(p.getFilter().getTranslation()).append(")");
                } else if (p.getCategory() != null) {
                    b.append("(").append(p.getCategory().getTranslation()).append(")");
                }
            }
        }
        return b.toString();
    }

    public SearchResultResource getResourceType() {
        if (this.searchResultResource == null) {
            Object object;
            this.searchResultResource = SearchResultResource.DETAILED;
            if (this.object != null && (object = this.object) instanceof Amenity) {
                Amenity amenity = (Amenity)object;
                SearchResultResource searchResultResource = this.searchResultResource = amenity.getType().isWiki() ? SearchResultResource.WIKIPEDIA : this.searchResultResource;
            }
            if (this.file != null) {
                this.searchResultResource = this.file.getFile().getName().contains(".travel") ? SearchResultResource.TRAVEL : this.searchResultResource;
                this.searchResultResource = this.file.isBasemap() ? SearchResultResource.BASEMAP : this.searchResultResource;
            }
        }
        return this.searchResultResource;
    }

    public Collection<String> getOtherWordsMatch() {
        return this.otherWordsMatch;
    }

    public void setOtherWordsMatch(Collection<String> set) {
        this.otherWordsMatch = set;
    }

    public void setUnknownPhraseMatchWeight(double weight) {
        this.unknownPhraseMatchWeight = weight;
    }

    public boolean isFullPhraseEqualLocaleName() {
        return this.requiredSearchPhrase.getFullSearchPhrase().equalsIgnoreCase(this.localeName);
    }

    public List<String> filterUnknownSearchWord(List<String> leftUnknownSearchWords) {
        if (leftUnknownSearchWords == null) {
            leftUnknownSearchWords = new ArrayList<String>(this.requiredSearchPhrase.getUnknownSearchWords());
            leftUnknownSearchWords.add(0, this.requiredSearchPhrase.getFirstUnknownSearchWord());
        }
        if (this.firstUnknownWordMatches) {
            leftUnknownSearchWords.remove(this.requiredSearchPhrase.getFirstUnknownSearchWord());
        }
        if (this.otherWordsMatch != null) {
            for (String otherWord : this.otherWordsMatch) {
                int ind = this.firstUnknownWordMatches ? leftUnknownSearchWords.indexOf(otherWord) : leftUnknownSearchWords.lastIndexOf(otherWord);
                if (ind == -1) continue;
                leftUnknownSearchWords.remove(ind);
            }
        }
        return leftUnknownSearchWords;
    }

    static class CheckWordsMatchCount {
        boolean allWordsEqual;
        boolean allWordsInPhraseAreInResult;

        CheckWordsMatchCount() {
        }
    }

    public static enum SearchResultResource {
        DETAILED,
        WIKIPEDIA,
        BASEMAP,
        TRAVEL;

    }
}

