/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import kotlin.Metadata;
import net.osmand.shared.util.KMapUtils;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH&J\b\u0010\u0010\u001a\u00020\rH&J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007J\b\u0010\u0013\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/osmand/shared/gpx/ElevationApproximator;", "", "<init>", "()V", "SLOPE_THRESHOLD", "", "distances", "", "elevations", "survivedIndexes", "", "getPointLatitude", "index", "", "getPointLongitude", "getPointElevation", "getPointsCount", "getDistances", "getElevations", "getSurvivedIndexes", "approximate", "", "OsmAnd-shared"})
public abstract class ElevationApproximator {
    private final double SLOPE_THRESHOLD;
    @Nullable
    private double[] distances;
    @Nullable
    private double[] elevations;
    @Nullable
    private int[] survivedIndexes;

    public ElevationApproximator() {
        this.SLOPE_THRESHOLD = 70.0;
    }

    public abstract double getPointLatitude(int var1);

    public abstract double getPointLongitude(int var1);

    public abstract double getPointElevation(int var1);

    public abstract int getPointsCount();

    @Nullable
    public final double[] getDistances() {
        return this.distances;
    }

    @Nullable
    public final double[] getElevations() {
        return this.elevations;
    }

    @Nullable
    public final int[] getSurvivedIndexes() {
        return this.survivedIndexes;
    }

    public final boolean approximate() {
        int i;
        int pointsCount = this.getPointsCount();
        if (pointsCount < 4) {
            return false;
        }
        boolean[] survived = new boolean[pointsCount];
        int lastSurvived = 0;
        int survivedCount = 0;
        int n = pointsCount - 1;
        for (i = 1; i < n; ++i) {
            double eleNext;
            double prevEle = this.getPointElevation(lastSurvived);
            double ele = this.getPointElevation(i);
            if (!((ele - prevEle) * ((eleNext = this.getPointElevation(i + 1)) - ele) > 0.0)) continue;
            survived[i] = true;
            lastSurvived = i;
            ++survivedCount;
        }
        if (!Double.isNaN(this.getPointElevation(pointsCount - 1))) {
            survived[pointsCount - 1] = true;
            ++survivedCount;
        }
        if (survivedCount < 2) {
            return false;
        }
        lastSurvived = 0;
        survivedCount = 0;
        n = pointsCount - 1;
        for (i = 1; i < n; ++i) {
            double dist;
            double prevEle;
            if (!survived[i]) continue;
            double ele = this.getPointElevation(i);
            double slope = (ele - (prevEle = this.getPointElevation(lastSurvived))) * (double)100 / (dist = KMapUtils.INSTANCE.getDistance(this.getPointLatitude(i), this.getPointLongitude(i), this.getPointLatitude(lastSurvived), this.getPointLongitude(lastSurvived)));
            if (Math.abs(slope) > this.SLOPE_THRESHOLD) {
                survived[i] = false;
                continue;
            }
            lastSurvived = i;
            ++survivedCount;
        }
        if (survivedCount < 2) {
            return false;
        }
        if (!Double.isNaN(this.getPointElevation(0))) {
            survived[0] = true;
            ++survivedCount;
        }
        if (!Double.isNaN(this.getPointElevation(pointsCount - 1))) {
            survived[pointsCount - 1] = true;
            ++survivedCount;
        }
        double[] distances = new double[survivedCount];
        double[] elevations = new double[survivedCount];
        int[] survivedIndexes = new int[survivedCount];
        int k = 0;
        lastSurvived = 0;
        for (int i2 = 0; i2 < pointsCount; ++i2) {
            if (!survived[i2]) continue;
            distances[k] = lastSurvived == 0 ? 0.0 : KMapUtils.INSTANCE.getDistance(this.getPointLatitude(i2), this.getPointLongitude(i2), this.getPointLatitude(lastSurvived), this.getPointLongitude(lastSurvived));
            elevations[k] = this.getPointElevation(i2);
            survivedIndexes[k] = i2;
            ++k;
            lastSurvived = i2;
        }
        this.distances = distances;
        this.elevations = elevations;
        this.survivedIndexes = survivedIndexes;
        return true;
    }
}

