/*
 * Decompiled with CFR 0.152.
 */
package com.wdtinc.mapbox_vector_tile.builder;

import com.wdtinc.mapbox_vector_tile.encoding.MvtValue;
import java.util.LinkedHashMap;

public final class MvtLayerProps {
    private LinkedHashMap<String, Integer> keys = new LinkedHashMap();
    private LinkedHashMap<Object, Integer> vals = new LinkedHashMap();

    public Integer keyIndex(String k) {
        return this.keys.get(k);
    }

    public Integer valueIndex(Object v) {
        return this.vals.get(v);
    }

    public int addKey(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        int nextIndex = this.keys.size();
        Integer mapIndex = !this.keys.containsKey(key) ? this.keys.put(key, nextIndex) : this.keys.get(key);
        return mapIndex == null ? nextIndex : mapIndex;
    }

    public int addValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (!MvtValue.isValidPropValue(value)) {
            return -1;
        }
        int nextIndex = this.vals.size();
        Integer mapIndex = !this.vals.containsKey(value) ? this.vals.put(value, nextIndex) : this.vals.get(value);
        return mapIndex == null ? nextIndex : mapIndex;
    }

    public Iterable<String> getKeys() {
        return this.keys.keySet();
    }

    public Iterable<Object> getVals() {
        return this.vals.keySet();
    }
}

