/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.TileId;

public class TileIdList {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected TileIdList(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(TileIdList tileIdList) {
        return tileIdList == null ? 0L : tileIdList.swigCPtr;
    }

    protected static long swigRelease(TileIdList tileIdList) {
        long l = 0L;
        if (tileIdList != null) {
            if (!tileIdList.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = tileIdList.swigCPtr;
            tileIdList.swigCMemOwn = false;
            tileIdList.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_TileIdList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public TileIdList() {
        this(OsmAndCoreJNI.new_TileIdList(), true);
    }

    public long size() {
        return OsmAndCoreJNI.TileIdList_size(this.swigCPtr, this);
    }

    public void reserve(long l) {
        OsmAndCoreJNI.TileIdList_reserve(this.swigCPtr, this, l);
    }

    public boolean isEmpty() {
        return OsmAndCoreJNI.TileIdList_isEmpty(this.swigCPtr, this);
    }

    public void clear() {
        OsmAndCoreJNI.TileIdList_clear(this.swigCPtr, this);
    }

    public void add(TileId tileId) {
        OsmAndCoreJNI.TileIdList_add(this.swigCPtr, this, TileId.getCPtr(tileId), tileId);
    }

    public TileId get(int n) {
        return new TileId(OsmAndCoreJNI.TileIdList_get(this.swigCPtr, this, n), false);
    }

    public void set(int n, TileId tileId) {
        OsmAndCoreJNI.TileIdList_set(this.swigCPtr, this, n, TileId.getCPtr(tileId), tileId);
    }
}

