/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class IntegerArrayIO {
    private static final int INT_BYTES = 4;

    public static int[] readArray(InputStream input) throws IOException {
        DataInputStream dataInput = new DataInputStream(input);
        int length = dataInput.readInt();
        ByteBuffer tmpBuffer = ByteBuffer.allocate(length * 4);
        ReadableByteChannel channel = Channels.newChannel(dataInput);
        channel.read(tmpBuffer);
        tmpBuffer.rewind();
        IntBuffer intBuffer = tmpBuffer.asIntBuffer();
        int[] array = new int[length];
        intBuffer.get(array);
        return array;
    }

    public static void writeArray(OutputStream output, int[] array) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(output);
        int length = array.length;
        dataOutput.writeInt(length);
        ByteBuffer tmpBuffer = ByteBuffer.allocate(length * 4);
        IntBuffer intBuffer = tmpBuffer.asIntBuffer();
        tmpBuffer.rewind();
        intBuffer.put(array);
        WritableByteChannel channel = Channels.newChannel(dataOutput);
        channel.write(tmpBuffer);
    }

    public static int[][] readArray2D(InputStream input) throws IOException {
        DataInputStream dataInput = new DataInputStream(input);
        int length = dataInput.readInt();
        int[][] array = new int[length][];
        for (int i = 0; i < length; ++i) {
            array[i] = IntegerArrayIO.readArray(dataInput);
        }
        return array;
    }

    public static void writeArray2D(OutputStream output, int[][] array) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(output);
        int length = array.length;
        dataOutput.writeInt(length);
        for (int i = 0; i < length; ++i) {
            IntegerArrayIO.writeArray(dataOutput, array[i]);
        }
    }

    public static int[][] readSparseArray2D(InputStream input) throws IOException {
        int index;
        DataInputStream dataInput = new DataInputStream(input);
        int length = dataInput.readInt();
        int[][] array = new int[length][];
        while ((index = dataInput.readInt()) >= 0) {
            array[index] = IntegerArrayIO.readArray(dataInput);
        }
        return array;
    }

    public static void writeSparseArray2D(OutputStream output, int[][] array) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(output);
        int length = array.length;
        dataOutput.writeInt(length);
        for (int i = 0; i < length; ++i) {
            int[] inner = array[i];
            if (inner == null) continue;
            dataOutput.writeInt(i);
            IntegerArrayIO.writeArray(dataOutput, inner);
        }
        dataOutput.writeInt(-1);
    }
}

