/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.grid;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import net.osmand.shared.data.KQuadRect;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b%\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0017\u0018\u0000 _2\u00020\u0001:\u0001_B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\u000bB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\u000eJ\u0006\u00102\u001a\u00020\u0000J\u0006\u00103\u001a\u00020\u0000J\u0006\u00104\u001a\u00020\u0000J\u0006\u00105\u001a\u00020\u0000J\u0006\u00106\u001a\u00020\u0000J\u0006\u00107\u001a\u00020\u0000J\u0016\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u0007J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0007J\u0016\u0010=\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007J\u0006\u0010D\u001a\u00020EJ>\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u00072\u0006\u0010L\u001a\u00020\t2\u0006\u0010M\u001a\u00020\u00072\u0006\u0010N\u001a\u00020\t2\u0006\u0010O\u001a\u00020\u0007J\u000e\u0010P\u001a\u00020\u00072\u0006\u0010H\u001a\u00020IJ\u000e\u0010Q\u001a\u00020\u00072\u0006\u0010H\u001a\u00020IJ\u000e\u0010R\u001a\u00020\u00072\u0006\u0010H\u001a\u00020IJ\u000e\u0010S\u001a\u00020\u00072\u0006\u0010H\u001a\u00020IJ\u000e\u0010T\u001a\u00020\u00072\u0006\u0010H\u001a\u00020IJ\u000e\u0010U\u001a\u00020\u00072\u0006\u0010H\u001a\u00020IJ\u000e\u0010V\u001a\u00020\u00002\u0006\u0010W\u001a\u00020EJ\b\u0010X\u001a\u00020GH\u0002J\b\u0010Y\u001a\u00020\u0003H\u0016J\u000e\u0010Z\u001a\u00020\t2\u0006\u0010[\u001a\u00020\u0000J\u0018\u0010\\\u001a\u00020G2\u0006\u0010]\u001a\u00020\u00072\u0006\u0010^\u001a\u00020\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\r\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0017\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0012\"\u0004\b\u0019\u0010\u0014R\u001a\u0010\u001a\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u0014R\u001a\u0010\u001d\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0012\"\u0004\b\u001f\u0010\u0014R\u001a\u0010 \u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0012\"\u0004\b\"\u0010\u0014R\u001a\u0010#\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'R\u001a\u0010+\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0012\"\u0004\b-\u0010\u0014R\u0014\u0010.\u001a\u00020/X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010>\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010%R\u0011\u0010?\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010%R\u0011\u0010@\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010%R\u0011\u0010A\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010%R\u0011\u0010B\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010%R\u0011\u0010C\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010%\u00a8\u0006`"}, d2={"Lnet/osmand/shared/grid/ButtonPositionSize;", "", "id", "", "<init>", "(Ljava/lang/String;)V", "sz8dp", "", "left", "", "top", "(Ljava/lang/String;IZZ)V", "posH", "posV", "(Ljava/lang/String;III)V", "getId", "()Ljava/lang/String;", "getPosH", "()I", "setPosH", "(I)V", "getPosV", "setPosV", "marginX", "getMarginX", "setMarginX", "marginY", "getMarginY", "setMarginY", "width", "getWidth", "setWidth", "height", "getHeight", "setHeight", "xMove", "getXMove", "()Z", "setXMove", "(Z)V", "yMove", "getYMove", "setYMove", "moveDescendants", "getMoveDescendants", "setMoveDescendants", "bounds", "Lnet/osmand/shared/data/KQuadRect;", "getBounds$OsmAnd_shared", "()Lnet/osmand/shared/data/KQuadRect;", "setMoveVertical", "setMoveDescendantsAny", "setMoveDescendantsVertical", "setMoveDescendantsHorizontal", "setMoveHorizontal", "setNonMoveable", "setSize", "width8dp", "height8dp", "setPositionHorizontal", "setPositionVertical", "setMargin", "isLeft", "isRight", "isTop", "isBottom", "isFullWidth", "isFullHeight", "toLongValue", "", "calcGridPositionFromPixel", "", "dpToPix", "", "widthPx", "heightPx", "gravLeft", "x", "gravTop", "y", "getYStartPix", "getYEndPix", "getXStartPix", "getXEndPix", "getWidthPix", "getHeightPix", "fromLongValue", "v", "validate", "toString", "overlap", "position", "updateBounds", "totalWidth", "totalHeight", "Companion", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nButtonPositionSize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ButtonPositionSize.kt\nnet/osmand/shared/grid/ButtonPositionSize\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,427:1\n1#2:428\n*E\n"})
public final class ButtonPositionSize {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private int posH;
    private int posV;
    private int marginX;
    private int marginY;
    private int width;
    private int height;
    private boolean xMove;
    private boolean yMove;
    private int moveDescendants;
    @NotNull
    private final KQuadRect bounds;
    @NotNull
    private static final Logger LOG = LoggerFactory.INSTANCE.getLogger("ButtonPositionSize");
    private static final int MAX_ITERATIONS = 1000;
    private static final int MAX_STUCK_ATTEMPTS = 20;
    private static boolean DEBUG_PRINT;
    private static boolean DEBUG_PRINT_MOVE;
    private static boolean SIMPLIFIED_ALGORITHM;
    public static final int CELL_SIZE_DP = 8;
    public static final int DEF_MARGIN_DP = 4;
    public static final int MOVE_DESCENDANTS_ANY = 0;
    public static final int MOVE_DESCENDANTS_VERTICAL = 1;
    public static final int MOVE_DESCENDANTS_HORIZONTAL = 2;
    public static final int POS_FULL_WIDTH = 0;
    public static final int POS_LEFT = 1;
    public static final int POS_RIGHT = 2;
    public static final int POS_FULL_HEIGHT = 0;
    public static final int POS_TOP = 1;
    public static final int POS_BOTTOM = 2;
    private static final int MAX_MARGIN_BITS = 10;
    private static final int MAX_SIZE_BITS = 6;
    private static final int MARGIN_MASK = 1023;
    private static final int SIZE_MASK = 63;

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final int getPosH() {
        return this.posH;
    }

    public final void setPosH(int n) {
        this.posH = n;
    }

    public final int getPosV() {
        return this.posV;
    }

    public final void setPosV(int n) {
        this.posV = n;
    }

    public final int getMarginX() {
        return this.marginX;
    }

    public final void setMarginX(int n) {
        this.marginX = n;
    }

    public final int getMarginY() {
        return this.marginY;
    }

    public final void setMarginY(int n) {
        this.marginY = n;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    public final boolean getXMove() {
        return this.xMove;
    }

    public final void setXMove(boolean bl) {
        this.xMove = bl;
    }

    public final boolean getYMove() {
        return this.yMove;
    }

    public final void setYMove(boolean bl) {
        this.yMove = bl;
    }

    public final int getMoveDescendants() {
        return this.moveDescendants;
    }

    public final void setMoveDescendants(int n) {
        this.moveDescendants = n;
    }

    @NotNull
    public final KQuadRect getBounds$OsmAnd_shared() {
        return this.bounds;
    }

    public ButtonPositionSize(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this(id, 7, true, true);
    }

    public ButtonPositionSize(@NotNull String id, int sz8dp, boolean left, boolean top) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.posH = 1;
        this.posV = 1;
        this.width = 7;
        this.height = 7;
        this.bounds = new KQuadRect();
        this.id = id;
        this.width = sz8dp;
        this.height = sz8dp;
        this.posH = left ? 1 : 2;
        this.posV = top ? 1 : 2;
    }

    public ButtonPositionSize(@NotNull String id, int sz8dp, int posH, int posV) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.posH = 1;
        this.posV = 1;
        this.width = 7;
        this.height = 7;
        this.bounds = new KQuadRect();
        this.id = id;
        this.width = sz8dp;
        this.height = sz8dp;
        this.posH = posH;
        this.posV = posV;
        this.validate();
    }

    @NotNull
    public final ButtonPositionSize setMoveVertical() {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setMoveVertical_u24lambda_u240 = buttonPositionSize = this;
        boolean bl = false;
        $this$setMoveVertical_u24lambda_u240.yMove = true;
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setMoveDescendantsAny() {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setMoveDescendantsAny_u24lambda_u241 = buttonPositionSize = this;
        boolean bl = false;
        $this$setMoveDescendantsAny_u24lambda_u241.moveDescendants = 0;
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setMoveDescendantsVertical() {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setMoveDescendantsVertical_u24lambda_u242 = buttonPositionSize = this;
        boolean bl = false;
        $this$setMoveDescendantsVertical_u24lambda_u242.moveDescendants = 1;
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setMoveDescendantsHorizontal() {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setMoveDescendantsHorizontal_u24lambda_u243 = buttonPositionSize = this;
        boolean bl = false;
        $this$setMoveDescendantsHorizontal_u24lambda_u243.moveDescendants = 2;
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setMoveHorizontal() {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setMoveHorizontal_u24lambda_u244 = buttonPositionSize = this;
        boolean bl = false;
        $this$setMoveHorizontal_u24lambda_u244.xMove = true;
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setNonMoveable() {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setNonMoveable_u24lambda_u245 = buttonPositionSize = this;
        boolean bl = false;
        $this$setNonMoveable_u24lambda_u245.xMove = false;
        $this$setNonMoveable_u24lambda_u245.yMove = false;
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setSize(int width8dp, int height8dp) {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setSize_u24lambda_u246 = buttonPositionSize = this;
        boolean bl = false;
        $this$setSize_u24lambda_u246.width = width8dp;
        $this$setSize_u24lambda_u246.height = height8dp;
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setPositionHorizontal(int posH) {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setPositionHorizontal_u24lambda_u247 = buttonPositionSize = this;
        boolean bl = false;
        $this$setPositionHorizontal_u24lambda_u247.posH = posH;
        $this$setPositionHorizontal_u24lambda_u247.validate();
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setPositionVertical(int posV) {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setPositionVertical_u24lambda_u248 = buttonPositionSize = this;
        boolean bl = false;
        $this$setPositionVertical_u24lambda_u248.posV = posV;
        $this$setPositionVertical_u24lambda_u248.validate();
        return buttonPositionSize;
    }

    @NotNull
    public final ButtonPositionSize setMargin(int marginX, int marginY) {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$setMargin_u24lambda_u249 = buttonPositionSize = this;
        boolean bl = false;
        $this$setMargin_u24lambda_u249.marginX = marginX;
        $this$setMargin_u24lambda_u249.marginY = marginY;
        return buttonPositionSize;
    }

    public final boolean isLeft() {
        return this.posH == 1;
    }

    public final boolean isRight() {
        return this.posH == 2;
    }

    public final boolean isTop() {
        return this.posV == 1;
    }

    public final boolean isBottom() {
        return this.posV == 2;
    }

    public final boolean isFullWidth() {
        return this.posH == 0;
    }

    public final boolean isFullHeight() {
        return this.posV == 0;
    }

    public final long toLongValue() {
        long vl = 0L;
        vl = (vl << 2) + (long)this.moveDescendants;
        vl = (vl << 2) + (long)this.posV;
        vl = (vl << 1) + (long)(this.yMove ? 1 : 0);
        vl = (vl << 10) + (long)Math.min(this.marginY, 1023);
        vl = (vl << 6) + (long)Math.min(this.height, 63);
        vl = (vl << 2) + (long)this.posH;
        vl = (vl << 1) + (long)(this.xMove ? 1 : 0);
        vl = (vl << 10) + (long)Math.min(this.marginX, 1023);
        vl = (vl << 6) + (long)Math.min(this.width, 63);
        return vl;
    }

    public final void calcGridPositionFromPixel(float dpToPix, int widthPx, int heightPx, boolean gravLeft, int x, boolean gravTop, int y) {
        float calcX = 0.0f;
        if (x < widthPx / 2) {
            this.posH = gravLeft ? 1 : 2;
            calcX = (float)x / dpToPix;
        } else {
            this.posH = gravLeft ? 2 : 1;
            calcX = (float)(widthPx - x) / dpToPix - (float)(this.width * 8);
        }
        this.marginX = Math.max(0, MathKt.roundToInt((float)((calcX - (float)4) / (float)8)));
        float calcY = 0.0f;
        if (y < heightPx / 2) {
            this.posV = gravTop ? 1 : 2;
            calcY = (float)y / dpToPix;
        } else {
            this.posV = gravTop ? 2 : 1;
            calcY = (float)(heightPx - y) / dpToPix - (float)(this.height * 8);
        }
        this.marginY = Math.max(0, MathKt.roundToInt((float)((calcY - (float)4) / (float)8)));
    }

    public final int getYStartPix(float dpToPix) {
        return (int)((float)(this.marginY * 8 + 4) * dpToPix);
    }

    public final int getYEndPix(float dpToPix) {
        return (int)((float)((this.marginY + this.height) * 8 + 4) * dpToPix);
    }

    public final int getXStartPix(float dpToPix) {
        return (int)((float)(this.marginX * 8 + 4) * dpToPix);
    }

    public final int getXEndPix(float dpToPix) {
        return (int)((float)((this.marginX + this.width) * 8 + 4) * dpToPix);
    }

    public final int getWidthPix(float dpToPix) {
        return (int)((float)(this.width * 8) * dpToPix);
    }

    public final int getHeightPix(float dpToPix) {
        return (int)((float)(this.height * 8) * dpToPix);
    }

    @NotNull
    public final ButtonPositionSize fromLongValue(long v) {
        ButtonPositionSize buttonPositionSize;
        ButtonPositionSize $this$fromLongValue_u24lambda_u2410 = buttonPositionSize = this;
        boolean bl = false;
        long value = v;
        $this$fromLongValue_u24lambda_u2410.width = (int)(value & 0x3FL);
        $this$fromLongValue_u24lambda_u2410.marginX = (int)((value >>= 6) & 0x3FFL);
        $this$fromLongValue_u24lambda_u2410.xMove = (value >>= 10) % (long)2 == 1L;
        $this$fromLongValue_u24lambda_u2410.posH = (int)((value >>= 1) % (long)4);
        $this$fromLongValue_u24lambda_u2410.height = (int)((value >>= 2) & 0x3FL);
        $this$fromLongValue_u24lambda_u2410.marginY = (int)((value >>= 6) & 0x3FFL);
        $this$fromLongValue_u24lambda_u2410.yMove = (value >>= 10) % (long)2 == 1L;
        $this$fromLongValue_u24lambda_u2410.posV = (int)((value >>= 1) % (long)4);
        $this$fromLongValue_u24lambda_u2410.moveDescendants = (int)((value >>= 2) % (long)4);
        $this$fromLongValue_u24lambda_u2410.validate();
        return buttonPositionSize;
    }

    private final void validate() {
        if (this.posH == 0 && this.posV == 0) {
            Logger.error$default(LOG, "Error parsing " + this + " as full width + full height", null, 2, null);
            this.posH = 2;
        }
    }

    @NotNull
    public String toString() {
        String posHStr = switch (this.posH) {
            case 0 -> "full_w";
            case 1 -> "left ";
            default -> "right";
        };
        String posVStr = switch (this.posV) {
            case 0 -> "full_h";
            case 1 -> "top ";
            default -> "bott";
        };
        String xMoveIndicator = this.xMove ? "+" : " ";
        String yMoveIndicator = this.yMove ? "+" : " ";
        String moveDescendantsStr = switch (this.moveDescendants) {
            case 1 -> "vertical";
            case 2 -> "horizontal";
            default -> "any";
        };
        String paddedWidth = StringsKt.padStart$default((String)String.valueOf(this.width), (int)2, (char)'\u0000', (int)2, null);
        String paddedHeight = StringsKt.padStart$default((String)String.valueOf(this.height), (int)2, (char)'\u0000', (int)2, null);
        return "Pos " + StringsKt.padStart$default((String)this.id, (int)10, (char)'\u0000', (int)2, null) + " x=(" + posHStr + "->" + this.marginX + xMoveIndicator + "), y=(" + posVStr + "->" + this.marginY + yMoveIndicator + "), w=" + paddedWidth + ", h=" + paddedHeight + ", move=" + moveDescendantsStr;
    }

    public final boolean overlap(@NotNull ButtonPositionSize position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return KQuadRect.Companion.intersects(this.bounds, position.bounds);
    }

    private final void updateBounds(int totalWidth, int totalHeight) {
        double left = 0.0;
        double right = 0.0;
        double top = 0.0;
        double bottom = 0.0;
        if (this.posH == 0) {
            left = 0.0;
            right = totalWidth;
        } else if (this.posH == 1) {
            left = this.marginX;
            right = left + (double)this.width;
        } else {
            right = totalWidth - this.marginX;
            left = right - (double)this.width;
        }
        if (this.posV == 0) {
            top = 0.0;
            bottom = totalHeight;
        } else if (this.posV == 1) {
            top = this.marginY;
            bottom = top + (double)this.height;
        } else {
            bottom = totalHeight - this.marginY;
            top = bottom - (double)this.height;
        }
        this.bounds.setLeft(left);
        this.bounds.setRight(right);
        this.bounds.setTop(top);
        this.bounds.setBottom(bottom);
    }

    static {
        SIMPLIFIED_ALGORITHM = true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001c\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00072\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007J8\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0007H\u0002J0\u00100\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u000e\u0010\u0015\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lnet/osmand/shared/grid/ButtonPositionSize$Companion;", "", "<init>", "()V", "LOG", "Lnet/osmand/shared/util/Logger;", "MAX_ITERATIONS", "", "MAX_STUCK_ATTEMPTS", "DEBUG_PRINT", "", "getDEBUG_PRINT", "()Z", "setDEBUG_PRINT", "(Z)V", "DEBUG_PRINT_MOVE", "getDEBUG_PRINT_MOVE", "setDEBUG_PRINT_MOVE", "SIMPLIFIED_ALGORITHM", "getSIMPLIFIED_ALGORITHM", "setSIMPLIFIED_ALGORITHM", "CELL_SIZE_DP", "DEF_MARGIN_DP", "MOVE_DESCENDANTS_ANY", "MOVE_DESCENDANTS_VERTICAL", "MOVE_DESCENDANTS_HORIZONTAL", "POS_FULL_WIDTH", "POS_LEFT", "POS_RIGHT", "POS_FULL_HEIGHT", "POS_TOP", "POS_BOTTOM", "MAX_MARGIN_BITS", "MAX_SIZE_BITS", "MARGIN_MASK", "SIZE_MASK", "computeNonOverlap", "space", "buttons", "", "Lnet/osmand/shared/grid/ButtonPositionSize;", "totalWidth", "totalHeight", "moveAndCheck", "toMove", "overlap", "mx", "my", "moveButton", "OsmAnd-shared"})
    @SourceDebugExtension(value={"SMAP\nButtonPositionSize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ButtonPositionSize.kt\nnet/osmand/shared/grid/ButtonPositionSize$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,427:1\n1863#2,2:428\n1863#2,2:430\n1863#2,2:432\n*S KotlinDebug\n*F\n+ 1 ButtonPositionSize.kt\nnet/osmand/shared/grid/ButtonPositionSize$Companion\n*L\n277#1:428,2\n282#1:430,2\n365#1:432,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getDEBUG_PRINT() {
            return DEBUG_PRINT;
        }

        public final void setDEBUG_PRINT(boolean bl) {
            DEBUG_PRINT = bl;
        }

        public final boolean getDEBUG_PRINT_MOVE() {
            return DEBUG_PRINT_MOVE;
        }

        public final void setDEBUG_PRINT_MOVE(boolean bl) {
            DEBUG_PRINT_MOVE = bl;
        }

        public final boolean getSIMPLIFIED_ALGORITHM() {
            return SIMPLIFIED_ALGORITHM;
        }

        public final void setSIMPLIFIED_ALGORITHM(boolean bl) {
            SIMPLIFIED_ALGORITHM = bl;
        }

        public final boolean computeNonOverlap(int space, @NotNull List<ButtonPositionSize> buttons, int totalWidth, int totalHeight) {
            ButtonPositionSize it;
            Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
            Iterable $this$forEach$iv = buttons;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ButtonPositionSize)element$iv;
                boolean bl = false;
                it.updateBounds(totalWidth, totalHeight);
            }
            if (this.getDEBUG_PRINT()) {
                LOG.info("---- Layout w=" + totalWidth + " h=" + totalHeight + " spc=" + space);
                $this$forEach$iv = buttons;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (ButtonPositionSize)element$iv;
                    boolean bl = false;
                    LOG.info("Before Button " + it + " " + it.getBounds$OsmAnd_shared());
                }
            }
            int iter = 0;
            int fixedPos = buttons.size() - 1;
            if (this.getSIMPLIFIED_ALGORITHM()) {
                int i = 1;
                while (i < buttons.size()) {
                    if (iter++ > 1000) {
                        Logger.error$default(LOG, "Relayout is broken.", null, 2, null);
                        return false;
                    }
                    boolean movedOnce = false;
                    boolean failMove = false;
                    ButtonPositionSize button2 = buttons.get(i);
                    int ox = button2.getMarginX();
                    int oy = button2.getMarginY();
                    for (int j = i - 1; -1 < j; --j) {
                        ButtonPositionSize check = buttons.get(j);
                        if (!button2.overlap(check)) continue;
                        boolean moved = this.moveButton(space, button2, check, totalWidth, totalHeight);
                        if (!moved) {
                            failMove = true;
                            break;
                        }
                        if (check.getXMove() || check.getYMove()) {
                            ox = button2.getMarginX();
                            oy = button2.getMarginY();
                        }
                        movedOnce = true;
                        if (!this.getDEBUG_PRINT_MOVE()) continue;
                        LOG.info("Move " + button2 + " because " + check + " new bounds " + button2.getBounds$OsmAnd_shared());
                    }
                    if (failMove) {
                        button2.setMarginX(ox);
                        button2.setMarginY(oy);
                        button2.updateBounds(totalWidth, totalHeight);
                        ++i;
                        continue;
                    }
                    if (movedOnce) continue;
                    ++i;
                }
            } else {
                while (fixedPos >= 0) {
                    if (iter++ > 1000) {
                        Logger.error$default(LOG, "Relayout is broken.", null, 2, null);
                        return false;
                    }
                    boolean overlap = false;
                    ButtonPositionSize button = buttons.get(fixedPos);
                    int button2 = buttons.size();
                    for (int i = fixedPos + 1; i < button2; ++i) {
                        boolean moved;
                        ButtonPositionSize check = buttons.get(i);
                        if (!button.overlap(check) || !(moved = this.moveButton(space, check, button, totalWidth, totalHeight))) continue;
                        overlap = true;
                        check.updateBounds(totalWidth, totalHeight);
                        if (this.getDEBUG_PRINT_MOVE()) {
                            LOG.info("Move " + check + " because " + button + " new bounds " + check.getBounds$OsmAnd_shared());
                        }
                        fixedPos = i;
                        break;
                    }
                    if (overlap) continue;
                    --fixedPos;
                }
            }
            if (this.getDEBUG_PRINT()) {
                Iterable $this$forEach$iv2 = buttons;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    ButtonPositionSize it2 = (ButtonPositionSize)element$iv;
                    boolean bl = false;
                    LOG.info("After Button " + it2 + " " + it2.getBounds$OsmAnd_shared());
                }
                LOG.info("++++ Layout w=" + totalWidth + " h=" + totalHeight + " spc=" + space);
            }
            return true;
        }

        private final boolean moveAndCheck(ButtonPositionSize toMove, ButtonPositionSize overlap, int totalWidth, int totalHeight, int mx, int my) {
            toMove.setMarginX(toMove.getMarginX() + mx);
            toMove.setMarginY(toMove.getMarginY() + my);
            toMove.updateBounds(totalWidth, totalHeight);
            return toMove.overlap(overlap);
        }

        private final boolean moveButton(int space, ButtonPositionSize toMove, ButtonPositionSize overlap, int totalWidth, int totalHeight) {
            boolean xMove = false;
            boolean yMove = false;
            if (!toMove.getXMove() && !toMove.getYMove()) {
                return false;
            }
            if (overlap.getMoveDescendants() == 0) {
                if (overlap.getPosH() == 0) {
                    yMove = true;
                } else if (overlap.getPosV() == 0) {
                    xMove = true;
                } else {
                    xMove = toMove.getXMove();
                    yMove = toMove.getYMove();
                }
            } else if (overlap.getMoveDescendants() == 1) {
                yMove = true;
            } else if (overlap.getMoveDescendants() == 2) {
                xMove = true;
            }
            int ox = toMove.getMarginX();
            int oy = toMove.getMarginY();
            boolean ok = false;
            while (!ok && xMove && toMove.getMarginX() <= totalWidth - toMove.getWidth()) {
                if (this.moveAndCheck(toMove, overlap, totalWidth, totalHeight, 1, 0)) continue;
                ok = true;
            }
            if (!ok) {
                toMove.setMarginX(ox);
                toMove.updateBounds(totalWidth, totalHeight);
            }
            while (!ok && yMove && toMove.getMarginY() <= totalHeight - toMove.getHeight()) {
                if (this.moveAndCheck(toMove, overlap, totalWidth, totalHeight, 0, 1)) continue;
                ok = true;
            }
            if (!ok) {
                toMove.setMarginY(oy);
                toMove.updateBounds(totalWidth, totalHeight);
            }
            return ok;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

