/*
 * Decompiled with CFR 0.152.
 */
package net.osmand;

import com.google.gson.JsonObject;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.osmand.PlatformUtil;
import net.osmand.RenderingContext;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.ObfConstants;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.QuadRect;
import net.osmand.render.RenderingRuleSearchRequest;
import net.osmand.render.RenderingRulesStorage;
import net.osmand.router.GeneralRouter;
import net.osmand.router.GpxRouteApproximation;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.router.HHRoutePlanner;
import net.osmand.router.NativeTransportRoutingResult;
import net.osmand.router.RouteCalculationProgress;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.RoutingContext;
import net.osmand.router.TransportRoutingConfiguration;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class NativeLibrary {
    private static final Log log = PlatformUtil.getLog(NativeLibrary.class);

    public NativeSearchResult searchObjectsForRendering(int sleft, int sright, int stop, int sbottom, int zoom, RenderingRuleSearchRequest request, boolean skipDuplicates, Object objectWithInterruptedField, String msgIfNothingFound) {
        int renderRouteDataFile = 0;
        if (request.searchRenderingAttribute("showRoadMapsAttribute")) {
            renderRouteDataFile = request.getIntPropertyValue(request.ALL.R_ATTR_INT_VALUE);
        }
        return new NativeSearchResult(NativeLibrary.searchNativeObjectsForRendering(sleft, sright, stop, sbottom, zoom, request, skipDuplicates, renderRouteDataFile, objectWithInterruptedField, msgIfNothingFound));
    }

    public RouteDataObject[] getDataObjects(NativeRouteSearchResult rs, int x31, int y31) {
        if (rs.nativeHandler == 0L) {
            return new RouteDataObject[0];
        }
        return NativeLibrary.getRouteDataObjects(rs.region.routeReg, rs.nativeHandler, x31, y31);
    }

    public boolean initMapFile(String filePath, boolean useLive) {
        return NativeLibrary.initBinaryMapFile(filePath, useLive, false);
    }

    public boolean initCacheMapFile(String filePath) {
        return NativeLibrary.initCacheMapFiles(filePath);
    }

    public boolean closeMapFile(String filePath) {
        return NativeLibrary.closeBinaryMapFile(filePath);
    }

    public NativeTransportRoutingResult[] runNativePTRouting(int sx31, int sy31, int ex31, int ey31, TransportRoutingConfiguration cfg, RouteCalculationProgress progress) {
        return NativeLibrary.nativeTransportRouting(new int[]{sx31, sy31, ex31, ey31}, cfg, progress);
    }

    public RouteSegmentResult[] runNativeRouting(RoutingContext c, HHRouteDataStructure.HHRoutingConfig hhRoutingConfig, BinaryMapRouteReaderAdapter.RouteRegion[] regions, boolean basemap) {
        if (hhRoutingConfig != null) {
            this.setHHNativeFilterAndParameters(c);
        }
        float CPP_NO_DIRECTION = (float)Math.PI * -2;
        return NativeLibrary.nativeRouting(c, hhRoutingConfig, c.config.initialDirection == null ? (float)Math.PI * -2 : c.config.initialDirection.floatValue(), regions, basemap);
    }

    private void setHHNativeFilterAndParameters(RoutingContext ctx) {
        GeneralRouter gr = (GeneralRouter)ctx.getRouter();
        TreeMap<String, String> tags = HHRoutePlanner.getFilteredTags(gr);
        String[] tm = new String[tags.size() * 2];
        int index = 0;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            tm[index] = entry.getKey();
            tm[index + 1] = entry.getValue();
            index += 2;
        }
        gr.hhNativeFilter = tm;
        int i = 0;
        gr.hhNativeParameterValues = new String[gr.getParameterValues().size() * 2];
        for (Map.Entry<String, String> entry : gr.getParameterValues().entrySet()) {
            gr.hhNativeParameterValues[i++] = entry.getKey();
            gr.hhNativeParameterValues[i++] = entry.getValue();
        }
    }

    public GpxRouteApproximation runNativeSearchGpxRoute(GpxRouteApproximation gCtx, List<RoutePlannerFrontEnd.GpxPoint> gpxPoints, boolean useGeo) {
        BinaryMapRouteReaderAdapter.RouteRegion[] regions = gCtx.ctx.reverseMap.keySet().toArray(new BinaryMapRouteReaderAdapter.RouteRegion[0]);
        int pointsSize = gpxPoints.size();
        NativeGpxPointApproximation[] nativePoints = new NativeGpxPointApproximation[pointsSize];
        for (int i = 0; i < pointsSize; ++i) {
            nativePoints[i] = new NativeGpxPointApproximation(gpxPoints.get(i));
        }
        NativeGpxRouteApproximationResult nativeResult = NativeLibrary.nativeSearchGpxRoute(gCtx.ctx, nativePoints, regions, useGeo);
        for (NativeGpxPointApproximation point : nativeResult.finalPoints) {
            gCtx.finalPoints.add(point.convertToGpxPoint());
        }
        List<RouteSegmentResult> results = nativeResult.result;
        for (RouteSegmentResult rsr : results) {
            this.initRouteRegion(gCtx, rsr);
        }
        gCtx.fullRoute.addAll(results);
        return gCtx;
    }

    private void initRouteRegion(GpxRouteApproximation gCtx, RouteSegmentResult rsr) {
        BinaryMapRouteReaderAdapter.RouteRegion region = rsr.getObject().region;
        if (region == null) {
            BinaryMapRouteReaderAdapter.RouteRegion reg = new BinaryMapRouteReaderAdapter.RouteRegion();
            reg.initRouteEncodingRule(0, "highway", "unmatched");
            RouteDataObject newRdo = new RouteDataObject(reg);
            RouteDataObject rdo = rsr.getObject();
            newRdo.pointsX = rdo.pointsX;
            newRdo.pointsY = rdo.pointsY;
            newRdo.types = rdo.getTypes();
            newRdo.id = -1L;
            rsr.setObject(newRdo);
            return;
        }
        BinaryMapIndexReader reader = gCtx.ctx.reverseMap.get(region);
        if (reader != null) {
            try {
                reader.initRouteRegion(region);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public NativeRouteSearchResult loadRouteRegion(BinaryMapRouteReaderAdapter.RouteSubregion sub, boolean loadObjects) {
        if (sub.routeReg.getFilePointer() > Integer.MAX_VALUE) {
            throw new IllegalStateException("C++ doesn't support files > 2 GB");
        }
        NativeRouteSearchResult lr = NativeLibrary.loadRoutingData(sub.routeReg, sub.routeReg.getName(), (int)sub.routeReg.getFilePointer(), sub, loadObjects);
        if (lr != null && lr.nativeHandler != 0L) {
            lr.region = sub;
        }
        return lr;
    }

    public void clearCachedRenderingRulesStorage() {
        NativeLibrary.clearRenderingRulesStorage();
    }

    protected static native NativeGpxRouteApproximationResult nativeSearchGpxRoute(RoutingContext var0, NativeGpxPointApproximation[] var1, BinaryMapRouteReaderAdapter.RouteRegion[] var2, boolean var3);

    protected static native NativeRouteSearchResult loadRoutingData(BinaryMapRouteReaderAdapter.RouteRegion var0, String var1, int var2, BinaryMapRouteReaderAdapter.RouteSubregion var3, boolean var4);

    public static native void deleteNativeRoutingContext(long var0);

    protected static native void deleteRenderingContextHandle(long var0);

    protected static native void deleteRouteSearchResult(long var0);

    protected static native RouteDataObject[] getRouteDataObjects(BinaryMapRouteReaderAdapter.RouteRegion var0, long var1, int var3, int var4);

    protected static native RouteSegmentResult[] nativeRouting(RoutingContext var0, HHRouteDataStructure.HHRoutingConfig var1, float var2, BinaryMapRouteReaderAdapter.RouteRegion[] var3, boolean var4);

    protected static native NativeTransportRoutingResult[] nativeTransportRouting(int[] var0, TransportRoutingConfiguration var1, RouteCalculationProgress var2);

    protected static native void deleteSearchResult(long var0);

    protected static native boolean initBinaryMapFile(String var0, boolean var1, boolean var2);

    protected static native boolean initCacheMapFiles(String var0);

    protected static native boolean closeBinaryMapFile(String var0);

    protected static native void initRenderingRulesStorage(RenderingRulesStorage var0);

    protected static native void clearRenderingRulesStorage();

    protected static native RenderingGenerationResult generateRenderingIndirect(RenderingContext var0, long var1, boolean var3, RenderingRuleSearchRequest var4, boolean var5);

    protected static native long searchNativeObjectsForRendering(int var0, int var1, int var2, int var3, int var4, RenderingRuleSearchRequest var5, boolean var6, int var7, Object var8, String var9);

    protected static native boolean initFontType(String var0, String var1, boolean var2, boolean var3);

    protected static native RenderedObject[] searchRenderedObjects(RenderingContext var0, int var1, int var2, boolean var3);

    public RenderedObject[] searchRenderedObjectsFromContext(RenderingContext context, int x, int y) {
        return NativeLibrary.searchRenderedObjects(context, x, y, false);
    }

    public RenderedObject[] searchRenderedObjectsFromContext(RenderingContext context, int x, int y, boolean notvisible) {
        return NativeLibrary.searchRenderedObjects(context, x, y, notvisible);
    }

    public boolean needRequestPrivateAccessRouting(RoutingContext ctx, int[] x31Coordinates, int[] y31Coordinates) {
        return NativeLibrary.nativeNeedRequestPrivateAccessRouting(ctx, x31Coordinates, y31Coordinates);
    }

    protected static native boolean nativeNeedRequestPrivateAccessRouting(RoutingContext var0, int[] var1, int[] var2);

    protected static native ByteBuffer getGeotiffTile(String var0, String var1, String var2, int var3, int var4, int var5, int var6, int var7);

    public static boolean loadNewLib(String path) {
        return NativeLibrary.load("OsmAndJNI", path);
    }

    public static boolean loadOldLib(String path) {
        boolean b = true;
        return b &= NativeLibrary.load("osmand", path);
    }

    public static boolean load(String libBaseName, String path) {
        if (path != null && path.length() > 0) {
            try {
                System.out.printf("Loading native library %s...\n ", path + "/" + System.mapLibraryName(libBaseName));
                System.load(path + "/" + System.mapLibraryName(libBaseName));
                return true;
            }
            catch (UnsatisfiedLinkError e) {
                log.error((Object)e);
            }
        }
        String osname = System.getProperty("os.name").toLowerCase();
        String osarch = System.getProperty("os.arch");
        if (osname.startsWith("mac os")) {
            osname = "mac";
            osarch = "universal";
        }
        if (osname.startsWith("windows")) {
            osname = "win";
        }
        if (osname.startsWith("sunos")) {
            osname = "solaris";
        }
        if (osarch.startsWith("i") && osarch.endsWith("86")) {
            osarch = "x86";
        }
        String libname = libBaseName + "-" + osname + "-" + osarch + ".lib";
        try {
            int len;
            ClassLoader cl = NativeLibrary.class.getClassLoader();
            InputStream in = cl.getResourceAsStream(libname);
            if (in == null) {
                log.error((Object)("libname: " + libname + " not found"));
                return false;
            }
            File tmplib = File.createTempFile(libBaseName + "-", ".lib");
            tmplib.deleteOnExit();
            FileOutputStream out = new FileOutputStream(tmplib);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
            System.load(tmplib.getAbsolutePath());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static int ccmp(int lhs, int rhs) {
        return lhs < rhs ? -1 : (lhs == rhs ? 0 : 1);
    }

    public void loadFontData(File dr) {
        File[] lf = dr.listFiles();
        if (lf == null) {
            System.err.println("No fonts loaded from " + dr.getAbsolutePath());
            return;
        }
        ArrayList<File> lst = new ArrayList<File>(Arrays.asList(lf));
        Collections.sort(lst, new Comparator<File>(){

            @Override
            public int compare(File arg0, File arg1) {
                return NativeLibrary.ccmp(this.order(arg0), this.order(arg1));
            }

            private int order(File a) {
                boolean hasNumber;
                String nm = a.getName().toLowerCase();
                boolean bl = hasNumber = Character.isDigit(nm.charAt(0)) && Character.isDigit(nm.charAt(1));
                if (hasNumber) {
                    return Integer.parseInt(nm.substring(0, 2));
                }
                if (nm.contains("NotoSans".toLowerCase())) {
                    return 100;
                }
                return 101;
            }
        });
        for (File f : lst) {
            String name = f.getName();
            if (!name.endsWith(".ttf") && !name.endsWith(".otf") || name.contains("Roboto".toLowerCase())) continue;
            NativeLibrary.initFontType(f.getAbsolutePath(), name.substring(0, name.length() - 4), name.toLowerCase().contains("bold"), name.toLowerCase().contains("italic"));
        }
    }

    public static class NativeSearchResult {
        public long nativeHandler;

        private NativeSearchResult(long nativeHandler) {
            this.nativeHandler = nativeHandler;
        }

        protected void finalize() throws Throwable {
            this.deleteNativeResult();
            super.finalize();
        }

        public void deleteNativeResult() {
            if (this.nativeHandler != 0L) {
                NativeLibrary.deleteSearchResult(this.nativeHandler);
                this.nativeHandler = 0L;
            }
        }
    }

    public static class NativeRouteSearchResult {
        public long nativeHandler;
        public RouteDataObject[] objects;
        public BinaryMapRouteReaderAdapter.RouteSubregion region;

        public NativeRouteSearchResult(long nativeHandler, RouteDataObject[] objects) {
            this.nativeHandler = nativeHandler;
            this.objects = objects;
        }

        protected void finalize() throws Throwable {
            this.deleteNativeResult();
            super.finalize();
        }

        public void deleteNativeResult() {
            if (this.nativeHandler != 0L) {
                NativeLibrary.deleteRouteSearchResult(this.nativeHandler);
                this.nativeHandler = 0L;
            }
        }
    }

    public static class NativeGpxPointApproximation {
        public int ind;
        public double lat;
        public double lon;
        public double cumDist;
        public int targetInd;
        public List<RouteSegmentResult> routeToTarget;

        NativeGpxPointApproximation(RoutePlannerFrontEnd.GpxPoint gpxPoint) {
            this.lat = gpxPoint.loc.getLatitude();
            this.lon = gpxPoint.loc.getLongitude();
            this.cumDist = gpxPoint.cumDist;
        }

        public NativeGpxPointApproximation(int ind, double lat, double lon, double cumDist, int targetInd) {
            this.ind = ind;
            this.lat = lat;
            this.lon = lon;
            this.cumDist = cumDist;
            this.targetInd = targetInd;
            this.routeToTarget = new ArrayList<RouteSegmentResult>();
        }

        public void addRouteToTarget(RouteSegmentResult routeSegmentResult) {
            this.routeToTarget.add(routeSegmentResult);
        }

        public RoutePlannerFrontEnd.GpxPoint convertToGpxPoint() {
            RoutePlannerFrontEnd.GpxPoint point = new RoutePlannerFrontEnd.GpxPoint();
            point.ind = this.ind;
            point.loc = new LatLon(this.lat, this.lon);
            point.cumDist = this.cumDist;
            if (this.routeToTarget.size() > 0 && this.routeToTarget.get((int)0).getObject().region == null) {
                this.fixStraightLineRegion();
            }
            point.targetInd = this.targetInd;
            point.routeToTarget = new ArrayList<RouteSegmentResult>(this.routeToTarget);
            return point;
        }

        private void fixStraightLineRegion() {
            BinaryMapRouteReaderAdapter.RouteRegion reg = new BinaryMapRouteReaderAdapter.RouteRegion();
            reg.initRouteEncodingRule(0, "highway", "unmatched");
            for (int i = 0; i < this.routeToTarget.size(); ++i) {
                RouteDataObject newRdo = new RouteDataObject(reg);
                RouteDataObject rdo = this.routeToTarget.get(i).getObject();
                newRdo.pointsX = rdo.pointsX;
                newRdo.pointsY = rdo.pointsY;
                newRdo.types = rdo.getTypes();
                newRdo.id = -1L;
                this.routeToTarget.get(i).setObject(newRdo);
            }
        }
    }

    public static class NativeGpxRouteApproximationResult {
        public List<NativeGpxPointApproximation> finalPoints = new ArrayList<NativeGpxPointApproximation>();
        public List<RouteSegmentResult> result = new ArrayList<RouteSegmentResult>();

        public void addFinalPoint(NativeGpxPointApproximation finalPoint) {
            this.finalPoints.add(finalPoint);
        }

        public void addResultSegment(RouteSegmentResult routeSegmentResult) {
            this.result.add(routeSegmentResult);
        }
    }

    public static class RenderedObject
    extends MapObject {
        private final Map<String, String> tags = new LinkedHashMap<String, String>();
        private QuadRect bbox = new QuadRect();
        private final TIntArrayList x = new TIntArrayList();
        private final TIntArrayList y = new TIntArrayList();
        private String iconRes;
        private int order;
        private boolean visible;
        private boolean drawOnPath;
        private LatLon labelLatLon;
        private int labelX = 0;
        private int labelY = 0;
        private boolean isPolygon;

        public Map<String, String> getTags() {
            return this.tags;
        }

        public String getTagValue(String tag) {
            return this.getTags().get(tag);
        }

        public boolean isText() {
            return !this.getName().isEmpty();
        }

        public int getOrder() {
            return this.order;
        }

        public void setLabelLatLon(LatLon labelLatLon) {
            this.labelLatLon = labelLatLon;
        }

        public LatLon getLabelLatLon() {
            return this.labelLatLon;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public void addLocation(int x, int y) {
            this.x.add(x);
            this.y.add(y);
        }

        public TIntArrayList getX() {
            return this.x;
        }

        public String getIconRes() {
            return this.iconRes;
        }

        public void setIconRes(String iconRes) {
            this.iconRes = iconRes;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setDrawOnPath(boolean drawOnPath) {
            this.drawOnPath = drawOnPath;
        }

        public boolean isDrawOnPath() {
            return this.drawOnPath;
        }

        public TIntArrayList getY() {
            return this.y;
        }

        public void setBbox(int left, int top, int right, int bottom) {
            this.bbox = new QuadRect(left, top, right, bottom);
        }

        public QuadRect getBbox() {
            return this.bbox;
        }

        public void setNativeId(long id) {
            this.setId(id);
        }

        public void putTag(String t, String v) {
            this.tags.put(t, v);
        }

        public int getLabelX() {
            return this.labelX;
        }

        public int getLabelY() {
            return this.labelY;
        }

        public void setLabelX(int labelX) {
            this.labelX = labelX;
        }

        public void setLabelY(int labelY) {
            this.labelY = labelY;
        }

        public void markAsPolygon(boolean isPolygon) {
            this.isPolygon = isPolygon;
        }

        public boolean isPolygon() {
            return this.isPolygon;
        }

        public boolean isSimplePoint() {
            return this.x.size() == 1 && this.y.size() == 1;
        }

        public List<String> getOriginalNames() {
            ArrayList<String> names = new ArrayList<String>();
            if (!Algorithms.isEmpty(this.name)) {
                names.add(this.name);
            }
            for (Map.Entry<String, String> entry : this.tags.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!key.startsWith("name:") && !key.equals("name") || value.isEmpty()) continue;
                names.add(value);
            }
            return names;
        }

        public String getRouteID() {
            for (Map.Entry<String, String> entry : this.getTags().entrySet()) {
                if (!"route_id".equals(entry.getKey())) continue;
                return entry.getValue();
            }
            return null;
        }

        @Override
        public String toString() {
            String s = this.getClass().getSimpleName() + " " + this.name;
            String link = ObfConstants.getOsmUrlForId(this);
            String tags = ObfConstants.getPrintTags(this);
            s = s + (String)(s.contains(link) ? "" : " " + link);
            s = s + (String)(s.contains(tags) ? "" : " " + tags);
            return s;
        }

        @Override
        public String toStringEn() {
            String s = "MapObject " + this.name + " ";
            s = s + String.valueOf((Object)ObfConstants.getOsmEntityType(this)) + "/";
            s = s + ObfConstants.getOsmObjectId(this);
            if (this.getTags().containsKey("wikidata")) {
                s = s + " " + this.getTags().get("wikidata");
            }
            return s;
        }

        public List<LatLon> getPolygon() {
            ArrayList<LatLon> res = new ArrayList<LatLon>();
            for (int i = 0; i < this.x.size(); ++i) {
                int x = this.x.get(i);
                int y = this.y.get(i);
                LatLon l = new LatLon(MapUtils.get31LatitudeY(y), MapUtils.get31LongitudeX(x));
                res.add(l);
            }
            return res;
        }

        public QuadRect getRectLatLon() {
            int top;
            int left;
            if (this.x.size() == 0) {
                return null;
            }
            int right = left = this.x.get(0);
            int bottom = top = this.y.get(0);
            for (int i = 0; i < this.x.size(); ++i) {
                int x = this.x.get(i);
                int y = this.y.get(i);
                left = Math.min(left, x);
                right = Math.max(right, x);
                top = Math.min(top, y);
                bottom = Math.max(bottom, y);
            }
            return new QuadRect(MapUtils.get31LongitudeX(left), MapUtils.get31LatitudeY(top), MapUtils.get31LongitudeX(right), MapUtils.get31LatitudeY(bottom));
        }

        public LatLon getLatLon() {
            LatLon latLon = this.getLabelLatLon();
            if (latLon == null && this.getLabelX() != 0) {
                latLon = new LatLon(MapUtils.get31LatitudeY(this.getLabelY()), MapUtils.get31LongitudeX(this.getLabelX()));
            }
            QuadRect rect = this.getRectLatLon();
            if (latLon == null && rect != null) {
                latLon = new LatLon(rect.centerY(), rect.centerX());
            }
            return latLon;
        }
    }

    public static class NativeDirectionPoint {
        public int x31;
        public int y31;
        public String[][] tags;

        public NativeDirectionPoint(double lat, double lon, Map<String, String> tags) {
            this.x31 = MapUtils.get31TileNumberX(lon);
            this.y31 = MapUtils.get31TileNumberY(lat);
            this.tags = new String[tags.size()][2];
            int i = 0;
            for (Map.Entry<String, String> e : tags.entrySet()) {
                this.tags[i][0] = e.getKey();
                this.tags[i][1] = e.getValue();
                ++i;
            }
        }
    }

    public static class RenderingGenerationResult {
        public ByteBuffer bitmapBuffer;
        private JsonObject info;

        public RenderingGenerationResult(ByteBuffer bitmap) {
            this.bitmapBuffer = bitmap;
        }

        public RenderingGenerationResult(ByteBuffer bitmap, JsonObject info) {
            this.bitmapBuffer = bitmap;
            this.info = info;
        }

        public JsonObject getInfo() {
            return this.info;
        }

        public void setInfo(JsonObject info) {
            this.info = info;
        }
    }
}

