/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import net.osmand.MapCreatorVersion;
import net.osmand.NativeJavaRendering;
import net.osmand.PlatformUtil;
import net.osmand.data.DataTileManager;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.data.RotatedTileBox;
import net.osmand.map.IMapLocationListener;
import net.osmand.map.ITileSource;
import net.osmand.map.MapTileDownloader;
import net.osmand.map.TileSourceManager;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.io.NetworkUtils;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.routing.RouteColorize;
import net.osmand.swing.DataExtractionSettings;
import net.osmand.swing.MapAddressLayer;
import net.osmand.swing.MapClusterLayer;
import net.osmand.swing.MapDataPrinter;
import net.osmand.swing.MapInformationLayer;
import net.osmand.swing.MapPanelLayer;
import net.osmand.swing.MapPanelSelector;
import net.osmand.swing.MapPointsLayer;
import net.osmand.swing.MapRouterLayer;
import net.osmand.swing.MapTransportLayer;
import net.osmand.swing.Messages;
import net.osmand.swing.NewTileSourceDialog;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;

public class MapPanel
extends JPanel
implements MapTileDownloader.IMapDownloaderCallback {
    private static final long serialVersionUID = 1L;
    private static final int EXPAND_X = 16;
    private static final int EXPAND_Y = 16;
    protected static final Log log = PlatformUtil.getLog(MapPanel.class);
    public static final int divNonLoadedImage = 16;
    private File tilesLocation = null;
    private ITileSource map = TileSourceManager.getMapnikSource();
    private NativeJavaRendering nativeLibRendering;
    private NativeRendererRunnable lastAddedRunnable;
    private Image nativeRenderingImg;
    private NativeJavaRendering.RenderingImageContext lastContext;
    private Rect nativeRect;
    private ThreadPoolExecutor nativeRenderer = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1));
    private int zoom = 1;
    private float mapDensity = 1.0f;
    private double longitude;
    private double latitude;
    private List<IMapLocationListener> listeners = new ArrayList<IMapLocationListener>();
    private List<MapPanelLayer> layers = new ArrayList<MapPanelLayer>();
    private Image[][] images;
    private int xStartingImage = 0;
    private int yStartingImage = 0;
    private MapTileDownloader downloader = MapTileDownloader.getInstance((String)MapCreatorVersion.APP_MAP_CREATOR_VERSION);
    Map<String, Image> cache = new ConcurrentHashMap<String, Image>();
    private final JPopupMenu popupMenu;
    private Point popupMenuPoint;
    private boolean willBePopupShown = false;
    private JTextField statusField;
    private JPanel diffButton;
    private JButton buttonOnlineRendering;
    private MapPanelSelector mapPanelSelector;
    private final MapDataPrinter printer = new MapDataPrinter(this, log);

    public static void main(String[] args) throws IOException {
        MapPanel.showMainWindow(512, 512, null);
    }

    public static MapPanel showMainWindow(int wx, int hy, NativeJavaRendering nativeLib) {
        JFrame frame = new JFrame(Messages.getString("MapPanel.MAP.VIEW"));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final MapPanel panel = new MapPanel(DataExtractionSettings.getSettings().getTilesDirectory());
        panel.nativeLibRendering = nativeLib;
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DataExtractionSettings.getSettings().saveLocation(panel.getLatitude(), panel.getLongitude(), panel.getZoom(), true);
                System.exit(0);
            }
        });
        Container content = frame.getContentPane();
        content.add((Component)panel, "Center");
        JMenuBar bar = new JMenuBar();
        bar.add(MapPanel.getMenuToChooseSource(panel));
        frame.setJMenuBar(bar);
        frame.setSize(wx, hy);
        frame.setVisible(true);
        return panel;
    }

    public MapPanel(File fileWithTiles) {
        this.mapPanelSelector = new MapPanelSelector(this);
        ImageIO.setUseCache(false);
        this.tilesLocation = fileWithTiles;
        this.loadSettingsLocation();
        if (this.map != null) {
            if (this.zoom > this.map.getMaximumZoomSupported()) {
                this.zoom = this.map.getMaximumZoomSupported();
            }
            if (this.zoom < this.map.getMinimumZoomSupported()) {
                this.zoom = this.map.getMinimumZoomSupported();
            }
        }
        this.popupMenu = new JPopupMenu();
        this.downloader.addDownloaderCallback((MapTileDownloader.IMapDownloaderCallback)this);
        this.setFocusable(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MapPanel.this.prepareImage();
            }
        });
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                KeyStroke key2 = KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
                KeyStroke key1 = KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                if (keyStroke.equals(key2)) {
                    if (MapPanel.this.statusField != null) {
                        MapPanel.this.statusField.requestFocus();
                    }
                    return true;
                }
                if (keyStroke.equals(key1)) {
                    if (MapPanel.this.buttonOnlineRendering != null) {
                        MapPanel.this.buttonOnlineRendering.doClick();
                    }
                    return true;
                }
                return false;
            }
        });
        this.setOpaque(false);
        MapMouseAdapter mouse = new MapMouseAdapter();
        this.addMouseListener(mouse);
        this.addMouseMotionListener(mouse);
        this.addMouseWheelListener(mouse);
        this.initDefaultLayers();
    }

    public void applySettings() {
        for (MapPanelLayer layer : this.layers) {
            layer.applySettings();
        }
    }

    public void loadSettingsLocation() {
        LatLon defaultLocation = DataExtractionSettings.getSettings().getDefaultLocation();
        this.latitude = defaultLocation.getLatitude();
        this.longitude = defaultLocation.getLongitude();
        this.zoom = DataExtractionSettings.getSettings().getDefaultZoom();
    }

    public void refresh() {
        this.printer.searchPOIs(false);
        this.prepareImage();
        this.fireMapLocationListeners();
    }

    public void setStatusField(JTextField statusField) {
        this.statusField = statusField;
    }

    private static Map<String, TileSourceManager.TileSourceTemplate> getCommonTemplates(File dir) {
        List list = TileSourceManager.getKnownSourceTemplates();
        LinkedHashMap<String, TileSourceManager.TileSourceTemplate> map = new LinkedHashMap<String, TileSourceManager.TileSourceTemplate>();
        for (TileSourceManager.TileSourceTemplate t : list) {
            map.put(t.getName(), t);
        }
        if (!dir.isDirectory()) {
            return map;
        }
        for (File f : dir.listFiles()) {
            if (!f.isDirectory()) continue;
            if (map.containsKey(f.getName())) {
                if (TileSourceManager.isTileSourceMetaInfoExist((File)f)) {
                    map.put(f.getName(), TileSourceManager.createTileSourceTemplate((File)f));
                    continue;
                }
                try {
                    TileSourceManager.createMetaInfoFile((File)f, (TileSourceManager.TileSourceTemplate)((TileSourceManager.TileSourceTemplate)map.get(f.getName())), (boolean)false);
                }
                catch (IOException iOException) {}
                continue;
            }
            map.put(f.getName(), TileSourceManager.createTileSourceTemplate((File)f));
        }
        return map;
    }

    public static JMenu getMenuToChooseSource(final MapPanel panel) {
        JCheckBoxMenuItem menuItem;
        JMenu tiles = new JMenu(Messages.getString("MapPanel.SOURCE.OF.TILES"));
        JMenu downloadedMenu = new JMenu("Additional");
        final File tilesDirectory = DataExtractionSettings.getSettings().getTilesDirectory();
        Map<String, TileSourceManager.TileSourceTemplate> udf = MapPanel.getCommonTemplates(tilesDirectory);
        List downloaded = TileSourceManager.downloadTileSourceTemplates((String)MapCreatorVersion.APP_VERSION, (boolean)false);
        final IdentityHashMap<TileSourceManager.TileSourceTemplate, JCheckBoxMenuItem> items = new IdentityHashMap<TileSourceManager.TileSourceTemplate, JCheckBoxMenuItem>();
        tiles.add(downloadedMenu);
        for (final TileSourceManager.TileSourceTemplate tileSourceTemplate : udf.values()) {
            if (tileSourceTemplate == null) continue;
            menuItem = new JCheckBoxMenuItem(tileSourceTemplate.getName());
            tiles.add(menuItem);
            items.put(tileSourceTemplate, menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (Map.Entry es : items.entrySet()) {
                        ((JCheckBoxMenuItem)es.getValue()).setSelected(tileSourceTemplate.equals(es.getKey()));
                    }
                    File dir = new File(tilesDirectory, tileSourceTemplate.getName());
                    try {
                        dir.mkdirs();
                        TileSourceManager.createMetaInfoFile((File)dir, (TileSourceManager.TileSourceTemplate)tileSourceTemplate, (boolean)false);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    panel.setMapName((ITileSource)tileSourceTemplate);
                }
            });
        }
        if (downloaded != null) {
            for (final TileSourceManager.TileSourceTemplate tileSourceTemplate : downloaded) {
                if (tileSourceTemplate == null) continue;
                menuItem = new JCheckBoxMenuItem(tileSourceTemplate.getName());
                downloadedMenu.add(menuItem);
                items.put(tileSourceTemplate, menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (Map.Entry es : items.entrySet()) {
                            ((JCheckBoxMenuItem)es.getValue()).setSelected(tileSourceTemplate.equals(es.getKey()));
                        }
                        File dir = new File(tilesDirectory, tileSourceTemplate.getName());
                        try {
                            dir.mkdirs();
                            TileSourceManager.createMetaInfoFile((File)dir, (TileSourceManager.TileSourceTemplate)tileSourceTemplate, (boolean)true);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        panel.setMapName((ITileSource)tileSourceTemplate);
                    }
                });
            }
        }
        for (Map.Entry entry : items.entrySet()) {
            if (!Algorithms.objectEquals((Object)panel.getMap(), entry.getKey())) continue;
            ((JCheckBoxMenuItem)entry.getValue()).setSelected(true);
        }
        tiles.addSeparator();
        tiles.add(MapPanel.createNewTileSourceAction(panel, tiles, items));
        return tiles;
    }

    private static AbstractAction createNewTileSourceAction(final MapPanel panel, final JMenu tiles, final Map<TileSourceManager.TileSourceTemplate, JCheckBoxMenuItem> items) {
        return new AbstractAction(Messages.getString("MapPanel.NEW.TILE.SRC")){
            private static final long serialVersionUID = -8286622335859339130L;

            @Override
            public void actionPerformed(ActionEvent e) {
                NewTileSourceDialog dlg = new NewTileSourceDialog(panel);
                dlg.showDialog();
                final TileSourceManager.TileSourceTemplate l = dlg.getTileSourceTemplate();
                if (l != null) {
                    JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(l.getName());
                    tiles.add(menuItem);
                    items.put(l, menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            for (Map.Entry es : items.entrySet()) {
                                ((JCheckBoxMenuItem)es.getValue()).setSelected(l.equals(es.getKey()));
                            }
                            panel.setMapName((ITileSource)l);
                        }
                    });
                    for (Map.Entry es : items.entrySet()) {
                        ((JCheckBoxMenuItem)es.getValue()).setSelected(l.equals(es.getKey()));
                    }
                    panel.setMapName((ITileSource)l);
                }
            }
        };
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (!flag) {
            this.downloader.removeDownloaderCallback((MapTileDownloader.IMapDownloaderCallback)this);
        } else {
            this.downloader.addDownloaderCallback((MapTileDownloader.IMapDownloaderCallback)this);
        }
    }

    public double getXTile() {
        return MapUtils.getTileNumberX((float)this.zoom, (double)this.longitude);
    }

    public double getYTile() {
        return MapUtils.getTileNumberY((float)this.zoom, (double)this.latitude);
    }

    public double getTileSize() {
        return 256.0f * this.mapDensity;
    }

    public QuadRect getLatLonBBox() {
        double xTileLeft = this.getXTile() - this.getCenterPointX() / this.getTileSize();
        double xTileRight = this.getXTile() + this.getCenterPointX() / this.getTileSize();
        double yTileUp = this.getYTile() - this.getCenterPointY() / this.getTileSize();
        double yTileDown = this.getYTile() + this.getCenterPointY() / this.getTileSize();
        QuadRect qr = new QuadRect();
        qr.left = MapUtils.getLongitudeFromTile((double)this.zoom, (double)xTileLeft);
        qr.top = MapUtils.getLatitudeFromTile((float)this.zoom, (double)yTileUp);
        qr.right = MapUtils.getLongitudeFromTile((double)this.zoom, (double)xTileRight);
        qr.bottom = MapUtils.getLatitudeFromTile((float)this.zoom, (double)yTileDown);
        return qr;
    }

    public QuadRect getLatLonPoiBBox(int x, int y) {
        RotatedTileBox.RotatedTileBoxBuilder bld = new RotatedTileBox.RotatedTileBoxBuilder();
        RotatedTileBox rotatedTileBox = bld.setPixelDimensions(this.getWidth(), this.getHeight()).setLocation(this.latitude, this.longitude).setZoom(this.zoom).build();
        rotatedTileBox.setMapDensity((double)this.mapDensity);
        int searchRadius = (int)((double)rotatedTileBox.getDefaultRadiusPoi() * 1.5);
        LatLon minLatLon = rotatedTileBox.getLatLonFromPixel((float)(x - searchRadius), (float)(y - searchRadius));
        LatLon maxLatLon = rotatedTileBox.getLatLonFromPixel((float)(x + searchRadius), (float)(y + searchRadius));
        return new QuadRect(minLatLon.getLongitude(), minLatLon.getLatitude(), maxLatLon.getLongitude(), maxLatLon.getLatitude());
    }

    public int getMapXForPoint(double longitude) {
        double tileX = MapUtils.getTileNumberX((float)this.zoom, (double)longitude);
        return (int)((tileX - this.getXTile()) * this.getTileSize() + this.getCenterPointX());
    }

    public double getCenterPointX() {
        return (double)this.getWidth() / 2.0;
    }

    public int getMapYForPoint(double latitude) {
        double tileY = MapUtils.getTileNumberY((float)this.zoom, (double)latitude);
        return (int)((tileY - this.getYTile()) * this.getTileSize() + this.getCenterPointY());
    }

    public double getCenterPointY() {
        return (double)this.getHeight() / 2.0;
    }

    public NativeJavaRendering getNativeLibrary() {
        return this.nativeLibRendering;
    }

    public void setNativeLibrary(NativeJavaRendering nl) {
        this.nativeLibRendering = nl;
        this.fullMapRedraw();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.nativeLibRendering != null) {
            if (this.nativeRect != null && this.zoom == this.nativeRect.nativeZoom) {
                double xTileLeft = this.getXTile() - (double)this.getWidth() / (2.0 * this.getTileSize());
                double yTileUp = this.getYTile() - (double)this.getHeight() / (2.0 * this.getTileSize());
                int shx = (int)(-xTileLeft * this.getTileSize() + (double)this.nativeRect.left31 / (MapUtils.getPowZoom((double)(31 - this.zoom - 8)) / (double)this.mapDensity));
                int shy = (int)(-yTileUp * this.getTileSize() + (double)this.nativeRect.top31 / (MapUtils.getPowZoom((double)(31 - this.zoom - 8)) / (double)this.mapDensity));
                g.drawImage(this.nativeRenderingImg, shx, shy, this);
            }
        } else if (this.images != null) {
            for (int i = 0; i < this.images.length; ++i) {
                for (int j = 0; j < this.images[i].length; ++j) {
                    if (this.images[i][j] == null) {
                        int div = 16;
                        double tileDiv = this.getTileSize() / (double)div;
                        for (int k1 = 0; k1 < div; ++k1) {
                            for (int k2 = 0; k2 < div; ++k2) {
                                if ((k1 + k2) % 2 == 0) {
                                    g.setColor(Color.gray);
                                } else {
                                    g.setColor(Color.white);
                                }
                                g.fillRect((int)((double)i * this.getTileSize() + (double)this.xStartingImage + (double)k1 * tileDiv), (int)((double)j * this.getTileSize() + (double)this.yStartingImage + (double)k2 * tileDiv), (int)tileDiv, (int)tileDiv);
                            }
                        }
                        continue;
                    }
                    g.drawImage(this.images[i][j], (int)((double)i * this.getTileSize() + (double)this.xStartingImage), (int)((double)j * this.getTileSize() + (double)this.yStartingImage), (int)this.getTileSize(), (int)this.getTileSize(), this);
                }
            }
        }
        this.updateMapDiffs((Graphics2D)g, false);
        for (MapPanelLayer l : this.layers) {
            l.paintLayer((Graphics2D)g);
        }
        if (this.getSelectionArea().isVisible()) {
            g.setColor(new Color(0, 0, 230, 50));
            Rectangle r = this.getSelectionArea().getSelectedArea();
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        super.paintComponent(g);
        if (this.statusField != null) {
            this.statusField.setText("http://www.openstreetmap.org/#map=" + this.zoom + "/" + (float)this.latitude + "/" + (float)this.longitude);
        }
    }

    private void updateMapDiffs(final Graphics2D g, boolean delete) {
        NativeJavaRendering.MapDiff md;
        NativeJavaRendering.MapDiff mapDiff = md = this.nativeLibRendering != null ? this.nativeLibRendering.getMapDiffs(this.latitude, this.longitude) : null;
        if (md == null || this.zoom < 13 || delete) {
            if (this.diffButton != null) {
                this.remove(this.diffButton);
                this.diffButton = null;
            }
        } else if (this.diffButton == null) {
            this.diffButton = new JPanel();
            this.diffButton.setLayout(new BoxLayout(this.diffButton, 0));
            this.diffButton.setOpaque(false);
            this.diffButton.add(Box.createHorizontalGlue());
            JPanel vertLayout = new JPanel();
            vertLayout.setLayout(new BoxLayout(vertLayout, 1));
            vertLayout.setOpaque(false);
            JCheckBox ch = new JCheckBox(md.baseName);
            ch.setSelected(md.enableBaseMap);
            ch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapPanel.this.nativeLibRendering.enableBaseFile(md, !md.enableBaseMap);
                    MapPanel.this.fullMapRedraw();
                }
            });
            ch.setAlignmentX(1.0f);
            vertLayout.add(ch);
            JButton downloadDiffs = new JButton("Download live");
            downloadDiffs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapPanel.this.downloadDiffs(g, md);
                }
            });
            downloadDiffs.setAlignmentX(1.0f);
            vertLayout.add(downloadDiffs);
            if (md.diffs.size() > 0) {
                ButtonGroup bG = new ButtonGroup();
                this.addButton(bG, md.baseName, vertLayout, md, "base");
                for (String s : md.diffs.keySet()) {
                    this.addButton(bG, s, vertLayout, md, null);
                }
            }
            this.diffButton.add(vertLayout);
            this.add(this.diffButton);
            this.revalidate();
        }
    }

    protected void downloadDiffs(Graphics2D g, NativeJavaRendering.MapDiff md) {
        try {
            String url = "https://download.osmand.net/check_live?aosmc=true&timestamp=" + md.timestamp + "&file=" + URLEncoder.encode(md.baseName, StandardCharsets.UTF_8.toString());
            System.out.println("Loading " + url);
            HttpURLConnection conn = NetworkUtils.getHttpURLConnection((String)url);
            XmlPullParser parser = PlatformUtil.newXMLPullParser();
            parser.setInput(conn.getInputStream(), "UTF-8");
            TreeMap<String, Long> updateFiles = new TreeMap<String, Long>();
            while (parser.next() != 1) {
                if (parser.getEventType() != 2 || !parser.getName().equals("update") || parser.getAttributeValue("", "name").endsWith("00.obf.gz")) continue;
                updateFiles.put(parser.getAttributeValue("", "name"), Long.parseLong(parser.getAttributeValue("", "timestamp")));
            }
            conn.disconnect();
            File dir = new File(DataExtractionSettings.getSettings().getBinaryFilesDir());
            for (String file : updateFiles.keySet()) {
                long time = (Long)updateFiles.get(file);
                File targetFile = new File(dir, file.substring(0, file.length() - 3));
                if (targetFile.exists() && targetFile.lastModified() == time) continue;
                String nurl = "https://download.osmand.net/download?aosmc=yes&" + md.timestamp + "&file=" + URLEncoder.encode(file, StandardCharsets.UTF_8.toString());
                System.out.println("Loading " + nurl);
                HttpURLConnection c = NetworkUtils.getHttpURLConnection((String)nurl);
                GZIPInputStream gzip = new GZIPInputStream(c.getInputStream());
                FileOutputStream fout = new FileOutputStream(targetFile);
                Algorithms.streamCopy((InputStream)gzip, (OutputStream)fout);
                gzip.close();
                fout.close();
                targetFile.setLastModified(time);
                this.nativeLibRendering.closeMapFile(targetFile.getAbsolutePath());
                this.nativeLibRendering.initMapFile(targetFile.getAbsolutePath(), true);
            }
            this.updateMapDiffs(g, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addButton(ButtonGroup bG, final String s, JPanel parent, final NativeJavaRendering.MapDiff md, String name) {
        boolean selected = s.equals(md.selected);
        JRadioButton m = new JRadioButton(name == null ? s.replace('_', ' ') : name);
        bG.add(m);
        m.setAlignmentX(1.0f);
        parent.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapPanel.this.nativeLibRendering.enableMapFile(md, s);
                MapPanel.this.fullMapRedraw();
            }
        });
        m.setSelected(selected);
    }

    public void fullMapRedraw() {
        this.lastAddedRunnable = null;
        this.prepareImage();
        this.repaint();
    }

    public File getTilesLocation() {
        return this.tilesLocation;
    }

    public void setTilesLocation(File tilesLocation) {
        this.tilesLocation = tilesLocation;
        this.cache.clear();
        this.prepareImage();
    }

    public String getFileForImage(int x, int y, int zoom, String ext) {
        return this.map.getName() + "/" + zoom + "/" + x + "/" + y + ext + ".tile";
    }

    public Image getImageFor(int x, int y, int zoom, boolean loadIfNeeded) throws IOException {
        if (this.map == null) {
            return null;
        }
        long pz = (long)MapUtils.getPowZoom((double)zoom);
        while (x < 0) {
            x = (int)((long)x + pz);
        }
        while ((long)x >= pz) {
            x = (int)((long)x - pz);
        }
        while (y < 0) {
            y = (int)((long)y + pz);
        }
        while ((long)y >= pz) {
            y = (int)((long)y - pz);
        }
        String file = this.getFileForImage(x, y, zoom, this.map.getTileFormat());
        if (this.cache.get(file) == null) {
            File en = new File(this.tilesLocation, file);
            if (this.cache.size() > 100) {
                ArrayList<String> list = new ArrayList<String>(this.cache.keySet());
                for (int i = 0; i < list.size(); i += 2) {
                    Image remove = this.cache.remove(list.get(i));
                    if (remove == null) continue;
                    remove.flush();
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Before running gc on map tiles. Total Memory : " + (Runtime.getRuntime().totalMemory() >> 20) + " Mb. Used memory : " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() >> 20) + " Mb"));
                }
                System.gc();
                if (log.isInfoEnabled()) {
                    log.info((Object)("After running gc on map tiles. Total Memory : " + (Runtime.getRuntime().totalMemory() >> 20) + " Mb. Used memory : " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() >> 20) + " Mb"));
                }
            }
            if (!this.downloader.isFileCurrentlyDownloaded(en)) {
                String urlToLoad;
                if (en.exists()) {
                    try {
                        this.cache.put(file, ImageIO.read(en));
                    }
                    catch (IIOException e) {
                        log.error((Object)("Eror reading png " + x + " " + y + " zoom : " + zoom), (Throwable)e);
                    }
                }
                if (loadIfNeeded && this.cache.get(file) == null && (urlToLoad = this.map.getUrlToLoad(x, y, zoom)) != null) {
                    this.downloader.requestToDownload(new MapTileDownloader.DownloadRequest(urlToLoad, en, null, x, y, zoom));
                }
            }
        }
        return this.cache.get(file);
    }

    public void tileDownloaded(MapTileDownloader.DownloadRequest request) {
        if (request == null) {
            this.prepareRasterImage(false);
            return;
        }
        double tileSize = this.getTileSize();
        double xTileLeft = this.getXTile() - (double)this.getSize().width / (2.0 * tileSize);
        double yTileUp = this.getYTile() - (double)this.getSize().height / (2.0 * tileSize);
        int i = request.xTile - (int)xTileLeft;
        int j = request.yTile - (int)yTileUp;
        if (request.zoom == this.zoom && i >= 0 && i < this.images.length && j >= 0 && j < this.images[i].length) {
            try {
                this.images[i][j] = this.getImageFor(request.xTile, request.yTile, this.zoom, false);
                this.repaint();
            }
            catch (IOException e) {
                log.error((Object)("Eror reading png " + request.xTile + " " + request.yTile + " zoom : " + this.zoom), (Throwable)e);
            }
        }
    }

    public void prepareImage() {
        if (this.nativeLibRendering != null) {
            this.prepareNativeImage();
        } else {
            this.prepareRasterImage(DataExtractionSettings.getSettings().useInternetToLoadImages());
        }
    }

    private synchronized void prepareNativeImage() {
        NativeRendererRunnable runnable = new NativeRendererRunnable(this.getWidth(), this.getHeight());
        if (this.lastAddedRunnable == null || !this.lastAddedRunnable.contains(runnable)) {
            this.lastAddedRunnable = runnable;
            this.nativeRenderer.getQueue().clear();
            this.nativeRenderer.execute(runnable);
        }
        for (MapPanelLayer l : this.layers) {
            l.prepareToDraw();
        }
        this.repaint();
    }

    private void prepareRasterImage(boolean loadNecessaryImages) {
        try {
            double tileSize = this.getTileSize();
            if (this.images != null) {
                for (int i = 0; i < this.images.length; ++i) {
                    for (int j = 0; j < this.images[i].length; ++j) {
                    }
                }
            }
            double xTileLeft = this.getXTile() - this.getCenterPointX() / tileSize;
            double xTileRight = this.getXTile() + this.getCenterPointX() / tileSize;
            double yTileUp = this.getYTile() - this.getCenterPointY() / tileSize;
            double yTileDown = this.getYTile() + this.getCenterPointY() / tileSize;
            int ixTileLeft = (int)Math.floor(xTileLeft);
            int iyTileUp = (int)Math.floor(yTileUp);
            int ixTileRight = (int)Math.ceil(xTileRight);
            int iyTileDown = (int)Math.ceil(yTileDown);
            this.xStartingImage = -((int)((xTileLeft - (double)ixTileLeft) * tileSize));
            this.yStartingImage = -((int)((yTileUp - (double)iyTileUp) * tileSize));
            if (loadNecessaryImages) {
                this.downloader.refuseAllPreviousRequests();
            }
            int tileXCount = ixTileRight - ixTileLeft;
            int tileYCount = iyTileDown - iyTileUp;
            this.images = new BufferedImage[tileXCount][tileYCount];
            for (int i = 0; i < this.images.length; ++i) {
                for (int j = 0; j < this.images[i].length; ++j) {
                    int x = ixTileLeft + i;
                    int y = iyTileUp + j;
                    this.images[i][j] = this.getImageFor(x, y, this.zoom, loadNecessaryImages);
                }
            }
            for (MapPanelLayer l : this.layers) {
                l.prepareToDraw();
            }
            this.repaint();
        }
        catch (IOException e) {
            log.error((Object)"Eror reading png preparing images");
        }
    }

    public int getMaximumZoomSupported() {
        if (this.nativeLibRendering != null) {
            return 21;
        }
        if (this.map == null) {
            return 18;
        }
        return this.map.getMaximumZoomSupported();
    }

    public int getMinimumZoomSupported() {
        if (this.nativeLibRendering != null || this.map == null) {
            return 1;
        }
        return this.map.getMinimumZoomSupported();
    }

    public void setMapDensity(float mapDensity) {
        this.mapDensity = mapDensity;
        this.prepareImage();
    }

    public void setZoom(int zoom) {
        if (this.map != null && (zoom > this.getMaximumZoomSupported() || zoom < this.getMinimumZoomSupported())) {
            return;
        }
        this.zoom = zoom;
        this.refresh();
    }

    public void setLatLon(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.refresh();
        DataExtractionSettings.getSettings().saveLocation(latitude, longitude, this.zoom, false);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int getZoom() {
        return this.zoom;
    }

    public float getMapDensity() {
        return this.mapDensity;
    }

    public MapPanelSelector.MapSelectionArea getSelectionArea() {
        return this.mapPanelSelector.getSelectionArea();
    }

    public ITileSource getMap() {
        return this.map;
    }

    public void setMapName(ITileSource map) {
        if (!map.couldBeDownloadedFromInternet()) {
            JOptionPane.showMessageDialog(this, "That map is not downloadable from internet");
        }
        this.map = map;
        if (map.getMaximumZoomSupported() < this.zoom) {
            this.zoom = map.getMaximumZoomSupported();
        }
        if (map.getMinimumZoomSupported() > this.zoom) {
            this.zoom = map.getMinimumZoomSupported();
        }
        this.prepareImage();
    }

    public void addMapLocationListener(IMapLocationListener l) {
        this.listeners.add(l);
    }

    public void removeMapLocationListener(IMapLocationListener l) {
        this.listeners.remove(l);
    }

    protected void fireMapLocationListeners() {
        for (IMapLocationListener l : this.listeners) {
            l.locationChanged(this.latitude, this.longitude, null);
        }
    }

    public List<MapPanelLayer> getLayers() {
        return this.layers;
    }

    protected void initDefaultLayers() {
        MapInformationLayer mapInformationLayer = new MapInformationLayer();
        MapRouterLayer mapRouterLayer = new MapRouterLayer();
        this.addLayer(mapInformationLayer);
        this.addLayer(mapRouterLayer);
        this.addLayer(new MapTransportLayer());
        this.addLayer(new MapPointsLayer());
        this.addLayer(new MapAddressLayer());
        this.addLayer(new MapClusterLayer());
        mapInformationLayer.addSetStartActionListener(mapRouterLayer.setStartActionListener);
        mapInformationLayer.addSetEndActionListener(mapRouterLayer.setEndActionListener);
        this.fillPopupActions();
    }

    public void fillPopupActions() {
        this.getPopupMenu().removeAll();
        for (MapPanelLayer l : this.layers) {
            l.fillPopupMenuWithActions(this.getPopupMenu());
        }
    }

    public void addLayer(MapPanelLayer l) {
        l.initLayer(this);
        this.layers.add(l);
    }

    public void addLayer(int ind, MapPanelLayer l) {
        l.initLayer(this);
        this.layers.add(ind, l);
    }

    public boolean removeLayer(MapPanelLayer l) {
        return this.layers.remove(l);
    }

    public <T extends MapPanelLayer> T getLayer(Class<T> cl) {
        for (MapPanelLayer l : this.layers) {
            if (!cl.isInstance(l)) continue;
            return (T)l;
        }
        return null;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        boolean processed = false;
        if (e.getID() == 402) {
            if (e.getKeyCode() == 37) {
                this.longitude = MapUtils.getLongitudeFromTile((double)((double)this.zoom + Math.log(this.mapDensity) / Math.log(2.0)), (double)(this.getXTile() - 0.5));
                processed = true;
            } else if (e.getKeyCode() == 39) {
                this.longitude = MapUtils.getLongitudeFromTile((double)((double)this.zoom + Math.log(this.mapDensity) / Math.log(2.0)), (double)(this.getXTile() + 0.5));
                processed = true;
            } else if (e.getKeyCode() == 38) {
                this.latitude = MapUtils.getLatitudeFromTile((float)((float)((double)this.zoom + Math.log(this.mapDensity) / Math.log(2.0))), (double)(this.getYTile() - 0.5));
                processed = true;
            } else if (e.getKeyCode() == 40) {
                this.latitude = MapUtils.getLatitudeFromTile((float)((float)((double)this.zoom + Math.log(this.mapDensity) / Math.log(2.0))), (double)(this.getYTile() + 0.5));
                processed = true;
            }
        }
        if (e.getID() == 400) {
            if (e.getKeyChar() == '+' || e.getKeyChar() == '=') {
                if (this.zoom < this.getMaximumZoomSupported()) {
                    ++this.zoom;
                    processed = true;
                }
            } else if (e.getKeyChar() == '-' && this.zoom > this.getMinimumZoomSupported()) {
                --this.zoom;
                processed = true;
            }
        }
        if (processed) {
            e.consume();
            this.refresh();
        }
        super.processKeyEvent(e);
    }

    public DataTileManager<Entity> getPoints() {
        return this.getLayer(MapPointsLayer.class).getPoints();
    }

    public void setPoints(DataTileManager<Entity> points) {
        this.getLayer(MapPointsLayer.class).setPoints(points);
        this.prepareImage();
    }

    public void setColorizationType(GpxFile gpxFile, RouteColorize.ColorizationType colorizationType, boolean grey) {
        this.getLayer(MapPointsLayer.class).setColorizationType(gpxFile, colorizationType, grey);
        this.repaint();
    }

    public Point getPopupMenuPoint() {
        return this.popupMenuPoint;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setOnlineRendering(JButton buttonOnlineRendering) {
        this.buttonOnlineRendering = buttonOnlineRendering;
    }

    public MapDataPrinter getPrinter() {
        return this.printer;
    }

    public class MapMouseAdapter
    extends MouseAdapter {
        private Point startDragging = null;
        private Point startSelecting = null;

        @Override
        public void mouseClicked(MouseEvent e) {
            MapPanel.this.requestFocus();
            MapPanel.this.printer.searchAndPrintObjects(e);
            MapPanel.this.printer.clearPOIs();
        }

        public void dragTo(Point p) {
            double dx = ((double)this.startDragging.x - (double)p.x) / MapPanel.this.getTileSize();
            double dy = ((double)this.startDragging.y - (double)p.y) / MapPanel.this.getTileSize();
            double lat = MapUtils.getLatitudeFromTile((float)MapPanel.this.zoom, (double)(MapPanel.this.getYTile() + dy));
            double lon = MapUtils.getLongitudeFromTile((double)MapPanel.this.zoom, (double)(MapPanel.this.getXTile() + dx));
            MapPanel.this.setLatLon(lat, lon);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MapPanel.this.willBePopupShown = false;
            if (this.startDragging != null && Math.abs(e.getPoint().x - this.startDragging.x) + Math.abs(e.getPoint().y - this.startDragging.y) >= 8) {
                this.dragTo(e.getPoint());
                this.startDragging = e.getPoint();
            }
            if (this.startSelecting != null) {
                MapPanel.this.getSelectionArea().setSelectedArea(this.startSelecting.x, this.startSelecting.y, e.getPoint().x, e.getPoint().y);
                MapPanel.this.updateUI();
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            double dy = (double)e.getPoint().y - MapPanel.this.getCenterPointY();
            double dx = (double)e.getPoint().x - MapPanel.this.getCenterPointX();
            double lat = MapUtils.getLatitudeFromTile((float)MapPanel.this.zoom, (double)(MapPanel.this.getYTile() + dy / MapPanel.this.getTileSize()));
            double lon = MapUtils.getLongitudeFromTile((double)MapPanel.this.zoom, (double)(MapPanel.this.getXTile() + dx / MapPanel.this.getTileSize()));
            MapPanel.this.setLatLon(lat, lon);
            if (e.getWheelRotation() < 0) {
                MapPanel.this.setZoom(MapPanel.this.getZoom() + 1);
            } else if (e.getWheelRotation() > 0) {
                MapPanel.this.setZoom(MapPanel.this.getZoom() - 1);
            }
            lat = MapUtils.getLatitudeFromTile((float)MapPanel.this.zoom, (double)(MapPanel.this.getYTile() - dy / MapPanel.this.getTileSize()));
            lon = MapUtils.getLongitudeFromTile((double)MapPanel.this.zoom, (double)(MapPanel.this.getXTile() - dx / MapPanel.this.getTileSize()));
            MapPanel.this.setLatLon(lat, lon);
            super.mouseWheelMoved(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                if (this.startDragging == null) {
                    this.startDragging = e.getPoint();
                }
            } else if (e.getButton() == 1) {
                this.startSelecting = e.getPoint();
            }
            MapPanel.this.willBePopupShown = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 3 && this.startDragging != null) {
                this.dragTo(e.getPoint());
                MapPanel.this.fireMapLocationListeners();
                this.startDragging = null;
            }
            if (e.getButton() == 1) {
                if (this.startSelecting != null) {
                    MapPanel.this.getSelectionArea().setSelectedArea(this.startSelecting.x, this.startSelecting.y, e.getPoint().x, e.getPoint().y);
                    this.startSelecting = null;
                }
                if (MapPanel.this.getSelectionArea().getSelectedArea().getWidth() < 4.0 && MapPanel.this.getSelectionArea().getSelectedArea().getHeight() < 4.0 && MapPanel.this.lastContext != null && MapPanel.this.zoom == MapPanel.this.lastContext.zoom) {
                    MapPanel.this.mapPanelSelector.select(MapPanel.this.lastContext, e);
                }
            }
            if (MapPanel.this.willBePopupShown && (e.isPopupTrigger() || e.getButton() == 3)) {
                MapPanel.this.popupMenuPoint = new Point(e.getX(), e.getY());
                MapPanel.this.popupMenu.show(MapPanel.this, e.getX(), e.getY());
                MapPanel.this.willBePopupShown = false;
            }
            super.mouseReleased(e);
        }
    }

    private class Rect {
        int left31;
        int top31;
        int nativeZoom;

        private Rect() {
        }
    }

    class NativeRendererRunnable
    implements Runnable {
        int sleft;
        int sright;
        int stop;
        int sbottom;
        int oright;
        int oleft;
        int otop;
        int obottom;
        int z;
        final int cf;

        public NativeRendererRunnable(int w, int h) {
            LatLon latLon = new LatLon(MapPanel.this.latitude, MapPanel.this.longitude);
            this.z = MapPanel.this.zoom;
            this.cf = (int)(MapUtils.getPowZoom((double)(31 - this.z - 8)) / (double)MapPanel.this.mapDensity);
            int minTile = 1;
            int mxTile = Integer.MAX_VALUE;
            this.oleft = MapUtils.get31TileNumberX((double)latLon.getLongitude()) - w / 2 * this.cf;
            this.oright = MapUtils.get31TileNumberX((double)latLon.getLongitude()) + w / 2 * this.cf;
            this.otop = MapUtils.get31TileNumberY((double)latLon.getLatitude()) - h / 2 * this.cf;
            this.obottom = MapUtils.get31TileNumberY((double)latLon.getLatitude()) + h / 2 * this.cf;
            this.sleft = this.oleft - 16 * this.cf;
            this.sright = this.oright + 16 * this.cf;
            this.stop = this.otop - 16 * this.cf;
            this.sbottom = this.obottom + 16 * this.cf;
            if (this.sleft < minTile) {
                this.sleft = minTile;
            }
            if (this.sright > mxTile || this.sright < 0) {
                this.sright = mxTile;
            }
            if (this.stop < minTile) {
                this.stop = minTile;
            }
            if (this.sbottom > mxTile || this.sbottom < 0) {
                this.sbottom = mxTile;
            }
        }

        public boolean contains(NativeRendererRunnable r) {
            if (r.oright > this.sright || r.oleft < this.sleft || r.otop < this.stop || r.obottom > this.sbottom) {
                return false;
            }
            return r.z == this.z;
        }

        @Override
        public void run() {
            if (MapPanel.this.nativeRenderer.getQueue().isEmpty()) {
                try {
                    MapPanel.this.lastContext = new NativeJavaRendering.RenderingImageContext(this.sleft, this.sright, this.stop, this.sbottom, MapPanel.this.zoom);
                    NativeJavaRendering.RenderingImageResult result = MapPanel.this.nativeLibRendering.renderImage(MapPanel.this.lastContext);
                    MapPanel.this.nativeRenderingImg = result.getImage();
                    Rect rect = new Rect();
                    rect.left31 = this.sleft;
                    rect.top31 = this.stop;
                    rect.nativeZoom = this.z;
                    MapPanel.this.nativeRect = rect;
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
                MapPanel.this.repaint();
            }
        }
    }
}

