/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal.xstream;

import java.util.Arrays;
import java.util.List;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.job.annotation.Serializable;

public final class XStreamUtils {
    private static final List<Class<?>> UNSERIALIZABLE_CLASSES = Arrays.asList(Logger.class, Provider.class, ComponentManager.class);

    private XStreamUtils() {
    }

    public static boolean isSafeType(Object obj) {
        return obj == null || obj instanceof String || obj instanceof Number || obj.getClass().isArray() || obj instanceof Enum;
    }

    public static boolean isSerializable(Object item) {
        if (item != null) {
            Serializable serializable = item.getClass().getAnnotation(Serializable.class);
            if (serializable != null) {
                return serializable.value();
            }
            if (item instanceof java.io.Serializable) {
                return true;
            }
            if (!item.getClass().isAnnotationPresent(Component.class)) {
                for (Class<?> clazz : UNSERIALIZABLE_CLASSES) {
                    if (!clazz.isInstance(item)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

