/*
 * Decompiled with CFR 0.152.
 */
package net.osmand;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.osmand.PlatformUtil;
import org.apache.commons.logging.Log;

public class ColorPalette {
    private static final Log LOG = PlatformUtil.getLog(ColorPalette.class);
    public static final int DARK_GREY = ColorPalette.rgbaToDecimal(92, 92, 92, 255);
    public static final int LIGHT_GREY = ColorPalette.rgbaToDecimal(200, 200, 200, 255);
    public static final int GREEN = ColorPalette.rgbaToDecimal(90, 220, 95, 255);
    public static final int YELLOW = ColorPalette.rgbaToDecimal(212, 239, 50, 255);
    public static final int RED = ColorPalette.rgbaToDecimal(243, 55, 77, 255);
    public static final int BLUE_SLOPE = ColorPalette.rgbaToDecimal(0, 0, 255, 255);
    public static final int CYAN_SLOPE = ColorPalette.rgbaToDecimal(0, 255, 255, 255);
    public static final int GREEN_SLOPE = ColorPalette.rgbaToDecimal(46, 185, 0, 255);
    public static final int WHITE = ColorPalette.rgbaToDecimal(255, 255, 255, 255);
    public static final int YELLOW_SLOPE = ColorPalette.rgbaToDecimal(255, 222, 2, 255);
    public static final int RED_SLOPE = ColorPalette.rgbaToDecimal(255, 1, 1, 255);
    public static final int PURPLE_SLOPE = ColorPalette.rgbaToDecimal(130, 1, 255, 255);
    public static final int[] COLORS = new int[]{GREEN, YELLOW, RED};
    public static final int[] SLOPE_COLORS = new int[]{CYAN_SLOPE, GREEN_SLOPE, LIGHT_GREY, YELLOW_SLOPE, RED_SLOPE};
    public static final double SLOPE_MIN_VALUE = -1.0;
    public static final double SLOPE_MAX_VALUE = 1.0;
    public static final ColorPalette SLOPE_PALETTE = ColorPalette.parsePalette({-1.0, BLUE_SLOPE}, {-0.15, CYAN_SLOPE}, {-0.05, GREEN_SLOPE}, {0.0, LIGHT_GREY}, {0.05, YELLOW_SLOPE}, {0.15, RED_SLOPE}, {1.0, PURPLE_SLOPE});
    public static final ColorPalette MIN_MAX_PALETTE = ColorPalette.parsePalette({0.0, GREEN}, {0.5, YELLOW}, {1.0, RED});
    List<ColorValue> colors = new ArrayList<ColorValue>();

    public ColorPalette() {
    }

    public ColorPalette(ColorPalette c, double minVal, double maxVal) {
        for (ColorValue cv : c.colors) {
            double val = cv.val * (maxVal - minVal) + minVal;
            this.colors.add(new ColorValue(val, cv.clr));
        }
    }

    public List<ColorValue> getColors() {
        return this.colors;
    }

    public static int rgbaToDecimal(int r, int g, int b, int a) {
        int value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        return value;
    }

    public int getColorByValue(double value) {
        if (Double.isNaN(value)) {
            return LIGHT_GREY;
        }
        for (int i = 0; i < this.colors.size() - 1; ++i) {
            ColorValue min = this.colors.get(i);
            ColorValue max = this.colors.get(i + 1);
            if (value == min.val) {
                return min.clr;
            }
            if (!(value >= min.val) || !(value <= max.val)) continue;
            double percent = (value - min.val) / (max.val - min.val);
            return this.getIntermediateColor(min, max, percent);
        }
        if (value <= this.colors.get((int)0).val) {
            return this.colors.get((int)0).clr;
        }
        if (value >= this.colors.get((int)(this.colors.size() - 1)).val) {
            return this.colors.get((int)(this.colors.size() - 1)).clr;
        }
        return ColorPalette.getTransparentColor();
    }

    private int getIntermediateColor(ColorValue min, ColorValue max, double percent) {
        double r = (double)min.r + percent * (double)(max.r - min.r);
        double g = (double)min.g + percent * (double)(max.g - min.g);
        double b = (double)min.b + percent * (double)(max.b - min.b);
        double a = (double)min.a + percent * (double)(max.a - min.a);
        return ColorPalette.rgbaToDecimal((int)r, (int)g, (int)b, (int)a);
    }

    public static int getIntermediateColor(int min, int max, double percent) {
        double r = (double)ColorPalette.red(min) + percent * (double)(ColorPalette.red(max) - ColorPalette.red(min));
        double g = (double)ColorPalette.green(min) + percent * (double)(ColorPalette.green(max) - ColorPalette.green(min));
        double b = (double)ColorPalette.blue(min) + percent * (double)(ColorPalette.blue(max) - ColorPalette.blue(min));
        double a = (double)ColorPalette.alpha(min) + percent * (double)(ColorPalette.alpha(max) - ColorPalette.alpha(min));
        return ColorPalette.rgbaToDecimal((int)r, (int)g, (int)b, (int)a);
    }

    public String toString() {
        return this.writeColorPalette();
    }

    public String writeColorPalette() {
        return ColorPalette.writeColorPalette(this.colors);
    }

    public static String writeColorPalette(List<ColorValue> colors) {
        StringBuilder bld = new StringBuilder();
        for (ColorValue v : colors) {
            bld.append(v.val).append(",");
            bld.append(v.r).append(",").append(v.g).append(",").append(v.b).append(",").append(v.a).append("\n");
        }
        return bld.toString().trim();
    }

    private void sortPalette() {
        Collections.sort(this.colors, new Comparator<ColorValue>(){

            @Override
            public int compare(ColorValue a, ColorValue b) {
                return Double.compare(a.val, b.val);
            }
        });
    }

    public static ColorPalette parsePalette(double[] ... vl) {
        ColorPalette palette = new ColorPalette();
        for (double[] v : vl) {
            ColorValue c = null;
            if (v.length == 2) {
                c = new ColorValue(v[0], (int)v[1]);
            } else if (v.length == 4) {
                c = new ColorValue(v[0], (int)v[1], (int)v[2], (int)v[3], 255);
            } else if (v.length >= 5) {
                c = new ColorValue(v[0], (int)v[1], (int)v[2], (int)v[3], (int)v[4]);
            }
            if (c == null) continue;
            palette.colors.add(c);
        }
        palette.sortPalette();
        return palette;
    }

    public static ColorPalette parseColorPalette(Reader reader) throws IOException {
        return ColorPalette.parseColorPalette(reader, true);
    }

    public static ColorPalette parseColorPalette(Reader reader, boolean shouldSort) throws IOException {
        String line;
        ColorPalette palette = new ColorPalette();
        BufferedReader r = new BufferedReader(reader);
        while ((line = r.readLine()) != null) {
            String[] values;
            String t = line.trim();
            if (t.startsWith("#") || (values = t.split(",")).length < 4) continue;
            try {
                ColorValue rgba = ColorValue.rgba(Double.parseDouble(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]), Integer.parseInt(values[3]), values.length >= 5 ? Integer.parseInt(values[4]) : 255);
                palette.colors.add(rgba);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (shouldSort) {
            palette.sortPalette();
        }
        return palette;
    }

    private static int red(int value) {
        return value >> 16 & 0xFF;
    }

    private static int green(int value) {
        return value >> 8 & 0xFF;
    }

    private static int blue(int value) {
        return value >> 0 & 0xFF;
    }

    private static int alpha(int value) {
        return value >> 24 & 0xFF;
    }

    public static int getTransparentColor() {
        return ColorPalette.rgbaToDecimal(0, 0, 0, 0);
    }

    public static void main(String[] args) throws IOException {
        ColorPalette pls = ColorPalette.parseColorPalette(new FileReader("../../resources/color-palette/route_speed_default.txt"));
        System.out.println(pls.colors);
        System.out.println(pls.writeColorPalette());
    }

    public static class ColorValue {
        public final int r;
        public final int g;
        public final int b;
        public final int a;
        public final int clr;
        public double val;

        public ColorValue(double val, int r, int g, int b, int a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.clr = ColorPalette.rgbaToDecimal(r, g, b, a);
            this.val = val;
        }

        public ColorValue(int clr) {
            this(0.0, clr);
        }

        public ColorValue(double val, int clr) {
            this.r = ColorPalette.red(clr);
            this.g = ColorPalette.green(clr);
            this.b = ColorPalette.blue(clr);
            this.a = ColorPalette.alpha(clr);
            this.clr = clr;
            this.val = val;
        }

        public void setValue(double val) {
            this.val = val;
        }

        public static ColorValue rgba(double val, int r, int g, int b, int a) {
            ColorValue clr = new ColorValue(val, r, g, b, a);
            return clr;
        }

        public String toString() {
            return "ColorValue [r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + ", val=" + this.val + "]";
        }
    }
}

