/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.osmand.swing.DataExtractionSettings;
import net.osmand.swing.MapPanel;
import net.osmand.swing.Messages;

public class NativePreferencesDialog
extends JDialog {
    private static final long serialVersionUID = -4862884032977071296L;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField nativeFilesDirectory;
    private JTextField renderingStyleFile;
    private JTextField renderingGenStyleFile;
    private Map<String, JCheckBox> checks = new TreeMap<String, JCheckBox>();
    private Map<String, JComboBox<String>> combos = new TreeMap<String, JComboBox<String>>();
    private boolean okPressed;
    private JTextField renderingPropertiesTxt;
    private MapPanel mapPanel;

    public NativePreferencesDialog(MapPanel mapPanel) {
        super(JOptionPane.getFrameForComponent(mapPanel), true);
        this.mapPanel = mapPanel;
        this.setTitle(Messages.getString("OsmExtractionPreferencesDialog.PREFERENCES"));
        this.initDialog();
    }

    public void showDialog() {
        this.setSize(1200, 768);
        double x = this.getParent().getBounds().getCenterX();
        double y = this.getParent().getBounds().getCenterY();
        this.setLocation((int)x - this.getWidth() / 2, (int)y - this.getHeight() / 2);
        this.setVisible(true);
    }

    private void initDialog() {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.add(pane);
        this.createGeneralSection(pane);
        pane.add(Box.createVerticalGlue());
        FlowLayout l = new FlowLayout(2);
        JPanel buttonsPane = new JPanel(l);
        this.okButton = new JButton(Messages.getString("OsmExtractionPreferencesDialog.OK"));
        buttonsPane.add(this.okButton);
        pane.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton(Messages.getString("OsmExtractionPreferencesDialog.CANCEL"));
        buttonsPane.add(this.cancelButton);
        buttonsPane.setMaximumSize(new Dimension(Short.MAX_VALUE, (int)l.preferredLayoutSize(buttonsPane).getHeight()));
        pane.add(buttonsPane);
        this.addListeners();
    }

    private void createGeneralSection(JPanel root) {
        String[] vls;
        JPanel panel = new JPanel();
        GridBagLayout l = new GridBagLayout();
        panel.setLayout(l);
        panel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OsmExtractionPreferencesDialog.GENERAL")));
        root.add(panel);
        JLabel label = new JLabel("Directory with binary files : ");
        panel.add(label);
        GridBagConstraints constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.gridx = 0;
        constr.gridy = 1;
        constr.anchor = 17;
        l.setConstraints(label, constr);
        this.nativeFilesDirectory = new JTextField();
        this.nativeFilesDirectory.setText(DataExtractionSettings.getSettings().getBinaryFilesDir());
        panel.add(this.nativeFilesDirectory);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = 1;
        constr.gridwidth = 4;
        l.setConstraints(this.nativeFilesDirectory, constr);
        this.renderingStyleFile = this.addTextField(panel, l, "Rendering style file : ", 3, DataExtractionSettings.getSettings().getRenderXmlPath());
        this.renderingGenStyleFile = this.addTextField(panel, l, "Rendering gen file: ", 4, DataExtractionSettings.getSettings().getRenderGenXmlPath());
        String prps = DataExtractionSettings.getSettings().getRenderingProperties();
        this.renderingPropertiesTxt = this.addTextField(panel, l, "Rendering properties : ", 5, prps);
        TreeMap<String, String> stringProps = new TreeMap<String, String>();
        TreeMap<String, Boolean> boolProps = new TreeMap<String, Boolean>();
        for (String v : vls = prps.split(",")) {
            String[] spl = v.split("=");
            if (spl.length < 2) continue;
            String name = spl[0].trim();
            String vl = spl[1].trim();
            if (vl.toLowerCase().equals("true") || vl.toLowerCase().equals("false")) {
                boolProps.put(name, Boolean.parseBoolean(vl));
                continue;
            }
            stringProps.put(name, vl);
        }
        int boolRowId = 6;
        int boolColId = 0;
        for (Map.Entry entry : boolProps.entrySet()) {
            String name = (String)entry.getKey();
            boolean value = (Boolean)entry.getValue();
            JCheckBox box = this.addCheckBox(panel, l, name, boolRowId, boolColId, value);
            this.checks.put(name, box);
            if (++boolColId != 4) continue;
            boolColId = 0;
            ++boolRowId;
        }
        int stringRowId = boolColId == 0 ? boolRowId : boolRowId + 1;
        int stringColId = 0;
        for (Map.Entry entry : stringProps.entrySet()) {
            String name = (String)entry.getKey();
            String vl = (String)entry.getValue();
            String[] vs = vl.split(";");
            if (vs.length <= 0) continue;
            JComboBox<String> cb = this.addComboBox(panel, l, name, stringRowId, stringColId * 2, vs[0], vs);
            this.combos.put(name, cb);
            if (++stringColId != 2) continue;
            stringColId = 0;
            ++stringRowId;
        }
        this.renderingPropertiesTxt.setText("");
        panel.setMaximumSize(new Dimension(Short.MAX_VALUE, panel.getPreferredSize().height));
    }

    protected JCheckBox addCheckBox(JPanel panel, GridBagLayout l, String labelText, int rowId, int colId, boolean value) {
        JCheckBox check = new JCheckBox();
        check.setText(labelText);
        check.setSelected(value);
        panel.add(check);
        GridBagConstraints constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = colId;
        constr.anchor = 17;
        constr.gridy = rowId;
        l.setConstraints(check, constr);
        return check;
    }

    protected JComboBox<String> addComboBox(JPanel panel, GridBagLayout l, String labelText, int rowId, int baseColId, String value, String[] otherValues) {
        JLabel label = new JLabel(labelText);
        panel.add(label);
        GridBagConstraints constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.gridx = baseColId;
        constr.gridy = rowId;
        constr.anchor = 17;
        constr.weightx = 1.0;
        constr.fill = 2;
        l.setConstraints(label, constr);
        JComboBox<String> textField = new JComboBox<String>(otherValues);
        textField.setEditable(true);
        textField.setSelectedItem(value);
        panel.add(textField);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = baseColId + 1;
        constr.gridy = rowId;
        l.setConstraints(textField, constr);
        return textField;
    }

    protected JTextField addTextField(JPanel panel, GridBagLayout l, String labelText, int rowId, String value) {
        JLabel label = new JLabel(labelText);
        panel.add(label);
        GridBagConstraints constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.gridx = 0;
        constr.gridy = rowId;
        constr.anchor = 17;
        l.setConstraints(label, constr);
        JTextField textField = new JTextField();
        textField.setText(value);
        panel.add(textField);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = rowId;
        constr.gridwidth = 4;
        l.setConstraints(textField, constr);
        return textField;
    }

    private void addListeners() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NativePreferencesDialog.this.saveProperties();
                NativePreferencesDialog.this.okPressed = true;
                NativePreferencesDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NativePreferencesDialog.this.setVisible(false);
            }
        });
    }

    public void saveProperties() {
        JComponent cb;
        DataExtractionSettings settings = DataExtractionSettings.getSettings();
        if (!settings.getBinaryFilesDir().equals(this.nativeFilesDirectory.getText())) {
            settings.setBinaryFilesDir(this.nativeFilesDirectory.getText());
        }
        if (!settings.getRenderXmlPath().equals(this.renderingStyleFile.getText())) {
            settings.setRenderXmlPath(this.renderingStyleFile.getText());
        }
        if (!settings.getRenderGenXmlPath().equals(this.renderingGenStyleFile.getText())) {
            settings.setRenderGenXmlPath(this.renderingGenStyleFile.getText());
        }
        Object res = this.renderingPropertiesTxt.getText();
        int i = ((String)res).length();
        for (String s : this.checks.keySet()) {
            if (i > 0) {
                res = (String)res + ",";
            }
            ++i;
            cb = this.checks.get(s);
            if (((String)res).contains(s + "=")) continue;
            res = (String)res + s + "=" + ((AbstractButton)cb).isSelected();
        }
        for (String s : this.combos.keySet()) {
            if (i > 0) {
                res = (String)res + ",";
            }
            ++i;
            cb = this.combos.get(s);
            String item = ((JComboBox)cb).getSelectedItem().toString();
            if (!((String)res).contains(s + "=")) {
                res = (String)res + s + "=" + item;
                for (int ij = 0; ij < ((JComboBox)cb).getItemCount(); ++ij) {
                    String kk = (String)((JComboBox)cb).getItemAt(ij);
                    if (item.equals(kk)) continue;
                    res = (String)res + ";" + kk;
                }
            }
            if (!s.equals("density")) continue;
            this.mapPanel.setMapDensity(Float.parseFloat(item));
        }
        DataExtractionSettings.getSettings().setRenderingProperties((String)res);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }
}

