/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import net.osmand.binary.MapZooms;
import net.osmand.obf.preparation.BasemapProcessor;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.swing.MapPanel;
import net.osmand.swing.MapPanelLayer;
import net.osmand.util.MapUtils;

public class CoastlinesLayer
implements MapPanelLayer {
    private MapPanel map;
    private BasemapProcessor basemapProcessor;
    private ArrayList<Polygon> lands = new ArrayList();
    private ArrayList<Polygon> waters = new ArrayList();

    @Override
    public void destroyLayer() {
    }

    @Override
    public void initLayer(MapPanel map) {
        this.map = map;
        this.basemapProcessor = new BasemapProcessor(null, MapZooms.getDefault(), new MapRenderingTypesEncoder("basemap"), 0);
    }

    @Override
    public void paintLayer(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(new Color(0, 0, 255, 120));
        for (Polygon w : this.waters) {
            g.drawPolygon(w);
            g.fillPolygon(w);
        }
        g.setColor(new Color(0, 255, 0, 120));
        for (Polygon l : this.lands) {
            g.drawPolygon(l);
            g.fillPolygon(l);
        }
    }

    public Polygon getPolygon(int tileX, int tileY, int z) {
        int pixX = (int)((double)MapUtils.getPixelShiftX((float)this.map.getZoom(), (double)MapUtils.getLongitudeFromTile((double)z, (double)tileX), (double)this.map.getLongitude(), (double)this.map.getTileSize()) + this.map.getCenterPointX());
        int pixY = (int)((double)MapUtils.getPixelShiftY((float)this.map.getZoom(), (double)MapUtils.getLatitudeFromTile((float)z, (double)tileY), (double)this.map.getLatitude(), (double)this.map.getTileSize()) + this.map.getCenterPointY());
        int pixsX = (int)((double)MapUtils.getPixelShiftX((float)this.map.getZoom(), (double)MapUtils.getLongitudeFromTile((double)z, (double)(tileX + 1)), (double)this.map.getLongitude(), (double)this.map.getTileSize()) + this.map.getCenterPointX());
        int pixsY = (int)((double)MapUtils.getPixelShiftY((float)this.map.getZoom(), (double)MapUtils.getLatitudeFromTile((float)z, (double)(tileY + 1)), (double)this.map.getLatitude(), (double)this.map.getTileSize()) + this.map.getCenterPointY());
        return new Polygon(new int[]{pixX, pixsX, pixsX, pixX, pixX}, new int[]{pixY, pixY, pixsY, pixsY, pixY}, 5);
    }

    @Override
    public void fillPopupMenuWithActions(JPopupMenu menu) {
        AbstractAction print = new AbstractAction("Print tile coastline info"){
            private static final long serialVersionUID = 507156107455281238L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Point popupMenuPoint = CoastlinesLayer.this.map.getPopupMenuPoint();
                double fy = ((double)popupMenuPoint.y - CoastlinesLayer.this.map.getCenterPointY()) / CoastlinesLayer.this.map.getTileSize();
                double fx = ((double)popupMenuPoint.x - CoastlinesLayer.this.map.getCenterPointX()) / CoastlinesLayer.this.map.getTileSize();
                int yTile = (int)(CoastlinesLayer.this.map.getYTile() + fy);
                int xTile = (int)(CoastlinesLayer.this.map.getXTile() + fx);
                System.out.println("!Tile x=" + xTile + " y=" + yTile + " z=" + CoastlinesLayer.this.map.getZoom());
                if (CoastlinesLayer.this.basemapProcessor.isWaterTile(xTile, yTile, CoastlinesLayer.this.map.getZoom())) {
                    System.out.println("!Water Tile x=" + xTile + " y=" + yTile + " z=" + CoastlinesLayer.this.map.getZoom());
                }
                if (CoastlinesLayer.this.basemapProcessor.isLandTile(xTile, yTile, CoastlinesLayer.this.map.getZoom())) {
                    System.out.println("!Land  Tile x=" + xTile + " y=" + yTile + " z=" + CoastlinesLayer.this.map.getZoom());
                }
                for (int z = CoastlinesLayer.this.map.getZoom(); z <= CoastlinesLayer.this.basemapProcessor.getTileZoomLevel(); ++z) {
                    System.out.println("Zoom " + z);
                    for (int x = xTile * 1 << z - CoastlinesLayer.this.map.getZoom(); x < (xTile + 1) * (1 << z - CoastlinesLayer.this.map.getZoom()); ++x) {
                        for (int y = yTile * 1 << z - CoastlinesLayer.this.map.getZoom(); y < (yTile + 1) * (1 << z - CoastlinesLayer.this.map.getZoom()); ++y) {
                            if (CoastlinesLayer.this.basemapProcessor.isWaterTile(x, y, z)) {
                                System.out.println("Water tile x=" + x + " y=" + y + " z=" + z);
                            }
                            if (!CoastlinesLayer.this.basemapProcessor.isLandTile(x, y, z)) continue;
                            System.out.println("Land  tile x=" + x + " y=" + y + " z=" + z);
                        }
                    }
                }
            }
        };
        menu.add(print);
    }

    @Override
    public void prepareToDraw() {
        double xTileLeft = this.map.getXTile() - this.map.getCenterPointX() / this.map.getTileSize();
        double xTileRight = this.map.getXTile() + this.map.getCenterPointX() / this.map.getTileSize();
        double yTileUp = this.map.getYTile() - this.map.getCenterPointY() / this.map.getTileSize();
        double yTileDown = this.map.getYTile() + this.map.getCenterPointY() / this.map.getTileSize();
        this.waters.clear();
        this.lands.clear();
        if (this.map.getZoom() > 5) {
            for (int k = 0; k < 5; ++k) {
                int tLeft = (int)(Math.floor(xTileLeft) * (double)(1 << k));
                int tRight = (int)(Math.ceil(xTileRight) * (double)(1 << k));
                int tTop = (int)(Math.floor(yTileUp) * (double)(1 << k));
                int tBottom = (int)(Math.ceil(yTileDown) * (double)(1 << k));
                int z = this.map.getZoom() + k;
                for (int i = tLeft; i <= tRight; ++i) {
                    for (int j = tTop; j <= tBottom; ++j) {
                        if (this.basemapProcessor.isWaterTile(i, j, z) && (k == 0 || !this.basemapProcessor.isWaterTile(i / 2, j / 2, z - 1))) {
                            this.waters.add(this.getPolygon(i, j, z));
                        }
                        if (!this.basemapProcessor.isLandTile(i, j, z) || k != 0 && this.basemapProcessor.isLandTile(i / 2, j / 2, z - 1)) continue;
                        this.lands.add(this.getPolygon(i, j, z));
                    }
                }
            }
        }
    }

    @Override
    public void applySettings() {
    }
}

