/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.extensions.scribunto.template;

import info.bliki.extensions.scribunto.ScribuntoException;
import info.bliki.extensions.scribunto.engine.ScribuntoEngine;
import info.bliki.extensions.scribunto.engine.ScribuntoModule;
import info.bliki.extensions.scribunto.template.Frame;
import info.bliki.wiki.filter.TemplateParser;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.template.AbstractTemplateFunction;
import info.bliki.wiki.template.ITemplateFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Invoke
extends AbstractTemplateFunction {
    public static final ITemplateFunction CONST = new Invoke();
    private static Logger logger = LoggerFactory.getLogger(Invoke.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String parseFunction(List<String> parts, IWikiModel model, char[] src, int beginIndex, int endIndex, boolean isSubst) throws IOException {
        if (parts.size() < 2) {
            throw new AssertionError((Object)"not enough arguments");
        }
        ScribuntoEngine engine = model.createScribuntoEngine();
        if (engine == null) {
            throw new AssertionError((Object)"no scribuntoEngine defined");
        }
        String moduleName = parts.get(0).trim();
        String functionName = parts.get(1).trim();
        Frame parent = model.getFrame();
        try {
            ScribuntoModule module = engine.fetchModuleFromParser(moduleName);
            Frame frame = parent.newChild(module.pageName(), this.getParameters(parts, model), isSubst);
            String string = module.invoke(functionName, frame);
            return string;
        }
        catch (ScribuntoException e) {
            logger.error("error invoking function", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            model.setFrame(parent);
        }
    }

    private Map<String, String> getParameters(List<String> parts, IWikiModel model) {
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        if (parts.size() > 2) {
            ArrayList<String> unnamedParameters = new ArrayList<String>();
            for (int i = 2; i < parts.size(); ++i) {
                TemplateParser.createSingleParameter(parts.get(i), model, parameterMap, unnamedParameters);
            }
            TemplateParser.mergeParameters(parameterMap, unnamedParameters);
        }
        return parameterMap;
    }

    @Override
    public String getFunctionDoc() {
        return null;
    }
}

