/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osmand.data.LatLon;
import net.osmand.osm.MapRenderingTypes;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.PoiType;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;

public class PropagateToNodes {
    private MapRenderingTypesEncoder renderingTypes;
    private TLongObjectHashMap<List<PropagateFromWayToNode>> propagateTagsByNodeId = new TLongObjectHashMap();
    private TLongObjectHashMap<List<PropagateRuleFromWayToNode>> propagateTagsByOsmNodeId = new TLongObjectHashMap();
    private Map<String, List<PropagateRule>> propagateRulesByTag = new HashMap<String, List<PropagateRule>>();
    private Map<PropagateRule, Map<String, String>> convertedPropagatedTags = new HashMap<PropagateRule, Map<String, String>>();

    public PropagateToNodes(MapRenderingTypesEncoder renderingTypes) {
        this.renderingTypes = renderingTypes;
        this.initPropagateToNodes();
        this.initConvertedTags();
    }

    private void initConvertedTags() {
        for (List<PropagateRule> rules : this.propagateRulesByTag.values()) {
            for (PropagateRule r : rules) {
                Map<String, String> tags = new HashMap<String, String>();
                Object tag = r.tag;
                if (!Algorithms.isEmpty((CharSequence)r.tagPrefix)) {
                    tag = r.tagPrefix + r.tag;
                }
                tags.put((String)tag, r.value);
                if (Algorithms.isEmpty(tags = this.renderingTypes.transformTags(tags, Entity.EntityType.NODE, MapRenderingTypesEncoder.EntityConvertApplyType.MAP))) continue;
                this.convertedPropagatedTags.put(r, tags);
            }
        }
    }

    public boolean isNoRegisteredNodes() {
        return this.propagateTagsByNodeId.isEmpty();
    }

    public void registerNode(PropagateFromWayToNode node) {
        ArrayList<PropagateFromWayToNode> lst = (ArrayList<PropagateFromWayToNode>)this.propagateTagsByNodeId.get(node.id);
        if (lst == null) {
            lst = new ArrayList<PropagateFromWayToNode>();
            this.propagateTagsByNodeId.put(node.id, lst);
        }
        lst.add(node);
        for (PropagateRuleFromWayToNode pn : node.rls) {
            ArrayList<PropagateRuleFromWayToNode> l = (ArrayList<PropagateRuleFromWayToNode>)this.propagateTagsByOsmNodeId.get(pn.osmId);
            if (l == null) {
                l = new ArrayList<PropagateRuleFromWayToNode>();
                this.propagateTagsByOsmNodeId.put(pn.osmId, l);
            }
            l.add(pn);
        }
    }

    public List<PropagateFromWayToNode> getPropagateByNodeId(long nodeId) {
        return (List)this.propagateTagsByNodeId.get(nodeId);
    }

    private void initPropagateToNodes() {
        Map ruleTypes = this.renderingTypes.getEncodingRuleTypes();
        for (Map.Entry entry : ruleTypes.entrySet()) {
            MapRenderingTypes.MapRulType ruleType = (MapRenderingTypes.MapRulType)entry.getValue();
            for (MapRenderingTypes.PropagateToNode d : ruleType.getPropagateToNodes()) {
                PropagateRule rule = new PropagateRule(d.propagateToNodes, d.propagateToNodesPrefix, d.propagateNetworkIf, d.propagateIf, d.propagateAlsoTags);
                String[] split = ((String)entry.getKey()).split("/");
                rule.tag = split[0];
                rule.value = split[1];
                if (!this.propagateRulesByTag.containsKey(rule.tag)) {
                    this.propagateRulesByTag.put(rule.tag, new ArrayList());
                }
                this.propagateRulesByTag.get(rule.tag).add(rule);
            }
        }
    }

    public PropagateFromWayToNode getNode(PropagateWayWithNodes rWay, Way way, int start, int end) {
        if (rWay.points[start + end] == null) {
            rWay.points[start + end] = new PropagateFromWayToNode(way, start, end);
        }
        rWay.empty = false;
        return rWay.points[start + end];
    }

    public PropagateWayWithNodes propagateTagsFromWays(Way w) {
        List<PropagateRule> rulesToApply = this.getRulesToApply(w);
        if (rulesToApply == null) {
            return null;
        }
        TLongArrayList allIds = w.getNodeIds();
        if (allIds.size() == 0) {
            return null;
        }
        PropagateWayWithNodes resultWay = new PropagateWayWithNodes(allIds.size());
        block8: for (PropagateRule rule : rulesToApply) {
            switch (rule.type) {
                case ALL: {
                    int i;
                    for (i = 0; i < allIds.size(); ++i) {
                        this.getNode(resultWay, w, i, i).applyRule(rule, w.getTags());
                    }
                    continue block8;
                }
                case START: {
                    this.getNode(resultWay, w, 0, 1).applyRule(rule, w.getTags());
                    break;
                }
                case END: {
                    this.getNode(resultWay, w, allIds.size() - 2, allIds.size() - 1).applyRule(rule, w.getTags(), true);
                    break;
                }
                case CENTER: {
                    if (allIds.size() == 2) {
                        this.getNode(resultWay, w, 0, 1).applyRule(rule, w.getTags());
                        break;
                    }
                    this.getNode(resultWay, w, allIds.size() / 2, allIds.size() / 2).applyRule(rule, w.getTags());
                    break;
                }
                case BORDERIN: {
                    int i;
                    for (i = 0; i < allIds.size() - 1; ++i) {
                        this.getNode(resultWay, w, i, i + 1).applyRule(rule, w.getTags(), false);
                        this.getNode(resultWay, w, i, i + 1).applyRule(rule, w.getTags(), true);
                    }
                    continue block8;
                }
                case BORDEROUT: {
                    int i;
                    for (i = 0; i < allIds.size(); ++i) {
                        this.getNode(resultWay, w, i, i).applyRule(rule, w.getTags());
                    }
                    break;
                }
            }
        }
        return resultWay;
    }

    private List<PropagateRule> getRulesToApply(Way w) {
        ArrayList<PropagateRule> rulesToApply = null;
        Map<String, String> trTags = this.renderingTypes.transformTags(w.getTags(), Entity.EntityType.WAY, MapRenderingTypesEncoder.EntityConvertApplyType.MAP);
        for (String tag : trTags.keySet()) {
            List<PropagateRule> list = this.propagateRulesByTag.get(tag);
            if (list == null) continue;
            for (PropagateRule rule : list) {
                boolean propIf;
                String entityTag = trTags.get(tag);
                if (entityTag == null || !entityTag.equals(rule.value) || !(propIf = rule.applicableBorder(trTags))) continue;
                if (rulesToApply == null) {
                    rulesToApply = new ArrayList<PropagateRule>();
                }
                if (rulesToApply.contains(rule)) continue;
                rulesToApply.add(rule);
            }
        }
        return rulesToApply;
    }

    public void propagateTagsToWayNodesNoBorderRule(Way w) {
        if (this.propagateTagsByNodeId.isEmpty()) {
            return;
        }
        List nodes = w.getNodes();
        for (Node n : nodes) {
            this.propagateTagsToNode(n, false);
        }
    }

    public void propagateTagsToNode(Node n, boolean includeBorder) {
        if (this.propagateTagsByNodeId.isEmpty()) {
            return;
        }
        long nodeId = n.getId();
        List list = (List)this.propagateTagsByNodeId.get(nodeId);
        if (list == null) {
            return;
        }
        for (PropagateFromWayToNode ways : list) {
            for (PropagateRuleFromWayToNode w : ways.rls) {
                if (!includeBorder && w.rule.type.isBorder()) continue;
                for (Map.Entry<String, String> entry : w.tags.entrySet()) {
                    if (n.getTag(entry.getKey()) != null || entry.getValue() == null) continue;
                    n.putTag(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public void calculateBorderPoints(Way w) {
        if (this.propagateTagsByOsmNodeId.isEmpty()) {
            return;
        }
        Map<String, String> convertTags = null;
        for (long nodeId : w.getNodeIds().toArray()) {
            List linkedPropagate = (List)this.propagateTagsByOsmNodeId.get(nodeId);
            if (linkedPropagate == null) continue;
            if (convertTags == null) {
                convertTags = this.renderingTypes.transformTags(w.getTags(), Entity.EntityType.WAY, MapRenderingTypesEncoder.EntityConvertApplyType.MAP);
            }
            HashMap rules = new HashMap();
            for (PropagateRuleFromWayToNode n : linkedPropagate) {
                if (!rules.containsKey(n.rule)) {
                    rules.put(n.rule, new ArrayList());
                }
                ((List)rules.get(n.rule)).add(n);
            }
            for (PropagateRule rule : rules.keySet()) {
                if (!rule.type.isBorder()) continue;
                List propagatedBorders = (List)rules.get(rule);
                for (PropagateRuleFromWayToNode p : propagatedBorders) {
                    if (!p.rule.applicableNetwork(convertTags) || p.rule.applicableBorder(convertTags)) continue;
                    p.ignoreBorderPoint = false;
                }
            }
        }
    }

    public void calculateBorderPointMainTypes(long nodeId, List<MapRenderingTypes.MapRulType> mainTypes) {
        List<PropagateFromWayToNode> linkedPropagate = this.getPropagateByNodeId(nodeId);
        if (linkedPropagate == null) {
            return;
        }
        Iterator<MapRenderingTypes.MapRulType> it = mainTypes.iterator();
        while (it.hasNext()) {
            MapRenderingTypes.MapRulType type = it.next();
            int delete = 0;
            for (PropagateFromWayToNode p : linkedPropagate) {
                for (PropagateRuleFromWayToNode n : p.rls) {
                    String value;
                    Map<String, String> convertedTags;
                    boolean isEqual = type.getTag().equals(n.rule.getPropagateTag()) && type.getValue().equals(n.rule.getPropagateValue());
                    boolean isConverted = false;
                    if (!isEqual && (convertedTags = this.convertedPropagatedTags.get(n.rule)) != null && !Algorithms.isEmpty((CharSequence)(value = convertedTags.get(type.getTag()))) && value.equals(type.getValue())) {
                        isConverted = true;
                    }
                    if (!isEqual && !isConverted) continue;
                    if (n.ignoreBorderPoint && delete == 0) {
                        delete = 1;
                        continue;
                    }
                    if (n.ignoreBorderPoint) continue;
                    delete = -1;
                }
            }
            if (delete != true) continue;
            it.remove();
        }
    }

    public boolean ignoreBorderPoint(long nodeId, PoiType poiType) {
        List<PropagateFromWayToNode> linkedPropagate = this.getPropagateByNodeId(nodeId);
        if (linkedPropagate == null) {
            return false;
        }
        for (PropagateFromWayToNode p : linkedPropagate) {
            for (PropagateRuleFromWayToNode n : p.rls) {
                if (!poiType.getOsmTag().equals(n.rule.getPropagateTag()) || !poiType.getOsmValue().equals(n.rule.getPropagateValue())) continue;
                return n.ignoreBorderPoint;
            }
        }
        return false;
    }

    public static class PropagateRule {
        public String tag;
        public String value;
        public final MapRenderingTypes.PropagateToNodesType type;
        public String tagPrefix;
        public Map<String, String> propMapIf;
        public Map<String, String> propNetworkIf;
        public Set<String> propAlso;

        public PropagateRule(MapRenderingTypes.PropagateToNodesType type, String tagPrefix, Map<String, String> propNetworkIf, Map<String, String> propMapIf, String[] propAlsoTags) {
            this.type = type;
            this.tagPrefix = tagPrefix;
            this.propMapIf = propMapIf;
            if (propAlsoTags != null) {
                this.propAlso = new HashSet<String>(Arrays.asList(propAlsoTags));
            }
            this.propNetworkIf = propNetworkIf;
        }

        public String getPropagateValue() {
            return this.value;
        }

        public String getWayTag() {
            return this.tag;
        }

        public String getWayValue() {
            return this.value;
        }

        public String getPropagateTag() {
            Object propagateTag = this.tag;
            if (this.tagPrefix != null) {
                propagateTag = this.tagPrefix + (String)propagateTag;
            }
            return propagateTag;
        }

        public Set<String> getPropAlso() {
            return this.propAlso;
        }

        public boolean applicableBorder(Map<String, String> tags) {
            if (!this.value.equals(tags.get(this.tag))) {
                return false;
            }
            if (this.propNetworkIf != null && !this.applicable(tags, this.propNetworkIf)) {
                return false;
            }
            return this.propMapIf == null || this.applicable(tags, this.propMapIf);
        }

        public boolean applicableNetwork(Map<String, String> tags) {
            if (this.propNetworkIf != null) {
                return this.applicable(tags, this.propNetworkIf);
            }
            return true;
        }

        private boolean applicable(Map<String, String> tags, Map<String, String> propMap) {
            for (Map.Entry<String, String> entry : propMap.entrySet()) {
                String tagValue;
                String propTag = entry.getKey();
                if (propTag.startsWith("~")) {
                    tagValue = tags.get(propTag.substring(1));
                    boolean noValue = Algorithms.isEmpty((CharSequence)tagValue) || "no".equals(tagValue);
                    if (noValue) continue;
                    return false;
                }
                tagValue = tags.get(propTag);
                if (tagValue == null) {
                    return false;
                }
                if (entry.getValue() == null) continue;
                String[] allValues = entry.getValue().split(",");
                boolean allNegs = true;
                boolean match = false;
                for (String v : allValues) {
                    if (v.startsWith("~")) {
                        if (!v.equals("~" + tagValue)) continue;
                        return false;
                    }
                    allNegs = false;
                    if (!v.equals(tagValue)) continue;
                    match = true;
                }
                if (allNegs || match) continue;
                return false;
            }
            return true;
        }
    }

    public static class PropagateFromWayToNode {
        public long id;
        public long wayId;
        public int start;
        public long startId;
        public long endId;
        public int end;
        public List<PropagateRuleFromWayToNode> rls = new ArrayList<PropagateRuleFromWayToNode>();

        public PropagateFromWayToNode(Way way, int start, int end) {
            this.end = end;
            this.start = start;
            this.wayId = way.getId();
            this.startId = way.getNodeIds().get(start);
            this.endId = way.getNodeIds().get(end);
            this.id = start == end ? way.getNodeIds().get(start) : -1L;
        }

        public LatLon getLatLon(Node st, Node en) {
            if (st == null || en == null) {
                return null;
            }
            return new LatLon(st.getLatitude() / 2.0 + en.getLatitude() / 2.0, st.getLongitude() / 2.0 + en.getLongitude() / 2.0);
        }

        public void applyRule(PropagateRule rule, Map<String, String> parentTags) {
            this.applyRule(rule, parentTags, false);
        }

        public void applyRule(PropagateRule rule, Map<String, String> parentTags, boolean end) {
            PropagateRuleFromWayToNode rl = new PropagateRuleFromWayToNode(this, rule);
            long l = rl.osmId = end ? this.endId : this.startId;
            if (parentTags != null && rule.getPropAlso() != null) {
                for (Map.Entry<String, String> wTag : parentTags.entrySet()) {
                    if (!rule.getPropAlso().contains(wTag.getKey())) continue;
                    rl.tags.put(wTag.getKey(), wTag.getValue());
                }
            }
            rl.tags.put(rule.getPropagateTag(), rule.getPropagateValue());
            if (rule.type.isBorder()) {
                rl.ignoreBorderPoint = true;
            }
            this.rls.add(rl);
        }
    }

    public static class PropagateRuleFromWayToNode {
        public final PropagateFromWayToNode way;
        public final PropagateRule rule;
        public final Map<String, String> tags = new HashMap<String, String>();
        public boolean ignoreBorderPoint;
        public long osmId;

        public PropagateRuleFromWayToNode(PropagateFromWayToNode propagateFromWayToNode, PropagateRule rule) {
            this.way = propagateFromWayToNode;
            this.rule = rule;
        }
    }

    public static class PropagateWayWithNodes {
        PropagateFromWayToNode[] points;
        boolean empty = true;

        public PropagateWayWithNodes(int oldNodes) {
            this.points = new PropagateFromWayToNode[2 * oldNodes - 1];
        }
    }
}

