/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import gnu.trove.set.hash.TLongHashSet;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.OsmDbAccessor;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.util.Algorithms;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MissingWikiTagsProcessor
implements OsmDbAccessor.OsmDbTagsPreparation {
    private static final Log log = LogFactory.getLog(MissingWikiTagsProcessor.class);
    private final String wikidataMappingUrl;
    private final String wikirankingUrl;
    Boolean init = null;
    private PreparedStatement selectById;
    private PreparedStatement selectId;
    private PreparedStatement selectRankById;
    private TLongHashSet assignedWids = new TLongHashSet();

    public MissingWikiTagsProcessor(String wikidataMappingUrl, String wikirankingUrl) {
        this.wikidataMappingUrl = wikidataMappingUrl;
        this.wikirankingUrl = wikirankingUrl;
    }

    @Override
    public void processTags(Entity e) {
        String wikidata = e.getTag(OSMSettings.OSMTagKey.WIKIDATA);
        String wikipedia = e.getTag(OSMSettings.OSMTagKey.WIKIPEDIA);
        if (wikipedia == null && wikidata == null) {
            return;
        }
        this.syncReadTags(e, wikidata, wikipedia);
    }

    private synchronized void syncReadTags(Entity e, String wikidata, String wikipedia) {
        try {
            boolean added;
            long wikidataId;
            if (!this.init()) {
                return;
            }
            if (wikipedia == null && wikidata == null) {
                return;
            }
            if (wikidata != null) {
                String ind = wikidata.substring(wikidata.lastIndexOf(81) + 1);
                wikidataId = Algorithms.parseLongSilently((String)ind, (long)0L);
                if (wikidataId != 0L && wikipedia == null) {
                    this.assignWikipediaTags(e, wikidataId);
                }
            } else {
                wikidataId = this.findAndAssignWikidataId(e, wikipedia);
            }
            if (wikidata != null && wikidataId != 0L && this.selectRankById != null && (added = this.assignedWids.add(wikidataId))) {
                this.assignRankingTags(e, wikidataId);
            }
        }
        catch (Exception es) {
            log.error((Object)es.getMessage(), (Throwable)es);
        }
    }

    private void assignRankingTags(Entity e, long wikidataId) throws SQLException {
        this.selectRankById.setLong(1, wikidataId);
        ResultSet rankIdRes = this.selectRankById.executeQuery();
        if (rankIdRes.next()) {
            double travelElo = rankIdRes.getDouble("elo");
            int qrank = rankIdRes.getInt("qrank");
            int travelTopic = rankIdRes.getInt("topic");
            String photoTitle = rankIdRes.getString("photoTitle");
            String catTitle = rankIdRes.getString("catTitle");
            String poiKey = rankIdRes.getString("poikey");
            if (travelElo > 0.0) {
                e.putTag("osmwiki", "wiki_place");
                e.putTag("travel_elo", "" + (int)travelElo);
            }
            if (qrank > 0) {
                e.putTag("qrank", "" + qrank);
            }
            if (travelTopic > 0) {
                e.putTag("travel_topic", "" + travelTopic);
            }
            if (!Algorithms.isEmpty((CharSequence)photoTitle)) {
                e.putTag("wiki_photo", photoTitle);
            }
            if (!Algorithms.isEmpty((CharSequence)catTitle)) {
                e.putTag("wiki_category", catTitle);
            }
            if (!Algorithms.isEmpty((CharSequence)poiKey)) {
                e.putTag("osmand_poi_key", poiKey);
            }
        }
        rankIdRes.close();
    }

    private long findAndAssignWikidataId(Entity e, String wikipedia) throws SQLException {
        int langInd = wikipedia.indexOf(58);
        String lang = "en";
        String title = wikipedia;
        if (langInd >= 0) {
            lang = wikipedia.substring(0, langInd);
            title = wikipedia.substring(langInd + 1);
        }
        this.selectId.setString(1, lang);
        this.selectId.setString(2, title);
        ResultSet rs = this.selectId.executeQuery();
        long wikidataId = 0L;
        if (rs.next()) {
            wikidataId = rs.getLong(1);
            e.putTag("wikidata", "Q" + wikidataId);
        }
        rs.close();
        return wikidataId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignWikipediaTags(Entity e, long wikidataId) throws SQLException {
        this.selectById.setLong(1, wikidataId);
        try (ResultSet rs = this.selectById.executeQuery();){
            String lang = null;
            String title = null;
            int cntLangs = 0;
            while (rs.next()) {
                lang = rs.getString(1);
                title = rs.getString(2);
                ++cntLangs;
                if (lang == null) {
                    System.out.println("Null language for " + title + " Q" + wikidataId);
                }
                if (lang.length() != 2 || !lang.equals("en")) continue;
                e.putTag("wikipedia", "en:" + title);
            }
            if (cntLangs == 1 && !lang.equals("en")) {
                e.removeTag("wikipedia:" + lang);
                e.putTag("wikipedia", lang + ":" + title);
            }
        }
    }

    private boolean init() {
        if (this.init != null) {
            return this.init;
        }
        try {
            this.init = false;
            String fileName = this.wikidataMappingUrl;
            if (this.wikidataMappingUrl.startsWith("http")) {
                log.info((Object)("Downloading wikidata database by url " + this.wikidataMappingUrl));
                URL url = new URL(this.wikidataMappingUrl);
                URLConnection cn = url.openConnection();
                fileName = "wikidata_mapping.sqlitedb";
                FileOutputStream fous = new FileOutputStream(fileName);
                Algorithms.streamCopy((InputStream)cn.getInputStream(), (OutputStream)fous);
                fous.close();
                log.info((Object)"Finished downloading wikidata database");
            } else {
                log.info((Object)("Using local wikidata database: " + this.wikidataMappingUrl));
            }
            Connection wikiMapping = DBDialect.SQLITE.getDatabaseConnection(fileName, log);
            this.selectById = wikiMapping.prepareStatement("SELECT lang, title from wiki_mapping where id = ?");
            this.selectId = wikiMapping.prepareStatement("SELECT id from wiki_mapping where lang = ? and title = ? ");
            if (!Algorithms.isEmpty((CharSequence)this.wikirankingUrl)) {
                String wikiRanking = this.wikirankingUrl;
                if (this.wikirankingUrl.startsWith("http")) {
                    log.info((Object)("Downloading wikiranking database by url " + this.wikirankingUrl));
                    URL url = new URL(this.wikirankingUrl);
                    URLConnection cn = url.openConnection();
                    wikiRanking = "wiki_ranking.sqlitedb";
                    FileOutputStream fous = new FileOutputStream(wikiRanking);
                    Algorithms.streamCopy((InputStream)cn.getInputStream(), (OutputStream)fous);
                    fous.close();
                    log.info((Object)"Finished downloading wikiranking database");
                } else {
                    log.info((Object)("Using local wikiranking database: " + this.wikirankingUrl));
                }
                Connection wikiRankingConn = DBDialect.SQLITE.getDatabaseConnection(wikiRanking, log);
                this.selectRankById = wikiRankingConn.prepareStatement("SELECT photoId, photoTitle, catId, catTitle, poikey, wikiTitle, osmid, osmtype, elo, qrank, topic, categories FROM wiki_rating WHERE id = ?");
            }
            this.init = true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.init;
    }
}

