/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.search.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.osmand.Collator;
import net.osmand.CollatorStringMatcher;
import net.osmand.OsmAndCollator;
import net.osmand.StringMatcher;
import net.osmand.binary.Abbreviations;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.CommonWords;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.osm.AbstractPoiType;
import net.osmand.search.core.ObjectType;
import net.osmand.search.core.SearchResult;
import net.osmand.search.core.SearchSettings;
import net.osmand.search.core.SearchWord;
import net.osmand.util.Algorithms;
import net.osmand.util.ArabicNormalizer;
import net.osmand.util.LocationParser;
import net.osmand.util.MapUtils;

public class SearchPhrase {
    public static final String DELIMITER = " ";
    public static final String ALLDELIMITERS = "\\s|,";
    public static final String ALLDELIMITERS_WITH_HYPHEN = "\\s|,|-";
    private static final Pattern reg = Pattern.compile("\\s|,");
    private static Comparator<String> commonWordsComparator;
    private static Set<String> conjunctions;
    private final Collator clt;
    private final SearchSettings settings;
    private List<BinaryMapIndexReader> indexes;
    private BinaryMapIndexReader fileRequest;
    private String fullTextSearchPhrase = "";
    private String unknownSearchPhrase = "";
    private List<SearchWord> words = new ArrayList<SearchWord>();
    private String firstUnknownSearchWord = "";
    private List<String> otherUnknownWords = new ArrayList<String>();
    private boolean lastUnknownSearchWordComplete;
    private String mainUnknownWordToSearch = null;
    private boolean mainUnknownSearchWordComplete;
    private NameStringMatcher firstUnknownNameStringMatcher;
    private NameStringMatcher mainUnknownNameStringMatcher;
    private List<NameStringMatcher> unknownWordsMatcher = new ArrayList<NameStringMatcher>();
    private AbstractPoiType unselectedPoiType;
    private boolean acceptPrivate;
    private QuadRect cache1kmRect;

    private SearchPhrase(SearchSettings settings, Collator clt) {
        this.settings = settings;
        this.clt = clt;
    }

    public Collator getCollator() {
        return this.clt;
    }

    public BinaryMapIndexReader getFileRequest() {
        return this.fileRequest;
    }

    public SearchPhrase generateNewPhrase(SearchPhrase phrase, BinaryMapIndexReader file) {
        SearchPhrase nphrase = this.generateNewPhrase(phrase.getUnknownSearchPhrase(), phrase.getSettings());
        nphrase.fileRequest = file;
        return nphrase;
    }

    public SearchPhrase generateNewPhrase(String text, SearchSettings settings) {
        String textToSearch = Algorithms.normalizeSearchText(text);
        List<SearchWord> leftWords = this.words;
        String thisTxt = this.getText(true);
        ArrayList<SearchWord> foundWords = new ArrayList<SearchWord>();
        if (textToSearch.startsWith(thisTxt = Algorithms.normalizeSearchText(thisTxt))) {
            textToSearch = textToSearch.substring(this.getText(false).length());
            foundWords.addAll(this.words);
            leftWords = leftWords.subList(leftWords.size(), leftWords.size());
        }
        for (SearchWord w : leftWords) {
            if (!textToSearch.startsWith(w.getWord() + DELIMITER)) break;
            foundWords.add(w);
            textToSearch = textToSearch.substring(w.getWord().length() + DELIMITER.length());
        }
        return this.createNewSearchPhrase(settings, text, foundWords, textToSearch);
    }

    public static SearchPhrase emptyPhrase() {
        return SearchPhrase.emptyPhrase(null);
    }

    public static SearchPhrase emptyPhrase(SearchSettings settings) {
        return SearchPhrase.emptyPhrase(settings, OsmAndCollator.primaryCollator());
    }

    public static SearchPhrase emptyPhrase(SearchSettings settings, Collator clt) {
        return new SearchPhrase(settings, clt);
    }

    private SearchPhrase createNewSearchPhrase(SearchSettings settings, String fullText, List<SearchWord> foundWords, String textToSearch) {
        SearchPhrase sp = new SearchPhrase(settings, this.clt);
        sp.words = foundWords;
        sp.fullTextSearchPhrase = fullText;
        sp.unknownSearchPhrase = textToSearch;
        sp.lastUnknownSearchWordComplete = this.isTextComplete(fullText);
        if (!reg.matcher(textToSearch).find()) {
            sp.firstUnknownSearchWord = sp.unknownSearchPhrase.trim();
        } else {
            sp.firstUnknownSearchWord = "";
            String[] ws = textToSearch.split(ALLDELIMITERS);
            boolean first = true;
            for (int i = 0; i < ws.length; ++i) {
                String wd = ws[i].trim();
                boolean conjunction = conjunctions.contains(wd.toLowerCase());
                boolean lastAndIncomplete = i == ws.length - 1 && !sp.lastUnknownSearchWordComplete;
                boolean decryptAbbreviations = this.needDecryptAbbreviations();
                if (wd.length() <= 0 || conjunction && !lastAndIncomplete) continue;
                if (first) {
                    sp.firstUnknownSearchWord = decryptAbbreviations ? Abbreviations.replace(wd) : wd;
                    first = false;
                    continue;
                }
                sp.otherUnknownWords.add(decryptAbbreviations ? Abbreviations.replace(wd) : wd);
            }
        }
        return sp;
    }

    private boolean needDecryptAbbreviations() {
        String langs;
        String string = langs = this.settings != null ? this.settings.getRegionLang() : null;
        if (langs != null) {
            String[] langArr;
            for (String lang : langArr = langs.split(",")) {
                if (!lang.equals("en")) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> splitWords(String w, List<String> ws, String delimiters) {
        if (!Algorithms.isEmpty(w)) {
            String[] wrs;
            for (String wr : wrs = w.split(delimiters)) {
                String wd = wr.trim();
                if (wd.length() <= 0) continue;
                ws.add(wd);
            }
        }
        return ws;
    }

    public static int countWords(String w) {
        int cnt = 0;
        if (!Algorithms.isEmpty(w)) {
            String[] ws = w.split(ALLDELIMITERS);
            for (int i = 0; i < ws.length; ++i) {
                String wd = ws[i].trim();
                if (wd.length() <= 0) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    public SearchPhrase selectWord(SearchResult res, List<String> unknownWords, boolean lastComplete) {
        SearchPhrase sp = new SearchPhrase(this.settings, this.clt);
        this.addResult(res, sp);
        SearchResult prnt = res.parentSearchResult;
        while (prnt != null) {
            this.addResult(prnt, sp);
            prnt = prnt.parentSearchResult;
        }
        sp.words.addAll(0, this.words);
        if (unknownWords != null) {
            sp.lastUnknownSearchWordComplete = lastComplete;
            StringBuilder genUnknownSearchPhrase = new StringBuilder();
            for (int i = 0; i < unknownWords.size(); ++i) {
                if (i == 0) {
                    sp.firstUnknownSearchWord = unknownWords.get(0);
                } else {
                    sp.otherUnknownWords.add(unknownWords.get(i));
                }
                genUnknownSearchPhrase.append(unknownWords.get(i)).append(DELIMITER);
            }
            sp.fullTextSearchPhrase = this.fullTextSearchPhrase;
            sp.unknownSearchPhrase = genUnknownSearchPhrase.toString().trim();
        }
        return sp;
    }

    private void calcMainUnknownWordToSearch() {
        if (this.mainUnknownWordToSearch != null) {
            return;
        }
        List<String> unknownSearchWords = this.otherUnknownWords;
        this.mainUnknownWordToSearch = this.firstUnknownSearchWord;
        this.mainUnknownSearchWordComplete = this.lastUnknownSearchWordComplete;
        if (!unknownSearchWords.isEmpty()) {
            this.mainUnknownSearchWordComplete = true;
            ArrayList<String> searchWords = new ArrayList<String>(unknownSearchWords);
            searchWords.add(0, this.getFirstUnknownSearchWord());
            Collections.sort(searchWords, commonWordsComparator);
            for (String s : searchWords) {
                if (s.length() <= 0 || LocationParser.isValidOLC(s)) continue;
                this.mainUnknownWordToSearch = s.trim();
                if (this.mainUnknownWordToSearch.endsWith(".")) {
                    this.mainUnknownWordToSearch = this.mainUnknownWordToSearch.substring(0, this.mainUnknownWordToSearch.length() - 1);
                    this.mainUnknownSearchWordComplete = false;
                }
                int unknownInd = unknownSearchWords.indexOf(s);
                if (this.lastUnknownSearchWordComplete || unknownSearchWords.size() - 1 != unknownInd) break;
                this.mainUnknownSearchWordComplete = false;
                break;
            }
        }
        if (ArabicNormalizer.isSpecialArabic(this.mainUnknownWordToSearch)) {
            String normalized = ArabicNormalizer.normalize(this.mainUnknownWordToSearch);
            this.mainUnknownWordToSearch = normalized == null ? this.mainUnknownWordToSearch : normalized;
        }
    }

    public List<SearchWord> getWords() {
        return this.words;
    }

    public AbstractPoiType getUnselectedPoiType() {
        return this.unselectedPoiType;
    }

    public void setUnselectedPoiType(AbstractPoiType unselectedPoiType) {
        this.unselectedPoiType = unselectedPoiType;
    }

    public boolean isMainUnknownSearchWordComplete() {
        return this.mainUnknownSearchWordComplete;
    }

    public boolean isLastUnknownSearchWordComplete() {
        return this.lastUnknownSearchWordComplete;
    }

    public boolean hasMoreThanOneUnknownSearchWord() {
        return this.otherUnknownWords.size() > 0;
    }

    public List<String> getUnknownSearchWords() {
        return this.otherUnknownWords;
    }

    public String getFirstUnknownSearchWord() {
        return this.firstUnknownSearchWord;
    }

    public boolean isFirstUnknownSearchWordComplete() {
        return this.hasMoreThanOneUnknownSearchWord() || this.isLastUnknownSearchWordComplete();
    }

    public boolean isAcceptPrivate() {
        return this.acceptPrivate;
    }

    public void setAcceptPrivate(boolean acceptPrivate) {
        this.acceptPrivate = acceptPrivate;
    }

    public String getFullSearchPhrase() {
        return this.fullTextSearchPhrase;
    }

    public String getUnknownSearchPhrase() {
        return this.unknownSearchPhrase;
    }

    public boolean isUnknownSearchWordPresent() {
        return this.firstUnknownSearchWord.length() > 0;
    }

    public QuadRect getRadiusBBoxToSearch(int radius) {
        QuadRect searchBBox31 = this.settings.getSearchBBox31();
        if (searchBBox31 != null) {
            return searchBBox31;
        }
        int radiusInMeters = this.getRadiusSearch(radius);
        QuadRect cache1kmRect = this.get1km31Rect();
        if (cache1kmRect == null) {
            return null;
        }
        int max = Integer.MAX_VALUE;
        double dx = cache1kmRect.width() / 2.0 * (double)radiusInMeters / 1000.0;
        double dy = cache1kmRect.height() / 2.0 * (double)radiusInMeters / 1000.0;
        double topLeftX = Math.max(0.0, cache1kmRect.left - dx);
        double topLeftY = Math.max(0.0, cache1kmRect.top - dy);
        double bottomRightX = Math.min((double)max, cache1kmRect.right + dx);
        double bottomRightY = Math.min((double)max, cache1kmRect.bottom + dy);
        return new QuadRect(topLeftX, topLeftY, bottomRightX, bottomRightY);
    }

    public QuadRect get1km31Rect() {
        if (this.cache1kmRect != null) {
            return this.cache1kmRect;
        }
        LatLon l = this.getLastTokenLocation();
        if (l == null) {
            return null;
        }
        float coeff = (float)(1000.0 / MapUtils.getTileDistanceWidth(16.0f));
        double tx = MapUtils.getTileNumberX(16.0f, l.getLongitude());
        double ty = MapUtils.getTileNumberY(16.0f, l.getLatitude());
        double topLeftX = Math.max(0.0, tx - (double)coeff);
        double topLeftY = Math.max(0.0, ty - (double)coeff);
        int max = 65535;
        double bottomRightX = Math.min((double)max, tx + (double)coeff);
        double bottomRightY = Math.min((double)max, ty + (double)coeff);
        double pw = MapUtils.getPowZoom(15.0);
        this.cache1kmRect = new QuadRect(topLeftX * pw, topLeftY * pw, bottomRightX * pw, bottomRightY * pw);
        return this.cache1kmRect;
    }

    public Iterator<BinaryMapIndexReader> getRadiusOfflineIndexes(int meters, SearchPhraseDataType dt) {
        QuadRect rect = meters > 0 ? this.getRadiusBBoxToSearch(meters) : null;
        return this.getOfflineIndexes(rect, dt);
    }

    public Iterator<BinaryMapIndexReader> getOfflineIndexes(final QuadRect rect, final SearchPhraseDataType dt) {
        List<BinaryMapIndexReader> list = this.indexes != null ? this.indexes : this.settings.getOfflineIndexes();
        final Iterator<BinaryMapIndexReader> lit = list.iterator();
        return new Iterator<BinaryMapIndexReader>(){
            BinaryMapIndexReader next = null;

            @Override
            public boolean hasNext() {
                while (lit.hasNext()) {
                    this.next = (BinaryMapIndexReader)lit.next();
                    if (rect != null) {
                        if (!(dt == SearchPhraseDataType.POI ? this.next.containsPoiData((int)rect.left, (int)rect.top, (int)rect.right, (int)rect.bottom) : (dt == SearchPhraseDataType.ADDRESS ? this.next.containsPoiData((int)rect.left, (int)rect.top, (int)rect.right, (int)rect.bottom) && this.next.containsAddressData() : (dt == SearchPhraseDataType.ROUTING ? this.next.containsRouteData((int)rect.left, (int)rect.top, (int)rect.right, (int)rect.bottom, 15) : this.next.containsMapData((int)rect.left, (int)rect.top, (int)rect.right, (int)rect.bottom, 15))))) continue;
                        return true;
                    }
                    return true;
                }
                return false;
            }

            @Override
            public BinaryMapIndexReader next() {
                return this.next;
            }

            @Override
            public void remove() {
            }
        };
    }

    public List<BinaryMapIndexReader> getOfflineIndexes() {
        if (this.indexes != null) {
            return this.indexes;
        }
        return this.settings.getOfflineIndexes();
    }

    public SearchSettings getSettings() {
        return this.settings;
    }

    public int getRadiusLevel() {
        return this.settings.getRadiusLevel();
    }

    public ObjectType[] getSearchTypes() {
        return this.settings == null ? null : this.settings.getSearchTypes();
    }

    public boolean isCustomSearch() {
        return this.getSearchTypes() != null;
    }

    public boolean hasCustomSearchType(ObjectType type) {
        return this.settings.hasCustomSearchType(type);
    }

    public boolean isSearchTypeAllowed(ObjectType searchType) {
        return this.isSearchTypeAllowed(searchType, false);
    }

    public boolean isSearchTypeAllowed(ObjectType searchType, boolean exclusive) {
        ObjectType[] searchTypes = this.getSearchTypes();
        if (searchTypes == null) {
            return !exclusive;
        }
        if (exclusive && searchTypes.length > 1) {
            return false;
        }
        for (ObjectType type : searchTypes) {
            if (type != searchType) continue;
            return true;
        }
        return false;
    }

    public boolean isEmptyQueryAllowed() {
        return this.settings.isEmptyQueryAllowed();
    }

    public boolean isSortByName() {
        return this.settings.isSortByName();
    }

    public SearchPhrase selectWord(SearchResult res) {
        return this.selectWord(res, null, false);
    }

    public void addResult(SearchResult res, SearchPhrase sp) {
        SearchWord sw = new SearchWord(res.wordsSpan != null ? res.wordsSpan : res.localeName.trim(), res);
        sp.words.add(0, sw);
    }

    public boolean isLastWord(ObjectType ... p) {
        for (int i = this.words.size() - 1; i >= 0; --i) {
            SearchWord sw = this.words.get(i);
            for (ObjectType o : p) {
                if (sw.getType() != o) continue;
                return true;
            }
            if (sw.getType() == ObjectType.UNKNOWN_NAME_FILTER) continue;
            return false;
        }
        return false;
    }

    public ObjectType getExclusiveSearchType() {
        SearchWord lastWord = this.getLastSelectedWord();
        if (lastWord != null) {
            return ObjectType.getExclusiveSearchType(lastWord.getType());
        }
        return null;
    }

    public NameStringMatcher getMainUnknownNameStringMatcher() {
        this.calcMainUnknownWordToSearch();
        if (this.mainUnknownNameStringMatcher == null) {
            this.mainUnknownNameStringMatcher = this.getNameStringMatcher(this.mainUnknownWordToSearch, this.mainUnknownSearchWordComplete);
        }
        return this.mainUnknownNameStringMatcher;
    }

    public NameStringMatcher getFirstUnknownNameStringMatcher() {
        if (this.firstUnknownNameStringMatcher == null) {
            this.firstUnknownNameStringMatcher = this.getNameStringMatcher(this.firstUnknownSearchWord, this.isFirstUnknownSearchWordComplete());
        }
        return this.firstUnknownNameStringMatcher;
    }

    public NameStringMatcher getUnknownNameStringMatcher(int i) {
        while (this.unknownWordsMatcher.size() <= i) {
            int ind = this.unknownWordsMatcher.size();
            boolean completeMatch = ind < this.otherUnknownWords.size() - 1 || this.isLastUnknownSearchWordComplete();
            this.unknownWordsMatcher.add(this.getNameStringMatcher(this.otherUnknownWords.get(ind), completeMatch));
        }
        return this.unknownWordsMatcher.get(i);
    }

    private NameStringMatcher getNameStringMatcher(String word, boolean complete) {
        return new NameStringMatcher(word, complete ? CollatorStringMatcher.StringMatcherMode.CHECK_EQUALS_FROM_SPACE : CollatorStringMatcher.StringMatcherMode.CHECK_STARTS_FROM_SPACE);
    }

    public boolean hasObjectType(ObjectType p) {
        for (SearchWord s : this.words) {
            if (s.getType() != p) continue;
            return true;
        }
        return false;
    }

    public void syncWordsWithResults() {
        for (SearchWord w : this.words) {
            w.syncWordWithResult();
        }
    }

    public String getText(boolean includeUnknownPart) {
        StringBuilder sb = new StringBuilder();
        for (SearchWord s : this.words) {
            sb.append(s.getWord()).append(DELIMITER);
        }
        if (includeUnknownPart) {
            sb.append(this.unknownSearchPhrase);
        }
        return sb.toString();
    }

    public String getTextWithoutLastWord() {
        StringBuilder sb = new StringBuilder();
        ArrayList<SearchWord> words = new ArrayList<SearchWord>(this.words);
        if (Algorithms.isEmpty(this.unknownSearchPhrase.trim()) && words.size() > 0) {
            words.remove(words.size() - 1);
        }
        for (SearchWord s : words) {
            sb.append(s.getWord()).append(DELIMITER);
        }
        return sb.toString();
    }

    public String getStringRerpresentation() {
        StringBuilder sb = new StringBuilder();
        for (SearchWord s : this.words) {
            sb.append(s.getWord()).append(" [" + String.valueOf((Object)s.getType()) + "], ");
        }
        sb.append(this.unknownSearchPhrase);
        return sb.toString();
    }

    public String toString() {
        return this.getStringRerpresentation();
    }

    public boolean isNoSelectedType() {
        return this.words.isEmpty();
    }

    public boolean isEmpty() {
        return this.words.isEmpty() && this.unknownSearchPhrase.isEmpty();
    }

    public SearchWord getLastSelectedWord() {
        if (this.words.isEmpty()) {
            return null;
        }
        return this.words.get(this.words.size() - 1);
    }

    public LatLon getWordLocation() {
        for (int i = this.words.size() - 1; i >= 0; --i) {
            SearchWord sw = this.words.get(i);
            if (sw.getLocation() == null) continue;
            return sw.getLocation();
        }
        return null;
    }

    public LatLon getLastTokenLocation() {
        for (int i = this.words.size() - 1; i >= 0; --i) {
            SearchWord sw = this.words.get(i);
            if (sw.getLocation() == null) continue;
            return sw.getLocation();
        }
        if (this.settings != null) {
            return this.settings.getOriginalLocation();
        }
        return null;
    }

    public void selectFile(BinaryMapIndexReader object) {
        if (this.indexes == null) {
            this.indexes = new ArrayList<BinaryMapIndexReader>();
        }
        if (!this.indexes.contains(object)) {
            this.indexes.add(object);
        }
    }

    public void sortFiles() {
        if (this.indexes == null) {
            this.indexes = new ArrayList<BinaryMapIndexReader>(this.getOfflineIndexes());
        }
        Map<String, List<BinaryMapIndexReader>> diffsByRegion = this.getDiffsByRegion();
        final LatLon ll = this.getLastTokenLocation();
        if (ll != null) {
            Collections.sort(this.indexes, new Comparator<BinaryMapIndexReader>(){
                Map<BinaryMapIndexReader, LatLon> locations = new HashMap<BinaryMapIndexReader, LatLon>();

                @Override
                public int compare(BinaryMapIndexReader o1, BinaryMapIndexReader o2) {
                    LatLon rc1 = o1 == null ? null : this.getLocation(o1);
                    LatLon rc2 = o2 == null ? null : this.getLocation(o2);
                    double d1 = rc1 == null ? 1.0E7 : MapUtils.getDistance(rc1, ll);
                    double d2 = rc2 == null ? 1.0E7 : MapUtils.getDistance(rc2, ll);
                    return Double.compare(d1, d2);
                }

                private LatLon getLocation(BinaryMapIndexReader o1) {
                    if (this.locations.containsKey(o1)) {
                        return this.locations.get(o1);
                    }
                    LatLon rc1 = null;
                    rc1 = o1.containsMapData() ? o1.getMapIndexes().get(0).getCenterLatLon() : o1.getRegionCenter();
                    this.locations.put(o1, rc1);
                    return rc1;
                }
            });
            if (!diffsByRegion.isEmpty()) {
                ArrayList<BinaryMapIndexReader> finalSort = new ArrayList<BinaryMapIndexReader>();
                for (int i = 0; i < this.indexes.size(); ++i) {
                    BinaryMapIndexReader currFile = this.indexes.get(i);
                    if (diffsByRegion.get(currFile.getRegionName()) != null) {
                        finalSort.addAll((Collection)diffsByRegion.get(currFile.getRegionName()));
                        finalSort.add(currFile);
                        continue;
                    }
                    finalSort.add(currFile);
                }
                this.indexes.clear();
                this.indexes.addAll(finalSort);
            }
        }
    }

    private Map<String, List<BinaryMapIndexReader>> getDiffsByRegion() {
        HashMap<String, List<BinaryMapIndexReader>> result = new HashMap<String, List<BinaryMapIndexReader>>();
        Iterator<BinaryMapIndexReader> it = this.indexes.iterator();
        while (it.hasNext()) {
            String filename;
            BinaryMapIndexReader r = it.next();
            if (r == null || r.getFile() == null || !(filename = r.getFile().getName()).matches("([a-zA-Z-]+_)+([0-9]+_){2}[0-9]+\\.obf")) continue;
            String currRegionName = r.getRegionName();
            if (result.containsKey(currRegionName)) {
                ((List)result.get(currRegionName)).add(r);
            } else {
                result.put(currRegionName, new ArrayList<BinaryMapIndexReader>(Collections.singletonList(r)));
            }
            it.remove();
        }
        return result;
    }

    public int countUnknownWordsMatchMainResult(SearchResult sr) {
        return this.countUnknownWordsMatchInternal(sr, null, 0);
    }

    public int countUnknownWordsMatchMainResult(SearchResult sr, int amountMatchingWords) {
        return this.countUnknownWordsMatchInternal(sr, null, amountMatchingWords);
    }

    public int countUnknownWordsMatchMainResult(SearchResult sr, String name, int amountMatchingWords) {
        return this.countUnknownWordsMatchInternal(sr, name, amountMatchingWords);
    }

    private int countUnknownWordsMatchInternal(SearchResult sr, String extraName, int amountMatchingWords) {
        int r = 0;
        if (this.otherUnknownWords.size() > 0) {
            for (int i = 0; i < this.otherUnknownWords.size(); ++i) {
                boolean match = false;
                if (i < amountMatchingWords - 1) {
                    match = true;
                } else {
                    NameStringMatcher ms = this.getUnknownNameStringMatcher(i);
                    if (ms.matches(sr.localeName) || ms.matches(sr.otherNames) || ms.matches(sr.alternateName) || ms.matches(extraName)) {
                        match = true;
                    }
                }
                if (!match) continue;
                if (sr.otherWordsMatch == null) {
                    sr.otherWordsMatch = new TreeSet<String>();
                }
                sr.otherWordsMatch.add(this.otherUnknownWords.get(i));
                ++r;
            }
        }
        if (amountMatchingWords > 0) {
            sr.firstUnknownWordMatches = true;
            ++r;
        } else {
            boolean match;
            boolean bl = match = this.getFirstUnknownNameStringMatcher().matches(sr.localeName) || this.getFirstUnknownNameStringMatcher().matches(sr.otherNames) || this.getFirstUnknownNameStringMatcher().matches(sr.alternateName) || this.getFirstUnknownNameStringMatcher().matches(extraName);
            if (match) {
                ++r;
            }
            sr.firstUnknownWordMatches = match || sr.firstUnknownWordMatches;
        }
        return r;
    }

    public String getLastUnknownSearchWord() {
        if (this.otherUnknownWords.size() > 0) {
            return this.otherUnknownWords.get(this.otherUnknownWords.size() - 1);
        }
        return this.firstUnknownSearchWord;
    }

    public int getRadiusSearch(int meters, int radiusLevel) {
        int res = meters;
        for (int k = 0; k < radiusLevel; ++k) {
            res *= k % 2 == 0 ? 2 : 3;
        }
        return res;
    }

    public int getRadiusSearch(int meters) {
        return this.getRadiusSearch(meters, this.getRadiusLevel() - 1);
    }

    public int getNextRadiusSearch(int meters) {
        return this.getRadiusSearch(meters, this.getRadiusLevel());
    }

    public static int icompare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private int getUnknownWordToSearchBuildingInd() {
        if (this.otherUnknownWords.size() > 0 && Algorithms.extractFirstIntegerNumber(this.getFirstUnknownSearchWord()) == 0) {
            int ind = 0;
            for (String wrd : this.otherUnknownWords) {
                ++ind;
                if (Algorithms.extractFirstIntegerNumber(wrd) == 0) continue;
                return ind;
            }
        }
        return 0;
    }

    public NameStringMatcher getUnknownWordToSearchBuildingNameMatcher() {
        int ind = this.getUnknownWordToSearchBuildingInd();
        if (ind > 0) {
            return this.getUnknownNameStringMatcher(ind - 1);
        }
        return this.getFirstUnknownNameStringMatcher();
    }

    public String getUnknownWordToSearchBuilding() {
        int ind = this.getUnknownWordToSearchBuildingInd();
        if (ind > 0) {
            return this.otherUnknownWords.get(ind - 1);
        }
        return this.firstUnknownSearchWord;
    }

    private static int lengthWithoutNumbers(String s) {
        int len = 0;
        for (int k = 0; k < s.length(); ++k) {
            if (s.charAt(k) >= '0' && s.charAt(k) <= '9') continue;
            ++len;
        }
        return len;
    }

    public String getUnknownWordToSearch() {
        this.calcMainUnknownWordToSearch();
        return this.mainUnknownWordToSearch;
    }

    private boolean isTextComplete(String fullText) {
        boolean lastUnknownSearchWordComplete = false;
        if (fullText.length() > 0) {
            char ch = fullText.charAt(fullText.length() - 1);
            lastUnknownSearchWordComplete = ch == ' ' || ch == ',' || ch == '\r' || ch == '\n' || ch == ';';
        }
        return lastUnknownSearchWordComplete;
    }

    static {
        conjunctions = new TreeSet<String>();
        conjunctions.add("the");
        conjunctions.add("der");
        conjunctions.add("den");
        conjunctions.add("die");
        conjunctions.add("das");
        conjunctions.add("la");
        conjunctions.add("le");
        conjunctions.add("el");
        conjunctions.add("il");
        conjunctions.add("and");
        conjunctions.add("und");
        conjunctions.add("en");
        conjunctions.add("et");
        conjunctions.add("y");
        conjunctions.add("\u0438");
        commonWordsComparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int i2;
                int i1 = CommonWords.getCommonSearch(o1.toLowerCase());
                if (i1 != (i2 = CommonWords.getCommonSearch(o2.toLowerCase()))) {
                    if (i1 == -1) {
                        return -1;
                    }
                    if (i2 == -1) {
                        return 1;
                    }
                    return -SearchPhrase.icompare(i1, i2);
                }
                return -SearchPhrase.icompare(SearchPhrase.lengthWithoutNumbers(o1), SearchPhrase.lengthWithoutNumbers(o2));
            }
        };
    }

    public static enum SearchPhraseDataType {
        MAP,
        ADDRESS,
        ROUTING,
        POI;

    }

    public static class NameStringMatcher
    implements StringMatcher {
        private CollatorStringMatcher sm;

        public NameStringMatcher(String namePart, CollatorStringMatcher.StringMatcherMode mode) {
            this.sm = new CollatorStringMatcher(namePart, mode);
        }

        public boolean matches(Collection<String> map) {
            if (map == null) {
                return false;
            }
            for (String v : map) {
                if (!this.sm.matches(v)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean matches(String name) {
            if (name == null || name.length() == 0) {
                return false;
            }
            return this.sm.matches(name);
        }
    }
}

