/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.osmand.CallbackWithObject;
import net.osmand.Collator;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.ObfConstants;
import net.osmand.data.Amenity;
import net.osmand.data.BaseDetailsObject;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.Street;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.MapPoiTypes;
import net.osmand.search.core.CustomSearchPoiFilter;
import net.osmand.search.core.ObjectType;
import net.osmand.search.core.SearchCoreAPI;
import net.osmand.search.core.SearchCoreFactory;
import net.osmand.search.core.SearchExportSettings;
import net.osmand.search.core.SearchPhrase;
import net.osmand.search.core.SearchResult;
import net.osmand.search.core.SearchSettings;
import net.osmand.search.core.SearchWord;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONObject;

public class SearchUICore {
    private static final int TIMEOUT_BETWEEN_CHARS = 700;
    private static final int TIMEOUT_BEFORE_SEARCH = 50;
    private static final int TIMEOUT_BEFORE_FILTER = 20;
    private static final Log LOG = PlatformUtil.getLog(SearchUICore.class);
    private SearchPhrase phrase;
    private SearchResultCollection currentSearchResult;
    private ThreadPoolExecutor singleThreadedExecutor;
    private LinkedBlockingQueue<Runnable> taskQueue;
    private Runnable onSearchStart = null;
    private Runnable onResultsComplete = null;
    private AtomicInteger requestNumber = new AtomicInteger();
    private int totalLimit = -1;
    List<SearchCoreAPI> apis = new ArrayList<SearchCoreAPI>();
    private SearchSettings searchSettings;
    private MapPoiTypes poiTypes;
    private static boolean debugMode = false;
    private static final Set<String> FILTER_DUPLICATE_POI_SUBTYPE = new TreeSet<String>(Arrays.asList("building", "internet_access_yes"));

    public SearchUICore(MapPoiTypes poiTypes, String locale, boolean transliterate) {
        this.poiTypes = poiTypes;
        this.taskQueue = new LinkedBlockingQueue();
        this.searchSettings = new SearchSettings(new ArrayList());
        this.searchSettings = this.searchSettings.setLang(locale, transliterate);
        this.phrase = SearchPhrase.emptyPhrase(this.searchSettings);
        this.currentSearchResult = new SearchResultCollection(this.phrase);
        this.singleThreadedExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.taskQueue);
    }

    public static void setDebugMode(boolean debugMode) {
        SearchUICore.debugMode = debugMode;
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public MapPoiTypes getPoiTypes() {
        return this.poiTypes;
    }

    public void setPoiTypes(MapPoiTypes poiTypes) {
        this.poiTypes = poiTypes;
    }

    public int getTotalLimit() {
        return this.totalLimit;
    }

    public void setTotalLimit(int totalLimit) {
        this.totalLimit = totalLimit;
    }

    public <T> T getApiByClass(Class<T> cl) {
        for (SearchCoreAPI a : this.apis) {
            if (!cl.isInstance(a)) continue;
            return (T)a;
        }
        return null;
    }

    public <T extends SearchCoreAPI> SearchResultCollection shallowSearch(Class<T> cl, String text, ResultMatcher<SearchResult> matcher) throws IOException {
        return this.shallowSearch(cl, text, matcher, true, true);
    }

    public <T extends SearchCoreAPI> SearchResultCollection shallowSearch(Class<T> cl, String text, ResultMatcher<SearchResult> matcher, boolean resortAll, boolean removeDuplicates) throws IOException {
        return this.shallowSearch(cl, text, matcher, resortAll, removeDuplicates, this.searchSettings);
    }

    public <T extends SearchCoreAPI> SearchResultCollection shallowSearch(Class<T> cl, String text, ResultMatcher<SearchResult> matcher, boolean resortAll, boolean removeDuplicates, SearchSettings searchSettings) throws IOException {
        SearchCoreAPI api = (SearchCoreAPI)this.getApiByClass(cl);
        if (api != null) {
            if (debugMode) {
                LOG.info((Object)("Start shallow search <" + String.valueOf(this.phrase) + "> API=<" + String.valueOf(api) + ">"));
            }
            SearchPhrase sphrase = this.phrase.generateNewPhrase(text, searchSettings);
            this.preparePhrase(sphrase);
            AtomicInteger ai = new AtomicInteger();
            SearchResultMatcher rm = new SearchResultMatcher(matcher, sphrase, ai.get(), ai, this.totalLimit);
            api.search(sphrase, rm);
            SearchResultCollection collection = new SearchResultCollection(sphrase);
            if (rm.totalLimit != -1 && rm.count > rm.totalLimit) {
                collection.setUseLimit(true);
            }
            collection.addSearchResults(rm.getRequestResults(), resortAll, removeDuplicates);
            if (debugMode) {
                LOG.info((Object)("Finish shallow search <" + String.valueOf(sphrase) + "> Results=" + rm.getRequestResults().size()));
            }
            return collection;
        }
        return null;
    }

    public <T extends SearchCoreAPI> void shallowSearchAsync(final Class<T> cl, final String text, final ResultMatcher<SearchResult> matcher, final boolean resortAll, final boolean removeDuplicates, final SearchSettings searchSettings, final CallbackWithObject<SearchResultCollection> callback) {
        this.singleThreadedExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    SearchResultCollection collection = SearchUICore.this.shallowSearch(cl, text, matcher, resortAll, removeDuplicates, searchSettings);
                    if (callback != null) {
                        callback.processResult(collection);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public void init() {
        SearchCoreFactory.SearchAmenityByNameAPI amenitiesApi = new SearchCoreFactory.SearchAmenityByNameAPI();
        this.apis.add(amenitiesApi);
        this.apis.add(new SearchCoreFactory.SearchLocationAndUrlAPI(amenitiesApi));
        SearchCoreFactory.SearchAmenityTypesAPI searchAmenityTypesAPI = new SearchCoreFactory.SearchAmenityTypesAPI(this.poiTypes);
        this.apis.add(searchAmenityTypesAPI);
        this.apis.add(new SearchCoreFactory.SearchAmenityByTypeAPI(this.poiTypes, searchAmenityTypesAPI));
        SearchCoreFactory.SearchBuildingAndIntersectionsByStreetAPI streetsApi = new SearchCoreFactory.SearchBuildingAndIntersectionsByStreetAPI();
        this.apis.add(streetsApi);
        SearchCoreFactory.SearchStreetByCityAPI cityApi = new SearchCoreFactory.SearchStreetByCityAPI(streetsApi);
        this.apis.add(cityApi);
        this.apis.add(new SearchCoreFactory.SearchAddressByNameAPI(streetsApi, cityApi));
    }

    public void clearCustomSearchPoiFilters() {
        for (SearchCoreAPI capi : this.apis) {
            if (!(capi instanceof SearchCoreFactory.SearchAmenityTypesAPI)) continue;
            ((SearchCoreFactory.SearchAmenityTypesAPI)capi).clearCustomFilters();
        }
    }

    public void addCustomSearchPoiFilter(CustomSearchPoiFilter poiFilter, int priority) {
        for (SearchCoreAPI capi : this.apis) {
            if (!(capi instanceof SearchCoreFactory.SearchAmenityTypesAPI)) continue;
            ((SearchCoreFactory.SearchAmenityTypesAPI)capi).addCustomFilter(poiFilter, priority);
        }
    }

    public void setActivePoiFiltersByOrder(List<String> filterOrders) {
        for (SearchCoreAPI capi : this.apis) {
            if (!(capi instanceof SearchCoreFactory.SearchAmenityTypesAPI)) continue;
            ((SearchCoreFactory.SearchAmenityTypesAPI)capi).setActivePoiFiltersByOrder(filterOrders);
        }
    }

    public void registerAPI(SearchCoreAPI api) {
        this.apis.add(api);
    }

    public SearchResultCollection getCurrentSearchResult() {
        return this.currentSearchResult;
    }

    public SearchPhrase getPhrase() {
        return this.phrase;
    }

    public void setOnSearchStart(Runnable onSearchStart) {
        this.onSearchStart = onSearchStart;
    }

    public void setOnResultsComplete(Runnable onResultsComplete) {
        this.onResultsComplete = onResultsComplete;
    }

    public SearchSettings getSearchSettings() {
        return this.searchSettings;
    }

    public void updateSettings(SearchSettings settings) {
        this.searchSettings = settings;
    }

    private void filterCurrentResults(SearchPhrase phrase, ResultMatcher<SearchResult> matcher) {
        if (matcher == null) {
            return;
        }
        List<SearchResult> l = this.currentSearchResult.searchResults;
        for (SearchResult r : l) {
            if (this.filterOneResult(r, phrase)) {
                matcher.publish(r);
            }
            if (!matcher.isCancelled()) continue;
            return;
        }
    }

    private boolean filterOneResult(SearchResult object, SearchPhrase phrase) {
        SearchPhrase.NameStringMatcher nameStringMatcher = phrase.getFirstUnknownNameStringMatcher();
        return nameStringMatcher.matches(object.localeName) || nameStringMatcher.matches(object.otherNames);
    }

    public boolean selectSearchResult(SearchResult r) {
        this.phrase = this.phrase.selectWord(r);
        return true;
    }

    public SearchPhrase resetPhrase() {
        this.phrase = this.phrase.generateNewPhrase("", this.searchSettings);
        return this.phrase;
    }

    public SearchPhrase resetPhrase(String text) {
        this.phrase = this.phrase.generateNewPhrase(text, this.searchSettings);
        return this.phrase;
    }

    public SearchPhrase resetPhrase(SearchResult result) {
        this.phrase = this.phrase.generateNewPhrase("", this.searchSettings);
        this.phrase.addResult(result, this.phrase);
        return this.phrase;
    }

    public SearchResultCollection immediateSearch(String text, LatLon loc) {
        if (loc != null) {
            this.searchSettings = this.searchSettings.setOriginalLocation(loc);
        }
        SearchPhrase searchPhrase = this.phrase.generateNewPhrase(text, this.searchSettings);
        SearchResultMatcher rm = new SearchResultMatcher(null, searchPhrase, this.requestNumber.get(), this.requestNumber, this.totalLimit);
        this.searchInternal(searchPhrase, rm);
        SearchResultCollection resultCollection = new SearchResultCollection(searchPhrase);
        if (rm.totalLimit != -1 && rm.count > rm.totalLimit) {
            resultCollection.setUseLimit(true);
        }
        resultCollection.addSearchResults(rm.getRequestResults(), true, true);
        return resultCollection;
    }

    public void search(String text, boolean delayedExecution, ResultMatcher<SearchResult> matcher) {
        this.search(text, delayedExecution, matcher, this.searchSettings);
    }

    public void search(String text, final boolean delayedExecution, final ResultMatcher<SearchResult> matcher, SearchSettings searchSettings) {
        final int request = this.requestNumber.incrementAndGet();
        final SearchPhrase phrase = this.phrase.generateNewPhrase(text, searchSettings);
        phrase.setAcceptPrivate(this.phrase.isAcceptPrivate());
        this.phrase = phrase;
        if (debugMode) {
            LOG.info((Object)("Prepare search <" + String.valueOf(phrase) + ">"));
        }
        this.singleThreadedExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (SearchUICore.this.onSearchStart != null) {
                        SearchUICore.this.onSearchStart.run();
                    }
                    final SearchResultMatcher rm = new SearchResultMatcher(matcher, phrase, request, SearchUICore.this.requestNumber, SearchUICore.this.totalLimit);
                    if (debugMode) {
                        LOG.info((Object)("Starting search <" + phrase.toString() + ">"));
                    }
                    rm.searchStarted(phrase);
                    if (debugMode) {
                        LOG.info((Object)("Search started <" + phrase.toString() + ">"));
                    }
                    if (delayedExecution) {
                        long startTime = System.currentTimeMillis();
                        if (debugMode) {
                            LOG.info((Object)("Wait for next char <" + phrase.toString() + ">"));
                        }
                        boolean filtered = false;
                        while (System.currentTimeMillis() - startTime <= 700L) {
                            if (rm.isCancelled()) {
                                if (debugMode) {
                                    LOG.info((Object)("Search cancelled <" + String.valueOf(phrase) + ">"));
                                }
                                return;
                            }
                            Thread.sleep(20L);
                            if (filtered) continue;
                            final SearchResultCollection quickRes = new SearchResultCollection(phrase);
                            if (debugMode) {
                                LOG.info((Object)("Filtering current data <" + String.valueOf(phrase) + "> Results=" + SearchUICore.this.currentSearchResult.searchResults.size()));
                            }
                            SearchUICore.this.filterCurrentResults(phrase, new ResultMatcher<SearchResult>(){

                                @Override
                                public boolean publish(SearchResult object) {
                                    quickRes.searchResults.add(object);
                                    return true;
                                }

                                @Override
                                public boolean isCancelled() {
                                    return rm.isCancelled();
                                }
                            });
                            if (debugMode) {
                                LOG.info((Object)("Current data filtered <" + String.valueOf(phrase) + "> Results=" + quickRes.searchResults.size()));
                            }
                            if (rm.totalLimit != -1 && rm.count > rm.totalLimit) {
                                quickRes.setUseLimit(true);
                            }
                            if (!rm.isCancelled()) {
                                SearchUICore.this.currentSearchResult = quickRes;
                                rm.filterFinished(phrase);
                            }
                            filtered = true;
                        }
                    } else {
                        Thread.sleep(50L);
                    }
                    if (rm.isCancelled()) {
                        if (debugMode) {
                            LOG.info((Object)("Search cancelled <" + String.valueOf(phrase) + ">"));
                        }
                        return;
                    }
                    SearchUICore.this.searchInternal(phrase, rm);
                    if (!rm.isCancelled()) {
                        SearchResultCollection collection = new SearchResultCollection(phrase);
                        if (rm.totalLimit != -1 && rm.count > rm.totalLimit) {
                            collection.setUseLimit(true);
                        }
                        if (debugMode) {
                            LOG.info((Object)("Processing search results <" + String.valueOf(phrase) + ">"));
                        }
                        collection.addSearchResults(rm.getRequestResults(), true, true);
                        if (debugMode) {
                            LOG.info((Object)("Finishing search <" + String.valueOf(phrase) + "> Results=" + rm.getRequestResults().size()));
                        }
                        SearchUICore.this.currentSearchResult = collection;
                        if (phrase.getSettings().isExportObjects()) {
                            rm.createTestJSON(collection);
                        }
                        rm.searchFinished(phrase);
                        if (SearchUICore.this.onResultsComplete != null) {
                            SearchUICore.this.onResultsComplete.run();
                        }
                        if (debugMode) {
                            LOG.info((Object)("Search finished <" + String.valueOf(phrase) + "> Results=" + rm.getRequestResults().size()));
                        }
                    } else if (debugMode) {
                        LOG.info((Object)("Search cancelled <" + String.valueOf(phrase) + ">"));
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public boolean isSearchMoreAvailable(SearchPhrase phrase) {
        for (SearchCoreAPI api : this.apis) {
            if (!api.isSearchAvailable(phrase) || api.getSearchPriority(phrase) < 0 || !api.isSearchMoreAvailable(phrase)) continue;
            return true;
        }
        return false;
    }

    public int getMinimalSearchRadius(SearchPhrase phrase) {
        int radius = Integer.MAX_VALUE;
        for (SearchCoreAPI api : this.apis) {
            int apiMinimalRadius;
            if (!api.isSearchAvailable(phrase) || api.getSearchPriority(phrase) == -1 || (apiMinimalRadius = api.getMinimalSearchRadius(phrase)) <= 0 || apiMinimalRadius >= radius) continue;
            radius = apiMinimalRadius;
        }
        return radius;
    }

    public int getNextSearchRadius(SearchPhrase phrase) {
        int radius = Integer.MAX_VALUE;
        for (SearchCoreAPI api : this.apis) {
            int apiNextSearchRadius;
            if (!api.isSearchAvailable(phrase) || api.getSearchPriority(phrase) == -1 || (apiNextSearchRadius = api.getNextSearchRadius(phrase)) <= 0 || apiNextSearchRadius >= radius) continue;
            radius = apiNextSearchRadius;
        }
        return radius;
    }

    public AbstractPoiType getUnselectedPoiType() {
        for (SearchCoreAPI capi : this.apis) {
            if (!(capi instanceof SearchCoreFactory.SearchAmenityByTypeAPI)) continue;
            return ((SearchCoreFactory.SearchAmenityByTypeAPI)capi).getUnselectedPoiType();
        }
        return null;
    }

    public String getCustomNameFilter() {
        for (SearchCoreAPI capi : this.apis) {
            if (!(capi instanceof SearchCoreFactory.SearchAmenityByTypeAPI)) continue;
            return ((SearchCoreFactory.SearchAmenityByTypeAPI)capi).getNameFilter();
        }
        return null;
    }

    void searchInternal(final SearchPhrase phrase, SearchResultMatcher matcher) {
        this.preparePhrase(phrase);
        ArrayList<SearchCoreAPI> lst = new ArrayList<SearchCoreAPI>(this.apis);
        Collections.sort(lst, new Comparator<SearchCoreAPI>(){

            @Override
            public int compare(SearchCoreAPI o1, SearchCoreAPI o2) {
                return Algorithms.compare(o1.getSearchPriority(phrase), o2.getSearchPriority(phrase));
            }
        });
        for (SearchCoreAPI api : lst) {
            if (matcher.isCancelled()) break;
            if (!api.isSearchAvailable(phrase) || api.getSearchPriority(phrase) == -1) continue;
            try {
                if (debugMode) {
                    LOG.info((Object)("Run API search <" + String.valueOf(phrase) + "> API=<" + String.valueOf(api) + ">"));
                }
                api.search(phrase, matcher);
                if (debugMode) {
                    LOG.info((Object)("API search finishing <" + String.valueOf(phrase) + "> API=<" + String.valueOf(api) + ">"));
                }
                matcher.apiSearchFinished(api, phrase);
                if (!debugMode) continue;
                LOG.info((Object)("API search done <" + String.valueOf(phrase) + "> API=<" + String.valueOf(api) + ">"));
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOG.error((Object)e.getMessage(), e);
            }
        }
    }

    private void preparePhrase(SearchPhrase phrase) {
        if (debugMode) {
            LOG.info((Object)("Preparing search phrase <" + String.valueOf(phrase) + ">"));
        }
        for (SearchWord sw : phrase.getWords()) {
            if (sw.getResult() == null || sw.getResult().file == null) continue;
            phrase.selectFile(sw.getResult().file);
        }
        phrase.sortFiles();
        if (debugMode) {
            LOG.info((Object)("Search phrase prepared <" + String.valueOf(phrase) + ">"));
        }
    }

    private static String stripBraces(String localeName) {
        int i = localeName.indexOf(40);
        String retName = localeName;
        if (i > -1) {
            retName = localeName.substring(0, i);
            int j = localeName.indexOf(41, i);
            if (j > -1) {
                retName = (retName.trim() + " " + localeName.substring(j + 1)).trim();
            }
        }
        return retName;
    }

    public boolean isOnlineSearch() {
        return this.searchSettings.hasCustomSearchType(ObjectType.ONLINE_SEARCH);
    }

    public static class SearchResultCollection {
        private final List<SearchResult> searchResults = new ArrayList<SearchResult>();
        private SearchPhrase phrase;
        private boolean useLimit;
        private static final int DEPTH_TO_CHECK_SAME_SEARCH_RESULTS = 20;
        private static final Integer DOMINATED_CITY_CRITERIA = 5;

        public SearchResultCollection(SearchPhrase phrase) {
            this.phrase = phrase;
        }

        public SearchResultCollection combineWithCollection(SearchResultCollection collection, boolean resort, boolean removeDuplicates) {
            SearchResultCollection src = new SearchResultCollection(this.phrase);
            src.addSearchResults(this.searchResults, false, false);
            src.addSearchResults(collection.searchResults, resort, removeDuplicates);
            return src;
        }

        public boolean getUseLimit() {
            return this.useLimit;
        }

        public void setUseLimit(boolean useLimit) {
            this.useLimit = useLimit;
        }

        public SearchResultCollection addSearchResults(List<SearchResult> sr, boolean resortAll, boolean removeDuplicates) {
            if (SearchUICore.isDebugMode()) {
                LOG.info((Object)("Add search results resortAll=" + (resortAll ? "true" : "false") + " removeDuplicates=" + (removeDuplicates ? "true" : "false") + " Results=" + sr.size() + " Current results=" + this.searchResults.size()));
            }
            if (Algorithms.isEmpty(sr)) {
                return this;
            }
            if (resortAll) {
                this.searchResults.addAll(sr);
                if (removeDuplicates) {
                    long start = System.currentTimeMillis();
                    long size = this.searchResults.size();
                    this.uniteSearchResultsByOsmIdOrWikidata(this.searchResults);
                    if (SearchUICore.isDebugMode()) {
                        LOG.info((Object)String.format(Locale.US, "Deduplicate time %d ms (removed %s results=%d-%d)\n", System.currentTimeMillis() - start, size - (long)this.searchResults.size(), size, this.searchResults.size()));
                    }
                }
                this.sortSearchResults();
                if (removeDuplicates) {
                    this.filterSearchDuplicateResults();
                }
            } else if (!removeDuplicates) {
                this.searchResults.addAll(sr);
            } else {
                ArrayList<SearchResult> addedResults = new ArrayList<SearchResult>(sr);
                SearchResultComparator cmp = new SearchResultComparator(this.phrase);
                Collections.sort(addedResults, cmp);
                this.filterSearchDuplicateResults(addedResults);
                int i = 0;
                int j = 0;
                while (j < addedResults.size()) {
                    SearchResult addedResult = addedResults.get(j);
                    if (i >= this.searchResults.size()) {
                        boolean same = false;
                        for (int k = 0; this.searchResults.size() > k && k < 20; ++k) {
                            if (!this.sameSearchResult(addedResult, this.searchResults.get(this.searchResults.size() - k - 1))) continue;
                            same = true;
                            break;
                        }
                        if (!same) {
                            this.searchResults.add(addedResult);
                        }
                        ++j;
                        continue;
                    }
                    SearchResult existingResult = this.searchResults.get(i);
                    if (this.sameSearchResult(addedResult, existingResult)) {
                        ++j;
                        continue;
                    }
                    int compare = cmp.compare(existingResult, addedResult);
                    if (compare == 0) {
                        ++j;
                        continue;
                    }
                    if (compare > 0) {
                        this.searchResults.add(addedResults.get(j));
                        ++j;
                        continue;
                    }
                    ++i;
                }
            }
            this.calculateAddressString();
            if (SearchUICore.isDebugMode()) {
                LOG.info((Object)("Search results added. Current results=" + this.searchResults.size()));
            }
            return this;
        }

        public boolean hasSearchResults() {
            return !Algorithms.isEmpty(this.searchResults);
        }

        public List<SearchResult> getCurrentSearchResults() {
            return Collections.unmodifiableList(this.searchResults);
        }

        public SearchPhrase getPhrase() {
            return this.phrase;
        }

        public void calculateAddressString() {
            Object object;
            String dominatedCity = "";
            TreeMap<String, Integer> cities = new TreeMap<String, Integer>();
            for (SearchResult s : this.searchResults) {
                if (Algorithms.isEmpty(s.cityName)) continue;
                Integer freq = (Integer)cities.get(s.cityName);
                if (freq == null) {
                    freq = 0;
                }
                object = freq;
                freq = freq + 1;
                if (freq >= DOMINATED_CITY_CRITERIA) {
                    dominatedCity = s.cityName;
                    break;
                }
                cities.put(s.cityName, freq);
            }
            for (SearchResult s : this.searchResults) {
                String city;
                object = s.object;
                if (!(object instanceof Amenity)) continue;
                Amenity amenity = (Amenity)object;
                if (!Algorithms.isEmpty(s.alternateName)) continue;
                String string = city = s.cityName == null ? "" : s.cityName;
                if (Algorithms.isEmpty(amenity.getStreetName())) {
                    s.alternateName = city;
                    continue;
                }
                String hno = amenity.getHousenumber();
                String addr = amenity.getStreetName() + (String)(Algorithms.isEmpty(hno) ? "" : " " + hno);
                if (dominatedCity.equals(s.cityName)) {
                    s.alternateName = addr + ", " + s.cityName;
                    continue;
                }
                s.alternateName = (String)(city.length() == 0 ? "" : s.cityName + ", ") + addr;
            }
        }

        public void sortSearchResults() {
            if (debugMode) {
                LOG.info((Object)("Sorting search results <" + String.valueOf(this.phrase) + "> Results=" + this.searchResults.size()));
            }
            Collections.sort(this.searchResults, new SearchResultComparator(this.phrase));
            if (debugMode) {
                LOG.info((Object)("Search results sorted <" + String.valueOf(this.phrase) + ">"));
            }
        }

        public void filterSearchDuplicateResults() {
            if (debugMode) {
                LOG.info((Object)("Filter duplicate results <" + String.valueOf(this.phrase) + "> Results=" + this.searchResults.size()));
            }
            this.filterSearchDuplicateResults(this.searchResults);
            if (debugMode) {
                LOG.info((Object)("Duplicate results filtered <" + String.valueOf(this.phrase) + "> Results=" + this.searchResults.size()));
            }
        }

        private void filterSearchDuplicateResults(List<SearchResult> lst) {
            ListIterator<SearchResult> it = lst.listIterator();
            LinkedList<SearchResult> lstUnique = new LinkedList<SearchResult>();
            while (it.hasNext()) {
                SearchResult rs;
                SearchResult r = it.next();
                boolean same = false;
                Iterator iterator = lstUnique.iterator();
                while (iterator.hasNext() && !(same = this.sameSearchResult(rs = (SearchResult)iterator.next(), r))) {
                }
                if (same) {
                    it.remove();
                    continue;
                }
                lstUnique.add(r);
                if (lstUnique.size() <= 20) continue;
                lstUnique.remove(0);
            }
        }

        private void copyData(SearchResult unique, SearchResult iterated) {
            BaseDetailsObject base = new BaseDetailsObject(unique.object, this.phrase.getSettings().getLang());
            base.addObject(iterated.object);
            unique.object = base.getSyntheticAmenity();
            if (iterated.otherNames != null) {
                if (!iterated.localeName.equals(unique.localeName)) {
                    iterated.otherNames.add(iterated.localeName);
                }
                if (unique.otherNames == null) {
                    unique.otherNames = new ArrayList<String>();
                }
                for (String name : iterated.otherNames) {
                    if (unique.otherNames.contains(name)) continue;
                    unique.otherNames.add(name);
                }
            }
            if (iterated.getOtherWordsMatch() != null) {
                if (unique.getOtherWordsMatch() == null) {
                    unique.setOtherWordsMatch(new TreeSet<String>());
                }
                unique.getOtherWordsMatch().addAll(iterated.getOtherWordsMatch());
            }
            if (iterated.getUnknownPhraseMatchWeight() > unique.getUnknownPhraseMatchWeight()) {
                unique.setUnknownPhraseMatchWeight(iterated.getUnknownPhraseMatchWeight());
            }
        }

        private void uniteSearchResultsByOsmIdOrWikidata(List<SearchResult> input) {
            ArrayList<SearchResult> output = new ArrayList<SearchResult>();
            HashMap<Long, Integer> osmIdMap = new HashMap<Long, Integer>();
            HashMap<String, Integer> wikidataMap = new HashMap<String, Integer>();
            for (SearchResult sr : input) {
                Object object = sr.object;
                if (object instanceof Amenity) {
                    Amenity that = (Amenity)object;
                    Long osmId = that.getOsmId();
                    String wikidata = that.getWikidata();
                    if (osmId != null && osmId < 0L) {
                        osmId = null;
                    }
                    if (that.isRouteTrack()) {
                        osmId = null;
                        wikidata = null;
                    }
                    Integer foundOsmIdIndex = osmId == null ? null : (Integer)osmIdMap.get(osmId);
                    Integer foundWikidataIndex = wikidata == null ? null : (Integer)wikidataMap.get(wikidata);
                    int indexToUpdate = -1;
                    if (foundOsmIdIndex != null && foundWikidataIndex != null && !Objects.equals(foundOsmIdIndex, foundWikidataIndex)) {
                        LOG.info((Object)"foundOsmIdIndex != foundWikidataIndex (should never happens)");
                    } else if (foundOsmIdIndex != null || foundWikidataIndex != null) {
                        indexToUpdate = foundOsmIdIndex != null ? foundOsmIdIndex : foundWikidataIndex;
                    }
                    if (indexToUpdate == -1) {
                        output.add(sr);
                        indexToUpdate = output.size() - 1;
                    } else {
                        this.copyData((SearchResult)output.get(indexToUpdate), sr);
                    }
                    if (osmId != null) {
                        osmIdMap.put(osmId, indexToUpdate);
                    }
                    if (wikidata == null) continue;
                    wikidataMap.put(wikidata, indexToUpdate);
                    continue;
                }
                output.add(sr);
            }
            if (input.size() != output.size()) {
                input.clear();
                input.addAll(output);
            }
        }

        public boolean sameSearchResult(SearchResult r1, SearchResult r2) {
            boolean isSameType = r1.objectType == r2.objectType;
            boolean interpolated = false;
            if (isSameType) {
                Object object;
                ObjectType type = r1.objectType;
                if (type == ObjectType.INDEX_ITEM || type == ObjectType.GPX_TRACK) {
                    return Algorithms.objectEquals(r1.localeName, r2.localeName);
                }
                if (r2.objectType == ObjectType.HOUSE && (object = r2.object) instanceof Building) {
                    Building building = (Building)object;
                    boolean streetEquals = r1.localeRelatedObjectName.equals(r2.localeRelatedObjectName);
                    boolean bl = interpolated = streetEquals && building.getInterpolationType() != null;
                }
            }
            if (r1.location != null && r2.location != null && !ObjectType.isTopVisible(r1.objectType) && !ObjectType.isTopVisible(r2.objectType)) {
                if (isSameType && r1.objectType == ObjectType.STREET) {
                    Street st1 = (Street)r1.object;
                    Street st2 = (Street)r2.object;
                    return st1.getLocation().equals(st2.getLocation());
                }
                Amenity a1 = null;
                if (r1.object instanceof Amenity) {
                    a1 = (Amenity)r1.object;
                }
                Amenity a2 = null;
                if (r2.object instanceof Amenity) {
                    a2 = (Amenity)r2.object;
                }
                if (r1.localeName.equals(r2.localeName)) {
                    double similarityRadius = 30.0;
                    if (a1 != null && a2 != null && a1.getId() != null && a2.getId() != null) {
                        boolean isEqualId;
                        String type1 = a1.getType().getKeyName();
                        String type2 = a2.getType().getKeyName();
                        String subType1 = a1.getSubType();
                        String subType2 = a2.getSubType();
                        boolean bl = isEqualId = ObfConstants.getOsmObjectId(a1) == ObfConstants.getOsmObjectId(a2);
                        if (isEqualId && (FILTER_DUPLICATE_POI_SUBTYPE.contains(subType1) || FILTER_DUPLICATE_POI_SUBTYPE.contains(subType2))) {
                            return true;
                        }
                        if (!type1.equals(type2)) {
                            return false;
                        }
                        if (type1.equals("natural")) {
                            similarityRadius = 50000.0;
                        } else if (subType1.equals(subType2)) {
                            if (subType1.contains("cn_ref") || subType1.contains("wn_ref") || subType1.startsWith("route_hiking_") && subType1.endsWith("n_poi")) {
                                similarityRadius = 50000.0;
                            }
                            if (a1.getAdditionalInfo("route_id") != null && Algorithms.stringsEqual(a1.getAdditionalInfo("route_id"), a2.getAdditionalInfo("route_id"))) {
                                similarityRadius = 1000000.0;
                            }
                        }
                    } else if (ObjectType.isAddress(r1.objectType) && ObjectType.isAddress(r2.objectType)) {
                        similarityRadius = interpolated ? 1000.0 : 100.0;
                    }
                    return MapUtils.getDistance(r1.location, r2.location) < similarityRadius;
                }
            } else if (r1.object != null && r2.object != null) {
                return r1.object.equals(r2.object);
            }
            return false;
        }
    }

    public static class SearchResultMatcher
    implements ResultMatcher<SearchResult> {
        private final List<SearchResult> requestResults = new ArrayList<SearchResult>();
        private final ResultMatcher<SearchResult> matcher;
        private final int request;
        int totalLimit;
        private SearchResult parentSearchResult;
        private final AtomicInteger requestNumber;
        int count = 0;
        private SearchPhrase phrase;
        private List<MapObject> exportedObjects;
        private List<City> exportedCities;

        public SearchResultMatcher(ResultMatcher<SearchResult> matcher, SearchPhrase phrase, int request, AtomicInteger requestNumber, int totalLimit) {
            this.matcher = matcher;
            this.phrase = phrase;
            this.request = request;
            this.requestNumber = requestNumber;
            this.totalLimit = totalLimit;
        }

        public SearchResult setParentSearchResult(SearchResult parentSearchResult) {
            SearchResult prev = this.parentSearchResult;
            this.parentSearchResult = parentSearchResult;
            return prev;
        }

        public SearchResult getParentSearchResult() {
            return this.parentSearchResult;
        }

        public List<SearchResult> getRequestResults() {
            return this.requestResults;
        }

        public int getCount() {
            return this.requestResults.size();
        }

        public void searchStarted(SearchPhrase phrase) {
            if (this.matcher != null) {
                SearchResult sr = new SearchResult(phrase);
                sr.objectType = ObjectType.SEARCH_STARTED;
                this.matcher.publish(sr);
            }
        }

        public void filterFinished(SearchPhrase phrase) {
            if (this.matcher != null) {
                SearchResult sr = new SearchResult(phrase);
                sr.objectType = ObjectType.FILTER_FINISHED;
                this.matcher.publish(sr);
            }
        }

        public void searchFinished(SearchPhrase phrase) {
            if (this.matcher != null) {
                SearchResult sr = new SearchResult(phrase);
                sr.objectType = ObjectType.SEARCH_FINISHED;
                this.matcher.publish(sr);
            }
        }

        public void apiSearchFinished(SearchCoreAPI api, SearchPhrase phrase) {
            if (this.matcher != null) {
                SearchResult sr = new SearchResult(phrase);
                sr.objectType = ObjectType.SEARCH_API_FINISHED;
                sr.object = api;
                sr.parentSearchResult = this.parentSearchResult;
                this.matcher.publish(sr);
            }
        }

        public void apiSearchRegionFinished(SearchCoreAPI api, BinaryMapIndexReader region, SearchPhrase phrase) {
            if (this.matcher != null) {
                SearchResult sr = new SearchResult(phrase);
                sr.objectType = ObjectType.SEARCH_API_REGION_FINISHED;
                sr.object = api;
                sr.parentSearchResult = this.parentSearchResult;
                sr.file = region;
                this.matcher.publish(sr);
                if (debugMode) {
                    LOG.info((Object)("API region search done <" + String.valueOf(phrase) + "> API=<" + String.valueOf(api) + "> Region=<" + region.getFile().getName() + ">"));
                }
            }
        }

        @Override
        public boolean publish(SearchResult object) {
            if (this.phrase != null && !this.phrase.getFirstUnknownNameStringMatcher().matches(object.localeName) && Algorithms.isEmpty(object.alternateName)) {
                boolean updateName = false;
                if (object.otherNames != null) {
                    for (String s : object.otherNames) {
                        if (!this.phrase.getFirstUnknownNameStringMatcher().matches(s)) continue;
                        object.localeName = s;
                        updateName = true;
                        break;
                    }
                }
                if (!updateName && object.object instanceof Amenity) {
                    for (String key : ((Amenity)object.object).getAdditionalInfoKeys()) {
                        if (!ObfConstants.isTagIndexedForSearchAsId(key) && !ObfConstants.isTagIndexedForSearchAsName(key)) continue;
                        String vl = ((Amenity)object.object).getAdditionalInfo(key);
                        if (!this.phrase.getFirstUnknownNameStringMatcher().matches(vl)) continue;
                        object.alternateName = vl;
                        break;
                    }
                }
            }
            if (Algorithms.isEmpty(object.localeName) && object.alternateName != null) {
                object.localeName = object.alternateName;
                object.alternateName = null;
            }
            object.parentSearchResult = this.parentSearchResult;
            if (this.matcher == null || this.matcher.publish(object)) {
                ++this.count;
                if (this.totalLimit == -1 || this.count < this.totalLimit) {
                    this.requestResults.add(object);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isCancelled() {
            boolean cancelled = this.request != this.requestNumber.get();
            return cancelled || this.matcher != null && this.matcher.isCancelled();
        }

        public List<MapObject> getExportedObjects() {
            return this.exportedObjects;
        }

        public List<City> getExportedCities() {
            return this.exportedCities;
        }

        public void exportObject(SearchPhrase phrase, MapObject object) {
            double distance;
            double maxDistance = phrase.getSettings().getExportSettings().getMaxDistance();
            if (maxDistance > 0.0 && (distance = MapUtils.getDistance(phrase.getSettings().getOriginalLocation(), object.getLocation())) > maxDistance) {
                return;
            }
            if (this.exportedObjects == null) {
                this.exportedObjects = new ArrayList<MapObject>();
            }
            this.exportedObjects.add(object);
        }

        public void exportCity(SearchPhrase phrase, City city) {
            double distance;
            double maxDistance = phrase.getSettings().getExportSettings().getMaxDistance();
            if (maxDistance > 0.0 && (distance = MapUtils.getDistance(phrase.getSettings().getOriginalLocation(), city.getLocation())) > maxDistance) {
                return;
            }
            if (this.exportedCities == null) {
                this.exportedCities = new ArrayList<City>();
            }
            this.exportedCities.add(city);
        }

        public JSONObject createTestJSON(SearchResultCollection searchResult) {
            JSONObject json = new JSONObject();
            HashSet<Amenity> amenities = new HashSet<Amenity>();
            HashSet<City> matchedCities = new HashSet<City>();
            HashSet<Object> streetCities = new HashSet<Object>();
            HashSet<Object> cities = this.exportedCities != null ? new HashSet<City>(this.exportedCities) : new HashSet();
            HashSet<Street> streets = new HashSet<Street>();
            if (this.exportedObjects != null) {
                for (MapObject mapObject : this.exportedObjects) {
                    if (mapObject instanceof Amenity) {
                        amenities.add((Amenity)mapObject);
                        continue;
                    }
                    if (mapObject instanceof Street) {
                        Street street = (Street)mapObject;
                        streets.add(street);
                        if (street.getCity() == null) continue;
                        Object city = street.getCity();
                        cities.add(city);
                        streetCities.add(city);
                        continue;
                    }
                    if (!(mapObject instanceof City)) continue;
                    City city = (City)mapObject;
                    cities.add(city);
                    matchedCities.add(city);
                }
            }
            for (City city : cities) {
                List<Street> cityStreets = city.getStreets();
                for (Street street : streets) {
                    if (!city.equals(street.getCity()) || cityStreets.contains(street)) continue;
                    cityStreets.add(street);
                }
            }
            SearchExportSettings exportSettings = this.phrase.getSettings().getExportSettings();
            json.put("settings", (Object)this.phrase.getSettings().toJSON());
            json.put("phrase", (Object)this.phrase.getFullSearchPhrase());
            if (searchResult.hasSearchResults()) {
                JSONArray jSONArray = new JSONArray();
                for (SearchResult r : searchResult.searchResults) {
                    jSONArray.put((Object)r.toString());
                }
                json.put("results", (Object)jSONArray);
            }
            if (amenities.size() > 0) {
                JSONArray jSONArray = new JSONArray();
                for (Amenity amenity : amenities) {
                    jSONArray.put((Object)amenity.toJSON());
                }
                json.put("amenities", (Object)jSONArray);
            }
            if (cities.size() > 0) {
                JSONArray jSONArray = new JSONArray();
                for (Object city : cities) {
                    JSONObject cityObj = ((City)city).toJSON(exportSettings.isExportBuildings());
                    if (this.exportedCities != null && this.exportedCities.contains(city)) {
                        if (!exportSettings.isExportEmptyCities()) continue;
                        cityObj.put("init", 1);
                    }
                    if (matchedCities.contains(city)) {
                        cityObj.put("matchCity", 1);
                    }
                    if (streetCities.contains(city)) {
                        cityObj.put("matchStreet", 1);
                    }
                    jSONArray.put((Object)cityObj);
                }
                json.put("cities", (Object)jSONArray);
            }
            return json;
        }
    }

    public static class SearchResultComparator
    implements Comparator<SearchResult> {
        private Collator collator;
        private LatLon loc;
        private boolean sortByName;

        public SearchResultComparator(SearchPhrase sp) {
            this.collator = sp.getCollator();
            this.loc = sp.getLastTokenLocation();
            this.sortByName = sp.isSortByName();
        }

        @Override
        public int compare(SearchResult o1, SearchResult o2) {
            ArrayList<ResultCompareStep> steps = new ArrayList<ResultCompareStep>();
            for (ResultCompareStep step : ResultCompareStep.values()) {
                int r = step.compare(o1, o2, this);
                steps.add(step);
                if (r == 0) continue;
                return r;
            }
            return 0;
        }
    }

    private static enum ResultCompareStep {
        TOP_VISIBLE,
        FOUND_WORD_COUNT,
        OBF_RESOURCE,
        UNKNOWN_PHRASE_MATCH_WEIGHT,
        SEARCH_DISTANCE_IF_NOT_BY_NAME,
        COMPARE_FIRST_NUMBER_IN_NAME,
        COMPARE_INTERPOLATED,
        COMPARE_DISTANCE_TO_PARENT_SEARCH_RESULT,
        COMPARE_BY_NAME,
        COMPARE_BY_DISTANCE,
        AMENITY_LAST_AND_SORT_BY_SUBTYPE;


        public int compare(SearchResult o1, SearchResult o2, SearchResultComparator c) {
            switch (this) {
                case TOP_VISIBLE: {
                    boolean topVisible1 = ObjectType.isTopVisible(o1.objectType);
                    boolean topVisible2 = ObjectType.isTopVisible(o2.objectType);
                    if (topVisible1 == topVisible2) break;
                    return topVisible1 ? -1 : 1;
                }
                case FOUND_WORD_COUNT: {
                    if (o1.getFoundWordCount() == o2.getFoundWordCount()) break;
                    return -Algorithms.compare(o1.getFoundWordCount(), o2.getFoundWordCount());
                }
                case OBF_RESOURCE: {
                    int ord2;
                    boolean fp1 = o1.isFullPhraseEqualLocaleName();
                    boolean fp2 = o2.isFullPhraseEqualLocaleName();
                    int ord1 = fp1 ? 0 : o1.getResourceType().ordinal();
                    int n = ord2 = fp2 ? 0 : o2.getResourceType().ordinal();
                    if (ord1 == ord2) break;
                    return ord2 > ord1 ? -1 : 1;
                }
                case UNKNOWN_PHRASE_MATCH_WEIGHT: {
                    SearchPhrase ph = o1.requiredSearchPhrase;
                    double o1PhraseWeight = o1.getUnknownPhraseMatchWeight();
                    double o2PhraseWeight = o2.getUnknownPhraseMatchWeight();
                    if (o1PhraseWeight == o2PhraseWeight && o1PhraseWeight / 100.0 > 1.0) {
                        if (!ph.getUnknownWordToSearchBuildingNameMatcher().matches(SearchUICore.stripBraces(o1.localeName))) {
                            o1PhraseWeight -= 1.0;
                        }
                        if (!ph.getUnknownWordToSearchBuildingNameMatcher().matches(SearchUICore.stripBraces(o2.localeName))) {
                            o2PhraseWeight -= 1.0;
                        }
                    }
                    if (o1PhraseWeight == o2PhraseWeight) break;
                    return -Double.compare(o1PhraseWeight, o2PhraseWeight);
                }
                case SEARCH_DISTANCE_IF_NOT_BY_NAME: {
                    double s2;
                    double s1;
                    if (c.sortByName || (s1 = o1.getSearchDistance(c.loc)) == (s2 = o2.getSearchDistance(c.loc))) break;
                    return Double.compare(s1, s2);
                }
                case COMPARE_FIRST_NUMBER_IN_NAME: {
                    String localeName1 = o1.localeName == null ? "" : o1.localeName;
                    String localeName2 = o2.localeName == null ? "" : o2.localeName;
                    int st1 = Algorithms.extractFirstIntegerNumber(localeName1);
                    int st2 = Algorithms.extractFirstIntegerNumber(localeName2);
                    if (st1 == st2) break;
                    return Algorithms.compare(st1, st2);
                }
                case COMPARE_INTERPOLATED: {
                    boolean interpolated2;
                    Object st1 = o1.object;
                    if (!(st1 instanceof Building)) break;
                    Building building1 = (Building)st1;
                    st1 = o2.object;
                    if (!(st1 instanceof Building)) break;
                    Building building2 = (Building)st1;
                    boolean interpolated1 = building1.getInterpolationType() != null;
                    boolean bl = interpolated2 = building2.getInterpolationType() != null;
                    if (interpolated1 == interpolated2) break;
                    return interpolated1 ? 1 : -1;
                }
                case COMPARE_DISTANCE_TO_PARENT_SEARCH_RESULT: {
                    double ps2;
                    double ps1 = o1.parentSearchResult == null ? 0.0 : o1.parentSearchResult.getSearchDistance(c.loc);
                    double d = ps2 = o2.parentSearchResult == null ? 0.0 : o2.parentSearchResult.getSearchDistance(c.loc);
                    if (ps1 == ps2) break;
                    return Double.compare(ps1, ps2);
                }
                case COMPARE_BY_NAME: {
                    String localeName1 = o1.localeName == null ? "" : o1.localeName;
                    String localeName2 = o2.localeName == null ? "" : o2.localeName;
                    int cmp = c.collator.compare(localeName1, localeName2);
                    if (cmp == 0) break;
                    return cmp;
                }
                case COMPARE_BY_DISTANCE: {
                    double s1 = o1.getSearchDistance(c.loc, 1.0);
                    double s2 = o2.getSearchDistance(c.loc, 1.0);
                    if (s1 == s2) break;
                    return Double.compare(s1, s2);
                }
                case AMENITY_LAST_AND_SORT_BY_SUBTYPE: {
                    boolean am1 = o1.object instanceof Amenity;
                    boolean am2 = o2.object instanceof Amenity;
                    if (am1 == am2) break;
                    return am1 ? 1 : -1;
                }
            }
            return 0;
        }
    }
}

