/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.osmand.PlatformUtil;
import net.osmand.binary.StringBundle;
import net.osmand.binary.StringBundleWriter;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlSerializer;

public class StringBundleXmlWriter
extends StringBundleWriter {
    public static final Log log = PlatformUtil.getLog(StringBundleXmlWriter.class);
    private XmlSerializer serializer;

    public StringBundleXmlWriter(StringBundle bundle, XmlSerializer serializer) {
        super(bundle);
        this.serializer = serializer;
    }

    @Override
    protected void writeItem(String name, StringBundle.Item<?> item) {
        if (this.serializer != null) {
            try {
                this.writeItemImpl(name, item);
            }
            catch (Exception e) {
                log.error((Object)"Error writing string bundle as xml", (Throwable)e);
            }
        }
    }

    @Override
    public void writeBundle() {
        if (this.serializer != null) {
            super.writeBundle();
            try {
                this.serializer.flush();
            }
            catch (Exception e) {
                log.error((Object)"Error writing string bundle as xml", (Throwable)e);
            }
        }
    }

    private void writeItemImpl(String name, StringBundle.Item<?> item) throws IOException {
        if (this.serializer != null && item != null) {
            switch (item.getType()) {
                case STRING: {
                    StringBundle.StringItem stringItem = (StringBundle.StringItem)item;
                    this.serializer.attribute(null, name, (String)stringItem.getValue());
                    break;
                }
                case LIST: {
                    StringBundle.StringListItem listItem = (StringBundle.StringListItem)item;
                    this.serializer.startTag(null, name);
                    List list = (List)listItem.getValue();
                    for (StringBundle.Item i : list) {
                        if (i.getType() != StringBundle.ItemType.STRING) continue;
                        this.writeItemImpl(i.getName(), i);
                    }
                    for (StringBundle.Item i : list) {
                        if (i.getType() == StringBundle.ItemType.STRING) continue;
                        this.writeItemImpl(i.getName(), i);
                    }
                    this.serializer.endTag(null, name);
                    break;
                }
                case MAP: {
                    StringBundle.Item i;
                    StringBundle.StringMapItem mapItem = (StringBundle.StringMapItem)item;
                    this.serializer.startTag(null, name);
                    for (Map.Entry entry : ((Map)mapItem.getValue()).entrySet()) {
                        i = (StringBundle.Item)entry.getValue();
                        if (i.getType() != StringBundle.ItemType.STRING) continue;
                        this.writeItemImpl((String)entry.getKey(), i);
                    }
                    for (Map.Entry entry : ((Map)mapItem.getValue()).entrySet()) {
                        i = (StringBundle.Item)entry.getValue();
                        if (i.getType() == StringBundle.ItemType.STRING) continue;
                        this.writeItemImpl((String)entry.getKey(), i);
                    }
                    this.serializer.endTag(null, name);
                    break;
                }
            }
        }
    }
}

