/*
 * Decompiled with CFR 0.152.
 */
package rtree.seeded;

import java.io.FileNotFoundException;
import java.io.IOException;
import rtree.Element;
import rtree.IllegalValueException;
import rtree.Node;
import rtree.NodeFullException;
import rtree.NodeReadException;
import rtree.NodeWriteException;
import rtree.NonLeafElement;
import rtree.RTree;
import rtree.RTreeException;
import rtree.Rect;

public class SdTree
extends RTree {
    private String seedName = null;
    private RTree sdingTree = null;
    private int slotLvl = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SdTree(String fileName, RTree sdingTree) throws RTreeException {
        super(fileName);
        try {
            System.out.println("SdTree:: sedding height is " + sdingTree.getHeight());
            this.fileHdr.lockWrite();
            try {
                this.fileHdr.setBufferPolicy(false);
                if (sdingTree == null) {
                    throw new IllegalArgumentException("SdTree: Seeding tree is null");
                }
                this.sdingTree = sdingTree;
                this.setSlot();
                if (this.slotLvl >= 1) {
                    this.seed();
                }
            }
            catch (Exception e) {
                throw new RTreeException(e.getMessage());
            }
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    private void setSlot() {
        int ht = this.sdingTree.getHeight();
        switch (ht) {
            case 0: {
                this.slotLvl = -999;
                break;
            }
            case 1: {
                this.slotLvl = -999;
                break;
            }
            case 2: {
                this.slotLvl = -999;
                break;
            }
            case 3: {
                this.slotLvl = 1;
                break;
            }
            case 4: {
                this.slotLvl = 2;
            }
        }
    }

    private void seed() throws RTreeException {
        try {
            long sdingRoot = this.sdingTree.getFileHdr().getRootIndex();
            Node sdingNode = this.sdingTree.getReadNode(sdingRoot);
            this.seedRec(sdingNode, chdNodes.getNode(this.fileHdr.getFile(), this.fileName, -999L, sdingNode.getElementType(), this.fileHdr), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RTreeException(e.getMessage());
        }
    }

    private void seedRec(Node sdingNode, Node sdNode, int level) throws Exception {
        if (sdingNode.getElementType() == 1) {
            throw new IllegalArgumentException("SdTree.seedRec : Cannot seed a leaf node");
        }
        Node[] chNodes = null;
        if (level != this.slotLvl) {
            chNodes = new Node[sdingNode.getTotalElements()];
        }
        Element[] elmts = sdingNode.getAllElements();
        Element[] newElmts = level != this.slotLvl ? new Element[sdingNode.getTotalElements()] : new Element[]{new NonLeafElement(new Rect(), -999L)};
        for (int i = 0; i < sdingNode.getTotalElements(); ++i) {
            if (level != this.slotLvl) {
                newElmts[i] = (NonLeafElement)((NonLeafElement)elmts[i]).clone();
                chNodes[i] = chdNodes.getNode(this.fileHdr.getFile(), this.fileName, sdNode.getNodeIndex(), sdingNode.getElementType(), this.fileHdr);
                newElmts[i].setPtr(chNodes[i].getNodeIndex());
                this.seedRec(this.sdingTree.getReadNode(elmts[i].getPtr()), chNodes[i], level + 1);
                continue;
            }
            newElmts[0].getRect().expandToInclude(elmts[i].getRect());
        }
        sdNode.insertElement(newElmts, false);
    }

    public void growLeaf(Element elmt) throws RTreeException {
        if (this.slotLvl == -999) {
            try {
                this.insert(elmt);
            }
            catch (Exception e) {
                throw new RTreeException(e.getMessage());
            }
        }
        this.fileHdr.lockWrite();
        try {
            long root = this.fileHdr.getRootIndex();
            LongWraper slotIndex = new LongWraper();
            Node node = this.chooseLeaf(elmt, slotIndex);
            if (slotIndex == null) {
                throw new NullPointerException();
            }
            long nodeParent = node.getParent();
            Node[] newNodes = new Node[2];
            try {
                node.insertElement(elmt);
                newNodes[0] = node;
                newNodes[1] = null;
            }
            catch (NodeFullException e) {
                newNodes = node.splitNode(elmt, slotIndex.val);
            }
            Node newRoot = this.adjustTree(newNodes, slotIndex.val);
            if (newRoot != null) {
                Node slot = chdNodes.getNode(this.fileHdr.getFile(), this.fileName, newRoot.getParent(), this.fileHdr);
                slot.modifyElement(0, newRoot.getNodeIndex());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RTreeException(e.getMessage());
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    private Node chooseLeaf(Element elmt, LongWraper slotIndex) throws RTreeException, IOException {
        try {
            long root = this.fileHdr.getRootIndex();
            int level = 0;
            Node sltNode = chdNodes.getNode(this.fileHdr.getFile(), this.fileName, root, this.fileHdr);
            while (sltNode.getElementType() != 1) {
                Element nextElmt = sltNode.getLeastEnlargement(elmt);
                if (level == this.slotLvl) {
                    slotIndex.val = sltNode.getNodeIndex();
                    if (nextElmt.getPtr() == -999L) {
                        Node rtNode = chdNodes.getNode(this.fileHdr.getFile(), this.fileName, sltNode.getNodeIndex(), 1, this.fileHdr);
                        sltNode.modifyElement(0, rtNode.getNodeIndex());
                        nextElmt.setPtr(rtNode.getNodeIndex());
                        return rtNode;
                    }
                }
                sltNode = chdNodes.getNode(this.fileHdr.getFile(), this.fileName, nextElmt.getPtr(), this.fileHdr);
                ++level;
            }
            return sltNode;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RTreeException(e.getMessage());
        }
    }

    private void adjustSlot(Node node, long childIndex) throws RTreeException {
        try {
            node.modifyElement(0, childIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RTreeException(e.getMessage());
        }
    }

    public void cleanUp() throws RTreeException {
        try {
            this.fileHdr.lockWrite();
            if (this.slotLvl == -999) {
                return;
            }
            long root = this.fileHdr.getRootIndex();
            Node node = chdNodes.getNode(this.fileHdr.getFile(), this.fileName, root, this.fileHdr);
            this.cleanUpRec(node, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RTreeException(e.getMessage());
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    private Rect cleanUpRec(Node node, int level) throws NodeWriteException, FileNotFoundException, IllegalValueException, IOException, NodeReadException, RTreeException {
        Element[] elmts = node.getAllElements();
        if (level == this.slotLvl) {
            if (elmts[0].getPtr() == -999L) {
                node.deleteNode();
                return new Rect();
            }
            Node parentNode = chdNodes.getNode(this.fileHdr.getFile(), this.fileName, node.getParent(), this.fileHdr);
            int index = parentNode.getElementIndex(node.getNodeIndex());
            parentNode.modifyElement(index, elmts[0].getPtr());
            Node subRoot = chdNodes.getNode(this.fileHdr.getFile(), this.fileName, elmts[0].getPtr(), this.fileHdr);
            subRoot.setParent(node.getParent());
            node.deleteNode();
            return subRoot.getNodeMBR();
        }
        Rect rect = new Rect();
        for (int i = node.getTotalElements() - 1; i > -1; --i) {
            Node chNode = chdNodes.getNode(this.fileHdr.getFile(), this.fileName, elmts[i].getPtr(), this.fileHdr);
            Rect chRect = this.cleanUpRec(chNode, level + 1);
            rect.expandToInclude(chRect);
            if (chRect.isNull()) {
                node.deleteElement(i, false);
                continue;
            }
            node.modifyElement(i, chRect);
        }
        if (rect.isNull()) {
            node.deleteNode();
        }
        return rect;
    }

    class LongWraper {
        long val = -999L;

        LongWraper() {
        }
    }
}

