/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.osmand.data.LatLon;
import net.osmand.osm.io.Base64;
import net.osmand.util.Algorithms;
import net.osmand.util.GeoParsedPoint;
import net.osmand.util.MapUtils;

public class GeoPointParserUtil {
    private static int kMaxPointBytes = 10;
    private static int kMaxCoordBits = kMaxPointBytes * 3;

    private static String getQueryParameter(String param, URI uri) {
        String query = uri.getQuery();
        String value = null;
        if (query != null && query.contains(param)) {
            String[] params;
            for (String p : params = query.split("&")) {
                if (!p.contains(param)) continue;
                value = p.substring(p.indexOf("=") + 1, p.length());
                break;
            }
        }
        return value;
    }

    static Map<String, String> getQueryParameters(URI uri) {
        String query = null;
        if (uri.isOpaque()) {
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            int pos = schemeSpecificPart.indexOf("?");
            if (pos == schemeSpecificPart.length()) {
                query = "";
            } else if (pos > -1) {
                query = schemeSpecificPart.substring(pos + 1);
            }
        } else {
            query = uri.getRawQuery();
        }
        return GeoPointParserUtil.getQueryParameters(query);
    }

    private static Map<String, String> getQueryParameters(String query) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (query != null && !query.isEmpty()) {
            String[] params;
            for (String p : params = query.split("[&/]")) {
                String[] keyValue = p.split("=");
                if (keyValue.length == 1) {
                    map.put(keyValue[0], "");
                    continue;
                }
                if (keyValue.length <= 1) continue;
                map.put(keyValue[0], URLDecoder.decode(keyValue[1]));
            }
        }
        return map;
    }

    public static LatLon decodeMapsMeLatLonToInt(String s) {
        int lat = 0;
        int lon = 0;
        int shift = kMaxCoordBits - 3;
        int i = 0;
        while (i < s.length()) {
            int a = Base64.indexOf(s.charAt(i));
            if (a < 0) {
                return null;
            }
            int lat1 = (a >> 5 & 1) << 2 | (a >> 3 & 1) << 1 | a >> 1 & 1;
            int lon1 = (a >> 4 & 1) << 2 | (a >> 2 & 1) << 1 | a & 1;
            lat |= lat1 << shift;
            lon |= lon1 << shift;
            ++i;
            shift -= 3;
        }
        double middleOfSquare = 1 << 3 * (kMaxPointBytes - s.length()) - 1;
        lat = (int)((double)lat + middleOfSquare);
        lon = (int)((double)lon + middleOfSquare);
        double dlat = (double)lat / (double)((1 << kMaxCoordBits) - 1) * 180.0 - 90.0;
        double dlon = (double)lon / (double)((1 << kMaxCoordBits) - 1 + 1) * 360.0 - 180.0;
        return new LatLon(dlat, dlon);
    }

    public static GeoParsedPoint parse(String uriString) {
        List<GeoParsedPoint> points = GeoPointParserUtil.parsePoints(uriString);
        if (!Algorithms.isEmpty(points)) {
            return points.get(0);
        }
        return null;
    }

    public static List<GeoParsedPoint> parsePoints(String uriString) {
        String scheme;
        URI uri = GeoPointParserUtil.createUri(uriString);
        String string = scheme = uri != null ? uri.getScheme() : null;
        if (scheme != null) {
            if ("http".equals(scheme = scheme.toLowerCase(Locale.US)) || "https".equals(scheme) || "google.navigation".equals(scheme)) {
                return GeoPointParserUtil.parseLinkUri(uri, scheme);
            }
            if ("geo".equals(scheme) || "osmand.geo".equals(scheme)) {
                return GeoPointParserUtil.parseGeoUri(uri);
            }
        }
        return null;
    }

    private static URI createUri(String uriString) {
        try {
            return URI.create(uriString.trim().replaceAll("\\s+", "+").replaceAll("%20", "+").replaceAll("%2C", ",").replaceAll("\\|", ";").replaceAll("\\(\\(\\S+\\)\\)", ""));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static List<GeoParsedPoint> parseLinkUri(URI uri, String scheme) {
        String host = uri.getHost();
        Map<String, String> params = GeoPointParserUtil.getQueryParameters(uri);
        if ("google.navigation".equals(scheme)) {
            host = scheme;
            if (uri.getSchemeSpecificPart() == null) {
                return null;
            }
            params = !uri.getSchemeSpecificPart().contains("=") ? GeoPointParserUtil.getQueryParameters("q=" + uri.getSchemeSpecificPart()) : GeoPointParserUtil.getQueryParameters(uri.getSchemeSpecificPart());
        } else {
            if (host == null) {
                return null;
            }
            host = host.toLowerCase(Locale.US);
        }
        String path = uri.getPath();
        if (path == null) {
            path = "";
        }
        String fragment = uri.getFragment();
        HashSet<String> simpleDomains = new HashSet<String>();
        simpleDomains.add("osmand.net");
        simpleDomains.add("www.osmand.net");
        simpleDomains.add("download.osmand.net");
        simpleDomains.add("openstreetmap.de");
        simpleDomains.add("www.openstreetmap.de");
        Pattern commaSeparatedPairPattern = Pattern.compile("(?:loc:)?([N|S]?[+-]?\\d+(?:\\.\\d+)?),([E|W]?[+-]?\\d+(?:\\.\\d+)?)");
        try {
            if (host.equals("osm.org") || host.endsWith("openstreetmap.org")) {
                return GeoPointParserUtil.parseOsmUri(uri, path, fragment);
            }
            if (host.startsWith("map.baidu.")) {
                return GeoPointParserUtil.parseBaiduUri(params);
            }
            if (host.equals("ge0.me")) {
                return GeoPointParserUtil.parseGe0meUri(path);
            }
            if (simpleDomains.contains(host)) {
                return GeoPointParserUtil.parseSimpleDomainsUri(uri, path, params, fragment);
            }
            if (host.matches("(?:www\\.)?(?:maps\\.)?yandex\\.[a-z]+")) {
                return GeoPointParserUtil.parseYandexUri(params, commaSeparatedPairPattern);
            }
            if (host.matches("(?:www\\.)?(?:maps\\.)?google\\.[a-z.]+")) {
                return GeoPointParserUtil.parseGoogleUri(uri, path, params, fragment, commaSeparatedPairPattern);
            }
            if (host.endsWith(".amap.com")) {
                return GeoPointParserUtil.parseAmapUri(uri, scheme, host);
            }
            if (host.equals("here.com") || host.endsWith(".here.com")) {
                return GeoPointParserUtil.parseHereUri(path, params);
            }
            if (host.endsWith(".qq.com")) {
                return GeoPointParserUtil.parseQqUri(params, commaSeparatedPairPattern);
            }
            if (host.equals("maps.apple.com")) {
                return GeoPointParserUtil.parseAppleUri(params, commaSeparatedPairPattern);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static List<GeoParsedPoint> parseOsmUri(URI uri, String path, String fragment) {
        if (path.startsWith("/go/")) {
            Pattern p = Pattern.compile("^/go/([A-Za-z0-9_@~]+-*)(?:.*)");
            Matcher matcher = p.matcher(path);
            if (matcher.matches()) {
                return Collections.singletonList(MapUtils.decodeShortLinkString(matcher.group(1)));
            }
        } else {
            String mlon;
            String queryStr;
            double lat = 0.0;
            double lon = 0.0;
            int zoom = -1;
            Map<String, String> queryMap = GeoPointParserUtil.getQueryParameters(uri);
            if (queryMap.containsKey("route")) {
                String routeValue = queryMap.get("route");
                Pattern coordinatesPattern = Pattern.compile("^(\\d+[.]?\\d*),(\\d+[.]?\\d*);(\\d+[.]?\\d*),(\\d+[.]?\\d*)");
                Matcher coordinatesMatcher = coordinatesPattern.matcher(routeValue);
                if (coordinatesMatcher.matches()) {
                    GeoParsedPoint pointFrom = new GeoParsedPoint(GeoPointParserUtil.parseSilentDouble(coordinatesMatcher.group(1)), GeoPointParserUtil.parseSilentDouble(coordinatesMatcher.group(2)));
                    GeoParsedPoint pointTo = new GeoParsedPoint(GeoPointParserUtil.parseSilentDouble(coordinatesMatcher.group(3)), GeoPointParserUtil.parseSilentDouble(coordinatesMatcher.group(4)));
                    ArrayList<GeoParsedPoint> parsedPoints = new ArrayList<GeoParsedPoint>();
                    parsedPoints.add(pointFrom);
                    parsedPoints.add(pointTo);
                    return parsedPoints;
                }
            } else if (queryMap.containsKey("from") || queryMap.containsKey("to")) {
                GeoParsedPoint pointFrom = null;
                String from = queryMap.get("from");
                if (!Algorithms.isEmpty(from)) {
                    String[] coordinates = from.split(",");
                    lat = GeoPointParserUtil.parseSilentDouble(coordinates[0]);
                    lon = GeoPointParserUtil.parseSilentDouble(coordinates[1]);
                    pointFrom = new GeoParsedPoint(lat, lon);
                }
                GeoParsedPoint pointTo = null;
                String to = queryMap.get("to");
                if (!Algorithms.isEmpty(to)) {
                    String[] coordinates = to.split(",");
                    lat = GeoPointParserUtil.parseSilentDouble(coordinates[0]);
                    lon = GeoPointParserUtil.parseSilentDouble(coordinates[1]);
                    pointTo = new GeoParsedPoint(lat, lon);
                }
                ArrayList<GeoParsedPoint> parsedPoints = new ArrayList<GeoParsedPoint>();
                parsedPoints.add(pointFrom);
                parsedPoints.add(pointTo);
                return parsedPoints;
            }
            if (fragment != null) {
                String[] vls;
                if (fragment.startsWith("map=")) {
                    fragment = fragment.substring("map=".length());
                }
                if ((vls = fragment.split("/|&")).length >= 3) {
                    zoom = GeoPointParserUtil.parseZoom(vls[0]);
                    lat = GeoPointParserUtil.parseSilentDouble(vls[1]);
                    lon = GeoPointParserUtil.parseSilentDouble(vls[2]);
                }
            } else if (queryMap != null && (queryStr = queryMap.get("query")) != null) {
                String[] vls = (queryStr = queryStr.replace("+", " ").replace(",", " ")).split(" ");
                if (vls.length == 2) {
                    lat = GeoPointParserUtil.parseSilentDouble(vls[0]);
                    lon = GeoPointParserUtil.parseSilentDouble(vls[1]);
                }
                if (lat == 0.0 || lon == 0.0) {
                    return Collections.singletonList(new GeoParsedPoint(queryStr));
                }
            }
            String mlat = GeoPointParserUtil.getQueryParameter("mlat", uri);
            if (mlat != null) {
                lat = GeoPointParserUtil.parseSilentDouble(mlat);
            }
            if ((mlon = GeoPointParserUtil.getQueryParameter("mlon", uri)) != null) {
                lon = GeoPointParserUtil.parseSilentDouble(mlon);
            }
            return Collections.singletonList(new GeoParsedPoint(lat, lon, zoom));
        }
        return null;
    }

    private static List<GeoParsedPoint> parseBaiduUri(Map<String, String> params) {
        String zm = params.get("l");
        String[] vls = GeoPointParserUtil.silentSplit(params.get("c"), ",");
        if (vls != null && vls.length >= 2) {
            double lat = (double)GeoPointParserUtil.parseSilentInt(vls[0]) / 100000.0;
            double lon = (double)GeoPointParserUtil.parseSilentInt(vls[1]) / 100000.0;
            int zoom = GeoPointParserUtil.parseZoom(zm);
            return Collections.singletonList(new GeoParsedPoint(lat, lon, zoom));
        }
        return null;
    }

    private static List<GeoParsedPoint> parseGe0meUri(String path) {
        LatLon l;
        String qry;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] pms = path.split("/");
        String label = "";
        if (pms.length > 1) {
            label = pms[1];
        }
        if ((qry = pms[0]).length() < 10) {
            return null;
        }
        int indZoom = Base64.indexOf(qry.charAt(0));
        int zoom = 15;
        if (indZoom >= 0) {
            zoom = indZoom / 4 + 4;
        }
        if ((l = GeoPointParserUtil.decodeMapsMeLatLonToInt(qry.substring(1).replace('-', '/'))) == null) {
            return null;
        }
        return Collections.singletonList(new GeoParsedPoint(l.getLatitude(), l.getLongitude(), zoom, label));
    }

    private static List<GeoParsedPoint> parseSimpleDomainsUri(URI uri, String path, Map<String, String> params, String fragment) {
        if (uri.getQuery() == null && params.size() == 0) {
            params = GeoPointParserUtil.getQueryParameters(path.substring(1));
        }
        if (params.containsKey("lat") && params.containsKey("lon")) {
            double lat = GeoPointParserUtil.parseSilentDouble(params.get("lat"));
            double lon = GeoPointParserUtil.parseSilentDouble(params.get("lon"));
            int zoom = -1;
            if (params.containsKey("z")) {
                zoom = GeoPointParserUtil.parseZoom(params.get("z"));
            } else if (params.containsKey("zoom")) {
                zoom = GeoPointParserUtil.parseZoom(params.get("zoom"));
            }
            return Collections.singletonList(new GeoParsedPoint(lat, lon, zoom));
        }
        if (params.containsKey("pin")) {
            String[] coordinates = params.get("pin").split(",");
            double lat = GeoPointParserUtil.parseSilentDouble(coordinates[0]);
            double lon = GeoPointParserUtil.parseSilentDouble(coordinates[1]);
            int zoom = -1;
            if (!Algorithms.isEmpty(fragment)) {
                zoom = GeoPointParserUtil.parseZoom(fragment.split("/")[0]);
            }
            return Collections.singletonList(new GeoParsedPoint(lat, lon, zoom));
        }
        return null;
    }

    private static List<GeoParsedPoint> parseYandexUri(Map<String, String> params, Pattern commaSeparatedPairPattern) {
        Matcher matcher;
        String ll = params.get("ll");
        if (ll != null && (matcher = commaSeparatedPairPattern.matcher(ll)).matches()) {
            String z = String.valueOf(GeoPointParserUtil.parseZoom(params.get("z")));
            return Collections.singletonList(new GeoParsedPoint(matcher.group(1), matcher.group(2), z, params.get("text")));
        }
        return null;
    }

    private static List<GeoParsedPoint> parseGoogleUri(URI uri, String path, Map<String, String> params, String fragment, Pattern commaSeparatedPairPattern) {
        String[] pathPrefixes;
        Pattern p;
        Matcher m;
        Matcher matcher;
        String latString = null;
        String lonString = null;
        String z = String.valueOf(-1);
        if (params.containsKey("q")) {
            matcher = commaSeparatedPairPattern.matcher(params.get("q"));
            if (matcher.matches()) {
                latString = matcher.group(1);
                lonString = matcher.group(2);
            }
        } else if (params.containsKey("ll") && (matcher = commaSeparatedPairPattern.matcher(params.get("ll"))).matches()) {
            latString = matcher.group(1);
            lonString = matcher.group(2);
        }
        if (latString != null && lonString != null) {
            if (params.containsKey("z")) {
                z = params.get("z");
            }
            return Collections.singletonList(new GeoParsedPoint(latString, lonString, z));
        }
        if (params.containsKey("daddr")) {
            return GeoPointParserUtil.parseGoogleMapsPath(params.get("daddr"), params);
        }
        if (params.containsKey("saddr")) {
            return GeoPointParserUtil.parseGoogleMapsPath(params.get("saddr"), params);
        }
        if (params.containsKey("q")) {
            String opath = params.get("q");
            String pref = "loc:";
            if (opath.contains("loc:")) {
                opath = opath.substring(opath.lastIndexOf("loc:") + "loc:".length());
            }
            String postf = "\\s\\((\\p{L}|\\p{M}|\\p{Z}|\\p{S}|\\p{N}|\\p{P}|\\p{C})*\\)$";
            opath = opath.replaceAll("\\s\\((\\p{L}|\\p{M}|\\p{Z}|\\p{S}|\\p{N}|\\p{P}|\\p{C})*\\)$", "");
            return GeoPointParserUtil.parseGoogleMapsPath(opath, params);
        }
        if (params.containsKey("destination") || params.containsKey("origin")) {
            GeoParsedPoint origin = null;
            if (params.containsKey("origin")) {
                String[] coordinates = params.get("origin").split(",");
                double lat = GeoPointParserUtil.parseSilentDouble(coordinates[0]);
                double lon = GeoPointParserUtil.parseSilentDouble(coordinates[1]);
                origin = new GeoParsedPoint(lat, lon);
            }
            GeoParsedPoint destination = null;
            if (params.containsKey("destination")) {
                String[] coordinates = params.get("destination").split(",");
                double lat = GeoPointParserUtil.parseSilentDouble(coordinates[0]);
                double lon = GeoPointParserUtil.parseSilentDouble(coordinates[1]);
                destination = new GeoParsedPoint(lat, lon);
            }
            ArrayList<GeoParsedPoint> parsedPoints = new ArrayList<GeoParsedPoint>();
            parsedPoints.add(origin);
            parsedPoints.add(destination);
            return parsedPoints;
        }
        if (fragment != null && (m = (p = Pattern.compile(".*[!&]q=([^&!]+).*")).matcher(fragment)).matches()) {
            return Collections.singletonList(new GeoParsedPoint(m.group(1)));
        }
        String DATA_PREFIX = "/data=";
        for (String pref : pathPrefixes = new String[]{DATA_PREFIX, "/@", "/ll=", "loc:", "/"}) {
            path = uri.getPath();
            if (!path.contains(pref)) continue;
            if ((path = path.substring(path.lastIndexOf(pref) + pref.length())).contains("/")) {
                path = path.substring(0, path.indexOf(47));
            }
            if (pref.equals(DATA_PREFIX)) {
                String[] vls = path.split("!");
                String lat = null;
                String lon = null;
                for (String v : vls) {
                    if (v.startsWith("3d")) {
                        lat = v.substring(2);
                        continue;
                    }
                    if (!v.startsWith("4d")) continue;
                    lon = v.substring(2);
                }
                if (lat == null || lon == null) continue;
                return Collections.singletonList(new GeoParsedPoint(Double.parseDouble(lat), Double.parseDouble(lon)));
            }
            return GeoPointParserUtil.parseGoogleMapsPath(path, params);
        }
        return null;
    }

    private static List<GeoParsedPoint> parseAmapUri(URI uri, String scheme, String host) {
        String subString = uri.toString().substring(scheme.length() + host.length() + 4);
        String[] patterns = new String[]{".*q=([+-]?\\d+(?:\\.\\d+)?),([+-]?\\d+(?:\\.\\d+)?).*&radius=(\\d+).*", ".*q=([+-]?\\d+(?:\\.\\d+)?),([+-]?\\d+(?:\\.\\d+)?).*", ".*p=(?:[A-Z0-9]+),([+-]?\\d+(?:\\.\\d+)?),([+-]?\\d+(?:\\.\\d+)?).*"};
        for (int i = 0; i < patterns.length; ++i) {
            Pattern p = Pattern.compile(patterns[i]);
            Matcher matcher = p.matcher(subString);
            if (!matcher.matches()) continue;
            if (matcher.groupCount() == 3) {
                float radius = Float.valueOf(matcher.group(3)).floatValue();
                long zoom = Math.round(23.0 - Math.log(radius) / Math.log(2.0));
                return Collections.singletonList(new GeoParsedPoint(matcher.group(1), matcher.group(2), String.valueOf(zoom)));
            }
            if (matcher.groupCount() != 2) continue;
            return Collections.singletonList(new GeoParsedPoint(matcher.group(1), matcher.group(2)));
        }
        return null;
    }

    private static List<GeoParsedPoint> parseHereUri(String path, Map<String, String> params) {
        Pattern p;
        Matcher matcher;
        String z = String.valueOf(-1);
        String label = null;
        if (params.containsKey("msg")) {
            label = params.get("msg");
        }
        if (params.containsKey("z")) {
            z = params.get("z");
        }
        if (params.containsKey("map")) {
            String[] mapArray = params.get("map").split(",");
            if (mapArray.length > 2) {
                return Collections.singletonList(new GeoParsedPoint(mapArray[0], mapArray[1], mapArray[2], label));
            }
            if (mapArray.length > 1) {
                return Collections.singletonList(new GeoParsedPoint(mapArray[0], mapArray[1], z, label));
            }
        }
        if (path.startsWith("/l/") && (matcher = (p = Pattern.compile("^/l/([+-]?\\d+(?:\\.\\d+)),([+-]?\\d+(?:\\.\\d+)),(.*)")).matcher(path)).matches()) {
            return Collections.singletonList(new GeoParsedPoint(matcher.group(1), matcher.group(2), z, matcher.group(3)));
        }
        return null;
    }

    private static List<GeoParsedPoint> parseQqUri(Map<String, String> params, Pattern commaSeparatedPairPattern) {
        String c;
        Matcher matcher;
        String x = null;
        String y = null;
        String z = String.valueOf(-1);
        String label = null;
        if (params.containsKey("city")) {
            label = params.get("city");
        } else if (params.containsKey("key")) {
            label = params.get("key");
        } else if (params.containsKey("a")) {
            label = params.get("a");
        } else if (params.containsKey("n")) {
            label = params.get("n");
        }
        String m = params.get("m");
        if (m != null && (matcher = commaSeparatedPairPattern.matcher(m)).matches()) {
            x = matcher.group(2);
            y = matcher.group(1);
        }
        if ((c = params.get("c")) != null) {
            Matcher matcher2 = commaSeparatedPairPattern.matcher(c);
            if (matcher2.matches()) {
                x = matcher2.group(2);
                y = matcher2.group(1);
            } else {
                x = c.replaceAll(".*\"lng\":\\s*([+\\-]?[0-9.]+).*", "$1");
                if (x == null) {
                    x = c.replaceAll(".*\"lon\":\\s*([+\\-]?[0-9.]+).*", "$1");
                }
                y = c.replaceAll(".*\"lat\":\\s*([+\\-]?[0-9.]+).*", "$1");
                z = c.replaceAll(".*\"l\":\\s*([+-]?[0-9.]+).*", "$1");
                return Collections.singletonList(new GeoParsedPoint(y, x, z, label));
            }
        }
        for (String key : new String[]{"centerX", "x", "x1", "x2"}) {
            if (!params.containsKey(key)) continue;
            x = params.get(key);
            break;
        }
        for (String key : new String[]{"centerY", "y", "y1", "y2"}) {
            if (!params.containsKey(key)) continue;
            y = params.get(key);
            break;
        }
        if (x != null && y != null) {
            return Collections.singletonList(new GeoParsedPoint(y, x, z, label));
        }
        return null;
    }

    private static List<GeoParsedPoint> parseAppleUri(Map<String, String> params, Pattern commaSeparatedPairPattern) {
        Matcher matcher;
        Matcher matcher2;
        String ll;
        String z = String.valueOf(-1);
        String label = null;
        if (params.containsKey("q")) {
            label = params.get("q");
        }
        if (params.containsKey("near")) {
            label = params.get("near");
        }
        if (params.containsKey("z")) {
            z = params.get("z");
        }
        if ((ll = params.get("ll")) != null && (matcher2 = commaSeparatedPairPattern.matcher(ll)).matches()) {
            return Collections.singletonList(new GeoParsedPoint(matcher2.group(1), matcher2.group(2), z, label));
        }
        String sll = params.get("sll");
        if (sll != null && (matcher = commaSeparatedPairPattern.matcher(sll)).matches()) {
            return Collections.singletonList(new GeoParsedPoint(matcher.group(1), matcher.group(2), z, label));
        }
        if (params.containsKey("q")) {
            return Collections.singletonList(new GeoParsedPoint(params.get("q")));
        }
        if (params.containsKey("daddr")) {
            return Collections.singletonList(new GeoParsedPoint(params.get("daddr")));
        }
        if (params.containsKey("saddr")) {
            return Collections.singletonList(new GeoParsedPoint(params.get("saddr")));
        }
        return null;
    }

    private static List<GeoParsedPoint> parseGeoUri(URI uri) {
        String positionPart;
        String schemeSpecific = uri.getSchemeSpecificPart();
        if (schemeSpecific == null) {
            return null;
        }
        if (uri.getRawSchemeSpecificPart().contains("%2B")) {
            schemeSpecific = schemeSpecific.replace("+", "%2B");
        }
        String name = null;
        Pattern namePattern = Pattern.compile("[\\+\\s]*\\((.*)\\)[\\+\\s]*$");
        Matcher nameMatcher = namePattern.matcher(schemeSpecific);
        if (nameMatcher.find() && (name = URLDecoder.decode(nameMatcher.group(1))) != null) {
            schemeSpecific = schemeSpecific.substring(0, nameMatcher.start());
        }
        String queryPart = "";
        int queryStartIndex = schemeSpecific.indexOf(63);
        if (queryStartIndex == -1) {
            positionPart = schemeSpecific;
        } else {
            positionPart = schemeSpecific.substring(0, queryStartIndex);
            if (queryStartIndex < schemeSpecific.length()) {
                queryPart = schemeSpecific.substring(queryStartIndex + 1);
            }
        }
        Pattern positionPattern = Pattern.compile("([+-]?\\d+(?:\\.\\d+)?),\\s?([+-]?\\d+(?:\\.\\d+)?)");
        Matcher positionMatcher = positionPattern.matcher(positionPart);
        double lat = 0.0;
        double lon = 0.0;
        if (positionMatcher.find()) {
            lat = Double.valueOf(positionMatcher.group(1));
            lon = Double.valueOf(positionMatcher.group(2));
        }
        int zoom = -1;
        String searchRequest = null;
        for (String param : queryPart.split("&")) {
            String paramName;
            String paramValue = null;
            int nameValueDelimititerIndex = param.indexOf(61);
            if (nameValueDelimititerIndex == -1) {
                paramName = param;
            } else {
                paramName = param.substring(0, nameValueDelimititerIndex);
                if (nameValueDelimititerIndex < param.length()) {
                    paramValue = param.substring(nameValueDelimititerIndex + 1);
                }
            }
            if ("z".equals(paramName) && paramValue != null) {
                zoom = (int)Float.parseFloat(paramValue);
                continue;
            }
            if (!"q".equals(paramName) || paramValue == null) continue;
            searchRequest = URLDecoder.decode(paramValue);
        }
        if (searchRequest != null) {
            String searchPattern = Pattern.compile("(?:\\.|,|\\s+|\\+|[+-]?\\d+(?:\\.\\d+)?)").pattern();
            String[] search = searchRequest.split(searchPattern);
            if (search.length > 0) {
                return Collections.singletonList(new GeoParsedPoint(searchRequest));
            }
            Matcher positionInSearchRequestMatcher = positionPattern.matcher(searchRequest);
            if (lat == 0.0 && lon == 0.0 && positionInSearchRequestMatcher.find()) {
                double tempLat = Double.valueOf(positionInSearchRequestMatcher.group(1));
                double tempLon = Double.valueOf(positionInSearchRequestMatcher.group(2));
                if (tempLat >= -90.0 && tempLat <= 90.0 && tempLon >= -180.0 && tempLon <= 180.0) {
                    lat = tempLat;
                    lon = tempLon;
                }
            }
        }
        if (lat == 0.0 && lon == 0.0 && searchRequest != null) {
            return Collections.singletonList(new GeoParsedPoint(searchRequest));
        }
        if (zoom != -1) {
            return Collections.singletonList(new GeoParsedPoint(lat, lon, zoom, name));
        }
        return Collections.singletonList(new GeoParsedPoint(lat, lon, name));
    }

    private static List<GeoParsedPoint> parseGoogleMapsPath(String opath, Map<String, String> params) {
        String[] vls;
        String zmPart = "";
        String descr = "";
        String path = opath;
        if (path.contains("&")) {
            vls = path.split("&");
            path = vls[0];
            for (int i = 1; i < vls.length; ++i) {
                int ik = vls[i].indexOf(61);
                if (ik <= 0) continue;
                params.put(vls[i].substring(0, ik), vls[i].substring(ik + 1));
            }
        }
        if (path.contains("+") && (descr = (path = path.substring(0, path.indexOf("+"))).substring(path.indexOf("+") + 1)).contains(")")) {
            descr = descr.substring(0, descr.indexOf(")"));
        }
        if (params.containsKey("z")) {
            zmPart = params.get("z");
        }
        vls = null;
        if (path.contains("@") && (path = path.substring(path.indexOf("@") + 1)).contains(",")) {
            vls = GeoPointParserUtil.silentSplit(path, ",");
        }
        if (vls == null) {
            vls = GeoPointParserUtil.silentSplit(path, ",");
        }
        if (vls.length >= 2) {
            double lat = GeoPointParserUtil.parseSilentDouble(vls[0], Double.NaN);
            double lon = GeoPointParserUtil.parseSilentDouble(vls[1], Double.NaN);
            int zoom = -1;
            if (vls.length >= 3 || zmPart.length() > 0) {
                if (zmPart.length() == 0) {
                    zmPart = vls[2];
                }
                if (zmPart.startsWith("z=")) {
                    zmPart = zmPart.substring(2);
                } else if (zmPart.contains("z")) {
                    zmPart = zmPart.substring(0, zmPart.indexOf(122));
                }
                zoom = GeoPointParserUtil.parseZoom(zmPart);
            }
            if (!Double.isNaN(lat) && !Double.isNaN(lon)) {
                return Collections.singletonList(new GeoParsedPoint(lat, lon, zoom));
            }
        }
        return Collections.singletonList(new GeoParsedPoint(URLDecoder.decode(opath)));
    }

    private static String[] silentSplit(String vl, String split) {
        if (vl == null) {
            return null;
        }
        return vl.split(split);
    }

    protected static int parseZoom(String zoom) {
        try {
            if (zoom != null) {
                return (int)Float.parseFloat(zoom);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static double parseSilentDouble(String zoom) {
        return GeoPointParserUtil.parseSilentDouble(zoom, 0.0);
    }

    private static double parseSilentDouble(String zoom, double vl) {
        try {
            if (zoom != null) {
                return Double.valueOf(zoom);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return vl;
    }

    private static int parseSilentInt(String zoom) {
        try {
            if (zoom != null) {
                return Integer.valueOf(zoom);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }
}

