/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.gpx.clickable;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.osmand.util.Algorithms;

public class ClickableWayTags {
    public static final Set<String> CLICKABLE_TAGS = Set.of("piste:type", "piste:difficulty", "mtb:scale", "dirtbike:scale", "snowmobile=yes", "snowmobile=designated", "snowmobile=permissive");
    public static final Map<String, String> FORBIDDEN_TAGS = Map.of("area", "yes", "access", "no", "piste:type", "connection", "osmc_stub_name", ".", "aerialway", "*");
    public static final Set<String> REQUIRED_TAGS_ANY = Set.of("name", "ref", "piste:name", "mtb:name", "shield_stub_name");
    public static final Map<String, String> GPX_COLORS = Map.ofEntries(Map.entry("0", "brown"), Map.entry("1", "green"), Map.entry("2", "blue"), Map.entry("3", "red"), Map.entry("4", "black"), Map.entry("5", "black"), Map.entry("6", "black"), Map.entry("novice", "green"), Map.entry("easy", "blue"), Map.entry("intermediate", "red"), Map.entry("advanced", "black"), Map.entry("expert", "black"), Map.entry("freeride", "yellow"));

    public static String getGpxColorByTags(Map<String, String> tags) {
        for (String t : CLICKABLE_TAGS) {
            String val = tags.get(t);
            if (val == null) continue;
            for (Map.Entry<String, String> matchColor : GPX_COLORS.entrySet()) {
                if (!val.contains(matchColor.getKey())) continue;
                return matchColor.getValue();
            }
        }
        return null;
    }

    public static Map<String, String> getGpxShieldTags(String color) {
        return color != null ? Map.of("shield_fg", "osmc_" + color + "_bar") : new HashMap();
    }

    public static boolean isClickableWayTags(String name, Map<String, String> tags) {
        for (Map.Entry<String, String> forbidden : FORBIDDEN_TAGS.entrySet()) {
            if (!forbidden.getValue().equals(tags.get(forbidden.getKey())) && (!"*".equals(forbidden.getValue()) || !tags.containsKey(forbidden.getKey()))) continue;
            return false;
        }
        for (String required : REQUIRED_TAGS_ANY) {
            boolean isRequiredNameFound;
            boolean bl = isRequiredNameFound = "name".equals(required) && !Algorithms.isEmpty(name);
            if (!tags.containsKey(required) && !isRequiredNameFound) continue;
            for (String key : tags.keySet()) {
                if (CLICKABLE_TAGS.contains(key)) {
                    return true;
                }
                String value = tags.get(key);
                if (value == null || !CLICKABLE_TAGS.contains(key + "=" + value)) continue;
                return true;
            }
        }
        return false;
    }
}

