/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm.edit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.osmand.data.LatLon;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.OSMSettings;

public class Relation
extends Entity {
    List<RelationMember> members = null;

    public Relation(long id) {
        super(id);
    }

    public void addMember(Long id, Entity.EntityType type, String role) {
        this.addMember(new Entity.EntityId(type, id), role);
    }

    public void addMember(Entity.EntityId id, String role) {
        if (this.members == null) {
            this.members = new ArrayList<RelationMember>();
        }
        this.members.add(new RelationMember(id, role));
    }

    public List<RelationMember> getMembers(String role) {
        if (this.members == null) {
            return Collections.emptyList();
        }
        if (role == null) {
            return this.members;
        }
        ArrayList<RelationMember> l = new ArrayList<RelationMember>();
        for (RelationMember m : this.members) {
            if (!role.equals(m.role)) continue;
            l.add(m);
        }
        return l;
    }

    public List<Entity> getMemberEntities(String role) {
        if (this.members == null) {
            return Collections.emptyList();
        }
        ArrayList<Entity> l = new ArrayList<Entity>();
        for (RelationMember m : this.members) {
            if (role != null && !role.equals(m.role) || m.entity == null) continue;
            l.add(m.entity);
        }
        return l;
    }

    public List<RelationMember> getMembers() {
        if (this.members == null) {
            return Collections.emptyList();
        }
        return this.members;
    }

    @Override
    public void initializeLinks(Map<Entity.EntityId, Entity> entities) {
        if (this.members != null) {
            for (RelationMember rm : this.members) {
                if (rm.entityId == null || !entities.containsKey(rm.entityId)) continue;
                rm.entity = entities.get(rm.entityId);
            }
        }
    }

    @Override
    public LatLon getLatLon() {
        return null;
    }

    public void update(RelationMember r, Entity.EntityId newEntityId) {
        r.entity = null;
        r.entityId = newEntityId;
    }

    public void updateRole(RelationMember r, String newRole) {
        r.role = newRole;
    }

    public boolean remove(Entity.EntityId key) {
        if (this.members != null) {
            for (RelationMember rm : this.members) {
                if (!key.equals(rm.getEntityId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean remove(RelationMember key) {
        if (this.members != null) {
            Iterator<RelationMember> it = this.members.iterator();
            while (it.hasNext()) {
                RelationMember rm = it.next();
                if (rm != key) continue;
                it.remove();
                return true;
            }
        }
        return false;
    }

    public static class RelationMember {
        private Entity.EntityId entityId;
        private Entity entity;
        private String role;

        public RelationMember(Entity.EntityId entityId, String role) {
            this.entityId = entityId;
            this.role = role;
        }

        public Entity.EntityId getEntityId() {
            if (this.entityId == null && this.entity != null) {
                return Entity.EntityId.valueOf(this.entity);
            }
            return this.entityId;
        }

        public String getRole() {
            return this.role;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public boolean hasName() {
            return this.entity != null && this.entity.getTag(OSMSettings.OSMTagKey.NAME) != null;
        }

        public String toString() {
            return this.entityId.toString() + " " + this.role;
        }
    }
}

