/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.WireFormat;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.osmand.Collator;
import net.osmand.CollatorStringMatcher;
import net.osmand.Location;
import net.osmand.OsmAndCollator;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.StringMatcher;
import net.osmand.binary.BinaryHHRouteReaderAdapter;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapAddressReaderAdapter;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReaderStats;
import net.osmand.binary.BinaryMapPoiReaderAdapter;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.BinaryMapTransportReaderAdapter;
import net.osmand.binary.MapZooms;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.Amenity;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.IncompleteTransportRoute;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.QuadRect;
import net.osmand.data.Street;
import net.osmand.data.TransportRoute;
import net.osmand.data.TransportStop;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.edit.Way;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BinaryMapIndexReader {
    public static final int DETAILED_MAP_MIN_ZOOM = 9;
    public static final int TRANSPORT_STOP_ZOOM = 24;
    public static final int SHIFT_COORDINATES = 5;
    public static final int LABEL_ZOOM_ENCODE = 26;
    private static final Log log = PlatformUtil.getLog(BinaryMapIndexReader.class);
    public static boolean READ_STATS = false;
    public static final SearchPoiTypeFilter ACCEPT_ALL_POI_TYPE_FILTER = new SearchPoiTypeFilter(){

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean accept(PoiCategory type, String subcategory) {
            return true;
        }
    };
    private final RandomAccessFile raf;
    protected final File file;
    int version;
    long dateCreated;
    OsmAndOwner owner;
    boolean basemap = false;
    List<MapIndex> mapIndexes = new ArrayList<MapIndex>();
    List<BinaryMapPoiReaderAdapter.PoiRegion> poiIndexes = new ArrayList<BinaryMapPoiReaderAdapter.PoiRegion>();
    List<BinaryMapAddressReaderAdapter.AddressRegion> addressIndexes = new ArrayList<BinaryMapAddressReaderAdapter.AddressRegion>();
    List<BinaryMapTransportReaderAdapter.TransportIndex> transportIndexes = new ArrayList<BinaryMapTransportReaderAdapter.TransportIndex>();
    List<BinaryMapRouteReaderAdapter.RouteRegion> routingIndexes = new ArrayList<BinaryMapRouteReaderAdapter.RouteRegion>();
    List<BinaryHHRouteReaderAdapter.HHRouteRegion> hhIndexes = new ArrayList<BinaryHHRouteReaderAdapter.HHRouteRegion>();
    List<BinaryIndexPart> indexes = new ArrayList<BinaryIndexPart>();
    TLongObjectHashMap<IncompleteTransportRoute> incompleteTransportRoutes = null;
    protected CodedInputStream codedIS;
    private final BinaryMapTransportReaderAdapter transportAdapter;
    private final BinaryMapPoiReaderAdapter poiAdapter;
    private final BinaryMapAddressReaderAdapter addressAdapter;
    private final BinaryMapRouteReaderAdapter routeAdapter;
    private final BinaryHHRouteReaderAdapter hhAdapter;
    private static final String BASEMAP_NAME = "basemap";
    private int MASK_TO_READ = -32;
    private static boolean testMapSearch = false;
    private static boolean testAddressSearch = false;
    private static boolean testAddressSearchName = true;
    private static boolean testAddressJustifySearch = false;
    private static boolean testPoiSearch = true;
    private static boolean testPoiSearchOnPath = false;
    private static boolean testTransportSearch = false;
    private static boolean testPoiRouteByName = true;
    private static boolean testPoiRouteByType = true;
    private static int sleft = MapUtils.get31TileNumberX(27.55079);
    private static int sright = MapUtils.get31TileNumberX(27.55317);
    private static int stop = MapUtils.get31TileNumberY(53.89378);
    private static int sbottom = MapUtils.get31TileNumberY(53.89276);
    private static int szoom = 15;

    public BinaryMapIndexReader(RandomAccessFile raf, File file) throws IOException {
        this.raf = raf;
        this.file = file;
        this.codedIS = CodedInputStream.newInstance(raf);
        this.codedIS.setSizeLimit(0x80000000000L);
        this.transportAdapter = new BinaryMapTransportReaderAdapter(this);
        this.addressAdapter = new BinaryMapAddressReaderAdapter(this);
        this.poiAdapter = new BinaryMapPoiReaderAdapter(this);
        this.routeAdapter = new BinaryMapRouteReaderAdapter(this);
        this.hhAdapter = new BinaryHHRouteReaderAdapter(this);
        this.init();
    }

    public BinaryMapIndexReader(RandomAccessFile raf, File file, boolean init) throws IOException {
        this.raf = raf;
        this.file = file;
        this.codedIS = CodedInputStream.newInstance(raf);
        this.codedIS.setSizeLimit(0x80000000000L);
        this.transportAdapter = new BinaryMapTransportReaderAdapter(this);
        this.addressAdapter = new BinaryMapAddressReaderAdapter(this);
        this.poiAdapter = new BinaryMapPoiReaderAdapter(this);
        this.routeAdapter = new BinaryMapRouteReaderAdapter(this);
        this.hhAdapter = new BinaryHHRouteReaderAdapter(this);
        if (init) {
            this.init();
        }
    }

    public BinaryMapIndexReader(RandomAccessFile raf, BinaryMapIndexReader referenceToSameFile) throws IOException {
        this.raf = raf;
        this.file = referenceToSameFile.file;
        this.codedIS = CodedInputStream.newInstance(raf);
        this.codedIS.setSizeLimit(0x80000000000L);
        this.version = referenceToSameFile.version;
        this.dateCreated = referenceToSameFile.dateCreated;
        this.transportAdapter = new BinaryMapTransportReaderAdapter(this);
        this.addressAdapter = new BinaryMapAddressReaderAdapter(this);
        this.poiAdapter = new BinaryMapPoiReaderAdapter(this);
        this.routeAdapter = new BinaryMapRouteReaderAdapter(this);
        this.hhAdapter = new BinaryHHRouteReaderAdapter(this);
        this.mapIndexes = new ArrayList<MapIndex>(referenceToSameFile.mapIndexes);
        this.poiIndexes = new ArrayList<BinaryMapPoiReaderAdapter.PoiRegion>(referenceToSameFile.poiIndexes);
        this.addressIndexes = new ArrayList<BinaryMapAddressReaderAdapter.AddressRegion>(referenceToSameFile.addressIndexes);
        this.transportIndexes = new ArrayList<BinaryMapTransportReaderAdapter.TransportIndex>(referenceToSameFile.transportIndexes);
        this.routingIndexes = new ArrayList<BinaryMapRouteReaderAdapter.RouteRegion>(referenceToSameFile.routingIndexes);
        this.hhIndexes = new ArrayList<BinaryHHRouteReaderAdapter.HHRouteRegion>(referenceToSameFile.hhIndexes);
        this.indexes = new ArrayList<BinaryIndexPart>(referenceToSameFile.indexes);
        this.basemap = referenceToSameFile.basemap;
        this.calculateCenterPointForRegions();
    }

    public long getDateCreated() {
        return this.dateCreated;
    }

    public OsmAndOwner getOwner() {
        return this.owner;
    }

    public void init() throws IOException {
        this.init(true);
    }

    public void init(boolean checkFileComplete) throws IOException {
        boolean initCorrectly = false;
        block13: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    if (!initCorrectly && checkFileComplete) {
                        throw new IOException("Corrupt file, it should have ended as it starts with version: " + this.file.getAbsolutePath());
                    }
                    return;
                }
                case 1: {
                    this.version = this.codedIS.readUInt32();
                    continue block13;
                }
                case 18: {
                    this.dateCreated = this.codedIS.readInt64();
                    continue block13;
                }
                case 33: {
                    long len = this.codedIS.readInt32();
                    long oldLimit = this.codedIS.pushLimitLong(len);
                    this.owner = new OsmAndOwner();
                    this.readOsmAndOwner();
                    this.codedIS.popLimit(oldLimit);
                    continue block13;
                }
                case 6: {
                    MapIndex mapIndex = new MapIndex();
                    mapIndex.length = this.readInt();
                    mapIndex.filePointer = this.codedIS.getTotalBytesRead();
                    long oldLimit = this.codedIS.pushLimitLong(mapIndex.length);
                    this.readMapIndex(mapIndex, false);
                    this.basemap = this.basemap || mapIndex.isBaseMap();
                    this.codedIS.popLimit(oldLimit);
                    this.codedIS.seek(mapIndex.filePointer + mapIndex.length);
                    this.mapIndexes.add(mapIndex);
                    this.indexes.add(mapIndex);
                    continue block13;
                }
                case 7: {
                    long oldLimit;
                    BinaryMapAddressReaderAdapter.AddressRegion region = new BinaryMapAddressReaderAdapter.AddressRegion();
                    region.length = this.readInt();
                    region.filePointer = this.codedIS.getTotalBytesRead();
                    if (this.addressAdapter != null) {
                        oldLimit = this.codedIS.pushLimitLong(region.length);
                        this.addressAdapter.readAddressIndex(region);
                        if (region.name != null) {
                            this.addressIndexes.add(region);
                            this.indexes.add(region);
                        }
                        this.codedIS.popLimit(oldLimit);
                    }
                    this.codedIS.seek(region.filePointer + region.length);
                    continue block13;
                }
                case 4: {
                    long oldLimit;
                    BinaryMapTransportReaderAdapter.TransportIndex ind = new BinaryMapTransportReaderAdapter.TransportIndex();
                    ind.length = this.readInt();
                    ind.filePointer = this.codedIS.getTotalBytesRead();
                    if (this.transportAdapter != null) {
                        oldLimit = this.codedIS.pushLimitLong(ind.length);
                        this.transportAdapter.readTransportIndex(ind);
                        this.codedIS.popLimit(oldLimit);
                        this.transportIndexes.add(ind);
                        this.indexes.add(ind);
                    }
                    this.codedIS.seek(ind.filePointer + ind.length);
                    continue block13;
                }
                case 9: {
                    long oldLimit;
                    BinaryMapRouteReaderAdapter.RouteRegion routeReg = new BinaryMapRouteReaderAdapter.RouteRegion();
                    routeReg.length = this.readInt();
                    routeReg.filePointer = this.codedIS.getTotalBytesRead();
                    if (this.routeAdapter != null) {
                        oldLimit = this.codedIS.pushLimitLong(routeReg.length);
                        this.routeAdapter.readRouteIndex(routeReg);
                        this.codedIS.popLimit(oldLimit);
                        this.routingIndexes.add(routeReg);
                        this.indexes.add(routeReg);
                    }
                    this.codedIS.seek(routeReg.filePointer + routeReg.length);
                    continue block13;
                }
                case 8: {
                    long oldLimit;
                    BinaryMapPoiReaderAdapter.PoiRegion poiInd = new BinaryMapPoiReaderAdapter.PoiRegion();
                    poiInd.length = this.readInt();
                    poiInd.filePointer = this.codedIS.getTotalBytesRead();
                    if (this.poiAdapter != null) {
                        oldLimit = this.codedIS.pushLimitLong(poiInd.length);
                        this.poiAdapter.readPoiIndex(poiInd, false);
                        this.codedIS.popLimit(oldLimit);
                        this.poiIndexes.add(poiInd);
                        this.indexes.add(poiInd);
                    }
                    this.codedIS.seek(poiInd.filePointer + poiInd.length);
                    continue block13;
                }
                case 10: {
                    long oldLimit;
                    BinaryHHRouteReaderAdapter.HHRouteRegion hhreg = new BinaryHHRouteReaderAdapter.HHRouteRegion();
                    hhreg.length = this.readInt();
                    hhreg.filePointer = this.codedIS.getTotalBytesRead();
                    if (this.hhAdapter != null) {
                        oldLimit = this.codedIS.pushLimitLong(hhreg.length);
                        this.hhAdapter.readHHIndex(hhreg, false);
                        this.codedIS.popLimit(oldLimit);
                        this.indexes.add(hhreg);
                        this.hhIndexes.add(hhreg);
                    }
                    this.codedIS.seek(hhreg.filePointer + hhreg.length);
                    continue block13;
                }
                case 32: {
                    int cversion = this.codedIS.readUInt32();
                    this.calculateCenterPointForRegions();
                    initCorrectly = cversion == this.version;
                    continue block13;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private void calculateCenterPointForRegions() {
        block0: for (BinaryMapAddressReaderAdapter.AddressRegion reg : this.addressIndexes) {
            for (MapIndex mapIndex : this.mapIndexes) {
                if (!Algorithms.objectEquals(reg.name, mapIndex.name) || mapIndex.getRoots().size() <= 0) continue;
                reg.calculatedCenter = mapIndex.getCenterLatLon();
                break;
            }
            if (reg.calculatedCenter != null) continue;
            for (BinaryMapRouteReaderAdapter.RouteRegion routeRegion : this.routingIndexes) {
                if (!Algorithms.objectEquals(reg.name, routeRegion.name)) continue;
                reg.calculatedCenter = new LatLon(routeRegion.getTopLatitude() / 2.0 + routeRegion.getBottomLatitude() / 2.0, routeRegion.getLeftLongitude() / 2.0 + routeRegion.getRightLongitude() / 2.0);
                continue block0;
            }
        }
    }

    public List<BinaryIndexPart> getIndexes() {
        return this.indexes;
    }

    public List<MapIndex> getMapIndexes() {
        return this.mapIndexes;
    }

    public List<BinaryMapRouteReaderAdapter.RouteRegion> getRoutingIndexes() {
        return this.routingIndexes;
    }

    public List<BinaryHHRouteReaderAdapter.HHRouteRegion> getHHRoutingIndexes() {
        return this.hhIndexes;
    }

    public boolean isBasemap() {
        return this.basemap;
    }

    public boolean containsMapData() {
        return this.mapIndexes.size() > 0;
    }

    public boolean containsPoiData() {
        return this.poiIndexes.size() > 0;
    }

    public boolean containsRouteData() {
        return this.routingIndexes.size() > 0;
    }

    public boolean containsActualRouteData(int x31, int y31, Set<String> checkedRegions) throws IOException {
        int zoomToLoad = 14;
        int x = x31 >> zoomToLoad;
        int y = y31 >> zoomToLoad;
        SearchRequest<RouteDataObject> request = BinaryMapIndexReader.buildSearchRouteRequest(x << zoomToLoad, x + 1 << zoomToLoad, y << zoomToLoad, y + 1 << zoomToLoad, null);
        for (BinaryMapRouteReaderAdapter.RouteRegion reg : this.getRoutingIndexes()) {
            List<BinaryMapRouteReaderAdapter.RouteSubregion> res;
            if (checkedRegions != null) {
                if (checkedRegions.contains(reg.getName())) continue;
                checkedRegions.add(reg.getName());
            }
            if ((res = this.searchRouteIndexTree(request, reg.getSubregions())).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean containsRouteData(int left31x, int top31y, int right31x, int bottom31y, int zoom) {
        for (BinaryMapRouteReaderAdapter.RouteRegion ri : this.routingIndexes) {
            List<BinaryMapRouteReaderAdapter.RouteSubregion> sr = ri.getSubregions();
            for (BinaryMapRouteReaderAdapter.RouteSubregion r : sr) {
                if (right31x < r.left || left31x > r.right || r.top > bottom31y || r.bottom < top31y) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsPoiData(int left31x, int top31y, int right31x, int bottom31y) {
        for (BinaryMapPoiReaderAdapter.PoiRegion index : this.poiIndexes) {
            if (right31x < index.left31 || left31x > index.right31 || index.top31 > bottom31y || index.bottom31 < top31y) continue;
            return true;
        }
        return false;
    }

    public boolean containsMapData(int tile31x, int tile31y, int zoom) {
        for (MapIndex mapIndex : this.mapIndexes) {
            for (MapRoot root : mapIndex.getRoots()) {
                if (root.minZoom > zoom || root.maxZoom < zoom || tile31x < root.left || tile31x > root.right || root.top > tile31y || root.bottom < tile31y) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsMapData(int left31x, int top31y, int right31x, int bottom31y, int zoom) {
        for (MapIndex mapIndex : this.mapIndexes) {
            for (MapRoot root : mapIndex.getRoots()) {
                if (root.minZoom > zoom || root.maxZoom < zoom || right31x < root.left || left31x > root.right || root.top > bottom31y || root.bottom < top31y) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAddressData() {
        return this.addressIndexes.size() > 0;
    }

    public boolean hasTransportData() {
        return this.transportIndexes.size() > 0;
    }

    public RandomAccessFile getRaf() {
        return this.raf;
    }

    public File getFile() {
        return this.file;
    }

    public String getCountryName() {
        List<String> rg = this.getRegionNames();
        if (rg.size() > 0) {
            return rg.get(0).split("_")[0];
        }
        return "";
    }

    public <T extends HHRouteDataStructure.NetworkDBPoint> TLongObjectHashMap<T> initHHPoints(BinaryHHRouteReaderAdapter.HHRouteRegion reg, short mapId, Class<T> cl) throws IOException {
        return this.hhAdapter.initRegionAndLoadPoints(reg, mapId, cl);
    }

    public <T extends HHRouteDataStructure.NetworkDBPoint> int loadNetworkSegmentPoint(HHRouteDataStructure.HHRoutingContext<T> ctx, HHRouteDataStructure.HHRouteRegionPointsCtx<T> reg, T point, boolean reverse) throws IOException {
        return this.hhAdapter.loadNetworkSegmentPoint(ctx, reg, point, reverse);
    }

    public String getRegionName() {
        String ls;
        List<String> rg = this.getRegionNames();
        if (rg.size() == 0) {
            rg.add(this.file.getName());
        }
        if ((ls = rg.get(0)).lastIndexOf(95) != -1) {
            if (ls.matches("([a-zA-Z-]+_)+([0-9]+_){2}[0-9]+\\.obf")) {
                Pattern osmDiffDateEnding = Pattern.compile("_([0-9]+_){2}[0-9]+\\.obf");
                Matcher m = osmDiffDateEnding.matcher(ls);
                if (m.find()) {
                    if ((ls = ls.substring(0, m.start())).lastIndexOf(95) != -1) {
                        return ls.substring(0, ls.lastIndexOf(95)).replace('_', ' ');
                    }
                    return ls;
                }
            } else {
                if (ls.contains(".")) {
                    ls = ls.substring(0, ls.indexOf("."));
                }
                if (ls.endsWith("_2")) {
                    ls = ls.substring(0, ls.length() - "_2".length());
                }
                if (ls.lastIndexOf(95) != -1) {
                    ls = ls.substring(0, ls.lastIndexOf(95)).replace('_', ' ');
                }
                return ls;
            }
        }
        return ls;
    }

    public int readByte() throws IOException {
        byte b = this.codedIS.readRawByte();
        if (b < 0) {
            return b + 256;
        }
        return b;
    }

    public final long readInt() throws IOException {
        boolean _8byte;
        long l = this.readByte();
        boolean bl = _8byte = l > 127L;
        if (_8byte) {
            l &= 0x7FL;
        }
        l = (l << 8) + (long)this.readByte();
        l = (l << 8) + (long)this.readByte();
        l = (l << 8) + (long)this.readByte();
        if (_8byte) {
            l = (l << 8) + (long)this.readByte();
            l = (l << 8) + (long)this.readByte();
            l = (l << 8) + (long)this.readByte();
            l = (l << 8) + (long)this.readByte();
        }
        return l;
    }

    public int getVersion() {
        return this.version;
    }

    protected void skipUnknownField(int tag) throws IOException {
        int wireType = WireFormat.getTagWireType(tag);
        if (wireType == 6) {
            long length = this.readInt();
            this.codedIS.skipRawBytes(length);
        } else {
            this.codedIS.skipField(tag);
        }
    }

    public TLongObjectHashMap<TransportRoute> getTransportRoutes(long[] filePointers) throws IOException {
        TLongObjectHashMap result = new TLongObjectHashMap();
        this.loadTransportRoutes(filePointers, (TLongObjectHashMap<TransportRoute>)result);
        return result;
    }

    public void loadTransportRoutes(long[] filePointers, TLongObjectHashMap<TransportRoute> result) throws IOException {
        HashMap<BinaryMapTransportReaderAdapter.TransportIndex, TLongArrayList> groupPoints = new HashMap<BinaryMapTransportReaderAdapter.TransportIndex, TLongArrayList>();
        for (long filePointer : filePointers) {
            BinaryMapTransportReaderAdapter.TransportIndex ind = this.getTransportIndex(filePointer);
            if (ind == null) continue;
            if (!groupPoints.containsKey(ind)) {
                groupPoints.put(ind, new TLongArrayList());
            }
            ((TLongArrayList)groupPoints.get(ind)).add(filePointer);
        }
        for (Map.Entry e : groupPoints.entrySet()) {
            BinaryMapTransportReaderAdapter.TransportIndex ind = (BinaryMapTransportReaderAdapter.TransportIndex)e.getKey();
            TLongArrayList pointers = (TLongArrayList)e.getValue();
            pointers.sort();
            TIntObjectHashMap stringTable = new TIntObjectHashMap();
            ArrayList<TransportRoute> finishInit = new ArrayList<TransportRoute>();
            for (int i = 0; i < pointers.size(); ++i) {
                long filePointer = pointers.get(i);
                TransportRoute transportRoute = this.transportAdapter.getTransportRoute(filePointer, (TIntObjectHashMap<String>)stringTable, false);
                result.put(filePointer, (Object)transportRoute);
                finishInit.add(transportRoute);
            }
            TIntObjectHashMap<String> indexedStringTable = this.transportAdapter.initializeStringTable(ind, (TIntObjectHashMap<String>)stringTable);
            for (TransportRoute transportRoute : finishInit) {
                this.transportAdapter.initializeNames(false, transportRoute, indexedStringTable);
            }
        }
    }

    public boolean transportStopBelongsTo(TransportStop s) {
        return this.getTransportIndex(s.getFileOffset()) != null;
    }

    public List<BinaryMapTransportReaderAdapter.TransportIndex> getTransportIndexes() {
        return this.transportIndexes;
    }

    private BinaryMapTransportReaderAdapter.TransportIndex getTransportIndex(long filePointer) {
        BinaryMapTransportReaderAdapter.TransportIndex ind = null;
        for (BinaryMapTransportReaderAdapter.TransportIndex i : this.transportIndexes) {
            if (i.filePointer > filePointer || filePointer - i.filePointer >= i.length) continue;
            ind = i;
            break;
        }
        return ind;
    }

    public boolean containTransportData(double latitude, double longitude) {
        double x = MapUtils.getTileNumberX(24.0f, longitude);
        double y = MapUtils.getTileNumberY(24.0f, latitude);
        for (BinaryMapTransportReaderAdapter.TransportIndex index : this.transportIndexes) {
            if (!((double)index.right >= x) || !((double)index.left <= x) || !((double)index.top <= y) || !((double)index.bottom >= y)) continue;
            return true;
        }
        return false;
    }

    public boolean containTransportData(double topLatitude, double leftLongitude, double bottomLatitude, double rightLongitude) {
        double leftX = MapUtils.getTileNumberX(24.0f, leftLongitude);
        double topY = MapUtils.getTileNumberY(24.0f, topLatitude);
        double rightX = MapUtils.getTileNumberX(24.0f, rightLongitude);
        double bottomY = MapUtils.getTileNumberY(24.0f, bottomLatitude);
        for (BinaryMapTransportReaderAdapter.TransportIndex index : this.transportIndexes) {
            if (!((double)index.right >= leftX) || !((double)index.left <= rightX) || !((double)index.top <= bottomY) || !((double)index.bottom >= topY)) continue;
            return true;
        }
        return false;
    }

    public List<TransportStop> searchTransportIndex(BinaryMapTransportReaderAdapter.TransportIndex index, SearchRequest<TransportStop> req) throws IOException {
        if (index.stopsFileLength == 0L || index.right < req.left || index.left > req.right || index.top > req.bottom || index.bottom < req.top) {
            return req.getSearchResults();
        }
        this.codedIS.seek(index.stopsFileOffset);
        long oldLimit = this.codedIS.pushLimitLong(index.stopsFileLength);
        int offset = req.searchResults.size();
        TIntObjectHashMap stringTable = new TIntObjectHashMap();
        this.transportAdapter.searchTransportTreeBounds(0, 0, 0, 0, req, (TIntObjectHashMap<String>)stringTable);
        this.codedIS.popLimit(oldLimit);
        TIntObjectHashMap<String> indexedStringTable = this.transportAdapter.initializeStringTable(index, (TIntObjectHashMap<String>)stringTable);
        for (int i = offset; i < req.searchResults.size(); ++i) {
            TransportStop st = (TransportStop)req.searchResults.get(i);
            this.transportAdapter.initializeNames(indexedStringTable, st);
        }
        return req.getSearchResults();
    }

    public List<TransportStop> searchTransportIndex(SearchRequest<TransportStop> req) throws IOException {
        for (BinaryMapTransportReaderAdapter.TransportIndex index : this.transportIndexes) {
            this.searchTransportIndex(index, req);
        }
        if (req.numberOfVisitedObjects > 0 && req.log) {
            log.debug((Object)("Search is done. Visit " + req.numberOfVisitedObjects + " objects. Read " + req.numberOfAcceptedObjects + " objects."));
            log.debug((Object)("Read " + req.numberOfReadSubtrees + " subtrees. Go through " + req.numberOfAcceptedSubtrees + " subtrees."));
        }
        return req.getSearchResults();
    }

    public List<String> getRegionNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (BinaryMapAddressReaderAdapter.AddressRegion r : this.addressIndexes) {
            names.add(r.name);
        }
        return names;
    }

    public LatLon getRegionCenter() {
        for (BinaryMapAddressReaderAdapter.AddressRegion r : this.addressIndexes) {
            if (r.calculatedCenter == null) continue;
            return r.calculatedCenter;
        }
        return null;
    }

    public List<City> getCities(SearchRequest<City> resultMatcher, BinaryMapAddressReaderAdapter.CityBlocks type) throws IOException {
        return this.getCities(resultMatcher, null, null, type, null, null);
    }

    public List<City> getCities(SearchRequest<City> resultMatcher, BinaryMapAddressReaderAdapter.CityBlocks type, BinaryMapAddressReaderAdapter.AddressRegion onlyRegion, BinaryMapIndexReaderStats.SearchStat stat) throws IOException {
        return this.getCities(resultMatcher, null, null, type, onlyRegion, stat);
    }

    public List<City> getCities(SearchRequest<City> resultMatcher, StringMatcher matcher, String lang, BinaryMapAddressReaderAdapter.CityBlocks type, BinaryMapAddressReaderAdapter.AddressRegion onlyRegion, BinaryMapIndexReaderStats.SearchStat searchStat) throws IOException {
        ArrayList<City> cities = new ArrayList<City>();
        List<BinaryMapAddressReaderAdapter.AddressRegion> inds = onlyRegion == null ? this.addressIndexes : Collections.singletonList(onlyRegion);
        for (BinaryMapAddressReaderAdapter.AddressRegion r : inds) {
            for (BinaryMapAddressReaderAdapter.CitiesBlock block : r.cities) {
                if (type == null || block.type != type.index) continue;
                long statReq = 0L;
                if (searchStat != null) {
                    statReq = searchStat.beginSearchStats(BinaryMapIndexReaderStats.BinaryMapIndexReaderApiName.LOAD_CITIES, r, this.codedIS, null);
                }
                this.codedIS.seek(block.filePointer);
                long old = this.codedIS.pushLimitLong(block.length);
                this.addressAdapter.readCities(cities, resultMatcher, matcher, r.attributeTagsTable);
                this.codedIS.popLimit(old);
                if (statReq <= 0L) continue;
                searchStat.endSearchStats(statReq, BinaryMapIndexReaderStats.BinaryMapIndexReaderApiName.LOAD_CITIES, r, this.codedIS, null);
            }
        }
        return cities;
    }

    public int preloadStreets(City c, SearchRequest<Street> resultMatcher, BinaryMapIndexReaderStats.SearchStat searchStat) throws IOException {
        return this.preloadStreets(c, resultMatcher, false, searchStat);
    }

    public int preloadStreets(City c, SearchRequest<Street> resultMatcher, boolean loadBuildings, BinaryMapIndexReaderStats.SearchStat searchStat) throws IOException {
        BinaryMapAddressReaderAdapter.AddressRegion reg;
        try {
            reg = this.checkAddressIndex(c.getFileOffset());
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage() + " while reading " + String.valueOf(c) + " (id: " + c.getId() + ")");
        }
        long statReq = 0L;
        if (searchStat != null) {
            statReq = searchStat.beginSearchStats(BinaryMapIndexReaderStats.BinaryMapIndexReaderApiName.LOAD_STREETS, reg, this.codedIS, null);
        }
        this.codedIS.seek(c.getFileOffset());
        int size = this.codedIS.readRawVarint32();
        long old = this.codedIS.pushLimitLong(size);
        this.addressAdapter.readCityStreets(resultMatcher, c, loadBuildings, reg.attributeTagsTable);
        this.codedIS.popLimit(old);
        if (statReq > 0L) {
            searchStat.endSearchStats(statReq, BinaryMapIndexReaderStats.BinaryMapIndexReaderApiName.LOAD_STREETS, reg, this.codedIS, null);
        }
        return size;
    }

    private BinaryMapAddressReaderAdapter.AddressRegion checkAddressIndex(long offset) {
        for (BinaryMapAddressReaderAdapter.AddressRegion r : this.addressIndexes) {
            if (offset < r.filePointer || offset > r.length + r.filePointer) continue;
            return r;
        }
        throw new IllegalArgumentException("Illegal offset " + offset);
    }

    public void preloadBuildings(Street s, SearchRequest<Building> resultMatcher, BinaryMapIndexReaderStats.SearchStat searchStat) throws IOException {
        BinaryMapAddressReaderAdapter.AddressRegion reg = this.checkAddressIndex(s.getFileOffset());
        long statReq = 0L;
        if (searchStat != null) {
            statReq = searchStat.beginSearchStats(BinaryMapIndexReaderStats.BinaryMapIndexReaderApiName.LOAD_BUILDINGS, reg, this.codedIS, null);
        }
        this.codedIS.seek(s.getFileOffset());
        long size = this.codedIS.readRawVarint32();
        long old = this.codedIS.pushLimitLong(size);
        City city = s.getCity();
        this.addressAdapter.readStreet(s, resultMatcher, true, 0, 0, city != null && city.isPostcode() ? city.getName() : null, reg.attributeTagsTable);
        this.codedIS.popLimit(old);
        if (statReq > 0L) {
            searchStat.endSearchStats(statReq, BinaryMapIndexReaderStats.BinaryMapIndexReaderApiName.LOAD_BUILDINGS, reg, this.codedIS, null);
        }
    }

    private void readMapIndex(MapIndex index, boolean onlyInitEncodingRules) throws IOException {
        int defaultId = 1;
        long encodingRulesSize = 0L;
        block6: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    if (onlyInitEncodingRules) {
                        index.finishInitializingTags();
                    }
                    return;
                }
                case 2: {
                    index.setName(this.codedIS.readString());
                    continue block6;
                }
                case 4: {
                    long oldLimit;
                    if (onlyInitEncodingRules) {
                        if (encodingRulesSize == 0L) {
                            encodingRulesSize = this.codedIS.getTotalBytesRead();
                        }
                        int len = this.codedIS.readInt32();
                        oldLimit = this.codedIS.pushLimitLong(len);
                        this.readMapEncodingRule(index, defaultId++);
                        this.codedIS.popLimit(oldLimit);
                        index.encodingRulesSizeBytes = (int)(this.codedIS.getTotalBytesRead() - encodingRulesSize);
                        continue block6;
                    }
                    this.skipUnknownField(t);
                    continue block6;
                }
                case 5: {
                    long oldLimit;
                    long length = this.readInt();
                    long filePointer = this.codedIS.getTotalBytesRead();
                    if (!onlyInitEncodingRules) {
                        oldLimit = this.codedIS.pushLimitLong(length);
                        MapRoot mapRoot = this.readMapLevel(new MapRoot());
                        mapRoot.length = length;
                        mapRoot.filePointer = filePointer;
                        index.getRoots().add(mapRoot);
                        this.codedIS.popLimit(oldLimit);
                    }
                    this.codedIS.seek(filePointer + length);
                    continue block6;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private void readMapEncodingRule(MapIndex index, int id) throws IOException {
        int type = 0;
        String tags = null;
        String val = null;
        block7: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    index.initMapEncodingRule(type, id, tags, val);
                    return;
                }
                case 5: {
                    val = this.codedIS.readString().intern();
                    continue block7;
                }
                case 3: {
                    tags = this.codedIS.readString().intern();
                    continue block7;
                }
                case 10: {
                    type = this.codedIS.readUInt32();
                    continue block7;
                }
                case 7: {
                    id = this.codedIS.readUInt32();
                    continue block7;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private MapRoot readMapLevel(MapRoot root) throws IOException {
        block11: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return root;
                }
                case 6: {
                    root.bottom = this.codedIS.readInt32();
                    continue block11;
                }
                case 3: {
                    root.left = this.codedIS.readInt32();
                    continue block11;
                }
                case 4: {
                    root.right = this.codedIS.readInt32();
                    continue block11;
                }
                case 5: {
                    root.top = this.codedIS.readInt32();
                    continue block11;
                }
                case 1: {
                    root.maxZoom = this.codedIS.readInt32();
                    continue block11;
                }
                case 2: {
                    root.minZoom = this.codedIS.readInt32();
                    continue block11;
                }
                case 7: {
                    long length = this.readInt();
                    long filePointer = this.codedIS.getTotalBytesRead();
                    if (root.trees != null) {
                        MapTree r = new MapTree();
                        r.length = length;
                        r.filePointer = filePointer;
                        long oldLimit = this.codedIS.pushLimitLong(r.length);
                        this.readMapTreeBounds(r, root.left, root.right, root.top, root.bottom);
                        root.trees.add(r);
                        this.codedIS.popLimit(oldLimit);
                    }
                    this.codedIS.seek(filePointer + length);
                    continue block11;
                }
                case 15: {
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    continue block11;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private void readMapTreeBounds(MapTree tree, int aleft, int aright, int atop, int abottom) throws IOException {
        block9: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 4: {
                    tree.bottom = this.codedIS.readSInt32() + abottom;
                    continue block9;
                }
                case 1: {
                    tree.left = this.codedIS.readSInt32() + aleft;
                    continue block9;
                }
                case 2: {
                    tree.right = this.codedIS.readSInt32() + aright;
                    continue block9;
                }
                case 3: {
                    tree.top = this.codedIS.readSInt32() + atop;
                    continue block9;
                }
                case 6: {
                    if (this.codedIS.readBool()) {
                        tree.ocean = Boolean.TRUE;
                        continue block9;
                    }
                    tree.ocean = Boolean.FALSE;
                    continue block9;
                }
                case 5: {
                    tree.mapDataBlock = this.readInt() + tree.filePointer;
                    continue block9;
                }
            }
            this.skipUnknownField(t);
        }
    }

    public List<BinaryMapDataObject> searchMapIndex(SearchRequest<BinaryMapDataObject> req) throws IOException {
        return this.searchMapIndex(req, null);
    }

    public List<BinaryMapDataObject> searchMapIndex(SearchRequest<BinaryMapDataObject> req, MapIndex filterMapIndex) throws IOException {
        req.numberOfVisitedObjects = 0;
        req.numberOfAcceptedObjects = 0;
        req.numberOfAcceptedSubtrees = 0;
        req.numberOfReadSubtrees = 0;
        ArrayList<MapTree> foundSubtrees = new ArrayList<MapTree>();
        for (MapIndex mapIndex : this.mapIndexes) {
            if (filterMapIndex != null && mapIndex != filterMapIndex) continue;
            if (mapIndex.encodingRules.isEmpty()) {
                this.codedIS.seek(mapIndex.filePointer);
                long oldLimit = this.codedIS.pushLimitLong(mapIndex.length);
                this.readMapIndex(mapIndex, true);
                this.codedIS.popLimit(oldLimit);
            }
            for (MapRoot index : mapIndex.getRoots()) {
                if (index.minZoom > req.zoom || index.maxZoom < req.zoom || index.right < req.left || index.left > req.right || index.top > req.bottom || index.bottom < req.top || req.hasSearchBoxes() && !req.containsSearchBox(index.left, index.top, index.right, index.bottom)) continue;
                if (index.trees == null) {
                    index.trees = new ArrayList<MapTree>();
                    this.codedIS.seek(index.filePointer);
                    long oldLimit = this.codedIS.pushLimitLong(index.length);
                    this.readMapLevel(index);
                    this.codedIS.popLimit(oldLimit);
                }
                for (MapTree tree : index.trees) {
                    if (tree.right < req.left || tree.left > req.right || tree.top > req.bottom || tree.bottom < req.top || req.hasSearchBoxes() && !req.containsSearchBox(tree.left, tree.top, tree.right, tree.bottom)) continue;
                    this.codedIS.seek(tree.filePointer);
                    long oldLimit = this.codedIS.pushLimitLong(tree.length);
                    this.searchMapTreeBounds(tree, index, req, foundSubtrees);
                    this.codedIS.popLimit(oldLimit);
                }
                Collections.sort(foundSubtrees, new Comparator<MapTree>(){

                    @Override
                    public int compare(MapTree o1, MapTree o2) {
                        return o1.mapDataBlock < o2.mapDataBlock ? -1 : (o1.mapDataBlock == o2.mapDataBlock ? 0 : 1);
                    }
                });
                for (MapTree tree : foundSubtrees) {
                    if (req.isCancelled()) continue;
                    this.codedIS.seek(tree.mapDataBlock);
                    int length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    this.readMapDataBlocks(req, tree, mapIndex);
                    this.codedIS.popLimit(oldLimit);
                }
                foundSubtrees.clear();
            }
        }
        if (req.numberOfVisitedObjects > 0 && req.log) {
            log.info((Object)("Search is done. Visit " + req.numberOfVisitedObjects + " objects. Read " + req.numberOfAcceptedObjects + " objects."));
            log.info((Object)("Read " + req.numberOfReadSubtrees + " subtrees. Go through " + req.numberOfAcceptedSubtrees + " subtrees."));
        }
        return req.getSearchResults();
    }

    protected void readMapDataBlocks(SearchRequest<BinaryMapDataObject> req, MapTree tree, MapIndex root) throws IOException {
        ArrayList<BinaryMapDataObject> tempResults = null;
        long baseId = 0L;
        block6: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    if (tempResults != null) {
                        for (BinaryMapDataObject obj : tempResults) {
                            req.publish(obj);
                        }
                    }
                    return;
                }
                case 10: {
                    baseId = this.codedIS.readUInt64();
                    if (!READ_STATS) continue block6;
                    req.stat.addBlockHeader(10, 0);
                    continue block6;
                }
                case 12: {
                    BinaryMapDataObject mapObject;
                    int length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    if (READ_STATS) {
                        req.stat.lastObjectSize += length;
                        req.stat.addBlockHeader(12, length);
                    }
                    if ((mapObject = this.readMapDataObject(tree, req, root)) != null) {
                        mapObject.setId(mapObject.getId() + baseId);
                        if (READ_STATS) {
                            req.publish(mapObject);
                        }
                        if (tempResults == null) {
                            tempResults = new ArrayList<BinaryMapDataObject>();
                        }
                        tempResults.add(mapObject);
                    }
                    this.codedIS.popLimit(oldLimit);
                    continue block6;
                }
                case 15: {
                    int length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    if (READ_STATS) {
                        req.stat.addBlockHeader(15, length);
                        req.stat.lastBlockStringTableSize += length;
                    }
                    if (tempResults != null) {
                        List<String> stringTable = this.readStringTable();
                        for (int i = 0; i < tempResults.size(); ++i) {
                            BinaryMapDataObject rs = (BinaryMapDataObject)tempResults.get(i);
                            if (rs.objectNames == null) continue;
                            int[] keys = rs.objectNames.keys();
                            for (int j = 0; j < keys.length; ++j) {
                                rs.objectNames.put(keys[j], (Object)stringTable.get(((String)rs.objectNames.get(keys[j])).charAt(0)));
                            }
                        }
                    } else {
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    }
                    this.codedIS.popLimit(oldLimit);
                    continue block6;
                }
            }
            this.skipUnknownField(t);
        }
        return;
    }

    protected void searchMapTreeBounds(MapTree current, MapTree parent, SearchRequest<BinaryMapDataObject> req, List<MapTree> foundSubtrees) throws IOException {
        int init = 0;
        ++req.numberOfReadSubtrees;
        block10: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            if (init == 15) {
                init = 0;
                if (current.right < req.left || current.left > req.right || current.top > req.bottom || current.bottom < req.top) {
                    return;
                }
                if (req.hasSearchBoxes() && !req.containsSearchBox(current.left, current.top, current.right, current.bottom)) {
                    return;
                }
                ++req.numberOfAcceptedSubtrees;
            }
            switch (tag) {
                case 0: {
                    return;
                }
                case 4: {
                    current.bottom = this.codedIS.readSInt32() + parent.bottom;
                    init |= 1;
                    continue block10;
                }
                case 1: {
                    current.left = this.codedIS.readSInt32() + parent.left;
                    init |= 2;
                    continue block10;
                }
                case 2: {
                    current.right = this.codedIS.readSInt32() + parent.right;
                    init |= 4;
                    continue block10;
                }
                case 3: {
                    current.top = this.codedIS.readSInt32() + parent.top;
                    init |= 8;
                    continue block10;
                }
                case 5: {
                    ++req.numberOfAcceptedSubtrees;
                    current.mapDataBlock = this.readInt() + current.filePointer;
                    foundSubtrees.add(current);
                    continue block10;
                }
                case 6: {
                    current.ocean = this.codedIS.readBool() ? Boolean.TRUE : Boolean.FALSE;
                    req.publishOceanTile(current.ocean);
                    continue block10;
                }
                case 7: {
                    MapTree child = new MapTree();
                    child.length = this.readInt();
                    child.filePointer = this.codedIS.getTotalBytesRead();
                    long oldLimit = this.codedIS.pushLimitLong(child.length);
                    if (current.ocean != null) {
                        child.ocean = current.ocean;
                    }
                    this.searchMapTreeBounds(child, current, req, foundSubtrees);
                    this.codedIS.popLimit(oldLimit);
                    this.codedIS.seek(child.filePointer + child.length);
                    continue block10;
                }
            }
            this.skipUnknownField(t);
        }
        return;
    }

    private BinaryMapDataObject readMapDataObject(MapTree tree, SearchRequest<BinaryMapDataObject> req, MapIndex root) throws IOException {
        boolean area;
        int tag = WireFormat.getTagFieldNumber(this.codedIS.readTag());
        boolean bl = area = 2 == tag;
        if (!area && 1 != tag) {
            throw new IllegalArgumentException();
        }
        req.cacheCoordinates.clear();
        int size = this.codedIS.readRawVarint32();
        if (READ_STATS) {
            req.stat.lastObjectCoordinates += size;
            req.stat.addTagHeader(1, size);
        }
        long old = this.codedIS.pushLimitLong(size);
        int px = tree.left & this.MASK_TO_READ;
        int py = tree.top & this.MASK_TO_READ;
        boolean contains = false;
        int minX = Integer.MAX_VALUE;
        int maxX = 0;
        int minY = Integer.MAX_VALUE;
        int maxY = 0;
        ++req.numberOfVisitedObjects;
        while (this.codedIS.getBytesUntilLimit() > 0L) {
            int x = (this.codedIS.readSInt32() << 5) + px;
            int y = (this.codedIS.readSInt32() << 5) + py;
            req.cacheCoordinates.add(x);
            req.cacheCoordinates.add(y);
            px = x;
            py = y;
            if (!contains && req.left <= x && req.right >= x && req.top <= y && req.bottom >= y) {
                contains = true;
            }
            if (contains) continue;
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        if (!contains && maxX >= req.left && minX <= req.right && minY <= req.bottom && maxY >= req.top) {
            contains = true;
        }
        this.codedIS.popLimit(old);
        if (!contains) {
            this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
            return null;
        }
        ArrayList<TIntArrayList> innercoordinates = null;
        TIntArrayList additionalTypes = null;
        TIntObjectHashMap stringNames = null;
        TIntArrayList stringOrder = null;
        long id = 0L;
        int labelX = 0;
        int labelY = 0;
        boolean loop = true;
        block10: while (loop) {
            int t = this.codedIS.readTag();
            tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    loop = false;
                    continue block10;
                }
                case 4: {
                    if (innercoordinates == null) {
                        innercoordinates = new ArrayList<TIntArrayList>();
                    }
                    TIntArrayList polygon = new TIntArrayList();
                    innercoordinates.add(polygon);
                    px = tree.left & this.MASK_TO_READ;
                    py = tree.top & this.MASK_TO_READ;
                    size = this.codedIS.readRawVarint32();
                    if (READ_STATS) {
                        req.stat.lastObjectCoordinates += size;
                        req.stat.addTagHeader(4, size);
                    }
                    old = this.codedIS.pushLimitLong(size);
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        int x = (this.codedIS.readSInt32() << 5) + px;
                        int y = (this.codedIS.readSInt32() << 5) + py;
                        polygon.add(x);
                        polygon.add(y);
                        px = x;
                        py = y;
                    }
                    this.codedIS.popLimit(old);
                    continue block10;
                }
                case 6: {
                    additionalTypes = new TIntArrayList();
                    int sizeL = this.codedIS.readRawVarint32();
                    old = this.codedIS.pushLimitLong(sizeL);
                    if (READ_STATS) {
                        req.stat.lastObjectAdditionalTypes += sizeL;
                        req.stat.addTagHeader(6, sizeL);
                    }
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        additionalTypes.add(this.codedIS.readRawVarint32());
                    }
                    this.codedIS.popLimit(old);
                    continue block10;
                }
                case 7: {
                    req.cacheTypes.clear();
                    int sizeL = this.codedIS.readRawVarint32();
                    old = this.codedIS.pushLimitLong(sizeL);
                    if (READ_STATS) {
                        req.stat.addTagHeader(7, sizeL);
                        req.stat.lastObjectTypes += sizeL;
                    }
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        req.cacheTypes.add(this.codedIS.readRawVarint32());
                    }
                    this.codedIS.popLimit(old);
                    boolean accept = true;
                    if (req.searchFilter != null) {
                        accept = req.searchFilter.accept(req.cacheTypes, root);
                    }
                    if (!accept) {
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                        return null;
                    }
                    ++req.numberOfAcceptedObjects;
                    continue block10;
                }
                case 12: {
                    id = this.codedIS.readSInt64();
                    if (!READ_STATS) continue block10;
                    req.stat.addTagHeader(12, 0);
                    --req.stat.lastObjectHeaderInfo;
                    req.stat.lastObjectIdSize += CodedOutputStream.computeSInt64SizeNoTag(id);
                    continue block10;
                }
                case 10: {
                    stringNames = new TIntObjectHashMap();
                    stringOrder = new TIntArrayList();
                    int sizeL = this.codedIS.readRawVarint32();
                    old = this.codedIS.pushLimitLong(sizeL);
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        int stag = this.codedIS.readRawVarint32();
                        int pId = this.codedIS.readRawVarint32();
                        stringNames.put(stag, (Object)("" + (char)pId));
                        stringOrder.add(stag);
                    }
                    this.codedIS.popLimit(old);
                    if (!READ_STATS) continue block10;
                    req.stat.addTagHeader(10, sizeL);
                    req.stat.lastStringNamesSize += sizeL;
                    continue block10;
                }
                case 8: {
                    int sizeL = this.codedIS.readRawVarint32();
                    old = this.codedIS.pushLimitLong(sizeL);
                    int i = 0;
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        if (i == 0) {
                            labelX = this.codedIS.readSInt32();
                        } else if (i == 1) {
                            labelY = this.codedIS.readSInt32();
                        } else {
                            this.codedIS.readRawVarint32();
                        }
                        ++i;
                    }
                    this.codedIS.popLimit(old);
                    if (!READ_STATS) continue block10;
                    req.stat.addTagHeader(8, sizeL);
                    req.stat.lastObjectLabelCoordinates += sizeL;
                    continue block10;
                }
            }
            this.skipUnknownField(t);
        }
        BinaryMapDataObject dataObject = new BinaryMapDataObject();
        dataObject.area = area;
        dataObject.coordinates = req.cacheCoordinates.toArray();
        dataObject.objectNames = stringNames;
        dataObject.namesOrder = stringOrder;
        if (innercoordinates == null) {
            dataObject.polygonInnerCoordinates = new int[0][0];
        } else {
            dataObject.polygonInnerCoordinates = new int[innercoordinates.size()][];
            for (int i = 0; i < innercoordinates.size(); ++i) {
                dataObject.polygonInnerCoordinates[i] = ((TIntArrayList)innercoordinates.get(i)).toArray();
            }
        }
        dataObject.types = req.cacheTypes.toArray();
        dataObject.additionalTypes = additionalTypes != null ? additionalTypes.toArray() : new int[0];
        dataObject.id = id;
        dataObject.area = area;
        dataObject.mapIndex = root;
        dataObject.labelX = labelX;
        dataObject.labelY = labelY;
        return dataObject;
    }

    public List<MapObject> searchAddressDataByName(SearchRequest<MapObject> req, List<BinaryMapAddressReaderAdapter.CityBlocks> typeFilter) throws IOException {
        for (BinaryMapAddressReaderAdapter.AddressRegion reg : this.addressIndexes) {
            if (reg.indexNameOffset == -1L) continue;
            long statReq = req.beginSearchStats(BinaryMapIndexReaderStats.BinaryMapIndexReaderApiName.ADDRESS_BY_NAME, reg, this.codedIS);
            this.codedIS.seek(reg.indexNameOffset);
            long len = this.readInt();
            long old = this.codedIS.pushLimitLong(len);
            this.addressAdapter.searchAddressDataByName(reg, req, typeFilter);
            this.codedIS.popLimit(old);
            req.endSearchStats(statReq, BinaryMapIndexReaderStats.BinaryMapIndexReaderApiName.ADDRESS_BY_NAME, reg, this.codedIS);
        }
        return req.getSearchResults();
    }

    public List<MapObject> searchAddressDataByName(SearchRequest<MapObject> req) throws IOException {
        return this.searchAddressDataByName(req, null);
    }

    public void initCategories(BinaryMapPoiReaderAdapter.PoiRegion poiIndex) throws IOException {
        this.poiAdapter.initCategories(poiIndex);
    }

    public void initCategories() throws IOException {
        for (BinaryMapPoiReaderAdapter.PoiRegion poiIndex : this.poiIndexes) {
            this.poiAdapter.initCategories(poiIndex);
        }
    }

    public List<Amenity> searchPoiByName(SearchRequest<Amenity> req) throws IOException {
        if (req.nameQuery == null || req.nameQuery.length() == 0) {
            throw new IllegalArgumentException();
        }
        for (BinaryMapPoiReaderAdapter.PoiRegion poiIndex : this.poiIndexes) {
            long statReq = req.beginSearchStats(BinaryMapIndexReaderStats.BinaryMapIndexReaderApiName.POI_BY_NAME, poiIndex, this.codedIS);
            this.poiAdapter.initCategories(poiIndex);
            this.codedIS.seek(poiIndex.filePointer);
            long old = this.codedIS.pushLimitLong(poiIndex.length);
            this.poiAdapter.searchPoiByName(poiIndex, req);
            this.codedIS.popLimit(old);
            req.endSearchStats(statReq, BinaryMapIndexReaderStats.BinaryMapIndexReaderApiName.POI_BY_NAME, poiIndex, this.codedIS);
        }
        return req.getSearchResults();
    }

    public Map<PoiCategory, List<String>> searchPoiCategoriesByName(String query, Map<PoiCategory, List<String>> map) throws IOException {
        if (query == null || query.length() == 0) {
            throw new IllegalArgumentException();
        }
        Collator collator = OsmAndCollator.primaryCollator();
        for (BinaryMapPoiReaderAdapter.PoiRegion poiIndex : this.poiIndexes) {
            this.poiAdapter.initCategories(poiIndex);
            for (int i = 0; i < poiIndex.categories.size(); ++i) {
                String cat = poiIndex.categories.get(i);
                PoiCategory catType = poiIndex.categoriesType.get(i);
                if (CollatorStringMatcher.cmatches(collator, cat, query, CollatorStringMatcher.StringMatcherMode.CHECK_STARTS_FROM_SPACE)) {
                    map.put(catType, null);
                    continue;
                }
                List<String> subcats = poiIndex.subcategories.get(i);
                for (int j = 0; j < subcats.size(); ++j) {
                    List<String> list;
                    if (!CollatorStringMatcher.cmatches(collator, subcats.get(j), query, CollatorStringMatcher.StringMatcherMode.CHECK_STARTS_FROM_SPACE)) continue;
                    if (!map.containsKey(catType)) {
                        map.put(catType, new ArrayList());
                    }
                    if ((list = map.get(catType)) == null) continue;
                    list.add(subcats.get(j));
                }
            }
        }
        return map;
    }

    public List<BinaryMapPoiReaderAdapter.PoiSubType> searchPoiSubTypesByPrefix(String query) throws IOException {
        if (query == null || query.length() == 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<BinaryMapPoiReaderAdapter.PoiSubType> list = new ArrayList<BinaryMapPoiReaderAdapter.PoiSubType>();
        for (BinaryMapPoiReaderAdapter.PoiRegion poiIndex : this.poiIndexes) {
            this.poiAdapter.initCategories(poiIndex);
            for (int i = 0; i < poiIndex.subTypes.size(); ++i) {
                BinaryMapPoiReaderAdapter.PoiSubType subType = poiIndex.subTypes.get(i);
                if (!subType.name.startsWith(query)) continue;
                list.add(subType);
            }
        }
        return list;
    }

    public List<BinaryMapPoiReaderAdapter.PoiSubType> getTopIndexSubTypes() throws IOException {
        ArrayList<BinaryMapPoiReaderAdapter.PoiSubType> list = new ArrayList<BinaryMapPoiReaderAdapter.PoiSubType>();
        for (BinaryMapPoiReaderAdapter.PoiRegion poiIndex : this.poiIndexes) {
            this.poiAdapter.initCategories(poiIndex);
            list.addAll(poiIndex.topIndexSubTypes);
        }
        return list;
    }

    public List<Amenity> searchPoi(SearchRequest<Amenity> req) throws IOException {
        return this.searchPoi(req, null);
    }

    public List<Amenity> searchPoi(SearchRequest<Amenity> req, BinaryMapPoiReaderAdapter.PoiRegion onlyIndex) throws IOException {
        req.numberOfVisitedObjects = 0;
        req.numberOfAcceptedObjects = 0;
        req.numberOfAcceptedSubtrees = 0;
        req.numberOfReadSubtrees = 0;
        List<BinaryMapPoiReaderAdapter.PoiRegion> lst = onlyIndex == null ? this.poiIndexes : Collections.singletonList(onlyIndex);
        for (BinaryMapPoiReaderAdapter.PoiRegion poiIndex : lst) {
            long statReq = req.beginSearchStats(BinaryMapIndexReaderStats.BinaryMapIndexReaderApiName.POI_BY_NAME, poiIndex, this.codedIS);
            this.poiAdapter.initCategories(poiIndex);
            this.codedIS.seek(poiIndex.filePointer);
            long old = this.codedIS.pushLimitLong(poiIndex.length);
            this.poiAdapter.searchPoiIndex(req.left, req.right, req.top, req.bottom, req, poiIndex);
            this.codedIS.popLimit(old);
            req.endSearchStats(statReq, BinaryMapIndexReaderStats.BinaryMapIndexReaderApiName.POI_BY_NAME, poiIndex, this.codedIS);
        }
        return req.getSearchResults();
    }

    protected List<String> readStringTable() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        block4: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return list;
                }
                case 1: {
                    list.add(this.codedIS.readString());
                    continue block4;
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected List<BinaryMapAddressReaderAdapter.AddressRegion> getAddressIndexes() {
        return this.addressIndexes;
    }

    public List<BinaryMapPoiReaderAdapter.PoiRegion> getPoiIndexes() {
        return this.poiIndexes;
    }

    public static SearchRequest<BinaryMapDataObject> buildSearchRequest(int sleft, int sright, int stop, int sbottom, int zoom, SearchFilter searchFilter) {
        return BinaryMapIndexReader.buildSearchRequest(sleft, sright, stop, sbottom, zoom, searchFilter, null);
    }

    public static SearchRequest<BinaryMapDataObject> buildSearchRequest(int sleft, int sright, int stop, int sbottom, int zoom, SearchFilter searchFilter, ResultMatcher<BinaryMapDataObject> resultMatcher) {
        SearchRequest<BinaryMapDataObject> request = new SearchRequest<BinaryMapDataObject>();
        request.left = sleft;
        request.right = sright;
        request.top = stop;
        request.bottom = sbottom;
        request.zoom = zoom;
        request.searchFilter = searchFilter;
        request.resultMatcher = resultMatcher;
        return request;
    }

    public static <T> SearchRequest<T> buildAddressRequest(ResultMatcher<T> resultMatcher) {
        SearchRequest request = new SearchRequest();
        request.resultMatcher = resultMatcher;
        return request;
    }

    public static <T> SearchRequest<T> buildAddressByNameRequest(ResultMatcher<T> resultMatcher, String nameRequest, CollatorStringMatcher.StringMatcherMode matcherMode) {
        return BinaryMapIndexReader.buildAddressByNameRequest(resultMatcher, null, nameRequest, matcherMode);
    }

    public static <T> SearchRequest<T> buildAddressByNameRequest(ResultMatcher<T> resultMatcher, ResultMatcher<T> rawDataCollector, String nameRequest, CollatorStringMatcher.StringMatcherMode matcherMode) {
        SearchRequest request = new SearchRequest();
        request.resultMatcher = resultMatcher;
        request.rawDataCollector = rawDataCollector;
        request.nameQuery = nameRequest.trim();
        request.matcherMode = matcherMode;
        return request;
    }

    public static SearchRequest<Amenity> buildSearchPoiRequest(List<Location> route, double radius, SearchPoiTypeFilter poiTypeFilter, ResultMatcher<Amenity> resultMatcher) {
        SearchRequest<Amenity> request = new SearchRequest<Amenity>();
        float coeff = (float)(radius / MapUtils.getTileDistanceWidth(16.0f));
        TLongObjectHashMap zooms = new TLongObjectHashMap();
        for (int i = 1; i < route.size(); ++i) {
            Location cr = route.get(i);
            Location pr = route.get(i - 1);
            double tx = MapUtils.getTileNumberX(16.0f, cr.getLongitude());
            double ty = MapUtils.getTileNumberY(16.0f, cr.getLatitude());
            double px = MapUtils.getTileNumberX(16.0f, pr.getLongitude());
            double py = MapUtils.getTileNumberY(16.0f, pr.getLatitude());
            double topLeftX = Math.min(tx, px) - (double)coeff;
            double topLeftY = Math.min(ty, py) - (double)coeff;
            double bottomRightX = Math.max(tx, px) + (double)coeff;
            double bottomRightY = Math.max(ty, py) + (double)coeff;
            int x = (int)topLeftX;
            while ((double)x <= bottomRightX) {
                int y = (int)topLeftY;
                while ((double)y <= bottomRightY) {
                    long hash = ((long)x << 16) + (long)y;
                    if (!zooms.containsKey(hash)) {
                        zooms.put(hash, new LinkedList());
                    }
                    List ll = (List)zooms.get(hash);
                    ll.add(pr);
                    ll.add(cr);
                    ++y;
                }
                ++x;
            }
        }
        int sleft = Integer.MAX_VALUE;
        int sright = 0;
        int stop = Integer.MAX_VALUE;
        int sbottom = 0;
        for (long vl : zooms.keys()) {
            long x = vl >> 16 << 15;
            long y = (vl & 0xFFFFL) << 15;
            sleft = (int)Math.min(x, (long)sleft);
            stop = (int)Math.min(y, (long)stop);
            sbottom = (int)Math.max(y, (long)sbottom);
            sright = (int)Math.max(x, (long)sright);
        }
        request.radius = radius;
        request.left = sleft;
        request.zoom = -1;
        request.right = sright;
        request.top = stop;
        request.bottom = sbottom;
        request.tiles = zooms;
        request.poiTypeFilter = poiTypeFilter;
        request.resultMatcher = resultMatcher;
        return request;
    }

    public static SearchRequest<Amenity> buildSearchPoiRequest(int sleft, int sright, int stop, int sbottom, int zoom, SearchPoiTypeFilter poiTypeFilter, ResultMatcher<Amenity> matcher) {
        return BinaryMapIndexReader.buildSearchPoiRequest(sleft, sright, stop, sbottom, zoom, poiTypeFilter, null, matcher);
    }

    public static SearchRequest<Amenity> buildSearchPoiRequest(int sleft, int sright, int stop, int sbottom, int zoom, SearchPoiTypeFilter poiTypeFilter, SearchPoiAdditionalFilter poiTopIndexAdditionalFilter, ResultMatcher<Amenity> matcher) {
        SearchRequest<Amenity> request = new SearchRequest<Amenity>();
        request.left = sleft;
        request.right = sright;
        request.top = stop;
        request.bottom = sbottom;
        request.zoom = zoom;
        request.poiTypeFilter = poiTypeFilter;
        request.poiAdditionalFilter = poiTopIndexAdditionalFilter;
        request.resultMatcher = matcher;
        return request;
    }

    public static SearchRequest<Amenity> buildSearchPoiRequest(LatLon latLon, int radius, int zoom, SearchPoiTypeFilter poiTypeFilter, ResultMatcher<Amenity> matcher) {
        SearchRequest<Amenity> request = new SearchRequest<Amenity>();
        request.setBBoxRadius(latLon.getLatitude(), latLon.getLongitude(), radius);
        request.zoom = zoom;
        request.poiTypeFilter = poiTypeFilter;
        request.resultMatcher = matcher;
        return request;
    }

    public static SearchRequest<RouteDataObject> buildSearchRouteRequest(int sleft, int sright, int stop, int sbottom, ResultMatcher<RouteDataObject> matcher) {
        SearchRequest<RouteDataObject> request = new SearchRequest<RouteDataObject>();
        request.left = sleft;
        request.right = sright;
        request.top = stop;
        request.bottom = sbottom;
        request.resultMatcher = matcher;
        return request;
    }

    public static SearchRequest<Amenity> buildSearchPoiRequest(int x, int y, String nameFilter, int sleft, int sright, int stop, int sbottom, ResultMatcher<Amenity> resultMatcher) {
        return BinaryMapIndexReader.buildSearchPoiRequest(x, y, nameFilter, sleft, sright, stop, sbottom, resultMatcher, null);
    }

    public static SearchRequest<Amenity> buildSearchPoiRequest(int x, int y, String nameFilter, int sleft, int sright, int stop, int sbottom, ResultMatcher<Amenity> resultMatcher, ResultMatcher<Amenity> rawDataCollector) {
        return BinaryMapIndexReader.buildSearchPoiRequest(x, y, nameFilter, sleft, sright, stop, sbottom, null, resultMatcher, null);
    }

    public static SearchRequest<Amenity> buildSearchPoiRequest(int x, int y, String nameFilter, int sleft, int sright, int stop, int sbottom, SearchPoiTypeFilter poiTypeFilter, ResultMatcher<Amenity> resultMatcher, ResultMatcher<Amenity> rawDataCollector) {
        SearchRequest<Amenity> request = new SearchRequest<Amenity>();
        request.x = x;
        request.y = y;
        request.left = sleft;
        request.right = sright;
        request.top = stop;
        request.bottom = sbottom;
        request.poiTypeFilter = poiTypeFilter;
        request.resultMatcher = resultMatcher;
        request.rawDataCollector = rawDataCollector;
        request.nameQuery = nameFilter.trim();
        return request;
    }

    public static SearchRequest<TransportStop> buildSearchTransportRequest(int sleft, int sright, int stop, int sbottom, int limit, List<TransportStop> stops) {
        SearchRequest<TransportStop> request = new SearchRequest<TransportStop>();
        if (stops != null) {
            request.searchResults = stops;
        }
        request.left = sleft >> 7;
        request.right = sright >> 7;
        request.top = stop >> 7;
        request.bottom = sbottom >> 7;
        request.limit = limit;
        return request;
    }

    public void close() throws IOException {
        if (this.codedIS != null) {
            this.raf.close();
            this.codedIS = null;
            this.mapIndexes.clear();
            this.addressIndexes.clear();
            this.transportIndexes.clear();
            this.poiIndexes.clear();
        }
    }

    private static void println(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) throws IOException {
        File fl = new File(System.getProperty("maps") + "/Synthetic_test_rendering.obf");
        fl = new File(System.getProperty("maps") + "/Us_pennsylvania_northamerica_3.obf");
        RandomAccessFile raf = new RandomAccessFile(fl, "r");
        BinaryMapIndexReaderStats.SearchStat stat = new BinaryMapIndexReaderStats.SearchStat();
        BinaryMapIndexReader reader = new BinaryMapIndexReader(raf, fl);
        BinaryMapIndexReader.println(String.format("VERSION %d bytes %,d KB read", reader.getVersion(), reader.getBytesRead() / 1024L));
        long time = System.currentTimeMillis();
        if (testMapSearch) {
            BinaryMapIndexReader.testMapSearch(reader);
        }
        if (testAddressSearchName) {
            BinaryMapIndexReader.testAddressSearchByName(reader, stat);
        }
        if (testAddressSearch) {
            BinaryMapIndexReader.testAddressSearch(reader, stat);
        }
        if (testAddressJustifySearch) {
            BinaryMapIndexReader.testAddressJustifySearch(reader, stat);
        }
        if (testTransportSearch) {
            BinaryMapIndexReader.testTransportSearch(reader);
        }
        if (testPoiSearch || testPoiSearchOnPath) {
            BinaryMapPoiReaderAdapter.PoiRegion poiRegion = reader.getPoiIndexes().get(0);
            if (testPoiSearch) {
                BinaryMapIndexReader.testPoiSearch(reader, poiRegion, stat);
                BinaryMapIndexReader.testPoiSearchByName(reader, "central ukraine", 0, 0, stat);
            }
            if (testPoiSearchOnPath) {
                BinaryMapIndexReader.testSearchOnthePath(reader, stat);
            }
        }
        if (testPoiRouteByName || testPoiRouteByType) {
            int y = MapUtils.get31TileNumberY(36.023431);
            int x = MapUtils.get31TileNumberX(14.298406);
            if (testPoiRouteByName) {
                BinaryMapIndexReader.testPoiSearchByName(reader, "Gozo Coastal Walk", x, y, stat);
            }
            if (testPoiRouteByType) {
                BinaryMapIndexReader.testPoiSearchByType(reader, "routes", "osm_hiking", x, y, stat);
            }
        }
        System.out.println(stat);
        BinaryMapIndexReader.println("MEMORY " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        BinaryMapIndexReader.println("Time " + (System.currentTimeMillis() - time));
    }

    private static void testSearchOnthePath(BinaryMapIndexReader reader, BinaryMapIndexReaderStats.SearchStat stat) throws IOException {
        float radius = 1000.0f;
        final MapPoiTypes poiTypes = MapPoiTypes.getDefault();
        long now = System.currentTimeMillis();
        BinaryMapIndexReader.println("Searching poi on the path...");
        List<Location> locations = BinaryMapIndexReader.readGPX(new File("/Users/victorshcherb/osmand/maps/2015-03-07_19-07_Sat.gpx"));
        SearchRequest<Amenity> req = BinaryMapIndexReader.buildSearchPoiRequest(locations, radius, new SearchPoiTypeFilter(){

            @Override
            public boolean accept(PoiCategory type, String subcategory) {
                return type == poiTypes.getPoiCategoryByName("shop") && subcategory.contains("super");
            }

            @Override
            public boolean isEmpty() {
                return false;
            }
        }, null);
        req.setSearchStat(stat);
        req.zoom = -1;
        List<Amenity> results = reader.searchPoi(req);
        int k = 0;
        BinaryMapIndexReader.println("Search done in " + (System.currentTimeMillis() - now) + " ms ");
        now = System.currentTimeMillis();
        for (Amenity a : results) {
            float dds = BinaryMapIndexReader.dist(a.getLocation(), locations);
            if (dds <= radius) {
                BinaryMapIndexReader.println("+ " + String.valueOf(a.getType()) + " " + a.getSubType() + " Dist " + dds + " (=" + (float)a.getRoutePoint().deviateDistance + ") " + a.getName() + " " + String.valueOf(a.getLocation()));
                ++k;
                continue;
            }
            BinaryMapIndexReader.println(String.valueOf(a.getType()) + " " + a.getSubType() + " Dist " + dds + " " + a.getName() + " " + String.valueOf(a.getLocation()));
        }
        BinaryMapIndexReader.println("Filtered in " + (System.currentTimeMillis() - now) + "ms " + k + " of " + results.size());
    }

    private static float dist(LatLon l, List<Location> locations) {
        float dist = Float.POSITIVE_INFINITY;
        for (int i = 1; i < locations.size(); ++i) {
            dist = Math.min(dist, (float)MapUtils.getOrthogonalDistance(l.getLatitude(), l.getLongitude(), locations.get(i - 1).getLatitude(), locations.get(i - 1).getLongitude(), locations.get(i).getLatitude(), locations.get(i).getLongitude()));
        }
        return dist;
    }

    private static Reader getUTF8Reader(InputStream f) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(f);
        assert (bis.markSupported());
        bis.mark(3);
        boolean reset = true;
        byte[] t = new byte[3];
        bis.read(t);
        if (t[0] == -17 && t[1] == -69 && t[2] == -65) {
            reset = false;
        }
        if (reset) {
            bis.reset();
        }
        return new InputStreamReader((InputStream)bis, "UTF-8");
    }

    private static List<Location> readGPX(File f) {
        ArrayList<Location> res = new ArrayList<Location>();
        try {
            BufferedReader reader = new BufferedReader(BinaryMapIndexReader.getUTF8Reader(new FileInputStream(f)));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dom = factory.newDocumentBuilder();
            Document doc = dom.parse(new InputSource(reader));
            NodeList list = doc.getElementsByTagName("trkpt");
            for (int i = 0; i < list.getLength(); ++i) {
                Element item = (Element)list.item(i);
                try {
                    double lon = Double.parseDouble(item.getAttribute("lon"));
                    double lat = Double.parseDouble(item.getAttribute("lat"));
                    Location o = new Location("");
                    o.setLatitude(lat);
                    o.setLongitude(lon);
                    res.add(o);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    private static void testPoiSearchByType(BinaryMapIndexReader reader, final String askType, final String askSubType, int x, int y, BinaryMapIndexReaderStats.SearchStat stat) throws IOException {
        BinaryMapIndexReader.println("Searching by type/subtype...");
        SearchRequest<Amenity> req = BinaryMapIndexReader.buildSearchPoiRequest(x, y, "", 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, new SearchPoiTypeFilter(){

            @Override
            public boolean accept(PoiCategory type, String subcategory) {
                return type.getKeyName().equals(askType) && (askSubType == null || subcategory.equals(askSubType));
            }

            @Override
            public boolean isEmpty() {
                return false;
            }
        }, null, null);
        req.setSearchStat(stat);
        reader.searchPoi(req);
        for (Amenity a : req.getSearchResults()) {
            int distance = 0;
            if (x > 0 && y > 0) {
                distance = (int)MapUtils.getDistance(a.getLocation(), MapUtils.get31LatitudeY(y), MapUtils.get31LongitudeX(x));
            }
            BinaryMapIndexReader.println(a.getType().getTranslation() + " " + a.getSubType() + " " + a.getName() + " " + String.valueOf(a.getLocation()) + (String)(distance > 0 ? " Dist " + distance + " m" : ""));
        }
    }

    private static void testPoiSearchByName(BinaryMapIndexReader reader, String query, int x, int y, BinaryMapIndexReaderStats.SearchStat stat) throws IOException {
        BinaryMapIndexReader.println("Searching by name...");
        SearchRequest<Amenity> req = BinaryMapIndexReader.buildSearchPoiRequest(x, y, query, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        reader.searchPoiByName(req);
        for (Amenity a : req.getSearchResults()) {
            int distance = 0;
            if (x > 0 && y > 0) {
                distance = (int)MapUtils.getDistance(a.getLocation(), MapUtils.get31LatitudeY(y), MapUtils.get31LongitudeX(x));
            }
            BinaryMapIndexReader.println(a.getType().getTranslation() + " " + a.getSubType() + " " + a.getName() + " " + String.valueOf(a.getLocation()) + (String)(distance > 0 ? " Dist " + distance + " m" : ""));
        }
        req.setSearchStat(stat);
    }

    private static void testPoiSearch(BinaryMapIndexReader reader, BinaryMapPoiReaderAdapter.PoiRegion poiRegion, BinaryMapIndexReaderStats.SearchStat stat) throws IOException {
        BinaryMapIndexReader.println(MapUtils.get31LongitudeX(poiRegion.left31) + " " + MapUtils.get31LongitudeX(poiRegion.right31) + " " + MapUtils.get31LatitudeY(poiRegion.bottom31) + " " + MapUtils.get31LatitudeY(poiRegion.top31));
        for (int i = 0; i < poiRegion.categories.size(); ++i) {
            BinaryMapIndexReader.println(poiRegion.categories.get(i));
            BinaryMapIndexReader.println(" " + String.valueOf(poiRegion.subcategories.get(i)));
        }
        SearchRequest<Amenity> req = BinaryMapIndexReader.buildSearchPoiRequest(sleft, sright, stop, sbottom, -1, ACCEPT_ALL_POI_TYPE_FILTER, null);
        req.setSearchStat(stat);
        List<Amenity> results = reader.searchPoi(req);
        for (Amenity a : results) {
            BinaryMapIndexReader.println(String.valueOf(a.getType()) + " " + a.getSubType() + " " + a.getName() + " " + String.valueOf(a.getLocation()));
        }
    }

    private static void testTransportSearch(BinaryMapIndexReader reader) throws IOException {
        for (BinaryMapTransportReaderAdapter.TransportIndex i : reader.transportIndexes) {
            BinaryMapIndexReader.println("Transport bounds : " + i.left + " " + i.right + " " + i.top + " " + i.bottom);
        }
        for (TransportStop s : reader.searchTransportIndex(BinaryMapIndexReader.buildSearchTransportRequest(sleft, sright, stop, sbottom, -1, null))) {
            BinaryMapIndexReader.println(s.getName());
            TLongObjectHashMap<TransportRoute> routes = reader.getTransportRoutes(s.getReferencesToRoutes());
            for (TransportRoute route : routes.valueCollection()) {
                BinaryMapIndexReader.println(" " + route.getRef() + " " + route.getName() + " " + route.getDistance() + " " + route.getAvgBothDistance());
                StringBuilder b = new StringBuilder();
                if (route.getForwardWays() == null) continue;
                for (Way w : route.getForwardWays()) {
                    b.append(w.getNodes()).append(" ");
                }
                BinaryMapIndexReader.println("  forward ways: " + b.toString());
            }
        }
    }

    private static void updateFrequence(Map<String, Integer> street, String key) {
        if (!street.containsKey(key)) {
            street.put(key, 1);
        } else {
            street.put(key, street.get(key) + 1);
        }
    }

    void readIndexedStringTable(Collator instance, List<String> queries, String prefix, List<TIntArrayList> listOffsets, TIntArrayList matchedCharacters) throws IOException {
        Object key = null;
        boolean[] matched = new boolean[matchedCharacters.size()];
        boolean shouldWeReadSubtable = false;
        block6: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 3: {
                    key = this.codedIS.readString();
                    if (prefix.length() > 0) {
                        key = prefix + (String)key;
                    }
                    shouldWeReadSubtable = false;
                    int i = 0;
                    while (true) {
                        if (i >= queries.size()) continue block6;
                        int charMatches = matchedCharacters.get(i);
                        String query = queries.get(i);
                        matched[i] = false;
                        if (query != null) {
                            if (CollatorStringMatcher.cmatches(instance, (String)key, query, CollatorStringMatcher.StringMatcherMode.CHECK_ONLY_STARTS_WITH)) {
                                if (query.length() >= charMatches) {
                                    if (query.length() > charMatches) {
                                        matchedCharacters.set(i, query.length());
                                        listOffsets.get(i).clear();
                                    }
                                    matched[i] = true;
                                }
                            } else if (CollatorStringMatcher.cmatches(instance, query, (String)key, CollatorStringMatcher.StringMatcherMode.CHECK_ONLY_STARTS_WITH) && ((String)key).length() >= charMatches) {
                                if (((String)key).length() > charMatches) {
                                    matchedCharacters.set(i, ((String)key).length());
                                    listOffsets.get(i).clear();
                                }
                                matched[i] = true;
                            }
                            shouldWeReadSubtable |= matched[i];
                        }
                        ++i;
                    }
                }
                case 4: {
                    int val = (int)this.readInt();
                    int i = 0;
                    while (true) {
                        if (i >= queries.size()) continue block6;
                        if (matched[i]) {
                            listOffsets.get(i).add(val);
                        }
                        ++i;
                    }
                }
                case 5: {
                    long len = this.codedIS.readRawVarint32();
                    long oldLim = this.codedIS.pushLimitLong(len);
                    if (shouldWeReadSubtable && key != null) {
                        ArrayList<String> subqueries = new ArrayList<String>(queries);
                        for (int i = 0; i < queries.size(); ++i) {
                            if (matched[i]) continue;
                            subqueries.set(i, null);
                        }
                        this.readIndexedStringTable(instance, subqueries, (String)key, listOffsets, matchedCharacters);
                    } else {
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    }
                    this.codedIS.popLimit(oldLim);
                    break;
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
    }

    private static void testAddressSearchByName(BinaryMapIndexReader reader, BinaryMapIndexReaderStats.SearchStat stat) throws IOException {
        SearchRequest<MapObject> req = BinaryMapIndexReader.buildAddressByNameRequest(new ResultMatcher<MapObject>(){

            @Override
            public boolean publish(MapObject object) {
                if (object instanceof Street) {
                    System.out.println(String.valueOf(object) + " " + String.valueOf(((Street)object).getCity()));
                } else {
                    System.out.println(String.valueOf(object) + " " + object.getId());
                }
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        }, "Mountain", CollatorStringMatcher.StringMatcherMode.CHECK_ONLY_STARTS_WITH);
        req.setSearchStat(stat);
        reader.searchAddressDataByName(req);
    }

    private static void testAddressJustifySearch(BinaryMapIndexReader reader, BinaryMapIndexReaderStats.SearchStat stat) throws IOException {
        String streetName = "Logger";
        double lat = 52.28212;
        double lon = 4.86269;
        final ArrayList streetsList = new ArrayList();
        SearchRequest<MapObject> req = BinaryMapIndexReader.buildAddressByNameRequest(new ResultMatcher<MapObject>(){

            @Override
            public boolean publish(MapObject object) {
                if (object instanceof Street && object.getName().equalsIgnoreCase("Logger")) {
                    if (MapUtils.getDistance(object.getLocation(), 52.28212, 4.86269) < 20000.0) {
                        streetsList.add((Street)object);
                        return true;
                    }
                    return false;
                }
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        }, "Logger", CollatorStringMatcher.StringMatcherMode.CHECK_EQUALS_FROM_SPACE);
        req.setSearchStat(stat);
        reader.searchAddressDataByName(req);
        TreeMap<MapObject, Street> resMap = new TreeMap<MapObject, Street>(new Comparator<MapObject>(){

            @Override
            public int compare(MapObject o1, MapObject o2) {
                LatLon l1 = o1.getLocation();
                LatLon l2 = o2.getLocation();
                if (l1 == null || l2 == null) {
                    return l2 == l1 ? 0 : (l1 == null ? -1 : 1);
                }
                return Double.compare(MapUtils.getDistance(l1, 52.28212, 4.86269), MapUtils.getDistance(l2, 52.28212, 4.86269));
            }
        });
        for (Street street : streetsList) {
            resMap.put(street, street);
            reader.preloadBuildings(street, null, stat);
            for (Building b : street.getBuildings()) {
                if (!(MapUtils.getDistance(b.getLocation(), 52.28212, 4.86269) < 100.0)) continue;
                resMap.put(b, street);
            }
        }
        for (Map.Entry entry : resMap.entrySet()) {
            MapObject e = (MapObject)entry.getKey();
            Street s = (Street)entry.getValue();
            if (e instanceof Building && MapUtils.getDistance(e.getLocation(), 52.28212, 4.86269) < 40.0) {
                Building b = (Building)e;
                System.out.println(b.getName() + "   " + String.valueOf(s));
                continue;
            }
            if (!(e instanceof Street)) continue;
            System.out.println(String.valueOf(s) + "   " + String.valueOf(s.getCity()));
        }
    }

    private static void testAddressSearch(BinaryMapIndexReader reader, BinaryMapIndexReaderStats.SearchStat stat) throws IOException {
        final HashMap<String, Integer> streetFreq = new HashMap<String, Integer>();
        List<City> cs = reader.getCities(null, BinaryMapAddressReaderAdapter.CityBlocks.CITY_TOWN_TYPE, null, stat);
        for (City city : cs) {
            int buildings = 0;
            reader.preloadStreets(city, null, stat);
            for (Street s : city.getStreets()) {
                BinaryMapIndexReader.updateFrequence(streetFreq, s.getName());
                reader.preloadBuildings(s, BinaryMapIndexReader.buildAddressRequest(null), stat);
                buildings += s.getBuildings().size();
                BinaryMapIndexReader.println(s.getName() + " " + s.getName("ru"));
            }
            BinaryMapIndexReader.println(city.getName() + " " + String.valueOf(city.getLocation()) + " " + city.getStreets().size() + " " + buildings + " " + city.getEnName(true) + " " + city.getName("ru"));
        }
        List<City> villages = reader.getCities(BinaryMapIndexReader.buildAddressRequest(null), BinaryMapAddressReaderAdapter.CityBlocks.VILLAGES_TYPE, null, stat);
        for (City v : villages) {
            reader.preloadStreets(v, null, stat);
            for (Street s : v.getStreets()) {
                BinaryMapIndexReader.updateFrequence(streetFreq, s.getName());
            }
        }
        System.out.println("Villages " + villages.size());
        ArrayList arrayList = new ArrayList(streetFreq.keySet());
        Collections.sort(arrayList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return -((Integer)streetFreq.get(o1)).intValue() + (Integer)streetFreq.get(o2);
            }
        });
        System.out.println(streetFreq.size());
        for (String s : arrayList) {
            System.out.println(s + "   " + String.valueOf(streetFreq.get(s)));
            if ((Integer)streetFreq.get(s) >= 10) continue;
            break;
        }
    }

    private static void testMapSearch(BinaryMapIndexReader reader) throws IOException {
        BinaryMapIndexReader.println(String.valueOf(reader.mapIndexes.get((int)0).encodingRules));
        BinaryMapIndexReader.println("SEARCH " + sleft + " " + sright + " " + stop + " " + sbottom);
        reader.searchMapIndex(BinaryMapIndexReader.buildSearchRequest(sleft, sright, stop, sbottom, szoom, null, new ResultMatcher<BinaryMapDataObject>(){

            @Override
            public boolean publish(BinaryMapDataObject obj) {
                TIntObjectHashMap<String> names;
                TagValuePair pair;
                int j;
                StringBuilder b = new StringBuilder();
                b.append(obj.area ? "Area" : (obj.getPointsLength() > 1 ? "Way" : "Point"));
                int[] types = obj.getTypes();
                b.append(" types [");
                for (j = 0; j < types.length; ++j) {
                    if (j > 0) {
                        b.append(", ");
                    }
                    if ((pair = obj.getMapIndex().decodeType(types[j])) == null) {
                        throw new NullPointerException("Type " + types[j] + "was not found");
                    }
                    b.append(pair.toSimpleString()).append("(").append(types[j]).append(")");
                }
                b.append("]");
                if (obj.getAdditionalTypes() != null && obj.getAdditionalTypes().length > 0) {
                    b.append(" add_types [");
                    for (j = 0; j < obj.getAdditionalTypes().length; ++j) {
                        if (j > 0) {
                            b.append(", ");
                        }
                        if ((pair = obj.getMapIndex().decodeType(obj.getAdditionalTypes()[j])) == null) {
                            throw new NullPointerException("Type " + obj.getAdditionalTypes()[j] + "was not found");
                        }
                        b.append(pair.toSimpleString()).append("(").append(obj.getAdditionalTypes()[j]).append(")");
                    }
                    b.append("]");
                }
                if ((names = obj.getObjectNames()) != null && !names.isEmpty()) {
                    b.append(" Names [");
                    int[] keys = names.keys();
                    for (int j2 = 0; j2 < keys.length; ++j2) {
                        TagValuePair pair2;
                        if (j2 > 0) {
                            b.append(", ");
                        }
                        if ((pair2 = obj.getMapIndex().decodeType(keys[j2])) == null) {
                            throw new NullPointerException("Type " + keys[j2] + "was not found");
                        }
                        b.append(pair2.toSimpleString()).append("(").append(keys[j2]).append(")");
                        b.append(" - ").append((String)names.get(keys[j2]));
                    }
                    b.append("]");
                }
                b.append(" id ").append(obj.getId() >> 1);
                b.append(" lat/lon : ");
                for (int i = 0; i < obj.getPointsLength(); ++i) {
                    float x = (float)MapUtils.get31LongitudeX(obj.getPoint31XTile(i));
                    float y = (float)MapUtils.get31LatitudeY(obj.getPoint31YTile(i));
                    b.append(x).append(" / ").append(y).append(" , ");
                }
                BinaryMapIndexReader.println(b.toString());
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        }));
    }

    public List<BinaryMapRouteReaderAdapter.RouteSubregion> searchRouteIndexTree(SearchRequest<?> req, List<BinaryMapRouteReaderAdapter.RouteSubregion> list) throws IOException {
        req.numberOfVisitedObjects = 0;
        req.numberOfAcceptedObjects = 0;
        req.numberOfAcceptedSubtrees = 0;
        req.numberOfReadSubtrees = 0;
        if (this.routeAdapter != null) {
            this.routeAdapter.initRouteTypesIfNeeded(req, list);
            return this.routeAdapter.searchRouteRegionTree(req, list, new ArrayList<BinaryMapRouteReaderAdapter.RouteSubregion>());
        }
        return Collections.emptyList();
    }

    public void loadRouteIndexData(List<BinaryMapRouteReaderAdapter.RouteSubregion> toLoad, ResultMatcher<RouteDataObject> matcher) throws IOException {
        if (this.routeAdapter != null) {
            this.routeAdapter.loadRouteRegionData(toLoad, matcher);
        }
    }

    public List<RouteDataObject> loadRouteIndexData(BinaryMapRouteReaderAdapter.RouteSubregion rs) throws IOException {
        if (this.routeAdapter != null) {
            return this.routeAdapter.loadRouteRegionData(rs);
        }
        return Collections.emptyList();
    }

    public void initRouteRegion(BinaryMapRouteReaderAdapter.RouteRegion routeReg) throws IOException {
        if (this.routeAdapter != null) {
            this.routeAdapter.initRouteRegion(routeReg);
        }
    }

    public TLongObjectHashMap<IncompleteTransportRoute> getIncompleteTransportRoutes() throws InvalidProtocolBufferException, IOException {
        if (this.incompleteTransportRoutes == null) {
            this.incompleteTransportRoutes = new TLongObjectHashMap();
            for (BinaryMapTransportReaderAdapter.TransportIndex ti : this.transportIndexes) {
                if (ti.incompleteRoutesLength <= 0L) continue;
                this.codedIS.seek(ti.incompleteRoutesOffset);
                long oldLimit = this.codedIS.pushLimitLong(ti.incompleteRoutesLength);
                this.transportAdapter.readIncompleteRoutesList(this.incompleteTransportRoutes, ti.filePointer);
                this.codedIS.popLimit(oldLimit);
            }
        }
        return this.incompleteTransportRoutes;
    }

    private void readOsmAndOwner() throws IOException {
        block7: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 1: {
                    this.owner.name = this.codedIS.readString();
                    continue block7;
                }
                case 2: {
                    this.owner.resource = this.codedIS.readString();
                    continue block7;
                }
                case 4: {
                    this.owner.pluginid = this.codedIS.readString();
                    continue block7;
                }
                case 3: {
                    this.owner.description = this.codedIS.readString();
                    continue block7;
                }
            }
            this.skipUnknownField(t);
        }
    }

    public long getBytesRead() {
        return this.codedIS.getBytesCounter();
    }

    public String toString() {
        return this.file.getName();
    }

    public static class OsmAndOwner {
        String name = "";
        String pluginid = "";
        String description = "";
        String resource = "";

        public OsmAndOwner() {
        }

        public OsmAndOwner(String name, String resource, String pluginid, String description) {
            this.name = name;
            this.resource = resource;
            this.pluginid = pluginid;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getPluginid() {
            return this.pluginid;
        }

        public String getDescription() {
            return this.description;
        }

        public String getResource() {
            return this.resource;
        }

        public String toString() {
            String owner = " owner=name:" + this.name;
            if (!this.resource.isEmpty()) {
                owner = owner + ", resource:" + this.resource;
            }
            if (!this.description.isEmpty()) {
                owner = owner + ", description:" + this.description;
            }
            if (!this.pluginid.isEmpty()) {
                owner = owner + ", pluginid:" + this.pluginid;
            }
            return owner;
        }
    }

    public static class MapIndex
    extends BinaryIndexPart {
        List<MapRoot> roots = new ArrayList<MapRoot>();
        Map<String, Map<String, Integer>> encodingRules = new HashMap<String, Map<String, Integer>>();
        public TIntObjectMap<TagValuePair> decodingRules = new TIntObjectHashMap();
        public int nameEncodingType = 0;
        public int nameEnEncodingType = -1;
        public int refEncodingType = -1;
        public int coastlineEncodingType = -1;
        public int coastlineBrokenEncodingType = -1;
        public int landEncodingType = -1;
        public int onewayAttribute = -1;
        public int onewayReverseAttribute = -1;
        public TIntHashSet positiveLayers = new TIntHashSet(2);
        public TIntHashSet negativeLayers = new TIntHashSet(2);
        public int encodingRulesSizeBytes;
        private MapIndex referenceMapIndex;

        public Integer getRule(String t, String v) {
            Map<String, Integer> m = this.encodingRules.get(t);
            if (m != null) {
                return m.get(v);
            }
            return null;
        }

        public LatLon getCenterLatLon() {
            if (this.roots.size() == 0) {
                return null;
            }
            MapRoot mapRoot = this.roots.get(this.roots.size() - 1);
            double cy = (MapUtils.get31LatitudeY(mapRoot.getBottom()) + MapUtils.get31LatitudeY(mapRoot.getTop())) / 2.0;
            double cx = (MapUtils.get31LongitudeX(mapRoot.getLeft()) + MapUtils.get31LongitudeX(mapRoot.getRight())) / 2.0;
            return new LatLon(cy, cx);
        }

        public List<MapRoot> getRoots() {
            return this.roots;
        }

        public TagValuePair decodeType(int type) {
            return (TagValuePair)this.decodingRules.get(type);
        }

        public Integer getRule(TagValuePair tv) {
            Map<String, Integer> m = this.encodingRules.get(tv.tag);
            if (m != null) {
                return m.get(tv.value);
            }
            return null;
        }

        public void finishInitializingTags() {
            int free = this.decodingRules.size();
            this.coastlineBrokenEncodingType = free++;
            this.initMapEncodingRule(0, this.coastlineBrokenEncodingType, "natural", "coastline_broken");
            if (this.landEncodingType == -1) {
                this.landEncodingType = free++;
                this.initMapEncodingRule(0, this.landEncodingType, "natural", "land");
            }
        }

        public boolean isRegisteredRule(int id) {
            return this.decodingRules.containsKey(id);
        }

        public void initMapEncodingRule(int type, int id, String tag, String val) {
            if (!this.encodingRules.containsKey(tag)) {
                this.encodingRules.put(tag, new HashMap());
            }
            this.encodingRules.get(tag).put(val, id);
            if (!this.decodingRules.containsKey(id)) {
                this.decodingRules.put(id, (Object)new TagValuePair(tag, val, type));
            }
            if ("name".equals(tag)) {
                this.nameEncodingType = id;
            } else if ("natural".equals(tag) && "coastline".equals(val)) {
                this.coastlineEncodingType = id;
            } else if ("natural".equals(tag) && "land".equals(val)) {
                this.landEncodingType = id;
            } else if ("oneway".equals(tag) && "yes".equals(val)) {
                this.onewayAttribute = id;
            } else if ("oneway".equals(tag) && "-1".equals(val)) {
                this.onewayReverseAttribute = id;
            } else if ("ref".equals(tag)) {
                this.refEncodingType = id;
            } else if ("name:en".equals(tag)) {
                this.nameEnEncodingType = id;
            } else if ("tunnel".equals(tag)) {
                this.negativeLayers.add(id);
            } else if ("bridge".equals(tag)) {
                this.positiveLayers.add(id);
            } else if ("layer".equals(tag) && val != null && !val.equals("0") && val.length() > 0) {
                if (val.startsWith("-")) {
                    this.negativeLayers.add(id);
                } else {
                    this.positiveLayers.add(id);
                }
            }
        }

        public boolean isBaseMap() {
            return this.name != null && this.name.toLowerCase().contains(BinaryMapIndexReader.BASEMAP_NAME);
        }

        @Override
        public String getPartName() {
            return "Map";
        }

        @Override
        public int getFieldNumber() {
            return 6;
        }

        public BinaryMapDataObject adoptMapObject(BinaryMapDataObject o) {
            int nid;
            Integer r;
            TagValuePair tp;
            int i;
            if (o.mapIndex == this || o.mapIndex == this.referenceMapIndex) {
                return o;
            }
            if (this.encodingRules.isEmpty()) {
                this.encodingRules.putAll(o.mapIndex.encodingRules);
                this.decodingRules.putAll(o.mapIndex.decodingRules);
                this.referenceMapIndex = o.mapIndex;
                return o;
            }
            TIntArrayList types = new TIntArrayList();
            TIntArrayList additionalTypes = new TIntArrayList();
            if (o.types != null) {
                for (i = 0; i < o.types.length; ++i) {
                    tp = o.mapIndex.decodeType(o.types[i]);
                    r = this.getRule(tp);
                    if (r != null) {
                        types.add(r.intValue());
                        continue;
                    }
                    nid = this.decodingRules.size() + 1;
                    this.initMapEncodingRule(tp.additionalAttribute, nid, tp.tag, tp.value);
                    types.add(nid);
                }
            }
            if (o.additionalTypes != null) {
                for (i = 0; i < o.additionalTypes.length; ++i) {
                    tp = o.mapIndex.decodeType(o.additionalTypes[i]);
                    r = this.getRule(tp);
                    if (r != null) {
                        additionalTypes.add(r.intValue());
                        continue;
                    }
                    nid = this.decodingRules.size() + 1;
                    this.initMapEncodingRule(tp.additionalAttribute, nid, tp.tag, tp.value);
                    additionalTypes.add(nid);
                }
            }
            BinaryMapDataObject bm = new BinaryMapDataObject(o.id, o.coordinates, o.polygonInnerCoordinates, o.objectType, o.area, types.toArray(), additionalTypes.isEmpty() ? null : additionalTypes.toArray(), o.labelX, o.labelY);
            if (o.namesOrder != null) {
                bm.objectNames = new TIntObjectHashMap();
                bm.namesOrder = new TIntArrayList();
                for (int i2 = 0; i2 < o.namesOrder.size(); ++i2) {
                    int nameType = o.namesOrder.get(i2);
                    String name = (String)o.objectNames.get(nameType);
                    TagValuePair tp2 = o.mapIndex.decodeType(nameType);
                    Integer nameKeyId = this.getRule(tp2);
                    if (nameKeyId == null) {
                        nameKeyId = this.decodingRules.size() + 1;
                        this.initMapEncodingRule(tp2.additionalAttribute, nameKeyId, tp2.tag, tp2.value);
                        additionalTypes.add(nameKeyId.intValue());
                    }
                    bm.objectNames.put(nameKeyId.intValue(), (Object)name);
                    bm.namesOrder.add(nameKeyId.intValue());
                }
            }
            return bm;
        }
    }

    public static class SearchRequest<T> {
        public static final int ZOOM_TO_SEARCH_POI = 16;
        private List<T> searchResults = new ArrayList<T>();
        private boolean land = false;
        private boolean ocean = false;
        private ResultMatcher<T> resultMatcher;
        private ResultMatcher<T> rawDataCollector;
        int x = 0;
        int y = 0;
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        private Collection<QuadRect> searchBoxes;
        int zoom = 15;
        int limit = -1;
        TLongObjectHashMap<List<Location>> tiles = null;
        double radius = -1.0;
        String nameQuery = null;
        CollatorStringMatcher.StringMatcherMode matcherMode = CollatorStringMatcher.StringMatcherMode.CHECK_STARTS_FROM_SPACE;
        SearchFilter searchFilter = null;
        SearchPoiTypeFilter poiTypeFilter = null;
        SearchPoiAdditionalFilter poiAdditionalFilter;
        TIntArrayList cacheCoordinates = new TIntArrayList();
        TIntArrayList cacheTypes = new TIntArrayList();
        TLongArrayList cacheIdsA = new TLongArrayList();
        TLongArrayList cacheIdsB = new TLongArrayList();
        TLongArrayList cacheIdsC = new TLongArrayList();
        BinaryMapIndexReaderStats.MapObjectStat stat = new BinaryMapIndexReaderStats.MapObjectStat();
        BinaryMapIndexReaderStats.SearchStat searchStat = null;
        public boolean log = true;
        int numberOfVisitedObjects = 0;
        int numberOfAcceptedObjects = 0;
        int numberOfReadSubtrees = 0;
        int numberOfAcceptedSubtrees = 0;
        boolean interrupted = false;

        public BinaryMapIndexReaderStats.MapObjectStat getStat() {
            return this.stat;
        }

        public void setSearchStat(BinaryMapIndexReaderStats.SearchStat stat) {
            this.searchStat = stat;
        }

        public BinaryMapIndexReaderStats.SearchStat getSearchStat() {
            return this.searchStat;
        }

        protected SearchRequest() {
        }

        public long beginSearchStats(BinaryMapIndexReaderStats.BinaryMapIndexReaderApiName api, BinaryIndexPart part, CodedInputStream codedIS) {
            if (this.searchStat != null) {
                return this.searchStat.beginSearchStats(api, part, codedIS, this.nameQuery);
            }
            return 0L;
        }

        public void endSearchStats(long statReq, BinaryMapIndexReaderStats.BinaryMapIndexReaderApiName api, BinaryIndexPart part, CodedInputStream codedIS) {
            if (statReq > 0L && this.searchStat != null) {
                this.searchStat.endSearchStats(statReq, api, part, codedIS, this.nameQuery);
            }
        }

        public long getTileHashOnPath(double lat, double lon) {
            long x = (int)MapUtils.getTileNumberX(16.0f, lon);
            long y = (int)MapUtils.getTileNumberY(16.0f, lat);
            return x << 16 | y;
        }

        public void setBBoxRadius(double lat, double lon, int radiusMeters) {
            double dx = MapUtils.getTileNumberX(16.0f, lon);
            double half16t = MapUtils.getDistance(lat, MapUtils.getLongitudeFromTile(16.0, (double)((int)dx) + 0.5), lat, MapUtils.getLongitudeFromTile(16.0, (int)dx));
            double cf31 = (double)radiusMeters / (half16t * 2.0) * 32768.0;
            this.y = MapUtils.get31TileNumberY(lat);
            this.x = MapUtils.get31TileNumberX(lon);
            this.left = (int)((double)this.x - cf31);
            this.right = (int)((double)this.x + cf31);
            this.top = (int)((double)this.y - cf31);
            this.bottom = (int)((double)this.y + cf31);
        }

        public void setBBox(int x31, int y31, int left, int top, int right, int bottom) {
            this.x = x31;
            this.y = y31;
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }

        public boolean publish(T obj) {
            if (this.resultMatcher == null || this.resultMatcher.publish(obj)) {
                this.searchResults.add(obj);
                return true;
            }
            return false;
        }

        public void collectRawData(T obj) {
            if (this.rawDataCollector != null) {
                this.rawDataCollector.publish(obj);
            }
        }

        protected void publishOceanTile(boolean ocean) {
            if (ocean) {
                this.ocean = true;
            } else {
                this.land = true;
            }
        }

        public List<T> getSearchResults() {
            return this.searchResults;
        }

        public void setInterrupted(boolean interrupted) {
            this.interrupted = interrupted;
        }

        public boolean limitExceeded() {
            return this.limit != -1 && this.searchResults.size() > this.limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public boolean isCancelled() {
            if (this.interrupted) {
                return this.interrupted;
            }
            if (this.resultMatcher != null) {
                return this.resultMatcher.isCancelled();
            }
            return false;
        }

        public boolean isOcean() {
            return this.ocean;
        }

        public boolean isLand() {
            return this.land;
        }

        public boolean intersects(int l, int t, int r, int b) {
            return r >= this.left && l <= this.right && t <= this.bottom && b >= this.top;
        }

        public boolean contains(int l, int t, int r, int b) {
            return r <= this.right && l >= this.left && b <= this.bottom && t >= this.top;
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }

        public int getBottom() {
            return this.bottom;
        }

        public int getTop() {
            return this.top;
        }

        public int getZoom() {
            return this.zoom;
        }

        public void clearSearchResults() {
            this.searchResults = new ArrayList<T>();
            this.cacheCoordinates.clear();
            this.cacheTypes.clear();
            this.cacheIdsA.clear();
            this.cacheIdsB.clear();
            this.cacheIdsC.clear();
            this.land = false;
            this.ocean = false;
            this.numberOfVisitedObjects = 0;
            this.numberOfAcceptedObjects = 0;
            this.numberOfReadSubtrees = 0;
            this.numberOfAcceptedSubtrees = 0;
        }

        public boolean isBboxSpecified() {
            return this.left != 0 || this.right != 0;
        }

        private boolean hasSearchBoxes() {
            return this.searchBoxes != null;
        }

        private boolean containsSearchBox(int left, int top, int right, int bottom) {
            if (Algorithms.isEmpty(this.searchBoxes)) {
                return false;
            }
            QuadRect searchRect = new QuadRect(left, top, right, bottom);
            for (QuadRect box : this.searchBoxes) {
                if (!searchRect.contains(box)) continue;
                return true;
            }
            return false;
        }

        public Collection<QuadRect> clearSearchBoxes() {
            this.searchBoxes = null;
            return null;
        }

        public void setSearchBoxes(Collection<QuadRect> searchBboxes) {
            this.searchBoxes = searchBboxes;
        }

        public void setMatcherMode(CollatorStringMatcher.StringMatcherMode mode) {
            this.matcherMode = mode;
        }
    }

    public static class MapRoot
    extends MapTree {
        int minZoom = 0;
        int maxZoom = 0;
        private List<MapTree> trees = null;

        public int getMinZoom() {
            return this.minZoom;
        }

        public int getMaxZoom() {
            return this.maxZoom;
        }

        public MapZooms.MapZoomPair getMapZoom() {
            return new MapZooms.MapZoomPair(this.minZoom, this.maxZoom);
        }
    }

    private static class MapTree {
        long filePointer = 0L;
        long length = 0L;
        long mapDataBlock = 0L;
        Boolean ocean = null;
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;

        private MapTree() {
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }

        public int getTop() {
            return this.top;
        }

        public int getBottom() {
            return this.bottom;
        }

        public long getLength() {
            return this.length;
        }

        public long getFilePointer() {
            return this.filePointer;
        }

        public String toString() {
            return "Top Lat " + (float)MapUtils.get31LatitudeY(this.top) + " lon " + (float)MapUtils.get31LongitudeX(this.left) + " Bottom lat " + (float)MapUtils.get31LatitudeY(this.bottom) + " lon " + (float)MapUtils.get31LongitudeX(this.right);
        }
    }

    public static interface SearchFilter {
        public boolean accept(TIntArrayList var1, MapIndex var2);
    }

    public static interface SearchPoiTypeFilter {
        public boolean accept(PoiCategory var1, String var2);

        public boolean isEmpty();
    }

    public static interface SearchPoiAdditionalFilter {
        public boolean accept(BinaryMapPoiReaderAdapter.PoiSubType var1, String var2);

        public String getName();

        public String getIconResource();
    }

    public static class TagValuePair {
        public String tag;
        public String value;
        public int additionalAttribute;

        public TagValuePair(String tag, String value, int additionalAttribute) {
            this.tag = tag;
            this.value = value;
            this.additionalAttribute = additionalAttribute;
        }

        public boolean isAdditional() {
            return this.additionalAttribute % 2 == 1;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.additionalAttribute;
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public String toSimpleString() {
            if (this.value == null) {
                return this.tag;
            }
            return this.tag + "-" + this.value;
        }

        public String toString() {
            return "TagValuePair : " + this.tag + " - " + this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TagValuePair other = (TagValuePair)obj;
            if (this.additionalAttribute != other.additionalAttribute) {
                return false;
            }
            if (this.tag == null ? other.tag != null : !this.tag.equals(other.tag)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

